<?php
// Require authentication
require_once 'includes/auth.php';
requireAuth();
?>
<?php include 'header.php'; ?>
<!-- Quill Editor CSS -->
<link rel="stylesheet" href="assets/libs/quill/quill.snow.css">
<!-- Add Blog Custom CSS -->
<link rel="stylesheet" href="assets/css/add-blog.css">

<div class="page-wrapper">
    <!-- Page Content-->
    <div class="page-content">
        <div class="container-fluid">
            <!-- Header -->
            <div class="row mb-3">
                <div class="col-sm-12">
                    <div class="page-title-box d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center gap-2">
                            <h4 class="page-title mb-0" style="font-size: 1.25rem; font-weight: 700;">Add Blog Post</h4>
                        </div>
                    </div>
                </div>
            </div>

            <form id="addBlogForm" method="POST" enctype="multipart/form-data">
                <div class="row">
                    
                    <!-- Left Column (Main Content) -->
                    <div class="col-lg-8">
                        <!-- Title -->
                        <div class="card">
                            <div class="card-body">
                                <div class="form-group">
                                    <label class="form-label">Title</label>
                                    <input type="text" class="form-control" id="blogTitle" name="title"
                                        placeholder="e.g. The Ultimate Guide to Vaping" required>
                                </div>
                                <div class="form-group mt-3">
                                    <label class="form-label">Category</label>
                                    <input type="text" class="form-control" id="blogCategory" name="category" placeholder="e.g. Health, News">
                                </div>
                                <div class="form-group mt-3">
                                    <label class="form-label">Excerpt</label>
                                    <textarea class="form-control" id="blogExcerpt" name="excerpt" rows="2" placeholder="Short summary of the post"></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Content -->
                        <div class="card">
                            <div class="card-body">
                                <label class="form-label">Content</label>
                                <div id="blogContent" style="height: 300px;"></div>
                                <textarea name="content" id="contentInput" style="display:none;"></textarea>
                            </div>
                        </div>

                        <!-- Search Engine Listing Section -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title mb-0">Search engine listing</h4>
                            </div>
                            <div class="card-body">
                                <!-- SEO Edit Fields -->
                                <div id="seoEditFields" class="mb-4">
                                    <div class="mb-3">
                                        <label class="form-label">Page title</label>
                                        <input type="text" class="form-control" id="seoTitle" name="seo_title" value=""
                                            maxlength="70" placeholder="Enter page title">
                                        <small class="text-muted">
                                            <span id="seoTitleCount">0</span> of 70 characters used
                                        </small>
                                    </div>

                                    <div class="mb-0">
                                        <label class="form-label">Meta description</label>
                                        <textarea class="form-control" id="seoDescription" name="seo_description"
                                            rows="3" maxlength="320" placeholder="Enter meta description"></textarea>
                                        <small class="text-muted">
                                            <span id="seoDescriptionCount">0</span> of 320 characters used
                                        </small>
                                    </div>
                                </div>

                                <!-- SEO Preview -->
                                <div class="border rounded p-3 bg-white" id="seoPreviewBox">
                                    <div class="d-flex align-items-start mb-2">
                                        <div class="flex-shrink-0 me-2">
                                            <img src="assets/images/favicon.ico" alt="favicon" width="16" height="16"
                                                class="rounded-circle">
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="fw-semibold text-dark mb-0"
                                                style="font-size: 14px; line-height: 1.3;">The Perfect Vape</div>
                                            <div class="text-muted seo-url-preview"
                                                style="font-size: 12px; line-height: 1.3; color: #5f6368;">
                                                www.theperfectvape.com/blogs/news/...</div>
                                        </div>
                                    </div>
                                    <h6 class="text-primary mb-1 seo-title-preview"
                                        style="font-size: 18px; font-weight: 400; line-height: 1.3;">Blog Post Title
                                    </h6>
                                    <p class="text-muted small mb-2 seo-description-preview"
                                        style="font-size: 13px; line-height: 1.4; color: #4d5156;">Blog post description
                                        will appear here...</p>
                                </div>
                            </div>
                        </div>
                        <!--end card-->
                    </div>

                    <!-- Right Column (Sidebar) -->
                    <div class="col-lg-4">
                        <!-- Visibility -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title mb-0">Visibility</h4>
                            </div>
                            <div class="card-body">
                                <div class="visibility-radio-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="visibility" id="visVisible"
                                            value="visible" checked>
                                        <label class="form-check-label" for="visVisible">
                                            Visible
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="visibility" id="visHidden"
                                            value="hidden">
                                        <label class="form-check-label" for="visHidden">
                                            Hidden
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Featured Image -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title mb-0">Featured image</h4>
                            </div>
                            <div class="card-body">
                                <div class="image-upload-area" id="featuredImageArea">
                                    <div id="uploadPlaceholder">
                                        <button type="button" class="btn btn-sm btn-outline-secondary mb-2">Add
                                            image</button>
                                        <p class="text-muted small mb-0">or drop an image to upload</p>
                                    </div>
                                    <img id="imagePreview" src="" style="display: none;" alt="Featured Image">
                                </div>
                                <input type="file" id="featuredImageInput" name="featured_image" class="d-none"
                                    accept="image/*">

                                <div id="imageActions" class="mt-2 text-end" style="display: none;">
                                    <button type="button"
                                        class="btn btn-link text-danger btn-sm p-0 text-decoration-none"
                                        id="removeImageBtn">Remove</button>
                                    <button type="button"
                                        class="btn btn-link text-primary btn-sm p-0 ms-2 text-decoration-none"
                                        id="changeImageBtn">Change</button>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
                <div class="row mt-3 mb-4">
                    <div class="col-12 text-end">
                        <a href="blogs.php" class="btn btn-outline-secondary me-2">Discard</a>
                        <button type="submit" class="btn btn-dark"
                            style="background-color: #303030; border-color: #303030;">Save</button>
                    </div>
                </div>
            </form>

        </div><!-- container -->
    </div>
    <!-- end page content -->
</div>
<!-- end page-wrapper -->

<!-- Quill Editor JS -->
<script src="assets/libs/quill/quill.js"></script>
<!-- Add Blog Custom JS -->
<script src="assets/js/add-blog.js"></script>

<?php include 'footer.php'; ?>