<?php include 'header.php'; ?>
    <!-- Quill Editor CSS -->
    <link rel="stylesheet" href="assets/libs/quill/quill.snow.css">
    <!-- Add Product Custom CSS (Reuse for consistency) -->
    <link rel="stylesheet" href="assets/css/add-product.css">

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Add Collection</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="collections.php">Collections</a></li>
                                    <li class="breadcrumb-item active">Add Collection</li>
                                </ol>
                            </div>                            
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->

                <form id="addCollectionForm" method="POST" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-lg-8">
                            <!-- Title Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Title</h4>
                                </div>
                                <div class="card-body">
                                    <div class="form-group mb-3">
                                        <input type="text" class="form-control" id="collectionTitle" name="name" placeholder="Enter collection title" required>
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Description Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Description</h4>
                                </div>
                                <div class="card-body">
                                    <div id="collectionDescription"></div>
                                    <textarea name="description" id="descriptionInput" style="display:none;"></textarea>
                                </div>
                            </div><!--end card-->

                            <!-- Media Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Collection Image</h4>
                                </div>
                                <div class="card-body">
                                    <!-- Drag and Drop Zone -->
                                    <div id="dropZone" class="drop-zone mb-4">
                                        <div class="drop-zone-content">
                                            <i class="iconoir-cloud-upload fs-1 text-primary mb-3"></i>
                                            <h5 class="mb-2">Drag and drop image here</h5>
                                            <p class="text-muted mb-3">or</p>
                                            <button type="button" class="btn btn-primary" id="addMediaBtn">
                                                <i class="iconoir-plus me-2"></i>Add Image
                                            </button>
                                            <input type="file" id="mediaFileInput" name="image" accept="image/*" class="d-none">
                                            <p class="text-muted small mt-3 mb-0">Accepts images (JPG, PNG, GIF, WebP)</p>
                                        </div>
                                    </div>

                                    <!-- Image Preview -->
                                    <div id="imagePreviewContainer" class="position-relative" style="display: none;">
                                        <img id="imagePreview" src="" alt="Preview" class="img-fluid rounded border">
                                        <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-2" id="removeImageBtn">
                                            <i class="iconoir-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Search Engine Listing Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Search engine listing</h4>
                                </div>
                                <div class="card-body">
                                    <!-- SEO Edit Fields -->
                                    <div id="seoEditFields" class="mb-4">
                                        <div class="mb-3">
                                            <label class="form-label">Page title</label>
                                            <input type="text" class="form-control" id="seoTitle" name="seo_title" value="" maxlength="70" placeholder="Enter page title">
                                            <small class="text-muted">
                                                <span id="seoTitleCount">0</span> of 70 characters used
                                            </small>
                                        </div>

                                        <div class="mb-0">
                                            <label class="form-label">Meta description</label>
                                            <textarea class="form-control" id="seoDescription" name="seo_description" rows="3" maxlength="320" placeholder="Enter meta description"></textarea>
                                            <small class="text-muted">
                                                <span id="seoDescriptionCount">0</span> of 320 characters used
                                            </small>
                                        </div>
                                    </div>

                                    <!-- SEO Preview -->
                                    <div class="border rounded p-3 bg-white" id="seoPreviewBox">
                                        <div class="d-flex align-items-start mb-2">
                                            <div class="flex-shrink-0 me-2">
                                                <img src="assets/images/favicon.ico" alt="favicon" width="16" height="16" class="rounded-circle">
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="fw-semibold text-dark mb-0" style="font-size: 14px; line-height: 1.3;">The Perfect Vape</div>
                                                <div class="text-muted seo-url-preview" style="font-size: 12px; line-height: 1.3; color: #5f6368;">www.theperfectvape.com › collections</div>
                                            </div>
                                        </div>
                                        <h6 class="text-primary mb-1 seo-title-preview" style="font-size: 18px; font-weight: 400; line-height: 1.3;">Collection Title</h6>
                                        <p class="text-muted small mb-2 seo-description-preview" style="font-size: 13px; line-height: 1.4; color: #4d5156;">Collection description will appear here...</p>
                                    </div>
                                </div>
                            </div><!--end card-->
                        </div><!--end col-->

                        <div class="col-lg-4">
                            <!-- Status Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Status</h4>
                                </div>
                                <div class="card-body">
                                    <select class="form-select" name="is_active" id="collectionStatus">
                                        <option value="1" selected>Active</option>
                                        <option value="0">Draft</option>
                                    </select>
                                </div>
                            </div><!--end card-->

                            <!-- Parent Collection Section -->
                             <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Parent Collection</h4>
                                </div>
                                <div class="card-body">
                                    <select class="form-select" name="parent_id" id="parentCollection">
                                        <option value="">None</option>
                                        <!-- Options will be loaded dynamically -->
                                    </select>
                                    <small class="text-muted mt-2 d-block">Select a parent collection to create a hierarchy.</small>
                                </div>
                            </div><!--end card-->
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="row mt-3 mb-4">
                        <div class="col-12 text-end">
                            <button type="button" class="btn btn-outline-secondary me-2" onclick="history.back()">Discard</button>
                            <button type="submit" class="btn btn-dark" id="saveBtn" style="background-color: #303030; border-color: #303030;">Save Collection</button>
                        </div>
                    </div>
                </form>
            </div><!-- container -->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->
    
    <!-- Quill Editor JS -->
    <script src="assets/libs/quill/quill.js"></script>
    <!-- Add Collection Custom JS -->
    <script src="assets/js/add-collection.js"></script>

<?php include 'footer.php'; ?>
