/**
 * Authentication API
 * Handles login, logout, and authentication checks
 */

// Import API client (if using modules)
// import { apiClient } from './api-client.js';

/**
 * Login
 */
async function login(username, password, rememberMe = false) {
    try {
        const response = await apiClient.post('login.php', {
            username: username,
            password: password,
            remember_me: rememberMe
        });

        if (response.success) {
            return {
                success: true,
                message: response.message,
                user: response.user,
                redirect: 'index.php'
            };
        }

        return {
            success: false,
            message: response.message,
            errors: response.errors || {}
        };
    } catch (error) {
        return {
            success: false,
            message: error.message || 'Login failed. Please try again.',
            errors: {}
        };
    }
}

/**
 * Logout
 */
async function logout() {
    try {
        const response = await apiClient.post('logout.php');

        if (response.success) {
            return {
                success: true,
                message: response.message,
                redirect: 'login.php'
            };
        }

        return {
            success: false,
            message: response.message || 'Logout failed'
        };
    } catch (error) {
        return {
            success: false,
            message: error.message || 'Logout failed. Please try again.'
        };
    }
}

/**
 * Check Authentication Status
 */
async function checkAuth() {
    try {
        const response = await apiClient.get('check-auth.php');
        return {
            success: true,
            authenticated: response.authenticated || false,
            user: response.user
        };
    } catch (error) {
        return {
            success: false,
            authenticated: false
        };
    }
}

// Export functions
if (typeof module !== 'undefined' && module.exports) {
    module.exports = { login, logout, checkAuth };
}

