/**
 * https://www.amcharts.com/svg-maps/?map=southKorea
 * map data by amcharts team
 */
'use strict';

(function() {
    var data = [{"code":"KR-SU","name":"Seoul","path":"M133.45,208.68L133.45,208.68L137.25,212.51L138.02,217.91L139.15,218.34L141.56,217.09L144.66,222.92L146.47,222.19L150.07,222.59L154.24,220.28L157.32,219.99L158,222.92L161.65,220.84L164.64,220.58L166.32,219L166.3,217.85L167.56,217.55L168.84,215.83L167.66,214.75L168.06,212.24L171.26,210.1L169.81,206.54L165.01,208.72L163.46,208.29L164.88,202.94L162.8,198.22L162.7,193.7L160.6,192.41L155.64,192.21L153.46,193.73L151.83,196.51L151.75,199.51L150.65,200.3L145.5,200.7L143.87,205.22L140.25,206.83L135.18,203.64L133,207.1L133,207.1z"},{"code":"KR-BS","name":"Busan","path":"M361.82,463.22l0.04,0.76h3.97l1.34,1.34l0,0l1,1.68l-0.17,1.51l-1.5,1.09l-0.84,5.03l-1.86,0.99l1.6,0.19l0.31,1.63l-1.42,3.04l-0.97,-0.51l-0.6,1.41l0.79,1.38l-0.55,1.73l-2.34,0.67l-0.58,2.21l-1.13,0.7l-1.65,-0.61l-1.29,0.93l-1.65,-1.09l0.11,0.8l-1.63,0.22l-0.6,2.08l1.02,0.16l0.52,1.5l-0.13,2.62l-1.18,-0.64l-1.92,0.32l-0.32,-0.38l-1.94,-0.26l0.21,-1.98l-0.71,-0.45l-1.79,1.31l-1.71,2.68l-0.21,1.79l-0.81,0.1l0.68,1.44l-0.71,1.15l-1.1,-3.58l-1.08,0.19l0.92,3.86l-0.94,0.42l-0.16,-1.47l-0.97,-0.35l0.21,1.66l-1.16,-0.13l0.69,0.93l-1.18,0.83l0.1,-1.76l-0.73,-0.38l-0.81,-3.32l0.55,-3.03l-2.08,2.43l-0.08,-2.87l-1.97,3.61h-1.65l1.02,-4.54l-1.05,-0.38l-0.97,4.92l-4.44,-0.51l-1.5,-1.63l-2.94,2.17l-0.76,-0.89l1.84,-1.53l-1.26,0.19l0.32,-2.32l0,0l6.93,-2.61l0.43,-5.01l2.29,-0.29l3.87,-2.43l4.15,-0.14l4.06,-4.94l3.95,-2.48l1.84,0.32l3.61,-6.64l4.87,-0.57l0.57,-1.86l2.95,-2.71l0,0L361.82,463.22zM347.32,494.1l1.86,1.6l-0.29,1.63l1.94,1.63l-0.5,1.09h-0.89l-0.47,-1.18l-0.63,0.26l-0.58,-1.28l-3.12,-2.3L347.32,494.1z"},{"code":"KR-DG","name":"Daegu","path":"M297.68,431.85L296.36,436.12L295.02,437.04L295.02,437.04L292.6,436.15L291.07,436.52L291.07,436.52L287.58,439.02L285.17,439.08L285.17,439.08L284.44,435.65L280.38,430.66L280.69,427.85L284.12,429.72L286.31,429.72L286.93,427.23L283.81,423.79L285.06,420.67L286.31,417.86L291.61,416.93L291.3,415.06L288.49,412.87L283.81,412.56L285.37,406.63L287.56,403.51L291.61,401.64L292.24,407.25L294.73,407.25L298.17,399.14L304.09,397.89L306.9,394.77L310.33,393.84L313.45,394.15L317.2,397.27L317.82,404.76L319.7,408.81L318.76,411L315.33,412.25L313.77,415.68L313.77,418.8L311.27,419.11L311.27,420.98L312.52,422.54L312.52,426.6L309.09,427.85L307.52,429.72L304.72,429.41L304.09,426.6L300.97,426.6L298.79,427.85L297.23,430.35z"},{"code":"KR-IC","name":"Incheon","path":"M113.39,205.14l4.15,-2.72l2.11,-2.84l2.08,0.19l7.46,6.03l0,0l3.83,1.29l0.45,1.58l0,0l0,0l0,0l-3.54,4.55l0,0l0.13,4.02l3.31,2.9l0,0l-0.45,3.79l-1.79,2.33l0,0l-2,-0.59l0.47,-1.81l-0.68,-0.53l-0.39,1.68l-0.6,-2.34l0.45,3l-1.97,2.27l-3.57,-0.49l-3.68,4.64l-4.59,0.13l-0.34,1.09l-1,-0.03l0.84,-0.26l0.53,-1.84l4.57,0.82l3.6,-4.51l-4.04,-3.16l-0.94,-4.28l-0.5,2.31l-1.47,-0.1l0.18,-2.6l-0.81,1.29l-1.21,-0.49l1.21,-4.64l2.99,-1.19l1.23,0.4l-0.92,-1.68l-2.42,1.12l0.05,-1.32l-1.02,-1.09l0.97,0.1l-0.16,-1.25l-1.23,-1.25l0.68,-0.3l0.05,-1.42l-2.78,1.65l-1,-0.16l-0.1,-0.07l3.91,-1.62L113.39,205.14zM87.39,206.76l1.84,1.25l0.87,-0.26l1.42,2.01l2.97,-0.43l-0.26,1.45l-2.05,-0.43l-1.86,0.63l-0.39,-0.56l-1.02,0.96l0.37,-2.11L87.39,206.76zM107.03,209.92l0.74,1.19l3.57,0.99l1.39,1.32l0.42,1.85l-2.26,1.42l-2,-0.66l-8.88,7.38l-2.86,0.56l0.34,-1.97l-0.94,-0.66l-1.23,0.82l0.89,-0.92l-0.47,-0.72l-1.6,1.25l-1.63,-0.82l0.87,-0.62l-1.55,-1.78l0.24,-1.38l1.65,-0.03l3.94,-2.8l5.57,-0.26l1.34,-0.96l0.68,-2.7L107.03,209.92zM97.18,224.58l2.78,2.9l-0.84,2.14l-1.57,0.43l-0.95,-0.92l0.11,-1.94l-1.18,-0.3l0.89,-2.44L97.18,224.58z"},{"code":"KR-GJ","name":"Gwangju","path":"M149.04,478.34L147.22,477.47L144.78,477.38L140.34,479.38L138.33,481.47L136.85,481.56L133.28,479.47L132.67,477.29L130.49,477.21L128.4,482.52L126.05,482.43L124.31,484.52L123.18,489.31L123.61,493.4L130.84,494.45L134.59,500.55L138.33,500.55L141.73,498.54L145.56,498.54L147.04,497.5L150.18,498.11L153.57,495.76L154.97,493.93L156.71,487.83L156.71,486.44L154.62,485.48L152.01,485.22L150.99,480.68z"},{"code":"KR-DJ","name":"Daejeon","path":"M191.13,336.42L192.38,341.72L192.69,341.89L192.69,341.89L194.15,339.52L194.15,339.52L194.76,338.88L194.76,338.88L196.15,339.06L195.83,340.36L195.83,340.36L195.76,341L195.76,341L198.62,338.6L198.62,338.6L201.12,341.1L201.12,341.1L201.36,343.72L203.79,344.88L203.47,346.51L205.49,348.9L202.68,350.77L202.68,350.77L201.74,356.39L201.74,356.39L200.49,362.63L201.66,366.38L201.66,366.38L198.31,368.56L196.13,371.37L192.38,369.18L190.2,365.44L189.57,362.01L188.01,362.01L187.7,370.12L186.77,372.31L185.52,372.31L184.58,369.18L182.08,368.25L180.52,366.06L180.21,362.63L178.03,360.76L177.72,356.7L179.9,354.21L179.59,345.47L186.45,343.29L187.41,337.15L187.41,337.15Z"},{"code":"KR-US","name":"Ulsan","path":"M361.02,427.42L362.82,428.89L365.81,429.79L366.04,430.61L366.04,430.61L365.62,433.46L365.62,433.46L366.64,434.56L366.64,434.56L368.61,435.22L368.61,435.22L373.98,432.82L373.98,432.82L382.11,434.97L382.11,434.97L385.01,435.38L385.71,436.83L385.68,438.21L384.55,438.99L385.08,442.13L384.42,444.54L383.29,445.06L384.05,445.15L383.87,446.73L382.66,447.24L383.66,447.98L382.4,448.59L383.89,449.3L382.87,450.48L381.87,450.07L380.06,451.35L380.22,448.88L379.06,447.98L378.43,445.03L376.49,442.9L374.99,442.42L377.3,444.77L377.22,445.89L378.19,446.15L378.54,447.6L376.17,447.72L376.7,448.43L377.67,448.17L378.56,449.75L375.96,452.99L373.73,451.29L374.49,454.3L375.65,454.24L375.15,455.23L376.51,454.5L376.51,456.1L374.94,457.32L376.07,459.05L374.26,461.97L376.04,464.47L374.55,465.34L373.36,464.85L371.34,467.93L370.27,468L370,469.18L368.01,468.51L368.18,467L367.18,465.32L367.18,465.32L365.84,463.98L361.86,463.98L361.82,463.22L361.82,463.22L360.28,461.34L360.28,461.34L357.19,461.13L357.19,461.13L351.53,455.26L351.53,455.26L348.27,451.9L345.87,451.7L345.87,451.7L343.12,451.7L340.89,450.65L340.55,445.82L342.78,443.93L342.78,443.93L343.98,442.88L343.98,441.42L342.51,438.99L342.51,438.99L346.43,435.9L346.43,435.9L346.43,435.9L346.43,435.9L348.09,435.73L348.09,435.73L348.09,435.73L348.09,435.73L349.42,434.99L348.07,432.51L348.44,430.95L355.71,427.36z"},{"code":"KR-GG","name":"Gyeonggi","labelCoordinate":{"x":0.65,"y":0.7},"path":"M79.19,183.7l-1.81,-2.08l1.52,-1.65l0.21,-2.28l1.58,-1.49h2.65l3.05,1.75l2.39,-0.66l1.08,1.19l-1.71,2.78l-1.97,1.19l-2.62,-0.33l-2.23,0.6l-1.05,1.42L79.19,183.7zM88.88,242.67l-3.44,-1.77l-1.08,1.25l3.99,2.1l2.07,-0.52l0.74,-1.22l-1.37,-0.53L88.88,242.67zM82.21,195.73l-3.12,-0.1l3.73,3.86l0.34,-0.56l-1.13,-0.82L82.21,195.73zM70.32,243.33l-0.92,0.63l-0.76,-2.86l-1.1,-0.16l-1.52,6.01l1.26,-0.2l0.18,-0.79l0.39,1.28l1.16,-0.36l-0.16,1.45l3.39,-0.52l1.6,-1.87l-3.28,-2.04L70.32,243.33zM75.07,193.06l-1.05,-0.36l-1.24,0.89l1.18,0.73l1.16,-0.5l0.87,1.49l1.86,0.33l0.29,-1.45L76.7,191.67L75.07,193.06zM154.22,126.06l-4.9,5.81h-2.81l-4.68,-1.87l-2.5,1.56l-5.62,4.68l-3.43,4.99l1.87,0.94l1.87,3.75l6.31,0.29l3.37,1.9l0.62,3.12l-1.25,0.94l-0.31,1.87l-4.99,-0.62l-0.31,3.75l-1.56,0.94l0.31,2.5l1.87,0.94l-0.31,6.55l-2.18,1.25l-3.12,-3.74l1.25,-4.37l-1.96,-2.47l-2.4,0.07l-0.32,2.71l-1.87,1.87l-3.47,-3.34l-0.74,0.11l0.9,4.9l-0.49,1.87l4.74,1.77l3.43,4.99l-6.55,1.87h-2.83l-0.96,4.55l-3,0.18l-3.07,2.46l-3.56,-0.53l-2.02,-1.61l-0.6,1.17l-1.76,0.79l1.1,1.75l-0.87,4.23l1.08,1.79l-0.5,3.11l1.16,0.53l-0.76,1.72l2.65,6.34l2.37,3.1l0,0l4.15,-2.72l2.11,-2.84l2.08,0.19l7.46,6.03l0,0l3.82,1.29l0,0l2.18,-3.46l5.07,3.2l3.63,-1.61l1.63,-4.52l5.15,-0.4l1.1,-0.79l0.08,-3l1.63,-2.77l2.18,-1.52l4.96,0.2l2.1,1.29l0.11,4.53l2.07,4.72l-1.42,5.35l1.55,0.43l4.81,-2.18l1.44,3.56l-3.2,2.14l-0.39,2.5l1.18,1.09l-1.29,1.71l-1.26,0.3l0.03,1.15l-1.68,1.58l-2.99,0.26l-3.65,2.08l-0.68,-2.93l-3.07,0.3l-4.18,2.31l-3.6,-0.39l-1.81,0.72l-3.1,-5.83l-2.41,1.25l-1.13,-0.43l-0.76,-5.4l-3.81,-3.82l0,0l-3.54,4.55l0,0l0.13,4.02l3.31,2.9l0,0l-0.45,3.79l-1.79,2.33l0,0l1.23,0.59l-3.96,-0.76l-0.89,1.05l0.81,0.63l-0.39,1.51l-4.7,2.63l0.29,1.51L116.01,236l-2.94,2.24l-0.92,-0.26l0.47,0.99l-1.29,1.38l-2.89,-1.38l2.89,4.04l-0.34,2.07l-1.81,1.12l1.45,1.48h-1.21l0.29,0.85l-1.08,1.08l1.65,-0.69l1.02,1.58l1.84,-3.38l3.02,1.54l0.79,-3.32l0.26,1.64l2,1.25l-0.52,1.71l0.58,0.62l0.79,-2.33l-0.34,-1.64l-2.63,-1.35l-0.63,-2.69l-2.21,-0.39l-2.13,-2l1.02,-1.81l3.2,-2.23l6.49,-2.24l9.38,4.54l3.1,-0.39l2.76,3.29l1.26,-0.43l-1,1.77l-1.58,-2l-1.92,-0.49l0.16,-0.92l-0.89,0.33l-0.34,0.79l0.95,1.28l-1.92,-0.1l0.74,1.74l-0.92,0.85l0.66,0.2l-2.23,3.35l-1.31,-0.89l0.58,-0.69l-0.6,-3.02l-2.65,0.85l-0.34,-1.08l-3.57,-0.75l-0.73,1.84l-1.71,0.36l0.39,1.74l0.92,0.59l-0.94,1.74l0.97,1.54l-1.42,0.03l-1.16,1.48l1.18,2.59l-1.08,0.95l1.5,-0.62l2.44,0.49l-2.23,2.13l1.29,0.82l-0.18,1.77l0.84,0.79l0.4,-1.61l3.36,-1.9l2.07,-3.41l2.55,0.23l1.39,-2.13l0.95,2.4l-2.15,1.31l4.67,0.07l-2.08,0.59l0.92,1.02l-0.81,-0.36l-1.36,1.31l-1.05,-0.72l-2.02,1.94l0.05,7.08l-1.57,2.75l0.37,0.79l4.31,0.33l0.29,2.1l-1.34,0.43l0.05,0.82l3.91,0.82l1.63,4.16l1.92,0.79l0.45,1.87l1.94,-0.33l1.42,0.92l0.87,4.56l0,0l3.46,-2.08l7.55,1.76l4.94,-1.77l3.01,-2.07l2.58,-0.08l2.99,1.43l3.29,3.38l5.1,0.7l0,0l2.77,-0.23l0,0l3.78,-1.7l0,0l1.71,-1.24l2.21,0.14l1.8,-1.75l0.17,-2.11l0,0l-0.3,-1.08l5.09,-3.01l0,0l0.8,-2.63l2.34,-2.57l0.8,1.19l1.48,-0.02l-0.27,2.07l1.6,-3.22l4.3,0.78l4.06,-3.74l2.5,-0.31l0.63,-7.8h1.56l1.56,1.87h1.87l2.66,-6.65l2.65,-0.58l0,0l0.62,-7.44l-0.62,-3.43l1.56,-1.25l-0.31,-7.49l3.43,-8.11l0.31,-4.06l-1.95,-0.71l-0.79,-2.38l3.14,-4.03l2.06,-0.7l0.79,-2.18l-1.65,-2.9l-8.97,-1.37l-4.31,-3.69l-2.69,-0.32l-4.11,-2.48l-3.64,1.4l-2.64,-2.84l1.75,-3.51l0.31,-4.39l-3.59,0.9l0.12,-2.02l2.7,-3.08l-1.32,-3.5l0.83,-1.96l-0.85,-2.95l0.59,-1.52l2.26,-0.75l1.8,-2.06l3.31,-1.07l1,-3.97l-0.82,-4.03l-1.44,-1.59l-4.2,-1.42l-0.08,-2.7l-0.88,-0.6l-3.22,0.34l-3.09,-1.53l-1.56,-3.02l-0.4,-7.52l-1.42,-1.97l-1.96,1.05l-2.09,-1.55l-1.49,0.2l-4.11,1.93l-4.47,-3.58l0.48,-5.32l1.09,-0.92l-1.97,-0.88l-3.66,3.74l-2.44,0.16l-1.64,-0.83l-0.39,-3.19l-0.99,0.31l-0.18,-1.08l0.63,-1.87l-1.56,-1.25l-0.94,-5.3h-4.68v-1.87l1.25,-0.94l-4.74,-4.42l0,0l-1.33,0.58L154.22,126.06zM92.9,190.84l-2.49,-0.36l-2.1,-1.65l-0.03,-2.31l1.02,-2.08l-0.92,-0.56l-3.23,1.32l-0.08,3.41l-1.52,0.56l4.6,3.17l1.02,1.45l-0.26,2.08l1.08,1.06l3.57,-2.74l0.39,-2.05L92.9,190.84zM108.47,194.51l-1.47,-1.35l0.79,-3.17l-1.16,-1.72l1.24,-3.74l-1.37,-1.69l-0.34,-2.28l-4.52,-2.94l-2.15,-2.78l-3.94,0.73l-0.84,2.02l-3.49,1.89l0.53,10.09l2.99,0.79l1.97,4.59l-0.87,2.38l-3.18,0.59l1.16,2.08l-0.58,0.79l3.28,1.95l5.36,0.36l0.03,-1.02l0.89,0.43l0.58,-0.92l3.15,0.92l0.81,-1.65l1.37,-0.4l-1.18,-4.72L108.47,194.51zM102.93,238.99l-1.94,0.43l-0.18,1.28l-1.55,-0.13l-0.71,1.51l0.81,1.97l-0.34,1.87l1.89,-0.03l0.05,0.92l0.63,-0.06l1.34,-1.12l-0.26,-0.85l1.52,-0.1l-1.15,-1.31l1.26,-0.03l-0.21,-0.76l1,0.72l0.68,-1.97l-1.31,-1.71L102.93,238.99z"},{"code":"KR-GW","name":"Gangwon","path":"M281.2,81.07L282.62,83.88L284.77,86.63L285.35,86.46L286.13,88.2L285.58,89.47L287.34,91.81L286.76,93.11L287.92,94.12L287.76,95.58L291.46,100.46L290.33,100.96L290.28,102.67L295.8,110.27L295.17,110.71L295.43,112.37L297.03,114.61L297,116.07L299.32,118.07L300.15,123.7L304.15,128.9L303.33,130.03L305.36,132.76L304.44,133.75L305.36,137.81L310.95,144.39L311.66,147.42L315.7,151.73L316.8,151.83L316.3,153.72L320.06,159.89L321.74,161.09L321.66,162.15L325.76,165.89L325.68,168.38L330.06,173.41L330.3,174.87L347.26,193.36L346.06,198.01L348.44,201.25L352.94,204.94L353.3,206.76L352.36,208.7L354.3,213.88L359.47,219.18L360.58,224.22L365.41,227.97L367.11,234.85L368.95,236.46L369.98,236.36L370.45,238.89L372.1,238.96L372.92,240.04L372.65,241.85L375.46,245.27L373.99,246.38L374.7,248.16L373.86,250.55L374.41,253.14L377.15,257.08L376.83,258.26L377.64,259.1L377.64,259.1L373.37,259.81L373.37,259.81L371.5,262L369,262.93L366.19,265.43L366.19,265.43L364.63,267.61L364.63,268.86L364.63,268.86L366.19,271.67L359.65,271.83L359.65,271.83L357,269.56L354.05,268.53L351.43,268.13L348.89,270.65L341.46,268.03L338.11,268.75L337.43,267.42L335.71,266.74L335.71,266.74L332.8,271.05L332.8,271.05L331.87,272.29L327.81,272.29L321.57,267.93L319.55,268.11L319.01,272.83L317.89,273.95L314.83,272.57L312.91,272.83L308.65,270.49L308.65,270.49L306.28,268.35L302.79,268.56L298.83,267.29L298.83,267.29L295.24,264.37L293.23,264.28L293.23,264.28L289,265.29L289,265.29L287.11,265.75L286.29,264.36L286.29,264.36L284.5,262.71L284.6,260.09L284.6,260.09L283.64,259.28L282.18,259.61L282.18,259.61L278.9,259.47L277.71,260.72L277.71,260.72L275.74,261.38L275.74,261.38L275.04,261.85L272.73,260.08L272.07,258.39L275.33,256.36L277.69,253.63L277.79,252.27L277.79,252.27L276.24,251.74L274.87,252.57L274.87,252.57L273.82,252.84L273.82,252.84L272.11,252.6L270.63,250.87L268.51,250.44L266.53,248.93L264.07,249.52L262.28,251.96L258.63,251.05L254.95,254.13L254.95,254.13L249.88,254.99L249.88,254.99L249.6,251.15L249.6,251.15L247.83,247.84L243.56,247.4L242.06,248.34L242.06,248.34L239.22,251.03L240.21,255.72L239.79,257.52L236.64,259.62L234.31,258.47L231.28,258.56L229.83,260.44L227.64,261.37L223.59,258.25L222.97,254.77L222.97,254.77L223.59,247.33L222.96,243.9L224.52,242.65L224.21,235.16L227.64,227.05L227.96,222.99L226,222.28L225.22,219.9L228.35,215.87L230.42,215.17L231.21,212.98L229.56,210.08L220.59,208.72L216.28,205.02L213.59,204.7L209.48,202.22L205.84,203.62L203.2,200.77L204.95,197.26L205.26,192.87L201.67,193.78L201.79,191.75L204.49,188.67L203.17,185.17L203.99,183.21L203.15,180.26L203.73,178.74L206,177.98L207.8,175.92L211.11,174.85L212.11,170.88L211.29,166.85L209.84,165.26L205.64,163.84L205.56,161.13L204.68,160.53L201.46,160.87L198.36,159.34L196.81,156.32L196.4,148.81L194.98,146.83L193.02,147.88L190.93,146.33L189.44,146.52L185.33,148.46L180.87,144.87L181.35,139.55L182.44,138.63L180.47,137.75L176.81,141.49L174.37,141.66L172.73,140.82L172.34,137.63L171.34,137.94L171.16,136.87L171.79,135L170.23,133.75L169.29,128.44L164.61,128.44L164.61,126.57L165.86,125.63L161.12,121.22L161.12,121.22L165.16,117.96L168.53,118.35L175.22,115.29L178.63,115.81L180.24,117L183.43,116.89L184.57,115.94L190.58,114.82L199.81,118.82L208.05,114.58L210.66,116.02L214.44,115.61L217.11,116.28L219.06,114.97L224.85,115.26L227.39,113.86L231.06,118.46L234.98,117.35L237.1,115.11L243.39,116.95L245.17,116.52L251.62,117.96L254.58,117.5L257.56,115.06L260.9,114.78L267.7,109.37L268.99,107.26L274.52,102.42L276.68,97.81L277.5,93.22L276.97,84.14z"},{"code":"KR-NC","name":"North Chungcheong","labelCoordinate":{"x":0.5,"y":0.25},"path":"M213.91,387.92L211.73,381.67L209.54,379.79L209.23,376.99L209.23,376.99L210.48,374.18L210.17,371.06L208.3,367.94L208.3,367.94L205.5,368.2L201.66,366.38L200.49,362.63L201.74,356.39L201.74,356.39L202.68,350.77L202.68,350.77L205.49,348.9L203.47,346.51L203.79,344.88L201.36,343.72L201.12,341.1L201.12,341.1L198.62,338.6L198.62,338.6L195.76,341L195.76,341L195.83,340.36L195.83,340.36L196.15,339.06L194.76,338.88L194.76,338.88L194.15,339.52L194.15,339.52L192.69,341.89L192.69,341.89L192.38,341.72L192.38,341.72L192.38,341.72L192.38,341.72L191.13,336.42L191.13,336.42L187.41,337.15L186.79,336.29L185.68,336.48L185.68,336.48L185.11,337.26L185.11,337.26L186.97,331.16L185.89,330.02L186.81,326.74L183.47,326.54L183.02,325.19L183.02,325.19L183.02,322.38L180.21,318.95L182.4,318.32L182.71,315.51L182.71,315.51L181.15,313.33L186.14,305.53L189.89,305.84L191.45,303.97L190.2,300.22L187.08,298.04L184.2,298.04L184.2,298.04L183.12,297.56L183.28,295.57L183.28,295.57L182.69,295.08L182.69,295.08L181.21,294.37L181.21,294.37L180.98,291.71L178.14,289.79L177.23,287.37L179.99,287.14L179.99,287.14L183.77,285.44L183.77,285.44L185.48,284.2L187.69,284.34L189.48,282.59L189.65,280.48L189.65,280.48L189.35,279.4L194.43,276.39L194.43,276.39L195.23,273.76L197.57,271.19L198.38,272.38L199.86,272.36L199.59,274.43L201.18,271.2L205.49,271.98L209.54,268.24L212.04,267.93L212.66,260.13L214.23,260.13L215.79,262L217.66,262L220.32,255.35L222.97,254.77L223.59,258.25L227.64,261.37L229.83,260.44L231.27,258.56L234.31,258.47L236.64,259.62L239.79,257.52L240.21,255.72L239.22,251.03L242.06,248.34L242.06,248.34L243.56,247.4L247.83,247.84L249.6,251.15L249.6,251.15L249.88,254.99L249.88,254.99L254.95,254.13L254.95,254.13L258.63,251.05L262.28,251.97L264.07,249.52L266.53,248.93L268.51,250.44L270.63,250.87L272.11,252.6L273.82,252.84L273.82,252.84L274.87,252.57L274.87,252.57L276.24,251.74L277.79,252.27L277.79,252.27L277.69,253.63L275.33,256.36L272.07,258.39L272.73,260.08L275.04,261.85L275.74,261.38L275.74,261.38L277.71,260.72L277.71,260.72L278.9,259.47L282.18,259.61L282.18,259.61L283.64,259.28L284.6,260.09L284.6,260.09L284.5,262.71L286.29,264.36L286.29,264.36L287.11,265.76L289,265.29L289,265.29L293.23,264.28L293.23,264.28L295.24,264.37L298.83,267.29L298.83,267.29L302.79,268.56L306.28,268.35L308.65,270.49L308.65,270.49L306.45,272.65L304.31,272.4L304.31,272.4L302.03,275.02L302.03,275.02L301.41,275.3L301.41,275.3L298.12,278.55L295.32,279.35L295.32,279.35L294.53,280.6L294.53,280.6L290.99,283.35L287.83,289.01L287.83,289.01L287,290.58L287,290.58L286.94,291.91L288.26,292.52L288.26,292.52L289.05,295.44L286.21,299.33L282.21,300.11L282.21,300.11L281.29,301.15L278.85,301.09L278.85,301.09L276.65,301.27L276.65,301.27L274.16,296.35L270.92,294.5L269.74,292.53L269.74,292.53L268.07,295.58L266.94,295.92L266.5,299.15L266.5,299.15L266.13,299.72L260.43,297.98L260.43,297.98L260.01,297.35L260.01,297.35L258.94,296.98L258.33,297.6L258.33,297.6L255.8,300.69L254.42,300.88L254.42,300.88L252.78,299.14L252.27,299.44L252.27,299.44L249.41,306.13L249.41,306.13L252.8,311.38L248.2,310.46L248.2,310.46L247.02,309.8L245.81,310.39L242.5,308.76L242.5,308.76L239.62,312.49L239.62,312.49L235.37,313.91L233.69,316.29L234.17,318.51L230.94,321.85L230.94,321.85L229.18,323.4L229.18,323.4L227.62,323.75L227.62,323.75L226.63,325.66L227.35,326.76L232.72,327.89L233.94,329.11L233.8,330.04L233.8,330.04L234.76,332.01L234.76,332.01L236.77,333.37L236.35,335.08L236.35,335.08L234.33,335.97L233.52,343.6L233.52,343.6L234.12,346.07L232.83,348.09L234.15,351.34L234.15,351.34L234.65,351.65L234.65,351.65L233.65,354.21L230.98,356.52L230.98,356.52L230.91,360.8L233.07,362.58L233.07,362.58L236.48,360.02L236.95,361.47L239.45,362.95L239.45,362.95L241.3,364.52L241.3,364.52L242.47,364.92L242.47,364.92L244.46,364.08L244.46,364.08L246.69,363.29L248.71,363.99L248.71,363.99L249.33,365.06L249.33,365.06L249.48,368.23L249.48,368.23L250.74,370.1L250.74,370.1L250.15,371.38L247.03,369.97L244.62,371.4L243.44,373.14L244.61,376.1L244.2,379.67L242.45,381.13L241.41,385.77L239.57,388.37L236.69,388.27L235.61,389.35L232.87,391.91L229.97,389.63L229.97,389.63L224.98,392.03L224.62,392.94L222.02,392.94L221.87,392.02L220.16,390.98L216.06,389.56L216.06,389.56L215.01,387.29z"},{"code":"KR-SC","name":"South Chungcheong","path":"M92.24,350.46l0.95,0.71l-0.79,0.1l-0.1,0.91l-1.31,-0.62l-0.47,0.68l-0.24,-1.39l1.08,-0.75l0.03,-1.33h0.66L92.24,350.46zM95.71,342.01h1.21l0.16,1.17l1.47,0.49l-0.58,-1.36l1.29,-1.01l-0.26,-2.14l-2.36,-1.76l1,-1.43l-0.87,-1.43l0.16,-1.82l-1.1,0.33l0.34,-2.02l-2.23,-1.24l0.81,-0.88l-1.02,-1.37l-0.1,-3.25l-1.47,-0.68l1.52,-0.98l0.05,-1.14l-0.97,-2.61l-1.34,-0.62l-3.73,3.78l1.65,3.39l-0.31,5.21l0.89,2.05l-1.08,2.89l1.37,-0.39l-0.63,3.35l2.44,0.39l-0.55,1.89l1.73,1.53l0.97,-1.1l1.92,0.03L95.71,342.01zM100.7,267.96l-0.5,-2.1l-2.36,-0.39l0.05,2.79L100.7,267.96zM99.68,346.49l-0.63,-1.14l-1.02,-0.1l-0.94,0.46l0.53,1.43l-2.52,-1.4l-0.71,1.62l1.86,-0.16l5.28,1.75l0.16,-0.94l-2.73,-0.75L99.68,346.49zM211.73,381.67l-2.18,-1.87l-0.31,-2.81l1.25,-2.81l-0.31,-3.12l-1.87,-3.12l-2.8,0.27l-3.83,-1.82l-3.35,2.18l-2.18,2.81l-3.74,-2.18l-2.18,-3.74l-0.62,-3.43h-1.56l-0.31,8.11l-0.94,2.19h-1.25l-0.94,-3.12l-2.5,-0.94l-1.56,-2.18l-0.31,-3.43l-2.18,-1.87l-0.31,-4.06l-1.71,-2.06l-1.75,-1.35l-1.21,-3.1l0.14,-4.04l-0.27,-2.83l-1.35,-3.91l-2.7,-1.48l-1.89,-2.56l-0.13,-2.02l1.08,-2.43v-3.1l-0.13,-3.5l-0.27,-3.37l0.67,-2.43l-0.27,-3.1l-0.54,-2.02l-1.08,-2.02l0.4,-1.75l2.7,-1.08l2.56,0.81l1.48,1.62l2.7,1.62l2.56,0.94l2.44,-0.2l4.99,-7.8l3.75,0.31l1.56,-1.87l-1.25,-3.74l-3.12,-2.18h-2.88l-1.08,-0.48l0.16,-1.99l-0.59,-0.49l-1.48,-0.71l-0.23,-2.66l-2.84,-1.92l-0.91,-2.42l-5.09,-0.7l-3.29,-3.38l-2.99,-1.43l-2.58,0.08l-3.01,2.07l-4.94,1.77l-7.55,-1.76l-3.46,2.08l-4.49,1.06l-3.57,-0.65l-1.5,-5l-1.13,-0.39l-1.68,-3.89l0.08,-1.37l-7.51,-2.03l-0.37,-0.79l-6.35,-0.23l-6.8,-4.06l-2.2,-0.36l-1.55,-2.26l-2.02,-0.72l-0.89,0.66l-0.71,1.38l0.53,0.56l-2.6,2.42l1,1.9l-1.26,0.66l-2.68,-1.34l-3.96,-0.39l-2.1,1.05l-0.81,-0.52l-1.97,1.67l-0.71,-0.36l0.32,1.83l3.15,0.72l0.81,-0.49l0.45,1.24l1,0.16l-1.65,1.34l-0.71,-1.11h-2.47l-0.21,1.08l1.45,-0.16l0.18,1.15l0.92,0.16l-0.18,1.34l0.95,-0.92l1.18,0.26l0.87,1.83l1.68,-1.34l0.92,0.43l0.03,1.5l-1.31,0.62l0.34,1.15l2.15,0.82l-3.31,0.98l0.16,1.54l-1.94,-0.26l-1.23,0.72l0.6,2.22l-1.44,1.24l0.89,1.86l-2.07,-1.83l0.42,-1.7l-1.6,-0.29l-1.13,2.68l0.97,0.75l-0.29,1.18l0.87,1.14l-1.13,-0.56l-0.87,0.88l-0.76,-0.42l-0.03,1.04l-0.94,-0.06l-0.39,1.11l-0.97,-2.35l0.24,-0.75l3.05,-0.91l0.16,-0.69l-2.1,-0.46l0.08,-1.18l1.65,-3.66l1.76,-0.95h-0.97l-0.18,-1.6l-1.65,-1.47v-3.24l0.95,-1.31l-1,0.1l-0.81,-1.05l1.02,-0.26l0.18,-1.57l-2.34,1.8l1.05,5.14l-0.84,1.31l0.37,1.08l-3.7,-1.08l0.45,-0.69l-1.47,0.1l-2.36,1.9l-0.92,-0.78l-0.5,2.26l-1.86,-0.13l1.34,1.21l-0.89,0.69l0.68,1.7l1,-0.06l-2.08,2.74l1.42,1.57l-1.1,0.1l1.63,4.34l-1.92,-3.69l-0.68,0.52l0.05,-3.72l-1.02,-0.06L73.26,290.7l-0.47,0.75l-0.63,-0.29l0.58,1.05l-0.92,0.03l1.29,1.21l-0.18,1.18l-1.31,1.01l0.74,0.65l-0.42,1.57l-1.05,0.85l-0.42,-0.52l0.03,1.27l-1.81,0.36l1.21,2.81h0.87l-1.36,4.93l3.1,-2.67l-1.15,-3.69l1.55,0.85l3.55,-0.26l-1.02,1.34l1.92,1.08l1.23,-0.59l-1.26,2.35l1.05,-0.65l0.89,0.65l-1.55,1.93l-3.57,-1.53l-1.84,1.47l0.55,3.29l3.91,0.39l1.08,-2.31l2.31,-0.23l0.63,-0.81l-0.31,-1.83l2.1,0.1l1.86,-1.53l0.39,0.75l-0.81,0.29l-0.08,2.22l-1.13,1.37l0.32,2.15l2.18,0.29l1.08,2.31l0.13,3.16l-1.05,0.75l-0.55,2.93l1.02,1.73l6.67,-5.76l4.31,1.24l5.01,3.55l0.74,3.03l-0.66,1.69l2.36,2.9l1.5,-1.27l4.15,2.99l-4.2,-2.24l-2.02,2.12l-0.24,3.41l0.55,2.8l1.23,1.3l-0.26,1.2l2.63,-1.33l0.32,-1.4l0.79,-0.06l2.52,-3.28l2.44,1.01l2.23,-0.78l-1,1.24l-2.7,-0.45l-0.68,2.76l-1.5,-0.1l-1.52,1.49h-1.26l-2.39,1.66l-0.92,1.92l-0.42,3.22l1.79,0.03l4.73,3.28l3.26,0.68l-2.6,-0.23l-4.07,2.82l-1.29,0.1l4.57,6.91l-1.73,3.14l0.89,4.5l-1.5,1.62l0.18,2.23l-0.76,0.97l-2.36,-0.23l-0.03,2.75l1.08,0.97l0.29,-2.4l1.18,-0.32l2.63,0.94l0.92,1.85l1.39,-1.39l2.55,2.2l1.34,2.94l0.81,-0.71l1.05,0.49l-0.03,0.84l1.18,-0.32l-2.44,1.94l1.05,-0.19l0.29,2.81l1.05,-0.1l2.26,2.59l-0.76,0.49l0.05,2.13l0.74,0.74l1.13,-0.61l4.28,1.07l1.39,-2.17l0.68,0.33l1.31,-0.56l1.48,1.36l11.55,-4.99l0,-8.44l4.69,-2.68l3.69,0.67l3.77,2.27l1.27,-0.38l2.19,2.01l0.31,3.75l2.44,0.19l0.53,2.02l2.55,0.18l5.68,-2.1l2.85,1.89l5.31,-0.31l-0.62,-2.5l4.37,0.31l2.42,-2.02l1.13,1.63l2.97,5.1l2.22,7.14l4.92,-1.56l0.7,4.99l6.55,-0.31l0.94,-1.87l0.16,-2.21l1.03,-0.18l1.89,-1l4.1,2.45l2.81,-2.81v-2.49L211.73,381.67z"},{"code":"KR-NJ","name":"North Jeolla","path":"M128.74,388.35L130.05,387.8L131.53,389.16L143.08,384.16L143.08,375.72L147.77,373.04L151.46,373.71L155.22,375.98L156.49,375.6L158.68,377.61L158.99,381.35L161.43,381.55L161.96,383.57L164.51,383.75L170.19,381.65L173.04,383.54L178.34,383.23L177.72,380.73L182.08,381.04L182.08,381.04L184.5,379.03L185.64,380.65L185.64,380.65L188.6,385.76L190.82,392.9L195.74,391.34L196.44,396.33L202.99,396.02L203.93,394.15L203.93,394.15L204.08,391.94L205.11,391.76L205.11,391.76L207,390.76L211.1,393.21L213.91,390.4L213.91,387.92L213.91,387.92L215.01,387.29L216.06,389.56L216.06,389.56L220.16,390.98L221.87,392.02L222.02,392.94L224.62,392.94L224.98,392.03L229.97,389.63L229.97,389.63L232.87,391.91L235.61,389.35L235.61,389.35L240.32,398.32L239.04,403.33L239.04,403.33L236.71,404.85L234.67,409.47L231.56,411.35L230.1,411.36L230.1,411.36L228.27,412.51L226.26,412.07L226.26,412.07L225.61,412.54L225.61,412.54L223.95,416.62L219.01,421.36L218.23,426.18L218.23,426.18L218.07,428.1L217.18,428.89L217.18,428.89L211.96,443.3L212.13,445.62L214.9,446.99L214.9,446.99L215.32,449.9L215.32,449.9L216.59,452.17L215.91,455.51L216.6,457.44L218.23,457.87L217.77,461.88L217.77,461.88L214.07,465.44L212.92,468.59L213.47,471.46L211.25,473.76L211.25,473.76L211.02,473.97L211.02,473.97L204.64,469.51L204.64,469.51L200.1,467.43L200.1,467.43L198.1,467.54L198.1,467.54L196.35,468.52L193.4,472.31L191.65,472.78L191.65,472.78L188.45,472.41L186.07,473.11L186.07,473.11L179.92,473.13L178.79,472.48L178.79,472.48L177.35,471.1L175.42,472.22L175.42,472.22L172.26,470.87L170.96,471.7L170.96,471.7L170,472.6L170,472.6L166.96,473.69L166.96,473.69L164.87,473.15L162.27,471.18L162.27,471.18L162.69,467.57L161.68,464.69L161.68,464.69L159.6,464.02L160.67,461.71L160.67,461.71L160.21,457.29L158.86,456.26L156.34,456.18L155.36,457.96L155.36,457.96L154.36,458.61L153.69,461.71L153.69,461.71L152.67,462.4L150.7,461.83L150.7,461.83L147.14,456.17L147.14,456.17L143.09,453.18L140.07,452.57L138.5,454.44L137.42,454.22L137.42,454.22L135.89,453.87L135.89,453.87L133.62,454.85L132.83,456.84L132.83,456.84L132.39,460.61L132.39,460.61L130.79,462.24L130.79,462.24L131.05,463.01L131.05,463.01L130.43,465.98L128.01,467.2L128.01,467.2L124.87,468.17L123.34,469.66L123.34,469.66L121.27,470.37L120.3,469.94L120.3,469.94L118.2,470.06L116.75,471.6L112.4,471.83L112.4,471.83L112.03,470.13L110.31,470.13L109.07,466.07L107.19,463.89L106.26,458.27L104.39,456.71L104.39,456.71L102.51,456.09L102.51,456.09L98.68,455.59L103.8,445.76L105.16,447.05L105.4,445.48L107.19,444.32L109.39,445.25L111.62,443.16L114.17,443.48L114.41,444.74L115.93,441.17L116.48,441.33L116.43,440.11L117.87,439.69L119.47,440.17L121.94,443.23L121.63,439.95L120.66,439.37L121.81,438.31L120.42,438.34L118.37,436.64L118.08,437.51L116.61,437.28L115.82,438.21L114.59,437.25L114.17,438.02L109.26,437.99L108.1,439.08L107.19,439.02L106.84,438.02L106.27,439.08L104.56,438.34L103.46,436.32L102.22,436.9L101.49,435.26L102.54,433.36L101.28,432.33L105.58,429.88L108.92,426.31L110.76,425.12L111.91,425.73L114.41,423.61L117.48,419.36L116.77,415.04L117.82,413.43L119.68,414.36L124.31,413.65L128.8,414.85L130.9,416.59L132.24,419.62L132.92,418.97L131.69,418.62L132.29,416.33L131.6,413.43L122.84,408.43L124.28,406.95L127.48,405.72L132.79,405.95L133.71,404.82L133.79,402.72L136.7,401.3L132.53,401.43L130.87,403.08L128.06,402.79L125.91,403.56L122.65,402.56L121.29,403.79L116.11,403.5L116.3,396.94L111.75,396.46L111.73,395.36L109.84,393.88L110.57,392.97L115.48,392.62L116.64,393.62L117.35,392.78L123.07,391.97L124.73,390.74L127.61,391.87L129.32,390L129.64,388.67z"},{"code":"KR-SJ","name":"South Jeolla","path":"M66.62,587.6l0.37,1.2l-1.84,-1.17l-0.68,1.2l-0.21,-1.61l-1.02,0.06l0.03,1.58l-0.47,-1.11l-2.47,-0.19l0.18,-1.11l-0.95,0.22l1.71,-1.58l-0.24,-0.31l0.84,-1.08l1.29,1.68l3.34,-0.89L66.62,587.6zM93.4,563.47l0.89,-0.67l-0.47,-1.14l-2.42,-1.71l-0.68,-1.78l-0.92,0.32l0.63,-1.11l-2.44,0.79l-1.34,-1.52l0.76,-0.67l-0.73,-1.08l-5.78,-1.81l-0.13,2.48l1,0.54l-1.5,2.92l-0.84,-0.67l-0.08,1.21l-1.23,0.41l1.1,1.21l-1.89,0.16l-0.37,1.05l0.74,0.83l-1.13,0.54l-0.5,-2.28l-1.73,3.36l-5.25,2.89l0.95,1.71l-0.66,-0.57l-1.13,0.44l-1.73,3.1l2.7,4.56l2.34,-0.79l0.29,0.79l-1.02,0.44l0.39,0.6l-0.94,1.23h1.65l-0.13,-0.73l0.76,-0.22l0.92,1.62l2.26,0.06l2.65,-0.98l-0.66,-1.27l1.23,0.54l0.92,-0.89l0.6,0.67l0.89,-1.2l1.63,0.13l0.13,-2.12l1.5,0.79l1.58,-0.82l-0.81,-0.98l0.89,-0.38l0.81,0.7l-0.37,-1.2l1.16,0.86l-0.24,-1.81l1.39,1.74l-0.37,0.73l1.23,0.03l-0.03,-1.68l2.81,-3.17l-0.71,-1.65l1.31,-1.68l-1.21,-0.35l0.03,-0.85l1.5,-0.41l0.58,0.86l-0.05,-1.62L93.4,563.47zM51.65,536.57l1.05,-0.16l-1.26,-1.91l0.05,-1.46l5.04,-0.67l0.34,-1.34l1.16,-0.16l-0.26,-2.83l-2.02,0.32l-0.97,1.91l-1.23,-0.25l0.21,0.64l-1.21,0.73l-3.99,-0.6l0.42,1.21l-0.81,0.38l-0.13,-0.54l-0.39,0.76l0.58,0.7l-0.73,3.28l2.86,1.81l2.13,-0.6L51.65,536.57zM131.13,584.47l-2.07,-0.73l-1.81,-3.77l0.08,-2.82l-1.08,-1.2l-3.39,-1.84l-4.07,1.96l-0.05,5.13l0.71,0.67l-0.5,0.89l1.97,0.41l2.84,3.61l1.55,-0.6l2.5,1.27l-0.18,-2.09l1.18,1.49l2.78,0.51l-1.39,-1.87L131.13,584.47zM55.48,538.28l-0.97,-2.39l-0.16,1.81l-1.23,-0.06l-0.1,2l-0.97,-0.57l0.26,-0.6l-2.1,0.44l-0.21,2.96l0.6,1.65l1.13,-0.79l-0.05,1.11l0.84,0.51l1.29,-1.02l-0.1,1.56l0.97,0.32l1.5,-0.67l0.03,-1.08l1.5,-1.02l0.16,-1.05l1.08,0.29l0.47,-1.21L55.48,538.28zM122.86,599.4l-3.36,-2.15l-0.66,1.55l-0.89,-0.09l1.81,2.05l-2.07,2.12l-0.05,1.61l0.71,1.64l1.37,-0.79l-0.13,1.61l1,0.47l0.89,-1.04l-0.13,-2.62l1.1,0.38l0.26,-1.07l-1.31,-0.03l-1.08,-2.65l2,-0.25L122.86,599.4zM115.59,594.53l-2.76,-0.54l-0.52,0.73l-0.47,-1.39l-1.42,0.06l1.23,1.68l-0.89,0.1l-0.26,0.76h0.97l-1.13,0.67l0.39,1.26l-0.92,0.41l1.6,0.41l-0.05,1.17l2.57,0.54l-1.34,-1.55l2,-0.51l-0.1,0.92l1.89,-0.03l-1.23,-1.93h1.81l-0.6,-1.74L115.59,594.53zM113.12,600.69l-0.6,1.01l-0.5,-1.11l-1.39,0.28l-1.55,-1.61l-3.28,2.5l-0.08,2.46l0.84,1.96l1.39,0.06l4.67,-2.68l0.24,-1.55l1.13,-0.6l1.16,2.02l0.05,-1.67l1.23,1.39l0.47,-1.86l-1.1,0.35L113.12,600.69zM59.92,555.76l0.97,-0.13l0.55,-1.3l0.6,0.98l1.81,-0.51l0.37,-1.17l-0.42,-1.11l-0.71,0.64l0.24,-2l-1.44,0.45l-0.84,-1.27l0.79,-2.13l-1.05,0.25l0.16,-0.79l-1.86,0.45l0.6,1.43l-0.52,2.54l0.82,-0.44l0.6,0.57l-0.66,0.6V555.76zM83.68,520.43l-0.76,1.82l-2.81,-0.89l-0.47,1.82l3.31,1.02l1.58,-1.88l3.15,0.35l0.37,0.86l1.29,-0.57l1.39,1.91l-1.71,1.08l0.45,0.67l1.76,0.54l0.18,-0.95l1.5,-0.22l0.05,-3.69l-1.08,0.45l0.03,-1.27l-3.12,0.32l-0.97,-0.83l1.02,-0.48l-1.08,-0.73l1.16,-0.19l0.05,-1.24l2.42,0.16l-0.03,-0.99l-1.44,-1.24l-2.26,0.19l-1.31,-1.66l-1.57,1.05l2.07,2.97l-1.02,0.64l-1.18,-0.61l-0.21,1.63l0.71,0.64l-1.1,0.38L83.68,520.43zM70.14,537.17l1.42,-0.13l0.63,3.02l2.78,-0.57l0.29,-1.78l-1.81,-4.07l-1.79,0.67l-1.71,-2.23l-1.73,0.54l-1.81,-0.92l-0.34,1.21l-0.66,0.03l0.45,1.43l-0.87,2.13l2.05,-1.21l0.1,1.02l0.66,-0.29l-0.37,1.88l1.18,-0.16l0.68,0.76L70.14,537.17zM75.57,547.31l0.32,-1.52l-3.05,-2.35l-0.97,0.32l-0.63,1.56l-0.79,-0.57l-0.31,0.95l-1.18,0.1l0.26,1.02l1,-0.64l0.58,0.73l-1.05,1.62l0.71,1.62l2.05,-0.57l0.47,-0.95l1.68,0.57l0.63,-1.05l1.52,-0.16l0.29,-1.21L75.57,547.31zM73.92,497.36l0.13,0.7l0.97,-0.29l-0.55,0.77l1.89,0.38l0.42,-0.61l0.84,1.05l1.79,-0.16l0.97,0.61l-0.42,1.66l0.92,0.19l0.87,1.6l1.42,0.13l0.97,-1.91l-1.15,-0.73l-0.39,-2.43l-1.42,-0.99l0.5,-2.75l-0.52,-0.64l-1.39,0.9l-0.39,-1.05l-1.97,0.35l-1,-1.25l-1.05,0.23l-2.28,1.37l0.76,1.79L73.92,497.36zM65.2,522.91l-1.57,0.29l3.05,3.85l0.37,2.07l2.21,-0.35l0.5,-1.4l-0.92,-1.65l0.79,-1.15l1.13,0.51l1.6,-1.24l-1.73,-1.11l-0.03,-0.8l1.84,0.06l0.6,-0.8l-1.39,-1.82l-0.47,0.77l-2.21,-0.89l-0.58,0.38l0.16,1.78l0.89,0.73l-0.5,0.92l-3.1,-1.11L65.2,522.91zM73.29,505.98l0.63,-1.88l-3.78,-1.37l-2.78,2.97L73.29,505.98zM55.96,521.41l5.2,0.54l1.05,1.85l-0.18,-1.78l0.76,-0.22l0.21,0.76l1.44,-0.45l-0.34,-0.8l1.97,0.1l-0.6,-1.43l1.92,-0.92l-1.44,-1.5l1.52,-1.4l-1.42,-0.22l0.71,-1.21l-1.23,0.29l0.11,-1.31l-2.1,-0.86l0.39,2.17l-0.58,0.96l-1.02,0.19l-0.42,-1.11l-0.66,1.21l-1.81,-0.35l-2.2,4.21l-2.13,0.03l1.39,0.89L55.96,521.41zM63.6,498.42l0.18,-0.35l1.58,-0.26v1.6l2.36,0.96l0.03,-1.56l1.52,0.1l-0.81,-1.53l1.23,-0.22l-1.79,-1.76l0.32,-1.5l1.18,-0.03l0.32,-3.1l3.83,-1.66l-4.65,0.23l-0.1,1.09l-2.81,2.97l-3.2,0.57l-0.68,2.27l1.58,0.93l-0.31,0.86l-1.68,-0.25l1.05,1.05L63.6,498.42zM5.33,542.07l-1.34,-0.73l1.29,-1.05l-3.1,0.57l0.05,1.24l-2.08,2.92l1.08,1.02L0,546.64l0.95,1.65l1.58,0.57l-0.08,-1.68l1.63,-0.7l-0.55,-1.59l1.89,-0.48l0.24,-2.06l1.86,-0.64l-1.02,-1.05L5.33,542.07zM143.87,599.08l0.5,-1.2l-0.79,-0.88l0.71,-1.2l-1.89,-0.54l-1.86,0.85l-0.18,0.82l-1.18,0.31l0.03,2.53l-1,0.35l1.16,0.54l-1,0.89l0.71,1.39l1.18,-1.77l1.1,1.86l1.79,-0.69l0.79,0.6l1.02,-0.91l0.13,-3.28L143.87,599.08zM226.87,518.86l-0.13,-3.44l-1.71,-1.69l-2.7,-0.06l0.26,-1.72l-0.79,-0.64l-2.57,2.58l0.05,2.01l5.36,1.21l0.5,0.7l-0.29,-2.71l0.95,-0.35l0.94,3.92L226.87,518.86zM227.32,553.44l1.55,-0.6l0.16,-0.86l-1.86,-1.24l0.32,-2.16l0.84,-0.35l-0.18,-2.89l0.74,-0.73l-1.02,0.13l0.55,-0.73l-1.55,-0.38l-0.79,-1.24l0.29,-1.88l-1.29,0.35l-0.66,-1.08l0.58,-0.76l0.84,0.67l0.16,0.29l1.31,0.32l-0.24,-2l-4.52,-1.94l0.68,2.26l1.13,0.16l-0.18,2.54l1.44,0.7l-1.79,0.32l-0.5,1.46l-2.28,1.49l-0.58,1.43l0.66,0.95l-1.34,1.52l2.55,1.18l1.16,2.16l1.44,-0.09L227.32,553.44zM218.86,537.52l-2.1,-1.27l0.34,-0.67l-1.76,-1.08l0.05,-0.73l-0.6,0.16l0.18,1.02l-2.26,3.05l0.71,1.44l-1.55,-0.55v-0.83l-0.42,1.31h-0.73l1.31,1.27l-0.42,1.02l1.39,0.35l-1.55,0.67l1.31,2.23l-0.66,0.51l1.31,0.51l-1.21,1.46l1.02,0.03l0.42,1.14l-2,-0.29l-0.97,-1.62l-2.42,-0.98l-1.21,0.38l0.45,2.16l-2.78,-4.1l1.18,-1.18l-1.1,-0.35l0.05,-1.59l2.36,-0.89l-1.29,-0.06v-0.83l-1.02,0.96l0.37,-1.53l-0.81,0.1l1.47,-1.27l-0.24,-0.92l0.63,0.48l1.05,-0.57l0.34,-1.43l1.92,0.06l-1.81,-0.6l0.63,-0.83l-0.68,-1.34l-1,1.08l-0.03,-1.59l-1.29,-0.38l1.37,-0.73l-1.37,-1.43l-0.13,-1.3l-3.12,-0.22l0.18,-1.62l1.6,-2.16l-1.65,-0.26l-0.79,-4.01l-2.55,0.7l0.19,3.06l-0.6,0.77l-1.78,-0.54l-2.34,0.92l-0.47,-1.37l-0.42,1.37l-3.36,1.34l-1.29,-1.34l-2.34,-0.1l2.23,1.18l0.92,1.46l3.36,0.03l-3.1,2.01l-0.79,2.01l-1.94,-0.1l3.44,1.24l-0.39,1.24l-2.39,1.88l1.55,3.4l3.28,2.29l0.81,1.34l-0.45,0.7l1.84,0.03l-0.24,1.37l1.21,-0.83l-0.05,0.83l0.95,0.1l-0.47,-1.08l1.47,-0.13l-0.39,2l1.55,0.51l-0.03,0.89l-1.18,-0.67l-0.34,0.83l-0.92,-0.95l-0.47,0.44l0.84,0.92l2.78,0.6l0.81,4.26l-1.71,1.43l-0.05,0.98l-2.44,-0.79l-0.39,-1.27l-1.23,1.68l-1,-1.3l-1.47,0.64l-0.92,-0.92l-3.96,0.57l0.05,0.67l2.36,-0.19l0.24,0.95l1.31,-0.79l-0.39,1.37l-2.21,0.38l-0.18,1.08l1.97,-0.57l2.26,0.38l-0.63,0.57l1.37,-0.32l0.45,2.28l-1.26,0.44l0.63,2.19l-2.07,-0.89l-0.34,1.68l-1.42,-0.6l-1.05,0.73l1.13,1.43l-0.24,0.92l-0.89,-0.48l-0.84,0.79l-1.34,-1.3l-0.47,1.62l-0.63,-0.66l-1.65,0.82l1.13,1.01l-1.68,0.19l1.68,0.95l0.26,1.01l-1.13,0.82l-2.21,-0.85l0.03,-0.63l1.1,0.03l-0.71,-0.98l-1.18,-0.03l0.34,-0.86l-3.05,-1.24l1.42,-1.93l-2.76,-2.63l-0.97,0.03l-0.03,0.73l-1.18,-0.38l0.21,-0.79l-2.39,-2.09l0.08,2.6l-2.52,-1.71l-0.84,1.74l-0.5,-0.67l-2.94,0.35l-1.47,-0.79l0.08,-1.24l-0.94,-0.63l0.47,-1.94l2.63,-2.41l0.34,-1.87l0.95,1.08l1.23,-0.38l0.05,-3.59l2.55,-2.54l2.68,-0.67l0.42,-2.48l1.1,-1.08l-0.39,-1.65l2.23,-1.97l0.68,0.54l0.97,-0.79l0.5,2.77l-0.73,2.42l0.76,0.8l2.68,0.25l1.71,-4.93l1.13,-0.35l-1.15,-0.54l-0.63,-4.17l-2.05,0.25l-1.13,2.19l-1.97,-1.24l-0.76,1.15l-1.73,-3.31l-1.55,0.35l-4.25,7.25l-3.86,0.13l-1.31,-1.21l-2.94,3.66l-2.94,1.08l-1.79,2.95l-2.76,1.27l-2.28,0.19l-0.03,0.95l1.39,0.76l-1.02,0.45l-0.66,2.57l-1.08,0.95l0.95,0.7l1.63,-0.32l-0.13,1.49l-1.6,-0.48l0.03,2.48l-1.55,-0.38l-1.15,1.3l1.66,2.03l-0.95,0.51l-0.37,1.56l1.5,2.09l-2.05,0.82l-1.39,-1.59l-0.58,0.83l0.97,2.31l-0.84,1.05l-1.65,-0.79l-4.73,-0.19l1.52,2.47l-0.16,1.46l-1.21,-1.81l-2.6,-1.58l-2.55,0.35l-1.29,-0.92l0.29,-1.4l-2.05,-0.06l1.02,-1.24l-0.94,-3.84l1.05,-3.93l-0.66,-0.51l0.42,-1.71l-0.87,-1.02l0.24,-1.17l-1.02,-0.92l0.84,-5.18l-1.55,2.73l-0.6,9.43l0.55,0.64l-1.05,0.67l0.68,2.63l-2.55,1.55l0.79,1.55l-2.21,3.3l-2.36,0.28l-2.34,1.43l-0.08,0.95l-0.81,-0.82l-1.37,0.48l-0.52,1.49l-0.97,-0.25l-0.55,1.05l-0.55,-0.57l-0.6,0.79l0.5,0.57l-0.94,1.17l0.84,0.73l-0.05,2.34l-1.71,1.08l0.6,0.51l-0.79,1.01l0.53,2.37l-4.28,-0.85l-1.5,2.21l-1.44,0.25l-0.34,1.01l-0.87,-0.31l0.26,-2.21l-0.66,-0.54l1.39,-1.68l-0.6,-3.07l-1.44,-0.63l-3.18,2.03l-0.6,-1.08l0.32,-0.66l0.92,0.85l-0.21,-1.01l0.97,0.09l-1.26,-2.22l2.39,-0.41l-1.08,-2.44l1.68,0.92l1.08,-1.65l-0.71,-2.82l-1.13,0.92l-1.29,-0.28v0.98l-2.63,-2.44l0.84,-0.85l0.37,-0.25l0.16,-1.65l-0.63,0.25l-0.74,-0.95l1,-0.73l-0.92,-2.06l1.34,-0.82l-0.79,-1.36l-1.92,-0.16l2.21,-1.68l-0.31,-0.82l-2.05,0.64l-0.03,-1.59l-2.28,-0.79l0.21,1.21l-1.5,0.25l0.03,0.95l-1.44,0.7l-0.79,-0.79l0.92,-2.35l-2.21,-0.09l-2.86,-1.43l-2,0.7l-0.94,-1.14l0.87,-1.02l-3.18,-1.18l0.11,-2.95l1.23,-1.02l-0.42,-0.57l-0.45,0.64l-1.18,-0.29l-1.18,-1.14l-0.45,-4.19l0.76,-0.7l-0.16,-2.45l0.58,0.45l0.68,-1.11l1.05,-5.15l1.31,-0.54l1.05,0.99l-0.32,0.73l1.26,-0.13l1,3.25l1.76,1.4l-1.55,1.3l0.16,2.77l-0.71,0.99l2.55,1.43l-0.1,2.89l1.31,0.64l0.26,1.84l1.02,-1.49l6.75,4.06l-0.18,-0.89l2.89,-1.46l0.45,-1.14l-0.87,-0.54l-2.02,0.98l-0.45,-2.89l-1.18,1.18l-0.81,-2.45l-1.05,0.25l0.5,-1.84l-0.74,-0.06l0.05,-0.83l-0.87,0.03l-0.31,1.24l-1.39,0.92l-1.08,-0.95l1.65,-1.97l-0.7,-2.41l1.13,0.92l0.47,-0.41l-0.73,-1.78l-1.05,-0.19l1.05,-0.95l1.81,3.5l1.65,-1.91l0.5,0.6l0.55,-0.95l1.13,0.67l-2.57,3.59l1.13,1.27l0.97,-0.38l-0.03,0.89l1.63,1.21l3.94,0.51l1.58,1.37l1,-1.33l-1.31,-0.38l0.13,-1.4l2.21,0.22l0.31,0.89l3.26,1.4l3.54,-0.16l-2.81,-0.86l-3.02,-2.22l0.24,-2.67l-2.39,-0.13l-1.18,-2.92l-2.68,-3.18l-2.47,-0.25l-1.44,1.11l-0.73,-1.65l-1.71,0.54l-1.58,-1.08l-2.41,1.85l-2.34,-0.86l1.63,-1.56l-0.21,-1.56l1.16,-0.44l-0.08,-1.34l-1.99,0.13l-0.71,-2.17l2.99,-4.26l1.81,-0.7l-1.6,-2.9l0.63,-1.31l-1.29,-0.35l0.29,-1.98h0.84l0.45,-1.27l-1.47,-1.88l0.66,-0.73l-0.79,-1.21l0.53,-2.23l-1.15,-0.77l-0.92,-3.25l-0.31,2.77l-0.87,0.7l0.08,0.77l1.42,0.61l-0.89,1.44l0.76,0.51l-0.71,0.86l0.39,0.93l-2.49,1.05l-1.36,-0.16l-0.24,-1.62l-1.92,0.25l-0.18,-0.73l1.5,-1.05l-2.44,-2.52l1.63,-2.55l-0.29,1.4l0.95,-0.67l0.81,1.69l1.89,-0.96l0.95,-2.04l-1.86,-0.41l4.91,-3.16l-0.08,-1.5l-0.89,-1.12l-2.63,0.83l-0.26,-2.04l-1.65,-0.41l1.26,-0.96l-1.15,-2.17l-1.34,-0.03l-0.13,0.73l-1.37,-0.96l1.21,2.24l-1.37,1.05l1.26,0.9l-1.29,1.21l-1.47,-2.08l-2.08,0.99l-0.6,-3l-1.02,-0.67l0.42,-1.28l1.65,-0.13l-2.21,-2.43l0.82,-1.92l0.76,0.31l-0.26,-1.3l1.47,-0.9l0.71,1.92l1.05,-0.83l1.37,0.42l0.08,1.25l1.29,-0.06l0.92,-1.63l-0.6,-0.77h0.97l1.08,-1.28l0.05,2.56l-0.68,2.33l-0.76,0.22l-0.13,2.46l1.21,0.22l0.89,-1.02l-0.71,2.65l1.23,0.42l0.74,-0.57l0.21,1.95l2.23,-2.75l-0.66,2.27l1.13,-1.18l1,1.53l-1.55,2.27l0.97,-0.03l0.1,1.85l2.23,-0.06l-0.58,-1.76l2.1,-1.4l1.44,-2.3l-2.07,-0.96l2.1,-0.67l0.66,-1.18l-4.07,-0.73l-3.62,-5.82l-2.18,-1.25l0.29,-1.34l-1,-0.48l1.63,-0.54l0.68,-2.56l-4.1,0.86l-1.57,-0.8l-0.26,-1.73l-1.37,-1.12l1.1,-2.08l1.34,2.85l1.37,-1.38l-0.55,-0.99l1.6,-2.18l-0.29,-0.7l-1.76,0.03l0.74,-1.31l3.13,0.03l0.74,-5.29l1.76,-4.45l4.7,1.57l-3.47,-2.37l-0.76,-2.4l0.45,-2.34l1.47,-1.41l4.49,-0.23l0,0l1.87,0.62l0,0l1.87,1.56l0.94,5.62l1.87,2.19l1.25,4.06h1.71l0.38,1.7l0,0l4.35,-0.23l1.45,-1.54l2.1,-0.11l0,0l0.97,0.43l2.07,-0.71l0,0l1.53,-1.5l3.14,-0.96l0,0l2.41,-1.22l0.62,-2.97l0,0l-0.26,-0.77l0,0l1.6,-1.63l0,0l0.44,-3.77l0,0l0.79,-1.99l2.27,-0.98l0,0l1.53,0.35l0,0l1.08,0.22l1.57,-1.87l3.02,0.61l4.04,2.99l0,0l3.56,5.67l0,0l1.97,0.57l1.02,-0.69l0,0l0.67,-3.1l1,-0.64l0,0l0.98,-1.79l2.52,0.08l1.35,1.04l0.46,4.41l0,0l-1.06,2.31l2.08,0.67l0,0l1.01,2.88l-0.42,3.61l0,0l2.59,1.98l2.1,0.54l0,0l3.03,-1.09l0,0l0.96,-0.9l0,0l1.3,-0.84l3.16,1.36l0,0l1.93,-1.12l1.44,1.37l0,0l1.13,0.66l6.15,-0.02l0,0l2.38,-0.7l3.19,0.36l0,0l1.75,-0.46l2.95,-3.79l1.76,-0.98l0,0l2,-0.11l0,0l4.54,2.08l0,0l6.38,4.46l0,0l-0.8,2.26l2.66,2.99l0.91,9.22l6.57,6.46l0.19,2.9l0,0l1.09,1.05l0,0l3.56,3.8l0,0l1.75,1.33l0,0l2.24,8.23l-2.78,-0.09l-1.36,-2.97l-2.97,1.66l-0.05,-2.9l-1.42,-2.04l1.13,5.2l-1.79,2.1l-2.02,0.77l0.29,1.44l-3.2,1.53l-0.94,1.37l-0.95,-1.21l0.45,-0.57l-2.07,0.22l-1.52,-2.26l0.16,-2.45l-0.71,-0.67l-0.13,3l-1.97,0.54l2.44,1.88l-0.5,0.8l-0.39,0.19l-1.92,0.8l1.44,0.54l1.58,3.76l2.89,0.67l-0.94,1.31l1.16,1.43l0.03,-1.11l2.31,0.8l2.55,-1.78l0.92,-1.53l0.11,-0.29l3.18,-0.96l-0.95,0.86l1.76,0.7l-0.13,-0.76l2.31,-0.83l1.34,1.34l-0.84,0.19l-0.29,5.89l-0.89,-0.06l-1.34,2.61l0.97,4.55h-2l-0.26,1.11L218.86,537.52zM152.01,485.22l-1.02,-4.54l-1.94,-2.34l-1.83,-0.87l-2.44,-0.09l-4.44,2l-2,2.09l-1.48,0.09l-3.57,-2.09l-0.61,-2.18l-2.18,-0.09l-2.09,5.31l-2.35,-0.09l-1.74,2.09l-1.13,4.79l0.44,4.09l7.23,1.04l3.75,6.1h3.75l3.4,-2h3.83l1.48,-1.04l3.14,0.61l3.4,-2.35l1.39,-1.83l1.74,-6.1v-1.39l-2.09,-0.96L152.01,485.22zM201.87,568.35l-1.42,-2.28l-0.05,1.14l-0.68,-0.41l-0.45,1.01l-0.92,-0.03l0.66,-0.82l-1.68,0.16l-1.76,-1.17l0.39,2.57l-0.81,0.48l2.21,-0.51l1,0.6l-0.21,0.63l-1.86,-0.22l1.21,1.27h1.68l-0.55,1.74l0.5,0.7l2.7,-1.71l1,0.48l0.76,-0.95l-0.1,-2.06L201.87,568.35zM225.16,561.91l1.39,-0.51l-1.84,-2.25l-0.55,-2.16l-1.71,0.03l-2.55,1.75l-1.42,-0.13l2.18,1.78l1.26,-0.41l-0.74,1.17l1.5,0.7l-0.6,0.89l1.84,-0.19l-0.03,0.64l1.65,0.28l-0.87,0.57l2.71,0.51l0.76,-1.17L225.16,561.91zM221.43,518.23l-0.94,-0.83l-1.76,0.67l-0.68,1.18l0.95,0.73l-0.47,0.45l2.26,0.57l0.92,-1.91l1.58,-0.38l-0.34,-0.57L221.43,518.23zM131.79,576.56l-1.31,2.6l1.39,0.82l0.03,-1.9l1.08,-1.46l2.55,-0.1l0.55,-1.96l2.31,1.24l1.55,-0.1l0.08,-0.82h-0.71l-0.16,-1.36l-0.81,0.13l0.21,-1.24l-1.1,0.82l-1.42,-1.01l1.79,-0.1l0.29,-0.98l-1.13,-0.29l-0.08,-1.39l-4.25,1.24l-2.23,2.57l0.34,1.36l-1.71,2.25L131.79,576.56zM196.99,564.61l1.44,0.32l0.39,-0.7l0.58,0.7l1.13,-0.82l-1.39,-1.97l-2.89,-0.22l0.16,-0.79l1.21,0.38l-1.52,-1.78l1.84,-0.79l-0.47,-0.92l-1.52,-0.16l-2.23,2.89l2.05,1.05l-0.42,0.54l0.66,0.44l-1.68,1.05l0.95,1.56l1.02,0.16L196.99,564.61zM228.5,568.48l0.32,-1.01l-1.08,0.57l0.29,0.89l-1.15,2.22l1.5,-0.25l-1.47,1.65l0.26,0.54l0.87,-0.48l0.11,0.82l0.71,0.03l0.97,-5.04l-0.71,0.48L228.5,568.48zM149.75,581.43l-1.16,1.36l0.26,2.12l0.55,-0.38l0.81,1.27l4.02,-2.59l-0.13,-0.92l-1.58,-0.85H149.75zM140.06,584.31l-0.05,-0.95l0.53,1.46l1.08,-0.03l-0.24,-2.34l1.5,-0.16l0.1,-1.52l-1.68,0.92l-0.71,-1.45l-1.44,0.41l-0.13,-0.66l-0.68,0.85l-1.5,-1.61l-1.37,1.3l0.13,1.04l-1.23,0.51l-1.6,-1.42l-1.39,1.27l-2.18,-0.13l2.73,0.98l1.21,1.39l1.44,-1.39l1.87,0.13l1.21,3.13l1.31,-1.2L140.06,584.31zM160.75,579.31l-0.89,-0.48l-2.91,1.27l0.05,-1.96l-1.55,-1.46l-0.21,0.89h-1.63l0.63,0.63l-0.89,0.06v1.14l-2.13,-0.32l2.13,1.24l0.71,-0.73l1.34,0.86l0.34,0.79l-1.42,0.32l1.16,0.67l2.05,-0.95l0.13,0.73l-1.57,1.11l0.42,1.84l1.66,-2.78l2.02,-0.51l-1.71,-0.28l0.55,-0.89l3.31,1.14l-1.89,-1.74L160.75,579.31zM144.45,575.48l-0.6,-1.33l-0.66,0.6l-0.47,-0.7l-0.16,0.92l-1,-1.27l-0.76,0.79l-0.05,-0.89l-0.87,-0.41l-0.31,0.63l0.95,1.36l-0.79,2.38l0.68,0.57l1.34,-0.6l0.32,1.62l1.79,0.7l1.63,-0.79l0.39,-1.17l1.81,0.35l-0.66,-1.96l1.02,-2.12l-0.55,-1.11l-1.24,2.5L144.45,575.48zM175.61,591.75l-0.03,1.17l-0.92,0.1l-0.71,2.78l1.47,-0.66l1.68,0.85l-0.81,-1.2l1.1,-0.28l-0.34,-3.07L175.61,591.75zM173.01,563.59l-1.39,0.86l-2.02,-0.29l-3.49,2.03l-1.34,-0.63l-0.42,-1.43l-0.79,0.06l-0.16,1.62l-2,0.67l1.26,1.74l-0.66,1.4l1.63,-0.63l-0.08,1.08l2.52,2.12l0.58,-1.24l1.47,0.28l0.21,-0.76l4.04,0.63l2.47,-5.29L173.01,563.59zM154.79,568.16l1.1,0.67l0.34,3.2l0.81,0.79l0.6,-0.32l-0.26,-1.27l1.05,0.25l0.13,2.79l1.18,-3.14l-0.92,-2.54l-0.97,-0.82l-0.39,0.76l-0.6,-0.95L154.79,568.16z"},{"code":"KR-NG","name":"North Gyeongsang","path":"M452.87,219.76l0.41,1.32l-0.76,0.88l-1.29,-0.54l-0.34,-0.96M452.87,219.76M442.25,208.93l0.94,0.28l-1.05,1.46l0.96,1.76l-0.73,2.61l0.94,0.68l-3.53,1.86l-0.75,1.9l-6.31,-2.46l-1.42,-5.79l0.75,0.48l4.06,-2.08l4.47,-0.62l0.77,-0.86L442.25,208.93zM299.65,432.93l-0.47,3.05l0,0l1.69,3.67l0,0l4.45,3.48l5.88,-1.1l7.44,2.75l0,0l1.92,0.57l5.51,-3.83l1.01,0.3l0,0l4.96,-4.15l2.1,0.04l0,0l2.93,0.87l0,0l3.7,1.57l0.96,-0.35l0,0l4.69,-3.88l0,0l0,0l0,0l1.66,-0.17l0,0l0,0l0,0l1.33,-0.73l-1.58,-3.54l4.75,-3.07l3.11,-1.02l4.22,-0.36l2.9,1.89l2.01,0.31l1.21,1.41l0,0l-0.43,2.84l0,0l1.02,1.11l0,0l1.98,0.65l0,0l5.37,-2.39l0,0l8.14,2.15l0,0l3.01,0.22l-1.44,-1.38l-0.24,-2.32l1.26,-2.38l1.05,-0.1v-1.61l1.15,-1.29l-0.45,-1.83l2.37,-7.54l-0.63,-1.9l1.94,-2.06l-0.29,-2.13l2.47,-5.52l-1.6,-0.32l1.1,-1.06l-0.44,-1.32l0.87,-0.74l-1.52,-3.23l2.94,-2.65l0.24,-3.17l3.07,-4.36l-0.68,-0.94l0.63,-2.49l-1.21,-3.75l-1.18,-1.07l-1.23,0.29l-0.92,2.3l-3.07,3.33l-0.05,1.33l-4.17,2.49L384.84,391l-0.82,0.26l-2.54,-1l-0.26,-2.13l-2.34,0.61l1.37,-1.91l2.26,-0.19l-2.6,-0.94l-1.68,1.16l-1,-1.65l0.66,-2.33l3.47,-1.36l-0.18,-1.45l1.31,-1.65l0.08,-0.97l-3.02,-2.49l-0.47,-6.02l-1.39,-0.61l-0.84,-1.59l1.39,-2.24v-2.3l-1.23,-1.46l0.81,-2.5l-0.68,-1.59l1.29,-7.98l4.6,-8.25l-0.24,-6.31l1.79,-2.99l-0.87,-0.78l-0.29,-4.62l-2.7,-3.65l0.03,-4.59l2.39,-5.67l1.18,-0.98l1.31,0.07l1.26,-2.41l-0.55,-2.58l0.52,-1.43l-0.92,-2.84l1.05,-1.11l-3.02,-7.67l-1.68,-1.86l-1.23,-4.31l0.5,-6.9l-1.18,-3.96l1.05,-1.86l-0.97,-4.19l0.68,-0.52l-0.18,-2.52l1.6,-0.36l-5.25,-5.24l0.37,-2.02l0,0l-4.28,0.72l0,0l-1.87,2.19l-2.5,0.94l-2.81,2.5l0,0l-1.56,2.19v1.25l0,0l1.56,2.81l-6.53,0.16l0,0l-2.66,-2.27l-2.95,-1.03l-2.61,-0.4l-2.55,2.52l-7.43,-2.62l-3.35,0.72l-0.68,-1.32l-1.72,-0.68l0,0l-2.91,4.31l0,0l-0.94,1.25h-4.06l-6.24,-4.37l-2.02,0.18l-0.54,4.72l-1.11,1.12l-3.07,-1.37l-1.92,0.26l-4.25,-2.34l0,0l-2.2,2.16l-2.15,-0.25l0,0l-2.28,2.61l0,0l-0.62,0.28l0,0l-3.29,3.25l-2.8,0.81l0,0l-0.79,1.24l0,0l-3.55,2.75l-3.16,5.67l0,0l-0.83,1.57l0,0l-0.05,1.33l1.31,0.61l0,0l0.8,2.91l-2.84,3.9l-3.99,0.78l0,0l-0.92,1.03l-2.44,-0.05l0,0l-2.19,0.18l0,0l-2.49,-4.92l-3.24,-1.85l-1.18,-1.97l0,0l-1.67,3.05l-1.13,0.34l-0.44,3.23l0,0l-0.37,0.57l-5.7,-1.74l0,0l-0.42,-0.63l0,0l-1.06,-0.38l-0.61,0.63l0,0l-2.53,3.09l-1.38,0.19l0,0l-1.64,-1.75l-0.51,0.31l0,0l-2.86,6.69l0,0l3.4,5.25l-4.6,-0.91l0,0l-1.18,-0.67l-1.21,0.59l-3.31,-1.63l0,0l-2.87,3.73l0,0l-4.25,1.42l-1.68,2.38l0.48,2.22l-3.23,3.34l0,0l-1.76,1.55l0,0l-1.56,0.35l0,0l-0.99,1.91l0.73,1.1l5.37,1.13l1.22,1.22l-0.14,0.93l0,0l0.97,1.97l0,0l2.01,1.36l-0.42,1.71l0,0l-2.02,0.89l-0.81,7.63l0,0l0.6,2.48l-1.28,2.02l1.32,3.25l0,0l0.5,0.31l0,0l-1,2.56l-2.66,2.31l0,0l-0.07,4.29l2.15,1.78l0,0l3.42,-2.56l0.46,1.44l2.5,1.48l0,0l1.85,1.57l0,0l1.17,0.4l0,0l1.99,-0.84l0,0l2.23,-0.79l2.02,0.7l0,0l0.62,1.07l0,0l0.15,3.17l0,0l1.26,1.87l0,0l-0.6,1.28l-3.12,-1.41l-2.41,1.43l-1.18,1.74l1.18,2.96l-0.41,3.57l-1.76,1.46l-1.04,4.64l-1.84,2.6l-2.88,-0.1l-1.08,1.07l0,0l4.72,8.98l-1.29,5.01l0,0l0.13,1.94l1.18,1.37l2.09,0.38l0,0l0.71,0.37l0,0l0.31,2.61l0.94,0.56l0,0l3.92,0.54l0,0l1.74,1.76l0,0l7,0.52l1.49,0.75l0,0l2.04,1.49l0.78,2.88l0,0l0.66,0.5l0,0l2.07,0.99l0.43,1.76l2.52,1.49l0.94,1.79l-2.06,6.18l0,0l-0.27,1.66l0.89,1.64l3.8,1.49l3.44,-0.61l0,0l2.96,-1.09l4.49,1.36l0,0l2.24,2.18l0,0l1.71,1.25l0,0l-0.73,-3.43l-4.06,-4.99l0.31,-2.81l3.43,1.87h2.18l0.62,-2.5l-3.12,-3.43l1.25,-3.12l1.25,-2.81l5.31,-0.94l-0.31,-1.87l-2.81,-2.18l-4.68,-0.31l1.56,-5.93l2.19,-3.12l4.06,-1.87l0.62,5.62h2.5l3.43,-8.11l5.93,-1.25l2.81,-3.12l3.43,-0.94l3.12,0.31l3.74,3.12l0.63,7.49l1.87,4.06l-0.94,2.19l-3.43,1.25l-1.56,3.43v3.12l-2.5,0.31v1.87l1.25,1.56v4.06l-3.43,1.25l-1.56,1.87l-2.81,-0.31l-0.62,-2.81h-3.12l-2.18,1.25l-1.56,2.5l0.45,1.51l0,0l1.27,-0.2L299.65,432.93z"},{"code":"KR-SG","name":"South Gyeongsang","path":"M240.35,406.64l2.09,0.38l0,0l0.71,0.37l0,0l0.31,2.61l0.95,0.56l0,0l3.92,0.54l0,0l1.74,1.76l0,0l7,0.52l1.49,0.75l0,0l2.04,1.49l0.78,2.88l0,0l0.66,0.5l0,0l2.07,0.99l0.43,1.76l2.52,1.49l0.94,1.79l-2.06,6.18l0,0l-0.27,1.66l0.89,1.64l3.8,1.49l3.44,-0.61l0,0l2.96,-1.09l4.49,1.36l0,0l2.24,2.18l0,0l1.71,1.25l2.41,-0.06l3.49,-2.5l0,0l1.52,-0.38l2.42,0.89l0,0l1.35,-0.92l1.32,-4.27l1.27,-0.2l0,0l0.69,1.28l-0.47,3.05l0,0l1.69,3.67l0,0l4.45,3.48l5.88,-1.1l7.44,2.75l0,0l1.92,0.57l5.51,-3.83l1.01,0.3l0,0l4.96,-4.15l2.1,0.04l0,0l2.93,0.87l0,0l3.7,1.57l0.96,-0.35l0,0l0.77,-0.79l0,0l1.47,2.43v1.47l-1.2,1.05l0,0l-2.23,1.89l0.34,4.83l2.23,1.05h2.75l0,0l2.4,0.21l3.26,3.35l0,0l5.66,5.87l0,0l3.09,0.21l0,0l1.27,1.55l0,0l-2.95,2.71l-0.57,1.86l-4.87,0.57l-3.61,6.64l-1.84,-0.32l-3.95,2.48l-4.06,4.94l-4.15,0.14l-3.86,2.43l-2.29,0.29l-0.43,5.01l-6.93,2.61l0,0l-1.81,2.23l-0.97,-0.73l0.16,1.25l-2.26,-0.67l-1.13,1.05l-0.37,-0.73l-0.87,0.19l-0.05,-0.93l-1.23,-0.03l-0.6,0.83l-0.71,-0.73l1.5,-2.2l-0.6,-1.82l-0.87,-0.29l0.21,-0.99l-1.68,0.8l0.52,1.76l-1.18,0.96l-0.34,-1.53l-1.78,-0.73l0.29,-1.34l-1.84,0.32l-0.42,1.73l-0.63,-0.83l-0.84,0.26l0.76,-1.09l-0.47,-1.89l-1.52,-1.09l-0.21,-3.23l3.94,-2.37l-4.2,1.34l-2.21,2.59l1.39,1.6l-0.29,1.31l1.13,0.13l0.95,2.11l-2.18,0.54l-0.13,0.7l2.52,-0.06l0.05,3.39l2.44,1.95l-2.26,0.64l0.79,0.96l1.37,-0.32l0.87,0.7l-5.94,1.76l1.42,-1.15l-0.42,-0.22l-1.97,-0.19l0.58,1.37l-1.21,0.16l-1.29,-1.82l2.23,-0.16l-0.31,-1.21l1.86,-1.12l-3.78,-1.15l0.6,-0.73l-0.87,-0.03l-0.08,-1.44l-1.02,1.82l-1.55,0.64l-2.52,-1.18l0.1,0.83l-1.02,0.42l-2.28,-0.89l-0.21,1.06l2.97,2.11l-1.08,-0.38l-0.42,0.96l-2.1,0.19l-1.31,1.95h-1.15l-0.34,-0.89l-2.73,1.92l-0.76,-0.41l0.71,1.6l-1.23,0.48l-0.97,2.42l2.73,-1.08l0.11,-1.76l1.5,-0.89l4.07,-1.02l-0.18,-2.01l0.79,-0.19l0.39,0.83l0.97,-1.44l1.26,1.31l-0.05,1.21l-0.26,0.9l-1.79,-0.06l2.02,0.67l-0.03,1.4l1.97,1.5l-0.92,1.24l-0.84,-0.54l-0.6,1.95l-1.29,-0.51l-0.05,1.02l-5.2,-0.8l0.03,1.44l1.94,-0.42l1.21,0.38l0.24,1.05l-1.94,1.95l0.58,0.26l-0.42,1.69l1,0.89l-1.68,2.52l0.79,0.77l-0.6,0.77l0.18,2.77l2.36,-3.25l-0.6,-1.47l1.23,-0.1l1.1,2.52l0.97,0.26l-0.76,2.29l-1.05,-1.34v1.94l-0.87,-0.13l0.5,2.26l-3.94,1.37l2.76,0.64l0.24,0.92l-0.03,2.07l-1,0.16l0.81,0.86l-1.89,0.28l1.52,1.21l-1.15,2.23l-2.49,-0.38l-0.08,-1.69l-0.81,0.38l0.29,-1.18l-0.84,-1.21l-0.63,0.96l-1.13,-0.76l1.5,-0.95l-0.05,-1.27l-2.99,-1.21l-1.05,0.96l-0.58,-1.05l0.92,-0.41l-0.24,-1.43l0.66,1.11l0.95,-1.18l1.08,1.43l0.63,-0.54l1.23,2.52l-0.18,-1.75l1,0.32l0.95,-0.76l-1.1,0.32l-0.79,-0.57l0.42,-0.86l-1.31,0.1l-0.37,-1.15l1.73,-1.37l2.92,0.13l-0.34,-0.6h-2.81l-0.55,-2.36l-0.29,0.7l-0.79,-0.41l0.29,1.88l-1.57,-0.32l-0.47,-1.69l-0.21,1.56l-0.66,-1.02l-1.29,0.7l-0.03,-1.24l-1.08,0.8l-1.79,-2.71l1.39,-0.7l4.07,0.13l-1.39,-4.62l-1.02,0.19l0.21,-1.08l-1.31,-0.64l0.29,2.01l-2.02,0.89l0.47,2.07l-1.42,1.02l-0.71,-0.73l0.03,1.4l-1.55,-0.92l0.03,-3.22l-1.65,-0.25l-0.31,-0.16l-1.63,0.32l-0.58,-0.6l-0.42,0.83l-2.02,0.19l0.79,1.27l-0.18,3.7l-1.89,-0.16l-0.66,-1.4l-0.21,1.21h-0.74l-0.68,-1.21l-1.6,0.57l-0.87,1.56l-1,-1.85l-1.05,0.26l-0.73,-1.02l1.68,-1.31l-4.25,-0.06l-3.44,-1.94l-0.94,-2.04l2.18,-2.33l-1.34,-2.08l1.02,-2.33l-0.42,-0.8l-0.73,0.64l-0.16,-0.51l1.29,-5.46l1.16,-0.99l-0.63,-0.32l-2.02,1.53l-1.18,4.66l-1.42,-0.73l1.18,-0.64l-0.24,-0.7l-0.73,0.86l-2.05,-0.93l-0.89,1.34l1.92,-0.35l1,2.81l1.13,0.26l-1.05,3.35l-0.97,-1.59l-1.47,2.11l-1.13,-2.17l-2.18,1.47l0.5,0.86l-1.5,-0.54l0.37,-0.83l-0.87,-0.41l0.76,-0.22l0.08,-1.24l-1.55,-1.44l-0.6,3.83h-0.92l0.4,1.25l-1,0.13l-0.31,1.34l-1.84,1.34l-2.94,0.19l-0.24,-1.53l-0.58,0.38l-0.55,-0.86l-0.42,2.1l-1.72,-0.25l-0.09,0.41l-2.24,-8.23l0,0l-1.74,-1.33l0,0l-3.56,-3.8l0,0l-1.09,-1.05l0,0l-0.19,-2.9l-6.56,-6.46l-0.91,-9.22l-2.66,-2.99l0.8,-2.26l0,0l0.23,-0.2l0,0l2.22,-2.31l-0.55,-2.87l1.16,-3.15l3.7,-3.57l0,0l0.46,-4.01l-1.63,-0.43l-0.69,-1.93l0.69,-3.34l-1.27,-2.27l0,0l-0.42,-2.91l0,0l-2.77,-1.37l-0.17,-2.32l5.22,-14.41l0,0l0.89,-0.8l0.16,-1.92l0,0l0.78,-4.82l4.94,-4.74l1.66,-4.08l0,0l0.65,-0.47l0,0l2.02,0.44l1.83,-1.15l0,0l1.46,-0.01l3.11,-1.88l2.05,-4.62l2.33,-1.51l0.13,1.94L240.35,406.64zM325.68,498.1l0.5,1.44l1.02,-0.29l0.47,1.76l-1.63,3.42l0.66,0.8l-1.31,1.85l0.26,-0.6l-1.1,-0.96l0.82,-1.21l-2.05,-0.89l0.94,-0.8l-1.78,-3L325.68,498.1zM312.55,502.25l0.71,-0.64l1.31,0.51l0.89,1.47l-0.87,1.66l-1.05,-0.1l0.5,1.05l-1.37,0.06l0.79,0.51l-0.39,2.23l1.94,0.93l0.97,2.93l-0.87,-0.09l0.55,2.93l-1.26,0.22l0.63,1.31l-1.99,1.15l-0.05,1.05l1.45,0.29l-0.1,0.89l1.86,-2.23l0.97,0.57l-0.1,0.73l0.45,1.24l-0.66,0.7l-1.21,-0.29l1.16,2.39l-1.13,0.28l-0.58,-0.99l-1.6,1.05l0.66,1.43l0.87,-1.02l0.74,0.54l-0.6,1.08l2.02,4.14l-2.89,-0.86l0.55,-0.8l-0.76,-1.37l-1.16,1.91l-0.68,-0.19l0.21,-1.24l-2.07,-0.45l-0.24,2.29l0.71,0.86l-1.44,1.27l-1.18,-0.44l-0.73,1.78l1.39,2.39l2.71,0.19l-0.47,1.4l-1.94,-1.34l-2.49,1.02l-0.18,-0.7l-0.47,0.76l1.66,1.43l-0.16,0.92l-1.21,-0.48l-1.5,1.46l-1.81,-0.92l-1.29,0.76l0.79,-2.29l2.07,-0.98l-2.84,-1.11l0.21,-2.45l2.05,-0.16l-0.86,-0.76l0.5,-0.86l-2.13,-0.06l-1.24,1.4l-0.84,-1.08l1.42,-1.4l-1,-0.16l-1.39,1.56l0.24,-1.05l-0.66,-0.38l4.39,-1.18l0.03,-2.29l0.97,-1.62l-0.71,0.19l-1,-1.53l1.05,0.32l0.03,-0.7l-1.44,-0.83l-0.81,2.48l-3.31,-0.03l-0.1,1.37l-0.76,-0.25l0.37,0.92l-1.26,0.73l-0.94,-1.69l0.68,-0.86l-2.47,-1.08l-0.89,-3.73l1.89,-3.15l0.82,-0.06l-0.39,-0.7l0.81,0.35l-0.47,-0.8l1.44,0.19l0.92,-1.56l3.86,2.81l0.92,-0.16l-0.55,-0.92l1.44,-0.77l3.73,2.61l-0.58,-2.84l-1,0.29l0.26,-1.05l-2.42,-2.26l1.89,-3.09l-0.03,1.37l2.6,-0.35l-0.03,-0.64l1.63,1.05l-0.16,-1.66l1.08,-1.12l-0.55,-0.73l1.05,-0.26l-0.5,-0.8l1.08,-0.13l0.26,-0.29l0.73,-0.73l-1.31,0.13l0.76,-3l0.89,-0.13L312.55,502.25zM308.56,503.27l0.47,1.25l-0.81,3.61l-1.73,0.38l-0.5,-0.7l-1.15,1.08l0.21,-1.4l1.37,-0.83l-0.89,-0.77l1.58,-0.03l-0.23,-1.12L308.56,503.27zM237.11,511.92l2.21,1.27l0.18,-0.8l0.63,0.29v5.58l-2.23,0.83l-0.34,1.5l1.63,2.68l-0.58,0.92l3.18,1.43l0.16,2.13l1.71,0.26l-0.34,-0.86l2.94,-2.07l3.73,-0.29l1.47,1.4l1.42,0.1l0.47,2.32l-1.18,0.06l0.47,0.96l-0.76,1.21l0.87,3.53l-2.34,3.02l2.49,1.78L249.01,540l0.66,-1.94l-0.94,-0.6l-0.79,0.29l0.08,1.08l-1.52,-0.19l-0.34,-0.83l-0.47,1.43l-2.57,-0.06l-1.23,-4.29l0.63,-3.53l-4.36,1.34l0.71,3.69l-2.13,1.34l-2.99,-0.64l0.42,-0.73l-1.08,-0.41l0.18,-1.21l-1.5,-0.1l0.37,-2.13l1.08,-0.25l-1.71,-2.96l0.24,-1.43l-2.18,-2.9l-0.58,-2.83l1.05,-1.97l0.97,-0.06l0.08,-2.13l1.18,-1.4l0.39,0.61l1.65,-0.22l-0.97,-1.27l0.11,-1.56l1.08,-0.38l0.42,-1.24L237.11,511.92zM250.06,514.69l-1.92,6.37l1.29,0.29l-0.13,-2.07l1.31,-1.75l1,0.13l0.21,1.59l0.6,-0.26l1.08,1.31l-0.13,1.4l-1.1,1.05l0.76,-0.32l-0.13,1.18h1.45l1.08,1.94l-1.37,-0.86l-0.73,0.6l-0.97,-0.95l-0.79,0.32l-2.28,-1.53l-0.31,1.21l-1.39,0.32l-3.28,-0.89l-0.55,-3.22l1.31,-0.83l2,-3.76L250.06,514.69zM266.13,521.83l3.07,1.78l-2.49,0.22l-2.02,2.04l-0.13,-1.31l-1.29,-0.32l-0.29,-1.34L266.13,521.83zM269.59,524.03l2.76,2.87l-0.55,0.8l-2.02,-0.19l0.26,1.88l-4.02,-2.71l0.16,-0.8l1.21,0.38l-0.66,-0.6l0.87,-1.24L269.59,524.03zM292.99,526.7l-0.6,0.7h0.89l0.55,3.44l1.21,-0.25l0.55,0.83l-0.32,1.18l-1.89,1.11l-2,-0.44l0.58,-1.15l-1.34,-1.78l0.24,-2.29l0.47,1.78l0.76,-0.38l-0.16,-1.05l-0.71,-0.86l0.29,-0.83H292.99zM270.38,545.6l2.86,1.56l-1,0.7l0.95,0.95l0.95,-1.65l1.34,-0.03l-0.92,2.29l-2.49,-0.86l-1.76,0.92l-0.16,0.92l-0.89,-0.16l-0.26,-0.57l1.13,-0.7l-0.79,-0.57l0.26,-0.76l-0.87,0.51l-0.45,-0.73l1.1,-0.38l-0.68,-0.98L270.38,545.6z"},{"code":"KR-JJ","name":"Jeju","path":"M148.46,643.64l0.68,0.78l-0.45,0.6l1.45,-0.09l-0.68,2.92l-2.07,-0.5l-0.45,-1.44L148.46,643.64zM143.84,658.77l-3.15,2.28l-0.47,2.03l-2.47,2.48l0.16,1.44l-1.31,1.47l-5.07,-0.09l-3.12,3.25l-9.01,1.12l-2.76,2.94l-1.81,0.69l-1,-0.91l-1.71,-0.06l-0.52,1.28l-1.47,-0.87l-2.15,0.19l-5.3,1.66l-1.84,-1.84l-2.34,0.63l-1.86,-1l-3.31,1.5l-4.23,-1.12l-3.1,2.03l0.03,2.97l-1.39,-0.5l-0.95,0.62l-0.89,-0.59l0.24,-1.12l-0.84,-0.03l-2.13,-2.87l-4.88,-2.84l-1.84,-3l0.58,-3.31l-0.58,-1.81l1.79,-1.47l0.03,-1.41l2.76,-1.78l1.18,-1.81l1.21,0.19l2.18,-2.5l0.45,-2.82l4.2,-1.69l0.45,-1.97l5.38,-1.03l1.66,-1.35l1.18,0.75l7.9,-3.07l1.08,-1.22l2.02,0.6l2.42,-0.97l4.31,-0.09l0.79,-1.16l3.7,-0.25l1.1,-2.01l1.89,1.51l1.1,-1.13l4.65,-0.91l3.18,0.38l0.24,-0.94l3.33,1.13l2.76,-0.5l1.31,3.01l1.76,0.94l1,-0.63l3.26,1.03l-0.42,1.32h1.02l0.34,0.94l-1.16,2.16l1.81,1.44l1.34,-0.5l1.08,1.69l-0.47,0.56l-1,-0.66l-0.81,1.22l-0.1,1.03l1.5,1.1l-0.73,0.88l-1.23,-1.31L143.84,658.77z"},{"code":"KR-SE","name":"Sejong","path":"M176.14,312.59L173.45,310.97L171.97,309.35L169.4,308.54L166.71,309.62L166.3,311.38L167.38,313.4L167.92,315.42L168.19,318.52L167.52,320.95L167.79,324.32L167.92,327.82L167.92,330.92L166.84,333.35L166.98,335.37L168.86,337.93L171.56,339.41L172.91,343.32L173.18,346.15L173.04,350.2L174.26,353.3L176.01,354.65L177.72,356.7L179.9,354.21L179.59,345.47L186.45,343.29L187.41,337.15L186.79,336.29L185.68,336.48L185.11,337.26L186.97,331.16L185.89,330.02L186.81,326.74L183.47,326.54L183.02,325.19L183.02,322.38L180.21,318.95L182.4,318.32L182.71,315.51L181.15,313.33L178.71,313.53z"}];
    var chart = null

    if (typeof window === 'undefined') {
        return;
    }

    if (typeof require === 'undefined') {
        chart = tui.chart;
    } else {
        chart = require('tui-chart');
    }
    chart.registerMap('south-korea', data);
})();
