<?php
// Require authentication
require_once 'includes/auth.php';
requireAuth();
?>
<?php include 'header.php'; ?>

<div class="page-wrapper">
    <!-- Page Content-->
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">Blogs</h4>
                        <div class="col-auto d-flex gap-2">
                            <div class="input-group">
                                <input type="text" class="form-control" id="searchBlogs" placeholder="Search blogs...">
                                <button class="btn btn-outline-secondary" type="button"><i class="fas fa-search"></i></button>
                            </div>
                            <a href="add-blog.php"><button type="button" class="btn btn-primary"><i class="fa-solid fa-plus me-1"></i> Add Blog</button></a>
                        </div><!--end col-->                            
                    </div><!--end page-title-box-->
                </div><!--end col-->
            </div><!--end row-->
            
            <!-- Loading State -->
            <div id="loadingState" class="text-center py-5">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <p class="mt-2 text-muted">Loading blogs...</p>
            </div>

            <!-- Blogs Grid -->
            <div class="row justify-content-center" id="blogsGrid" style="display: none;">
                <!-- Dynamic content will be loaded here -->
            </div><!--end row-->

            <!-- Pagination -->
            <div id="paginationContainer" class="mt-3" style="display: none;">
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center" id="paginationList">
                        <!-- Pagination will be loaded here -->
                    </ul>
                </nav>
            </div>
                               
        </div><!-- container -->
    </div>
    <!-- end page content -->
</div>
<!-- end page-wrapper -->
   
<?php include 'footer.php'; ?>
<script src="assets/js/blogs.js"></script>