<?php
// Require authentication
require_once 'includes/auth.php';
requireAuth();
?>
<?php include 'header.php'; ?>

<div class="page-wrapper">
    <!-- Page Content-->
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">Customers</h4>
                    </div>
                    <!--end page-title-box-->
                </div>
                <!--end col-->
            </div>
            <!--end row-->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h4 class="card-title">Customers</h4>
                                </div>
                                <!--end col-->
                                <div class="col-auto">
                                    <form class="row g-2">
                                        <div class="col-auto">
                                            <input type="text" class="form-control" id="searchCustomers" placeholder="Search customers...">
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!--end row-->
                        </div>
                        <!--end card-header-->
                        <div class="card-body pt-0">

                            <!-- Loading State -->
                            <div id="loadingState" class="text-center py-5">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="mt-2 text-muted">Loading customers...</p>
                            </div>

                            <div class="table-responsive" id="customersTableContainer" style="display: none;">
                                <table class="table mb-0 checkbox-all" id="datatable_1">
                                    <thead class="table-light">
                                        <tr>
                                            <th style="width: 16px;">
                                                <div class="form-check mb-0 ms-n1">
                                                    <input type="checkbox" class="form-check-input" name="select-all"
                                                        id="select-all">
                                                </div>
                                            </th>
                                            <th class="ps-0">Customer name</th>
                                            <th>Email</th>
                                            <th style="border-bottom: 1px dotted #dee2e6;">Location</th>
                                            <th>Orders</th>
                                            <th>Amount spent</th>
                                        </tr>
                                    </thead>
                                    <tbody id="customersTableBody">
                                        <!-- Dynamic content will be loaded here -->
                                    </tbody>
                                </table>
                            </div>

                            <!-- Pagination -->
                            <div id="paginationContainer" class="mt-3" style="display: none;">
                                <nav aria-label="Page navigation">
                                    <ul class="pagination justify-content-end" id="paginationList">
                                        <!-- Pagination will be loaded here -->
                                    </ul>
                                </nav>
                            </div>

                        </div>
                    </div>
                </div> <!-- end col -->
            </div> <!-- end row -->
        </div><!-- container -->

    </div>
    <!-- end page content -->
</div>
<!-- end page-wrapper -->

<?php include 'footer.php'; ?>
<script src="assets/js/customers.js"></script>