<?php
// Require authentication
require_once 'includes/auth.php';
requireAuth();

// Get ID from URL
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$id) {
    header('Location: collections.php');
    exit;
}
?>
<?php include 'header.php'; ?>
    <!-- Quill Editor CSS -->
    <link rel="stylesheet" href="assets/libs/quill/quill.snow.css">
    <!-- Add Product Custom CSS (Reuse for consistency) -->
    <link rel="stylesheet" href="assets/css/add-product.css">

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Edit Collection</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="collections.php">Collections</a></li>
                                    <li class="breadcrumb-item active">Edit Collection</li>
                                </ol>
                            </div> 
                            <button id="deleteCollectionBtn" class="btn btn-danger btn-sm ms-3">
                                <i class="iconoir-trash me-1"></i> Delete Collection
                            </button>                           
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->

                <form id="editCollectionForm" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="id" id="collectionId" value="<?php echo $id; ?>">
                    
                    <div class="row">
                        <div class="col-lg-8">
                            <!-- Title Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Title</h4>
                                </div>
                                <div class="card-body">
                                    <div class="form-group mb-3">
                                        <input type="text" class="form-control" id="collectionTitle" name="name" placeholder="Enter collection title" required>
                                    </div>
                                    <div class="form-group mb-3">
                                        <label class="form-label text-muted small">Slug</label>
                                        <input type="text" class="form-control form-control-sm" id="collectionSlug" name="slug" placeholder="slug-preview">
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Description Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Description</h4>
                                </div>
                                <div class="card-body">
                                    <div id="collectionDescription"></div>
                                    <textarea name="description" id="descriptionInput" style="display:none;"></textarea>
                                </div>
                            </div><!--end card-->

                            <!-- Media Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Collection Image</h4>
                                </div>
                                <div class="card-body">
                                    <!-- Drag and Drop Zone -->
                                    <div id="dropZone" class="drop-zone mb-4" style="display: none;">
                                        <div class="drop-zone-content">
                                            <i class="iconoir-cloud-upload fs-1 text-primary mb-3"></i>
                                            <h5 class="mb-2">Drag and drop image here</h5>
                                            <p class="text-muted mb-3">or</p>
                                            <button type="button" class="btn btn-primary" id="addMediaBtn">
                                                <i class="iconoir-plus me-2"></i>Change Image
                                            </button>
                                            <input type="file" id="mediaFileInput" name="image" accept="image/*" class="d-none">
                                            <p class="text-muted small mt-3 mb-0">Accepts images (JPG, PNG, GIF, WebP)</p>
                                        </div>
                                    </div>

                                    <!-- Image Preview -->
                                    <div id="imagePreviewContainer" class="position-relative">
                                        <img id="imagePreview" src="" alt="Preview" class="img-fluid rounded border">
                                        <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0 m-2" id="removeImageBtn">
                                            <i class="iconoir-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Search Engine Listing Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Search engine listing</h4>
                                </div>
                                <div class="card-body">
                                    <!-- SEO Edit Fields -->
                                    <div id="seoEditFields" class="mb-4">
                                        <div class="mb-3">
                                            <label class="form-label">Page title</label>
                                            <input type="text" class="form-control" id="seoTitle" name="seo_title" value="" maxlength="70" placeholder="Enter page title">
                                            <small class="text-muted">
                                                <span id="seoTitleCount">0</span> of 70 characters used
                                            </small>
                                        </div>

                                        <div class="mb-0">
                                            <label class="form-label">Meta description</label>
                                            <textarea class="form-control" id="seoDescription" name="seo_description" rows="3" maxlength="320" placeholder="Enter meta description"></textarea>
                                            <small class="text-muted">
                                                <span id="seoDescriptionCount">0</span> of 320 characters used
                                            </small>
                                        </div>
                                    </div>

                                    <!-- SEO Preview -->
                                    <div class="border rounded p-3 bg-white" id="seoPreviewBox">
                                        <div class="d-flex align-items-start mb-2">
                                            <div class="flex-shrink-0 me-2">
                                                <img src="assets/images/favicon.ico" alt="favicon" width="16" height="16" class="rounded-circle">
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="fw-semibold text-dark mb-0" style="font-size: 14px; line-height: 1.3;">The Perfect Vape</div>
                                                <div class="text-muted seo-url-preview" style="font-size: 12px; line-height: 1.3; color: #5f6368;">www.theperfectvape.com › collections</div>
                                            </div>
                                        </div>
                                        <h6 class="text-primary mb-1 seo-title-preview" style="font-size: 18px; font-weight: 400; line-height: 1.3;">Collection Title</h6>
                                        <p class="text-muted small mb-2 seo-description-preview" style="font-size: 13px; line-height: 1.4; color: #4d5156;">Collection description will appear here...</p>
                                    </div>
                                </div>
                            </div><!--end card-->
                        </div><!--end col-->

                        <div class="col-lg-4">
                            <!-- Status Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Status</h4>
                                </div>
                                <div class="card-body">
                                    <select class="form-select" name="is_active" id="collectionStatus">
                                        <option value="1">Active</option>
                                        <option value="0">Draft</option>
                                    </select>
                                </div>
                            </div><!--end card-->

                            <!-- Parent Collection Section -->
                             <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Parent Collection</h4>
                                </div>
                                <div class="card-body">
                                    <select class="form-select" name="parent_id" id="parentCollection">
                                        <option value="">None</option>
                                        <!-- Options will be loaded dynamically -->
                                    </select>
                                    <small class="text-muted mt-2 d-block">Select a parent collection to create a hierarchy.</small>
                                </div>
                            </div><!--end card-->

                            <!-- Created At -->
                            <div class="card">
                                <div class="card-body">
                                    <p class="mb-0 text-muted">Created at: <span id="createdAtText">Loading...</span></p>
                                </div>
                            </div>
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="row mt-3 mb-4">
                        <div class="col-12 text-end">
                            <a href="collections.php" class="btn btn-outline-secondary me-2">Cancel</a>
                            <button type="submit" class="btn btn-dark" id="saveBtn" style="background-color: #303030; border-color: #303030;">Update Collection</button>
                        </div>
                    </div>
                </form>
            </div><!-- container -->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->
    
    <!-- Quill Editor JS -->
    <script src="assets/libs/quill/quill.js"></script>
    <!-- Edit Collection Custom JS -->
    <script src="assets/js/edit-collection.js?v=<?php echo time(); ?>"></script>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-danger" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this collection? <br>
                    <strong id="deleteCollectionName"></strong>
                    <p class="text-muted small mt-2">This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete Collection</button>
                </div>
            </div>
        </div>
    </div>

<?php include 'footer.php'; ?>
