<?php include 'header.php'; ?>
    <!-- Quill Editor CSS -->
    <link rel="stylesheet" href="assets/libs/quill/quill.snow.css">
    <!-- Add Product Custom CSS (Reuse) -->
    <link rel="stylesheet" href="assets/css/add-product.css">

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Edit Product</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="products.php">Products</a></li>
                                    <li class="breadcrumb-item active">Edit Product</li>
                                </ol>
                            </div> 
                            <button id="deleteProductBtn" class="btn btn-danger btn-sm ms-3">
                                <i class="iconoir-trash me-1"></i> Delete Product
                            </button>                           
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->

                <form id="editProductForm" method="POST" enctype="multipart/form-data">
                    <input type="hidden" id="productId" name="id">
                    <div class="row">
                        <div class="col-lg-8">
                            <!-- Title Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Title</h4>
                                </div>
                                <div class="card-body">
                                    <div class="form-group mb-3">
                                        <input type="text" class="form-control" id="productTitle" name="title" placeholder="Enter product title" required>
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Description Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Description</h4>
                                </div>
                                <div class="card-body">
                                    <div id="productDescription"></div>
                                    <textarea name="description" id="descriptionInput" style="display:none;"></textarea>
                                </div>
                            </div><!--end card-->

                            <!-- Pricing/Inventory Section (Simple Product) -->
                            <div class="card" id="simpleProductPricing">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Pricing & Inventory</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">Price</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" class="form-control" name="price" id="simplePrice" step="0.01" placeholder="0.00">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">SKU</label>
                                                <input type="text" class="form-control" name="sku" id="simpleSku" placeholder="Stock Keeping Unit">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">Inventory</label>
                                                <input type="number" class="form-control" name="inventory" id="simpleInventory" placeholder="0">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Media Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Media</h4>
                                </div>
                                <div class="card-body">
                                    <!-- Existing Images -->
                                    <div id="existingImages" class="mb-4" style="display:none;">
                                        <h5>Existing Images</h5>
                                        <div class="d-flex flex-wrap gap-2" id="existingImagesList"></div>
                                        <hr>
                                    </div>

                                    <!-- Drag and Drop Zone -->
                                    <div id="dropZone" class="drop-zone mb-4">
                                        <div class="drop-zone-content">
                                            <i class="iconoir-cloud-upload fs-1 text-primary mb-3"></i>
                                            <h5 class="mb-2">Drag and drop new images here</h5>
                                            <p class="text-muted mb-3">or</p>
                                            <button type="button" class="btn btn-primary" id="addMediaBtn">
                                                <i class="iconoir-plus me-2"></i>Add media
                                            </button>
                                            <input type="file" id="mediaFileInput" name="media[]" accept="image/*" multiple class="d-none">
                                            <p class="text-muted small mt-3 mb-0">Accepts images (JPG, PNG, GIF, WebP)</p>
                                        </div>
                                    </div>

                                    <!-- New Image Grid -->
                                    <div id="imageGrid" class="image-grid" style="display: none;"></div>
                                </div>
                            </div><!--end card-->

                            <!-- Category Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Category</h4>
                                </div>
                                <div class="card-body">
                                    <div class="form-group position-relative">
                                        <label class="form-label">Product Categories</label>
                                        <input type="text" class="form-control" id="categorySearch" placeholder="Search to add categories..." autocomplete="off">
                                        <div id="categorySearchResults" class="list-group position-absolute w-100 shadow-sm" style="display:none; z-index: 1000; max-height: 200px; overflow-y: auto;">
                                            <!-- Results populated by JS -->
                                        </div>
                                        <div id="selectedCategories" class="d-flex flex-wrap gap-2 mt-2">
                                            <!-- Selected tags will appear here -->
                                        </div>
                                        <div id="collectionInputsContainer"></div>
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Variants Container -->
                            <div id="variantsContainer" class="mb-4">
                                <!-- Dynamic content will be injected here by edit-product.js -->
                            </div><!--end variants container-->
                            
                            <!-- Hidden inputs for pre-filled variants state if needed -->
                            <div id="removedVariantsContainer"></div>

                            <!-- Product Metafields Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Product metafields</h4>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label">reviews</label>
                                        <input type="text" class="form-control" name="metafield_reviews" id="metaReviews" placeholder="Enter reviews">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Image</label>
                                        <div class="input-group">
                                            <button class="btn btn-outline-secondary metafield-image-btn" type="button">
                                                <i class="iconoir-camera"></i>
                                            </button>
                                            <input type="text" class="form-control metafield-image-display" name="metafield_image_display" id="metaImageDisplay" placeholder="Select image" readonly>
                                            <input type="file" class="d-none metafield-image-upload" name="metafield_image" accept="image/*">
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Related Product</label>
                                        <input type="text" class="form-control" name="metafield_related_product" id="metaRelated" placeholder="Enter related product">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">description</label>
                                        <input type="text" class="form-control" name="metafield_description" id="metaDescription" placeholder="Enter description">
                                    </div>
                                </div>
                            </div><!--end card-->

                            <!-- Search Engine Listing Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Search engine listing</h4>
                                </div>
                                <div class="card-body">
                                    <!-- SEO Edit Fields -->
                                    <div id="seoEditFields" class="mb-4">
                                        <div class="mb-3">
                                            <label class="form-label">Page title</label>
                                            <input type="text" class="form-control" id="seoTitle" name="seo_title" value="" maxlength="70" placeholder="Enter page title">
                                            <small class="text-muted">
                                                <span id="seoTitleCount">0</span> of 70 characters used
                                            </small>
                                        </div>

                                        <div class="mb-0">
                                            <label class="form-label">Meta description</label>
                                            <textarea class="form-control" id="seoDescription" name="seo_description" rows="3" maxlength="320" placeholder="Enter meta description"></textarea>
                                            <small class="text-muted">
                                                <span id="seoDescriptionCount">0</span> of 160 characters used
                                            </small>
                                        </div>
                                    </div>

                                    <!-- SEO Preview -->
                                    <div class="border rounded p-3 bg-white" id="seoPreviewBox">
                                        <div class="d-flex align-items-start mb-2">
                                            <div class="flex-shrink-0 me-2">
                                                <img src="assets/images/favicon.ico" alt="favicon" width="16" height="16" class="rounded-circle">
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="fw-semibold text-dark mb-0" style="font-size: 14px; line-height: 1.3;">The Perfect Vape</div>
                                                <div class="text-muted seo-url-preview" style="font-size: 12px; line-height: 1.3; color: #5f6368;">www.theperfectvape.com</div>
                                            </div>
                                        </div>
                                        <h6 class="text-primary mb-1 seo-title-preview" style="font-size: 18px; font-weight: 400; line-height: 1.3;">Product Title</h6>
                                        <p class="text-muted small mb-2 seo-description-preview" style="font-size: 13px; line-height: 1.4; color: #4d5156;">Product description will appear here...</p>
                                    </div>
                                </div>
                            </div><!--end card-->
                        </div><!--end col-->

                        <div class="col-lg-4">
                            <!-- Status Section -->
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Status</h4>
                                </div>
                                <div class="card-body">
                                    <select class="form-select" name="status" id="productStatus">
                                        <option value="active">Active</option>
                                        <option value="draft">Draft</option>
                                        <option value="archived">Archived</option>
                                    </select>
                                </div>
                            </div><!--end card-->
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="row mt-3 mb-4">
                        <div class="col-12 text-end">
                            <a href="products.php" class="btn btn-outline-secondary me-2">Cancel</a>
                            <button type="submit" class="btn btn-dark" style="background-color: #303030; border-color: #303030;">Update Product</button>
                        </div>
                    </div>
                </form>
            </div><!-- container -->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->
    
    <!-- Quill Editor JS -->
    <script src="assets/libs/quill/quill.js"></script>
    <!-- Edit Product Custom JS -->
    <script src="assets/js/edit-product.js"></script>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title text-danger" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this product? <br>
                    <strong id="deleteProductName"></strong>
                    <p class="text-muted small mt-2">This action cannot be undone.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete Product</button>
                </div>
            </div>
        </div>
    </div>

<?php include 'footer.php'; ?>
