<?php
/**
 * Admin Panel Configuration
 * The Perfect Vape
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Database Configuration - Path relative to admin folder
require_once __DIR__ . '/../../database/config.php';

// Base URL for Admin Panel
if (!defined('ADMIN_BASE_URL')) {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $script_path = dirname($_SERVER['SCRIPT_NAME']);
    
    // Remove 'admin' from path if present
    $script_path = str_replace('/admin', '', $script_path);
    $script_path = rtrim($script_path, '/');
    
    define('ADMIN_BASE_URL', $protocol . '://' . $host . $script_path . '/admin');
    define('API_BASE_URL', $protocol . '://' . $host . $script_path . '/admin/api');
}

// Timezone
date_default_timezone_set('America/New_York');

// Session Configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set to 1 in production with HTTPS

// Error Reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

?>

