<?php
// Require authentication - redirect to login if not logged in
require_once 'includes/auth.php';
requireAuth();
?>
<?php include 'header.php'; ?>
    <div class="page-wrapper">

        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Dashboard</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="#">The Perfect Vape</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item active">Dashboard</li>
                                </ol>
                            </div>                            
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->
                
                <!-- Stats Row -->
                <div class="row justify-content-center">
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0 bg-primary-subtle text-primary thumb-md rounded-circle">
                                        <i class="iconoir-dollar-circle fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-2 text-truncate">
                                        <p class="text-dark mb-0 fw-semibold fs-14">Total Revenue</p>
                                        <p class="mb-0 text-truncate text-muted"><span class="text-success">12.5%</span>
                                            Increase from last month</p>
                                    </div><!--end media-body-->
                                </div><!--end media-->
                                <div class="row d-flex justify-content-center">
                                    <div class="col">                                        
                                        <h3 class="mt-2 mb-0 fw-bold" id="totalRevenue">$0.00</h3>
                                    </div>
                                    <div class="col align-self-center">
                                        <img src="assets/images/extra/line-chart.png" alt="" class="img-fluid">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0 bg-info-subtle text-info thumb-md rounded-circle">
                                        <i class="iconoir-shopping-bag fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-2 text-truncate">
                                        <p class="text-dark mb-0 fw-semibold fs-14">Total Orders</p>
                                        <p class="mb-0 text-truncate text-muted"><span class="text-success">8.2%</span>
                                            Increase from last month</p>
                                    </div><!--end media-body-->
                                </div><!--end media-->
                                <div class="row d-flex justify-content-center">
                                    <div class="col">                                        
                                        <h3 class="mt-2 mb-0 fw-bold" id="totalOrders">0</h3>
                                    </div>
                                    <div class="col align-self-center">
                                        <img src="assets/images/extra/bar.png" alt="" class="img-fluid">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0 bg-warning-subtle text-warning thumb-md rounded-circle">
                                        <i class="iconoir-people-tag fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-2 text-truncate">
                                        <p class="text-dark mb-0 fw-semibold fs-14">Total Customers</p>
                                        <p class="mb-0 text-truncate text-muted"><span class="text-success">5.4%</span>
                                            Increase from last month</p>
                                    </div><!--end media-body-->
                                </div><!--end media-->
                                <div class="row d-flex justify-content-center">
                                    <div class="col">                                        
                                        <h3 class="mt-2 mb-0 fw-bold" id="totalCustomers">0</h3>
                                    </div>
                                    <div class="col align-self-center">
                                        <img src="assets/images/extra/donut.png" alt="" class="img-fluid">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0 bg-success-subtle text-success thumb-md rounded-circle">
                                        <i class="iconoir-cart-alt fs-4"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-2 text-truncate">
                                        <p class="text-dark mb-0 fw-semibold fs-14">Total Products</p>
                                        <p class="mb-0 text-truncate text-muted"><span class="text-info" id="activeProductsCount">0</span>
                                            Products active</p>
                                    </div><!--end media-body-->
                                </div><!--end media-->
                                <div class="row d-flex justify-content-center">
                                    <div class="col">                                        
                                        <h3 class="mt-2 mb-0 fw-bold" id="totalProducts">0</h3>
                                    </div>
                                    <div class="col align-self-center">
                                        <img src="assets/images/extra/tree.png" alt="" class="img-fluid">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end row-->

                <div class="row justify-content-center">
                    <div class="col-md-6 col-lg-8">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Monthly Income</h4>                      
                                    </div><!--end col-->
                                    <div class="col-auto"> 
                                        <div class="dropdown">
                                            <a href="#" class="btn bt btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="icofont-calendar fs-5 me-1"></i> <span id="incomeFilterLabel">This Year</span><i class="las la-angle-down ms-1"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="income" data-period="today">Today</a>
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="income" data-period="week">Last Week</a>
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="income" data-period="month">Last Month</a>
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="income" data-period="year">This Year</a>
                                            </div>
                                        </div>               
                                    </div><!--end col-->
                                </div>  <!--end row-->                                  
                            </div><!--end card-header-->
                            <div class="card-body pt-0">
                                <div id="monthly_income" class="apex-charts"></div>                                
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">New Customers</h4>                      
                                    </div><!--end col-->
                                </div>  <!--end row-->                                  
                            </div>
                            <div class="card-body pt-0">
                                <div id="customers" class="apex-charts"></div> 
                                <div class="bg-light py-3 px-2 mb-0 mt-3 text-center rounded">                                                                                       
                                    <h6 class="mb-0"><i class="icofont-calendar fs-5 me-1"></i> Last 7 Days</h6>                                                                       
                                </div> 
                            </div>
                        </div>
                    </div> 
                </div>
                <!--end row-->

                <div class="row justify-content-center">
                    <!-- Recent Orders -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Recent Orders</h4>                      
                                    </div><!--end col-->
                                    <div class="col-auto"> 
                                        <a href="orders.php" class="btn btn-sm btn-outline-primary">View All</a>
                                    </div><!--end col-->
                                </div><!--end row-->                                  
                            </div><!--end card-header-->
                            <div class="card-body pt-0">
                                <div class="table-responsive">
                                    <table class="table table-borderless mb-0">
                                        <tbody id="recentOrdersTable">
                                            <!-- Dynamic Content -->
                                            <tr><td colspan="2" class="text-center">Loading...</td></tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div><!--end card-body--> 
                        </div><!--end card--> 
                    </div><!--end col-->

                    <!-- Order Status Summary -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Order Status Summary</h4>
                            </div><!--end card-header-->
                            <div class="card-body" id="orderStatusSummary">
                                <!-- Dynamic Content -->
                                <div class="text-center">Loading...</div>
                            </div><!--end card-body--> 
                        </div><!--end card--> 
                    </div><!--end col-->

                    <!-- Low Stock Alert -->
                    <div class="col-md-6 col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Low Stock Alert</h4>                      
                                    </div><!--end col-->
                                    <div class="col-auto">
                                        <span class="badge bg-danger-subtle text-danger" id="lowStockCount">0 Items</span>
                                    </div><!--end col-->
                                </div><!--end row-->                                  
                            </div><!--end card-header-->
                            <div class="card-body pt-0" id="lowStockList">
                                <!-- Dynamic Content -->
                                <div class="text-center">Loading...</div>
                            </div><!--end card-body--> 
                        </div><!--end card--> 
                    </div><!--end col--> 
                    
                    <!-- Best Selling Products -->
                    <div class="col-md-6 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Best Selling Vape Products</h4>                      
                                    </div><!--end col-->
                                    <div class="col-auto"> 
                                        <div class="dropdown d-inline-block me-2">
                                            <a href="#" class="btn bt btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="icofont-calendar fs-5 me-1"></i> <span id="productsFilterLabel">This Year</span><i class="las la-angle-down ms-1"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="products" data-period="today">Today</a>
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="products" data-period="week">Last Week</a>
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="products" data-period="month">Last Month</a>
                                                <a class="dropdown-item" href="javascript:void(0);" data-filter="products" data-period="year">This Year</a>
                                            </div>
                                        </div>
                                        <a href="products.php" class="btn btn-sm btn-outline-primary">View All</a>
                                    </div><!--end col-->
                                </div>  <!--end row-->                                  
                            </div><!--end card-header-->
                            <div class="card-body pt-0">
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th class="border-top-0">Product</th>
                                                <th class="border-top-0">Price</th>
                                                <th class="border-top-0">Sell</th>
                                                <th class="border-top-0">Status</th>
                                                <th class="border-top-0">Action</th>
                                            </tr><!--end tr-->
                                        </thead>
                                        <tbody id="bestSellingProductsTable">
                                            <!-- Dynamic Content -->
                                            <tr><td colspan="5" class="text-center">Loading...</td></tr>
                                        </tbody>
                                    </table> <!--end table-->                                               
                                </div><!--end /div-->
                            </div><!--end card-body--> 
                        </div><!--end card--> 
                    </div> <!--end col-->            
                </div><!--end row-->

                <!-- Best Selling Flavors/Categories & Monthly Refunds -->
                <div class="row justify-content-center">
                    <!-- Best Selling Flavors/Categories -->
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Best Selling Categories</h4>                      
                                    </div><!--end col-->
                                </div><!--end row-->                                  
                            </div><!--end card-header-->
                            <div class="card-body" id="bestSellingCategoriesList">
                                <!-- Dynamic Content -->
                                <div class="text-center">Loading...</div>
                            </div><!--end card-body--> 
                        </div><!--end card--> 
                    </div><!--end col-->

                    <!-- Monthly Refunds -->
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">                      
                                        <h4 class="card-title">Recent Refunds</h4>                      
                                    </div><!--end col-->
                                    <div class="col-auto">
                                        <a href="refunds.php" class="btn btn-sm btn-outline-primary">View All</a>
                                    </div><!--end col-->
                                </div><!--end row-->                                  
                            </div><!--end card-header-->
                            <div class="card-body pt-0">
                                <div class="table-responsive">
                                    <table class="table table-borderless mb-0">
                                        <thead>
                                            <tr>
                                                <th class="px-0">Refund ID</th>
                                                <th>Customer</th>
                                                <th>Amount</th>
                                                <th class="text-end">Status</th>
                                            </tr>
                                        </thead>
                                        <tbody id="recentRefundsTable">
                                            <!-- Dynamic Content -->
                                            <tr><td colspan="4" class="text-center">Loading...</td></tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div><!--end card-body--> 
                        </div><!--end card--> 
                    </div><!--end col-->
                </div><!--end row-->
            </div><!-- container -->
           
        </div>
        <!-- end page content -->

    </div>
    <!-- end page-wrapper -->

    <!-- Apex Charts -->
    <script src="assets/libs/apexcharts/apexcharts.min.js"></script>
    <!-- Dashboard Custom JS -->
    <script src="assets/js/dashboard.js"></script>

<?php include 'footer.php'; ?>