<?php
// Require authentication
require_once 'includes/auth.php';
requireAuth();
?>
<?php include 'header.php'; ?>
<div class="page-wrapper">

    <!-- Page Content-->
    <div class="page-content">
        <div class="container-fluid"> 
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">Payments</h4>                            
                    </div><!--end page-title-box-->
                </div><!--end col-->
            </div><!--end row-->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h4 class="card-title">Payments List</h4>
                                </div>
                                <!--end col-->
                                <div class="col-auto">
                                    <form class="row g-2">
                                        <div class="col-auto">
                                            <select class="form-select" id="statusFilter">
                                                <option value="">All Status</option>
                                                <option value="paid">Paid</option>
                                                <option value="pending">Pending</option>
                                                <option value="refunded">Refunded</option>
                                                <option value="partially_refunded">Partially Refunded</option>
                                                <option value="voided">Voided</option>
                                            </select>
                                        </div>
                                        <div class="col-auto">
                                            <input type="text" class="form-control" id="searchPayments" placeholder="Search payments...">
                                        </div>
                                    </form>
                                </div>
                            </div>                               
                        </div><!--end card-header-->
                        <div class="card-body pt-0">
                            
                            <!-- Loading State -->
                            <div id="loadingState" class="text-center py-5">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="mt-2 text-muted">Loading payments...</p>
                            </div>

                            <div class="table-responsive" id="paymentsTableContainer" style="display: none;">
                                <table class="table mb-0">
                                    <thead class="table-light">
                                      <tr>
                                        <th>Transaction ID</th>
                                        <th>Date</th>
                                        <th>Order</th>
                                        <th>Customer</th>
                                        <th>Amount</th>
                                        <th>Payment Method</th>
                                        <th>Status</th>
                                      </tr>
                                    </thead>
                                    <tbody id="paymentsTableBody">
                                        <!-- Dynamic content will be loaded here -->
                                    </tbody>
                                  </table>
                            </div>

                            <!-- Pagination -->
                            <div id="paginationContainer" class="mt-3" style="display: none;">
                                <nav aria-label="Page navigation">
                                    <ul class="pagination justify-content-end" id="paginationList">
                                        <!-- Pagination will be loaded here -->
                                    </ul>
                                </nav>
                            </div>

                        </div>
                    </div>
                </div> <!-- end col -->
            </div> <!-- end row -->                                       
        </div><!-- container -->
    </div>
    <!-- end page content -->
</div>
<!-- end page-wrapper -->
<?php include 'footer.php'; ?>
<script src="assets/js/payments.js"></script>
