<?php
require_once 'includes/auth.php';
requireAuth();
require_once '../database/config.php';

$orderId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($orderId <= 0) die('Invalid Order ID');

$db = Database::getInstance()->getConnection();

$stmt = $db->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->execute([$orderId]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) die('Order not found');

// If no tracking number, generate a temporary one for display
$trackingNumber = $order['tracking_number'] ?: 'TRK-' . date('Ymd') . '-' . $order['id'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Label - <?php echo htmlspecialchars($trackingNumber); ?></title>
    <style>
        @media print {
            @page { size: 4in 6in; margin: 0; }
            body { margin: 0; }
        }
        body {
            width: 384px; height: 576px; /* 4x6 inches at 96dpi */
            font-family: 'Courier New', Courier, monospace;
            margin: 0 auto;
            border: 1px solid #000;
            box-sizing: border-box;
            padding: 10px;
            position: relative;
        }
        .header { border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 15px; }
        .sender { font-size: 10px; text-transform: uppercase; }
        .recipient { margin-top: 30px; font-size: 16px; font-weight: bold; text-transform: uppercase; line-height: 1.4; padding-left: 20px;}
        .tracking-box { margin-top: 40px; text-align: center; border: 2px solid #000; padding: 10px; }
        .barcode-container { margin: 10px 0; }
        .tracking-number { font-size: 14px; font-weight: bold; letter-spacing: 2px; }
        .footer { position: absolute; bottom: 10px; left: 10px; right: 10px; font-size: 10px; display: flex; justify-content: space-between; border-top: 1px solid #000; padding-top: 5px; }
    </style>
    <!-- JsBarcode Library -->
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
</head>
<body onload="init()">

    <div class="header">
        <div class="sender">
            FROM:<br>
            THE PERFECT VAPE<br>
            123 VAPE STREET<br>
            NEW YORK, NY 10001
        </div>
        <div style="float: right; font-size: 24px; font-weight: bold;">P</div>
    </div>

    <div class="recipient">
        SHIP TO:<br>
        <?php echo htmlspecialchars($order['customer_first_name'] . ' ' . $order['customer_last_name']); ?><br>
        <?php echo htmlspecialchars($order['shipping_address_line1']); ?><br>
        <?php if ($order['shipping_address_line2']) echo htmlspecialchars($order['shipping_address_line2']) . '<br>'; ?>
        <?php echo htmlspecialchars($order['shipping_city'] . ', ' . $order['shipping_state'] . ' ' . $order['shipping_postal_code']); ?>
    </div>

    <div class="tracking-box">
        US POSTAGE PAID
        <div class="barcode-container">
            <svg id="barcode"></svg>
        </div>
        <div class="tracking-number"><?php echo htmlspecialchars($trackingNumber); ?></div>
        <div>ZONE 4</div>
    </div>

    <div class="footer">
        <div>ORD: <?php echo htmlspecialchars($order['order_number']); ?></div>
        <div>WT: 2 LBS</div>
    </div>

    <script>
        function init() {
            try {
                JsBarcode("#barcode", "<?php echo $trackingNumber; ?>", {
                    format: "CODE128",
                    width: 2,
                    height: 50,
                    displayValue: false, // We display it separately
                    margin: 0
                });
                window.print();
            } catch (e) {
                console.error("Barcode generation failed", e);
                window.print(); // Print anyway
            }
        }
    </script>
</body>
</html>
