<?php
require_once 'includes/auth.php';
requireAuth();
require_once '../database/config.php';

$orderId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($orderId <= 0) die('Invalid Order ID');

$db = Database::getInstance()->getConnection();

// Fetch Data (Same logic as order-details.php)
$stmt = $db->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->execute([$orderId]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) die('Order not found');

$stmt = $db->prepare("SELECT * FROM order_items WHERE order_id = ?");
$stmt->execute([$orderId]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Packing Slip - <?php echo htmlspecialchars($order['order_number']); ?></title>
    <style>
        body { font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 14px; line-height: 1.4; color: #333; margin: 0; padding: 20px; }
        .header { display: flex; justify-content: space-between; margin-bottom: 40px; border-bottom: 2px solid #eee; padding-bottom: 20px; }
        .logo { font-size: 24px; font-weight: bold; }
        .invoice-details { text-align: right; }
        .columns { display: flex; justify-content: space-between; margin-bottom: 40px; }
        .column { width: 48%; }
        .column h3 { font-size: 12px; text-transform: uppercase; color: #999; margin-bottom: 10px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th { text-align: left; border-bottom: 2px solid #eee; padding: 10px 0; font-size: 12px; text-transform: uppercase; color: #999; }
        td { border-bottom: 1px solid #eee; padding: 10px 0; }
        .footer { text-align: center; font-size: 12px; color: #999; margin-top: 50px; border-top: 1px solid #eee; padding-top: 20px; }
        @media print {
            .no-print { display: none; }
            body { padding: 0; }
        }
    </style>
</head>
<body onload="window.print()">

    <div class="header">
        <div class="logo">The Perfect Vape</div>
        <div class="invoice-details">
            <h1>PACKING SLIP</h1>
            <p><strong>Order:</strong> <?php echo htmlspecialchars($order['order_number']); ?></p>
            <p><strong>Date:</strong> <?php echo date('M d, Y', strtotime($order['created_at'])); ?></p>
        </div>
    </div>

    <div class="columns">
        <div class="column">
            <h3>Ship To:</h3>
            <p>
                <strong><?php echo htmlspecialchars($order['customer_first_name'] . ' ' . $order['customer_last_name']); ?></strong><br>
                <?php echo htmlspecialchars($order['shipping_address_line1']); ?><br>
                <?php if ($order['shipping_address_line2']) echo htmlspecialchars($order['shipping_address_line2']) . '<br>'; ?>
                <?php echo htmlspecialchars($order['shipping_city'] . ', ' . $order['shipping_state'] . ' ' . $order['shipping_postal_code']); ?><br>
                <?php echo htmlspecialchars($order['shipping_country']); ?>
            </p>
        </div>
        <div class="column">
            <h3>Bill To:</h3>
            <p>
                <strong><?php echo htmlspecialchars($order['customer_first_name'] . ' ' . $order['customer_last_name']); ?></strong><br>
                <?php echo htmlspecialchars($order['billing_address_line1'] ?: $order['shipping_address_line1']); ?><br>
                <?php echo htmlspecialchars($order['billing_city'] ?: $order['shipping_city']); ?>, 
                <?php echo htmlspecialchars($order['billing_state'] ?: $order['shipping_state']); ?> 
                <?php echo htmlspecialchars($order['billing_postal_code'] ?: $order['shipping_postal_code']); ?>
            </p>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Item</th>
                <th>SKU</th>
                <th>Qty</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($items as $item): ?>
            <tr>
                <td>
                    <strong><?php echo htmlspecialchars($item['product_title']); ?></strong>
                    <?php if ($item['variant_title']): ?>
                        <br><span style="color: #666; font-size: 12px;"><?php echo htmlspecialchars($item['variant_title']); ?></span>
                    <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($item['sku'] ?: '-'); ?></td>
                <td><?php echo $item['quantity']; ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>Thank you for your business!</p>
        <p>If you have any questions about your order, please contact support@theperfectvape.com.</p>
    </div>

</body>
</html>
