<?php
// Require authentication
require_once 'includes/auth.php';
requireAuth();
?>
<?php include 'header.php'; ?>

        <div class="page-wrapper">

            <!-- Page Content-->
            <div class="page-content">
                <div class="container-fluid"> 
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                                <h4 class="page-title">Products</h4>                             
                            </div><!--end page-title-box-->
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col">                      
                                            <h4 class="card-title">Products</h4>                      
                                        </div><!--end col-->
                                        <div class="col-auto"> 
                                            <form class="row g-2">
                                                <div class="col-auto">
                                                    <input type="text" class="form-control" id="searchProducts" placeholder="Search products...">
                                                </div><!--end col-->
                                                <div class="col-auto">
                                                    <select class="form-select" id="statusFilter">
                                                        <option value="">All Status</option>
                                                        <option value="active">Active</option>
                                                        <option value="draft">Draft</option>
                                                        <option value="archived">Archived</option>
                                                    </select>
                                                </div><!--end col-->
                                                <div class="col-auto">
                                                  <a href="add-product.php"><button type="button" class="btn btn-primary"><i class="fa-solid fa-plus me-1"></i> Add Product</button></a>
                                                </div><!--end col-->
                                            </form>    
                                        </div><!--end col-->
                                    </div><!--end row-->                                  
                                </div><!--end card-header-->
                                <div class="card-body pt-0">
                                    
                                    <!-- Loading State -->
                                    <div id="loadingState" class="text-center py-5">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                        <p class="mt-2 text-muted">Loading products...</p>
                                    </div>
                                    
                                    <!-- Products Table -->
                                    <div class="table-responsive" id="productsTableContainer" style="display: none;">
                                        <table class="table mb-0 checkbox-all" id="datatable_1">
                                            <thead class="table-light">
                                              <tr>
                                                <th style="width: 16px;">
                                                    <div class="form-check mb-0 ms-n1">
                                                        <input type="checkbox" class="form-check-input" name="select-all" id="select-all">                                                    
                                                    </div>
                                                </th>
                                                <th class="ps-0">Product</th>
                                                <th>Status</th>
                                                <th>Price</th>
                                                <th>SKU</th>
                                                <th>Collections</th>
                                                <th>Variants</th>
                                                <th>Created At</th>
                                                <th>Action</th>
                                              </tr>
                                            </thead>
                                            <tbody id="productsTableBody">
                                                <!-- Products will be loaded here dynamically -->
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <!-- Pagination -->
                                    <div id="paginationContainer" class="mt-3" style="display: none;">
                                        <nav aria-label="Page navigation">
                                            <ul class="pagination justify-content-end" id="paginationList">
                                                <!-- Pagination will be loaded here -->
                                            </ul>
                                        </nav>
                                    </div>
                                    
                                </div>
                            </div>
                        </div> <!-- end col -->
                    </div> <!-- end row -->                                     
                </div><!-- container -->
            </div>
            <!-- end page content -->
        </div>
        <!-- end page-wrapper -->

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-danger" id="deleteModalLabel">Confirm Deletion</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete this product? <br>
                        <strong id="deleteProductName"></strong>
                        <p class="text-muted small mt-2">This action cannot be undone.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete Product</button>
                    </div>
                </div>
            </div>
        </div>

        <?php include 'footer.php'; ?>
        
        <script src="assets/js/products.js?v=<?php echo time(); ?>"></script>
