<?php
// Base URL define karo - automatically detect karta hai
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$script_name = $_SERVER['SCRIPT_NAME'];
$base_path = dirname($script_name);
$base_url = $protocol . '://' . $host . $base_path;
// Root directory ke liye base URL
$root_base_url = $protocol . '://' . $host . dirname($script_name);
$BASE_URL = rtrim($root_base_url, '/');
define('BASE_URL', $BASE_URL);
include 'header.php';
?>

<main class="main-content" id="main">
  <!-- Breadcrumb -->
  <div class="breadcrumb-main">
    <div class="breadcrumb-container">
      <nav aria-label="breadcrumbs" class="breadcrumb" id="product-breadcrumb" role="navigation">
        <span class="breadcrumb__link"><a href="<?php echo BASE_URL; ?>/">Home</a></span><span class="breadcrumb__separator">/</span><span class="breadcrumb__current">Cart</span>
      </nav>
    </div>
  </div>

  <!-- Cart Section -->
  <div class="cart-section container--large container--vertical-space" id="main-cart-section">
    <div class="gutter-bottom--page">
      <h1 class="title h2">Shopping Cart</h1>
    </div>

    <div class="cart-page-layout" style="display: grid; grid-template-columns: 1fr 350px; gap: 30px; align-items: start;">
      
      <!-- Left Section - Cart Items -->
      <div class="cart-items-section">
        <div class="card" style="background: #f9f9f9; border-radius: 8px; padding: 30px;">
          <!-- Table Header -->
          <div class="cart-table-header" style="display: grid; grid-template-columns: 2fr 1fr 1fr; gap: 20px; padding-bottom: 15px; border-bottom: 1px solid #ddd; margin-bottom: 20px; font-weight: 600; color: #000;">
            <div>Product</div>
            <div style="text-align: center;">Quantity</div>
            <div style="text-align: right;">Total</div>
          </div>

          <!-- Cart Items -->
          <div class="cart-items">
            <!-- Cart Item -->
            <div class="cart-item" style="display: grid; grid-template-columns: 2fr 1fr 1fr; gap: 20px; padding: 20px 0; border-bottom: 1px solid #eee; align-items: start;">
              
              <!-- Product Column -->
              <div class="cart-item__product" style="display: flex; gap: 15px;">
                <a href="<?php echo BASE_URL; ?>/products/off-stamp-xcube-crystal-35k" class="cart-item__thumbnail" style="display: block; width: 100px; height: 100px; flex-shrink: 0; overflow: hidden; border-radius: 8px; background: #f5f5f5;">
                  <img src="<?php echo BASE_URL; ?>/assets/image/ryl-classic-35k.webp" alt="Off-Stamp X-Cube Crystal 35k" loading="lazy" style="width: 100%; height: 100%; object-fit: cover; display: block;">
                </a>
                <div class="cart-item__details" style="flex: 1;">
                  <div class="cart-item__price" style="font-weight: bold; font-size: 18px; margin-bottom: 8px; color: #000;">$18.95</div>
                  <a href="<?php echo BASE_URL; ?>/products/off-stamp-xcube-crystal-35k" class="cart-item__title" style="text-decoration: none; color: inherit; display: block; font-weight: 600; margin-bottom: 5px; font-size: 16px;">Off-Stamp X-Cube Crystal 35k (Pod)</a>
                  <div class="cart-item__variant" style="font-size: 14px; color: #666; margin-top: 5px;">Flavor: Black Mint</div>
                </div>
              </div>

              <!-- Quantity Column -->
              <div class="cart-item__quantity" style="display: flex; flex-direction: column; align-items: center; gap: 10px;">
                <div class="quantity-selector-holder" style="display: flex; align-items: center; gap: 8px;">
                  <button type="button" class="qty-button qty-decrease" aria-label="Decrease quantity" data-item-price="18.95" style="width: 1.875rem; height: 1.875rem; border-radius: 100%; border: 1px solid #ddd; background: #fff; display: flex; align-items: center; justify-content: center; cursor: pointer; padding: 0; line-height: 1; transition: all 0.1s linear;">
                    <svg fill="none" height="11" viewbox="0 0 12 12" width="12" xmlns="http://www.w3.org/2000/svg" style="height: 0.6875rem;">
                      <path d="M2 6h8" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"></path>
                    </svg>
                  </button>
                  <span class="qty-selector" data-quantity="5" style="height: 1.875rem; min-width: 1.875rem; display: flex; align-items: center; justify-content: center; font-size: 14px; font-weight: 500; color: #000;">5</span>
                  <button type="button" class="qty-button qty-increase" aria-label="Increase quantity" data-item-price="18.95" style="width: 1.875rem; height: 1.875rem; border-radius: 100%; border: 1px solid #ddd; background: #fff; display: flex; align-items: center; justify-content: center; cursor: pointer; padding: 0; line-height: 1; transition: all 0.1s linear;">
                    <svg fill="none" height="11" viewbox="0 0 12 12" width="12" xmlns="http://www.w3.org/2000/svg" style="height: 0.6875rem;">
                      <path d="M6 2v8M2 6h8" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"></path>
                    </svg>
                  </button>
                </div>
                <a href="#" class="remove" style="text-decoration: underline; font-size: 12px; color: #666;">Remove</a>
              </div>

              <!-- Total Column -->
              <div class="cart-item__total" data-item-total="94.75" style="text-align: right; font-weight: bold; font-size: 18px; color: #000;">
                $94.75
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Right Section - Order Summary -->
      <div class="cart-summary-section" style="position: sticky; top: 20px;">
        <div class="card" style="background: #f9f9f9; border-radius: 8px; padding: 30px;">
          <div class="cart__details">
            <div class="cart__total" style="margin-bottom: 20px;">
              <span style="display: block; font-size: 14px; color: #666; margin-bottom: 10px;">Total</span>
              <strong class="text-size--heading cart-total-amount" data-total="94.75" style="font-size: 32px; font-weight: bold; color: #000; display: block;">$94.75</strong>
            </div>
            <div class="cart__shipping text-color--opacity text-size--small" style="font-size: 12px; color: #666; margin-bottom: 25px;">
              Taxes and <a href="#" style="text-decoration: underline;">shipping</a> calculated at checkout
            </div>
            <div class="flex-buttons" style="display: flex; flex-direction: column; gap: 10px;">
              <a href="<?php echo BASE_URL; ?>/checkout.php" class="button button--regular button--solid" style="width: 100%; background: #000; color: #fff; border: none; padding: 15px; border-radius: 4px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.2s; text-decoration: none; text-align: center; display: block;">
                Checkout
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  
</main>

<style>
  @media screen and (max-width: 1024px) {
    .cart-page-layout {
      grid-template-columns: 1fr !important;
    }
    .cart-summary-section {
      position: static !important;
    }
  }
  
  /* Mobile Responsive Styles */
  @media screen and (max-width: 768px) {
    .cart-table-header {
      display: none !important;
    }
    
    .cart-item {
      display: flex !important;
      flex-direction: column !important;
      gap: 15px !important;
      padding: 20px 0 !important;
    }
    
    .cart-item__product {
      display: flex !important;
      gap: 15px !important;
      width: 100% !important;
    }
    
    .cart-item__thumbnail {
      width: 120px !important;
      height: 120px !important;
    }
    
    .cart-item__quantity {
      display: flex !important;
      flex-direction: row !important;
      align-items: center !important;
      justify-content: space-between !important;
      width: 100% !important;
      gap: 15px !important;
    }
    
    .quantity-selector-holder {
      margin: 0 !important;
    }
    
    .cart-item__total {
      text-align: left !important;
      font-size: 20px !important;
      width: 100% !important;
      padding-top: 10px !important;
      border-top: 1px solid #eee !important;
    }
    
    .card {
      padding: 20px !important;
    }
    
    .cart-section {
      padding: 20px 15px !important;
    }
  }
  
  .qty-button:hover {
    border-color: #000 !important;
    background-color: #000 !important;
  }
  
  .qty-button:hover svg path {
    stroke: #fff !important;
  }
  
  .button--solid:hover {
    background: #333 !important;
  }
</style>


<?php include 'footer.php'; ?>
