<?php
// Base URL define karo - automatically detect karta hai
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$script_name = $_SERVER['SCRIPT_NAME'];
$base_path = dirname($script_name);
$base_url = $protocol . '://' . $host . $base_path;
// Root directory ke liye base URL
$root_base_url = $protocol . '://' . $host . dirname($script_name);
$BASE_URL = rtrim($root_base_url, '/');
define('BASE_URL', $BASE_URL);
include 'header.php';
?>

<main class="main-content" id="main">
  <!-- Breadcrumb -->
  <div class="breadcrumb-main">
    <div class="breadcrumb-container">
      <nav aria-label="breadcrumbs" class="breadcrumb" id="product-breadcrumb" role="navigation">
        <span class="breadcrumb__link"><a href="<?php echo BASE_URL; ?>/">Home</a></span><span class="breadcrumb__separator">/</span><span class="breadcrumb__link"><a href="<?php echo BASE_URL; ?>/cart.php">Cart</a></span><span class="breadcrumb__separator">/</span><span class="breadcrumb__current">Checkout</span>
      </nav>
    </div>
  </div>

  <!-- Checkout Section -->
  <div class="checkout-section container--large container--vertical-space" id="main-checkout-section">
    <div class="gutter-bottom--page">
      <h1 class="title h2">Checkout</h1>
    </div>

    <form class="checkout-form" id="checkout-form" method="post" action="#">
      <div class="checkout-page-layout" style="display: grid; grid-template-columns: 1fr 400px; gap: 40px; align-items: start;">
        
        <!-- Left Section - Checkout Forms -->
        <div class="checkout-forms-section">
          
          <!-- Shipping Address -->
          <div class="checkout-section-block card" style="background: #f9f9f9; border-radius: 8px; padding: 30px; margin-bottom: 30px;">
            <h2 class="checkout-section-title" style="font-size: 20px; font-weight: 600; margin-bottom: 20px; color: #000;">Shipping Address</h2>
            
            <div class="form-fields" style="display: grid; gap: 20px;">
              <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <div class="form-field">
                  <label for="first-name" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">First Name *</label>
                  <input type="text" id="first-name" name="first_name" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                </div>
                <div class="form-field">
                  <label for="last-name" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Last Name *</label>
                  <input type="text" id="last-name" name="last_name" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                </div>
              </div>
              
              <div class="form-field">
                <label for="email" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Email Address *</label>
                <input type="email" id="email" name="email" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
              </div>
              
              <div class="form-field">
                <label for="phone" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Phone Number *</label>
                <input type="tel" id="phone" name="phone" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
              </div>
              
              <div class="form-field">
                <label for="address" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Street Address *</label>
                <input type="text" id="address" name="address" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
              </div>
              
              <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 15px;">
                <div class="form-field">
                  <label for="city" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">City *</label>
                  <input type="text" id="city" name="city" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                </div>
                <div class="form-field">
                  <label for="state" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">State *</label>
                  <input type="text" id="state" name="state" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                </div>
                <div class="form-field">
                  <label for="zip" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">ZIP Code *</label>
                  <input type="text" id="zip" name="zip" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                </div>
              </div>
              
              <div class="form-field">
                <label for="country" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Country *</label>
                <select id="country" name="country" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; background: #fff;">
                  <option value="">Select Country</option>
                  <option value="US" selected>United States</option>
                  <option value="CA">Canada</option>
                  <option value="UK">United Kingdom</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Payment Method -->
          <div class="checkout-section-block card" style="background: #f9f9f9; border-radius: 8px; padding: 30px; margin-bottom: 30px;">
            <h2 class="checkout-section-title" style="font-size: 20px; font-weight: 600; margin-bottom: 20px; color: #000;">Payment Method</h2>
            
            <div class="payment-methods" style="display: flex; flex-direction: column; gap: 15px;">
              <label class="payment-option" style="display: flex; align-items: center; gap: 12px; padding: 15px; border: 2px solid #ddd; border-radius: 8px; cursor: pointer; transition: all 0.2s;">
                <input type="radio" name="payment_method" value="card" checked style="width: 18px; height: 18px; cursor: pointer;">
                <div style="flex: 1;">
                  <div style="font-weight: 600; margin-bottom: 4px;">Credit/Debit Card</div>
                  <div style="font-size: 12px; color: #666;">Pay securely with your card</div>
                </div>
                <svg fill="none" height="24" viewbox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg">
                  <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z" stroke="currentColor" stroke-width="2"></path>
                  <path d="M2 10h20" stroke="currentColor" stroke-width="2"></path>
                </svg>
              </label>
              
              <label class="payment-option" style="display: flex; align-items: center; gap: 12px; padding: 15px; border: 2px solid #ddd; border-radius: 8px; cursor: pointer; transition: all 0.2s;">
                <input type="radio" name="payment_method" value="paypal" style="width: 18px; height: 18px; cursor: pointer;">
                <div style="flex: 1;">
                  <div style="font-weight: 600; margin-bottom: 4px;">PayPal</div>
                  <div style="font-size: 12px; color: #666;">Pay with your PayPal account</div>
                </div>
                <svg fill="none" height="24" viewbox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg">
                  <path d="M7.076 7.076c2.439-2.439 6.389-2.439 8.828 0 2.439 2.439 2.439 6.389 0 8.828-2.439 2.439-6.389 2.439-8.828 0-2.439-2.439-2.439-6.389 0-8.828z" stroke="currentColor" stroke-width="2"></path>
                </svg>
              </label>
            </div>

            <!-- Card Details (shown when card is selected) -->
            <div class="card-details" id="card-details" style="margin-top: 25px; padding-top: 25px; border-top: 1px solid #eee;">
              <div class="form-field" style="margin-bottom: 20px;">
                <label for="card-number" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Card Number *</label>
                <input type="text" id="card-number" name="card_number" placeholder="1234 5678 9012 3456" maxlength="19" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
              </div>
              
              <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <div class="form-field">
                  <label for="expiry" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Expiry Date *</label>
                  <input type="text" id="expiry" name="expiry" placeholder="MM/YY" maxlength="5" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                </div>
                <div class="form-field">
                  <label for="cvv" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">CVV *</label>
                  <input type="text" id="cvv" name="cvv" placeholder="123" maxlength="4" style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px;">
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Right Section - Order Summary -->
        <div class="checkout-summary-section" style="position: sticky; top: 20px;">
          <div class="card" style="background: #f9f9f9; border-radius: 8px; padding: 30px;">
            <h2 class="checkout-section-title" style="font-size: 20px; font-weight: 600; margin-bottom: 25px; color: #000;">Order Summary</h2>
            
            <!-- Order Items -->
            <div class="order-items" style="margin-bottom: 25px;">
              <div class="order-item" style="display: flex; gap: 15px; padding-bottom: 15px; margin-bottom: 15px; border-bottom: 1px solid #eee;">
                <div class="order-item__image" style="width: 80px; height: 80px; flex-shrink: 0; border-radius: 8px; overflow: hidden; background: #f5f5f5;">
                  <img src="<?php echo BASE_URL; ?>/assets/image/ryl-classic-35k.webp" alt="Off-Stamp X-Cube Crystal 35k" style="width: 100%; height: 100%; object-fit: cover;">
                </div>
                <div class="order-item__details" style="flex: 1;">
                  <div class="order-item__name" style="font-weight: 600; margin-bottom: 5px; font-size: 14px;">Off-Stamp X-Cube Crystal 35k (Pod)</div>
                  <div class="order-item__variant" style="font-size: 12px; color: #666; margin-bottom: 5px;">Flavor: Black Mint</div>
                  <div class="order-item__qty" style="font-size: 12px; color: #666;">Quantity: 5</div>
                </div>
                <div class="order-item__price" style="font-weight: 600; font-size: 14px;">$94.75</div>
              </div>
            </div>

            <!-- Order Totals -->
            <div class="order-totals" style="border-top: 1px solid #eee; padding-top: 20px;">
              <div class="order-total-row" style="display: flex; justify-content: space-between; margin-bottom: 10px; font-size: 14px;">
                <span>Subtotal</span>
                <span>$94.75</span>
              </div>
              <div class="order-total-row" style="display: flex; justify-content: space-between; margin-bottom: 10px; font-size: 14px; color: #666;">
                <span>Shipping</span>
                <span>Calculated at next step</span>
              </div>
              <div class="order-total-row" style="display: flex; justify-content: space-between; margin-bottom: 20px; font-size: 14px; color: #666;">
                <span>Tax</span>
                <span>Calculated at next step</span>
              </div>
              <div class="order-total-final" style="display: flex; justify-content: space-between; padding-top: 20px; border-top: 2px solid #000; margin-bottom: 25px;">
                <span style="font-weight: 600; font-size: 18px;">Total</span>
                <strong style="font-size: 24px; font-weight: bold;">$94.75</strong>
              </div>
            </div>

            <!-- Place Order Button -->
            <button type="submit" class="button button--regular button--solid" style="width: 100%; background: #000; color: #fff; border: none; padding: 15px; border-radius: 4px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.2s;">
              Place Order
            </button>
            
            <div class="checkout-security" style="margin-top: 20px; text-align: center; font-size: 12px; color: #666;">
              <svg fill="none" height="16" viewbox="0 0 16 16" width="16" style="display: inline-block; vertical-align: middle; margin-right: 5px;" xmlns="http://www.w3.org/2000/svg">
                <path d="M8 1L3 4v3c0 2.5 1.5 4.5 5 5.5 3.5-1 5-3 5-5.5V4L8 1z" stroke="currentColor" stroke-width="1.5" fill="none"></path>
              </svg>
              Secure checkout
            </div>
          </div>
        </div>
      </div>
    </form>
  </div>
  
</main>

<style>
  @media screen and (max-width: 1024px) {
    .checkout-page-layout {
      grid-template-columns: 1fr !important;
    }
    .checkout-summary-section {
      position: static !important;
    }
  }
  
  @media screen and (max-width: 768px) {
    .form-row {
      grid-template-columns: 1fr !important;
    }
    
    .card {
      padding: 20px !important;
    }
    
    .checkout-section {
      padding: 20px 15px !important;
    }
  }
  
  .payment-option:hover {
    border-color: #000 !important;
  }
  
  .payment-option input[type="radio"]:checked + div {
    color: #000;
  }
  
  .payment-option input[type="radio"]:checked ~ svg {
    color: #000;
  }
  
  .button--solid:hover {
    background: #333 !important;
  }
  
  input:focus, select:focus {
    outline: none;
    border-color: #000 !important;
  }
</style>


<?php include 'footer.php'; ?>

