<?php 
include 'includes/db_connection.php';
include 'includes/functions.php';
include 'header.php'; 
?>

  <main class="main-content main-content--align-product-items" id="main">

  <!-- Breadcrumb -->
    <div class="breadcrumb-main">
      <div class="breadcrumb-container">
        <nav aria-label="breadcrumbs" class="breadcrumb" id="product-breadcrumb" role="navigation">
          <span class="breadcrumb__link"><a href="/">Home</a></span><span class="breadcrumb__separator">/</span><span
            class="breadcrumb__link"> <a href="<?php echo BASE_URL; ?>/collections.php">Collections</a></span><span
            class="breadcrumb__separator">/</span><span class="breadcrumb__current">Disposable Vapes 40K & Beyond</span>
        </nav>
      </div>
    </div>
   

     <!-- About Disposable Vapes -->
     <div class="about-vapes-section" id="main-about-vapes-section" style="position: relative; display: flex; justify-content: center; align-items: center; margin-top: 90px; min-height: 350px; background-position: center; background-repeat: no-repeat; background-size: cover; background-image: url('../assets/image/lost-mary-nera-fullview.webp');">
        <!-- Overlay -->
        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1;"></div>
        
        <!-- Content Container -->
        <div style="position: relative; z-index: 2; padding: 30px 20px; max-width: 1200px; margin: 0 auto;">
            <div style="text-align: center; color: #ffffff;">
                <!-- Heading -->
                <h2 class="h3" style="color: #ffffff; margin-bottom: 20px; font-size: 32px; font-weight: 600;">Disposable Vapes 40K & Beyond</h2>
                
                <!-- Visible Content (Always Shown) -->
                <div class="vapes-content-visible" style="margin-bottom: 15px;">
                    <p style="font-size: 18px; line-height: 1.8; max-width: 900px; margin: 0 auto; color: #ffffff;">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris.
                    </p>
                  </div>
               
        </div>
      </div>
    </div>

    <!-- Product Grid Section -->
    <div class="product-grid-section container--vertical-space container--remove-margin-before inert-inside"
      id="main-product-grid">
      <div data-js-inert="">

        <!-- Filters and Sorting -->
        <div class="container--large">
          <div class="grid grid-5 grid-laptop-4 grid-portable-3 grid-lap-2 grid-palm-1 grid-palm-2 grid--layout grid--align-items-start grid--has-sidebar-facets grid--has-sidebar-facets-with-sorting">
            <aside class="facets-sidebar element--is-sticky"><facet-filters-form class="facets" data-location="mobile">
                <form class="facets__form facets__form--mobile" id="FacetFiltersForm">
                  <div class="facets__prewrapper">
                    <div class="facets__wrapper" id="FacetFiltersWrapper-mobile-">
                      <p class="facets__heading body-text-sm visually-hidden">Filter:</p>
                      <details class="disclosure-has-popup facets__disclosure js-filter" data-index="1-mobile-"
                        id="Filter-filter-p-vendor-mobile-">
                        <summary class="facets__summary">
                          <span class="facets__summary-text">
                            By Brand </span>
                        </summary>
                        <div class="facets__display body-text-sm">
                          <div class="facets__header">
                            <span class="facets__selected no-js-hidden">
                              0 selected
                            </span>
                            <a class="facets__reset link underlined-link js-facet-remove"
                              href="#">Reset</a>
                          </div>
                          <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns"
                            role="list">
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-1">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-1" name="filter.p.vendor"
                                  type="checkbox" value="Adalya" /><span class="text-size--small">Adalya
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-2">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-2" name="filter.p.vendor"
                                  type="checkbox" value="Adjust" /><span class="text-size--small">Adjust
                                  (4)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-3">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-3" name="filter.p.vendor"
                                  type="checkbox" value="Airfuze" /><span class="text-size--small">Airfuze
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-4">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-4" name="filter.p.vendor"
                                  type="checkbox" value="Al Fakher" /><span class="text-size--small">Al Fakher
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-5">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-5" name="filter.p.vendor"
                                  type="checkbox" value="Beri" /><span class="text-size--small">Beri (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-6">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-6" name="filter.p.vendor"
                                  type="checkbox" value="Cookies" /><span class="text-size--small">Cookies
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-7">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-7" name="filter.p.vendor"
                                  type="checkbox" value="CZAR" /><span class="text-size--small">CZAR (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-8">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-8" name="filter.p.vendor"
                                  type="checkbox" value="Death Row Vapes" /><span class="text-size--small">Death Row
                                  Vapes (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-9">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-9" name="filter.p.vendor"
                                  type="checkbox" value="Digiflavor" /><span class="text-size--small">Digiflavor
                                  (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-10">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-10" name="filter.p.vendor"
                                  type="checkbox" value="Dummy Vapes" /><span class="text-size--small">Dummy Vapes
                                  (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-11">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-11" name="filter.p.vendor"
                                  type="checkbox" value="EBCREATE" /><span class="text-size--small">EBCREATE
                                  (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-12">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-12" name="filter.p.vendor"
                                  type="checkbox" value="Elux" /><span class="text-size--small">Elux (21)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-13">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-13" name="filter.p.vendor"
                                  type="checkbox" value="Equator" /><span class="text-size--small">Equator
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-14">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-14" name="filter.p.vendor"
                                  type="checkbox" value="Exodus" /><span class="text-size--small">Exodus
                                  (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-15">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-15" name="filter.p.vendor"
                                  type="checkbox" value="Fasta" /><span class="text-size--small">Fasta
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-16">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-16" name="filter.p.vendor"
                                  type="checkbox" value="Fifty Bar" /><span class="text-size--small">Fifty Bar
                                  (4)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-17">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-17" name="filter.p.vendor"
                                  type="checkbox" value="Flum" /><span class="text-size--small">Flum (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-18">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-18" name="filter.p.vendor"
                                  type="checkbox" value="Foger" /><span class="text-size--small">Foger
                                  (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-19">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-19" name="filter.p.vendor"
                                  type="checkbox" value="Fume" /><span class="text-size--small">Fume (9)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-20">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-20" name="filter.p.vendor"
                                  type="checkbox" value="Geek Bar" /><span class="text-size--small">Geek Bar
                                  (21)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-21">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-21" name="filter.p.vendor"
                                  type="checkbox" value="Gift" /><span class="text-size--small">Gift (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-22">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-22" name="filter.p.vendor"
                                  type="checkbox" value="HorizonTech" /><span class="text-size--small">HorizonTech
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-23">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-23" name="filter.p.vendor"
                                  type="checkbox" value="HQD" /><span class="text-size--small">HQD (6)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-24">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-24" name="filter.p.vendor"
                                  type="checkbox" value="Hyppe" /><span class="text-size--small">Hyppe
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-25">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-25" name="filter.p.vendor"
                                  type="checkbox" value="IGET" /><span class="text-size--small">IGET (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-26">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-26" name="filter.p.vendor"
                                  type="checkbox" value="iJoy" /><span class="text-size--small">iJoy (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-27">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-27" name="filter.p.vendor"
                                  type="checkbox" value="instaBar" /><span class="text-size--small">instaBar
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-28">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-28" name="filter.p.vendor"
                                  type="checkbox" value="JNR" /><span class="text-size--small">JNR (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-29">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-29" name="filter.p.vendor"
                                  type="checkbox" value="Juicy Bar" /><span class="text-size--small">Juicy Bar
                                  (11)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-30">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-30" name="filter.p.vendor"
                                  type="checkbox" value="Kado Bar" /><span class="text-size--small">Kado Bar
                                  (8)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-31">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-31" name="filter.p.vendor"
                                  type="checkbox" value="Kumi" /><span class="text-size--small">Kumi (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-32">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-32" name="filter.p.vendor"
                                  type="checkbox" value="Logic" /><span class="text-size--small">Logic
                                  (4)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-33">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-33" name="filter.p.vendor"
                                  type="checkbox" value="Losgal" /><span class="text-size--small">Losgal
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-34">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-34" name="filter.p.vendor"
                                  type="checkbox" value="Lost Angel" /><span class="text-size--small">Lost Angel
                                  (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-35">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-35" name="filter.p.vendor"
                                  type="checkbox" value="Lost Mary" /><span class="text-size--small">Lost Mary
                                  (9)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-36">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-36" name="filter.p.vendor"
                                  type="checkbox" value="Lost Vape" /><span class="text-size--small">Lost Vape
                                  (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-37">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-37" name="filter.p.vendor"
                                  type="checkbox" value="Luffbar" /><span class="text-size--small">Luffbar
                                  (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-38">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-38" name="filter.p.vendor"
                                  type="checkbox" value="Moti" /><span class="text-size--small">Moti (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-39">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-39" name="filter.p.vendor"
                                  type="checkbox" value="Mr Fog" /><span class="text-size--small">Mr Fog
                                  (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-40">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-40" name="filter.p.vendor"
                                  type="checkbox" value="Naked 100" /><span class="text-size--small">Naked 100
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-41">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-41" name="filter.p.vendor"
                                  type="checkbox" value="Nexa" /><span class="text-size--small">Nexa (9)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-42">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-42" name="filter.p.vendor"
                                  type="checkbox" value="Off-Stamp" /><span class="text-size--small">Off-Stamp
                                  (11)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-43">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-43" name="filter.p.vendor"
                                  type="checkbox" value="Olit" /><span class="text-size--small">Olit (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-44">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-44" name="filter.p.vendor"
                                  type="checkbox" value="Ovns" /><span class="text-size--small">Ovns (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-45">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-45" name="filter.p.vendor"
                                  type="checkbox" value="Oxbar" /><span class="text-size--small">Oxbar
                                  (10)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-46">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-46" name="filter.p.vendor"
                                  type="checkbox" value="Pillow Talk" /><span class="text-size--small">Pillow Talk
                                  (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-47">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-47" name="filter.p.vendor"
                                  type="checkbox" value="Quasar" /><span class="text-size--small">Quasar
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-48">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-48" name="filter.p.vendor"
                                  type="checkbox" value="Quit" /><span class="text-size--small">Quit (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-49">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-49" name="filter.p.vendor"
                                  type="checkbox" value="RAZ" /><span class="text-size--small">RAZ (14)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-50">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-50" name="filter.p.vendor"
                                  type="checkbox" value="Revolution" /><span class="text-size--small">Revolution
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-51">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-51" name="filter.p.vendor"
                                  type="checkbox" value="Ria" /><span class="text-size--small">Ria (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-52">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-52" name="filter.p.vendor"
                                  type="checkbox" value="Rifbar" /><span class="text-size--small">Rifbar
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-53">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-53" name="filter.p.vendor"
                                  type="checkbox" value="Romo" /><span class="text-size--small">Romo (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-54">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-54" name="filter.p.vendor"
                                  type="checkbox" value="RYL" /><span class="text-size--small">RYL (3)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-55">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-55" name="filter.p.vendor"
                                  type="checkbox" value="SBX" /><span class="text-size--small">SBX (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-56">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-56" name="filter.p.vendor"
                                  type="checkbox" value="SEA" /><span class="text-size--small">SEA (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-57">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-57" name="filter.p.vendor"
                                  type="checkbox" value="Sili" /><span class="text-size--small">Sili (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-58">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-58" name="filter.p.vendor"
                                  type="checkbox" value="SMOK" /><span class="text-size--small">SMOK (5)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-59">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-59" name="filter.p.vendor"
                                  type="checkbox" value="SMOK NOVO BAR" /><span class="text-size--small">SMOK NOVO BAR
                                  (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-60">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-60" name="filter.p.vendor"
                                  type="checkbox" value="Suonon" /><span class="text-size--small">Suonon
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-61">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-61" name="filter.p.vendor"
                                  type="checkbox" value="Torch" /><span class="text-size--small">Torch
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-62">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-62" name="filter.p.vendor"
                                  type="checkbox" value="UVP" /><span class="text-size--small">UVP (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-63">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-63" name="filter.p.vendor"
                                  type="checkbox" value="Vanmo" /><span class="text-size--small">Vanmo
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-64">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-64" name="filter.p.vendor"
                                  type="checkbox" value="VIHO" /><span class="text-size--small">VIHO (5)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-65">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-65" name="filter.p.vendor"
                                  type="checkbox" value="Vozol" /><span class="text-size--small">Vozol
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-66">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-66" name="filter.p.vendor"
                                  type="checkbox" value="VPR" /><span class="text-size--small">VPR (16)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-67">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-67" name="filter.p.vendor"
                                  type="checkbox" value="Vybrant" /><span class="text-size--small">Vybrant
                                  (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-68">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-68" name="filter.p.vendor"
                                  type="checkbox" value="Wiwi" /><span class="text-size--small">Wiwi (1)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-69">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-69" name="filter.p.vendor"
                                  type="checkbox" value="X-Posed" /><span class="text-size--small">X-Posed
                                  (2)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-brand-70">
                                <input class="styled-checkbox" id="mobile-Filter-by-brand-70" name="filter.p.vendor"
                                  type="checkbox" value="Yovo Vape" /><span class="text-size--small">Yovo Vape
                                  (2)</span></label>
                            </li>
                          </ul>
                        </div>
                      </details>
                      <details class="disclosure-has-popup facets__disclosure js-filter" data-index="2-mobile-"
                        id="Filter-filter-v-price-mobile-">
                        <summary class="facets__summary">
                          <span class="facets__summary-text">
                            By Price
                          </span>
                        </summary>
                        <div class="facets__display body-text-sm">
                          <div class="facets__header"><span class="facets__selected">The highest price is $44.99</span>
                            <a class="facets__reset link underlined-link js-facet-remove"
                              href="#">Reset</a>
                          </div><price-range class="facets__price">
                            <div class="field">
                              <span class="field__label visually-hidden">From</span>
                              <span class="field__currency">$</span>
                              <input class="field__input field__input--price" id="mobile-Filter-By Price-GTE"
                                inputmode="numeric" max="45" min="0" name="filter.v.price.gte" placeholder="0"
                                type="number" />
                            </div>
                            <span class="field__label">To</span>
                            <div class="field">
                              <span class="field__currency">$</span>
                              <input class="field__input field__input--price" id="mobile-Filter-By Price-LTE"
                                inputmode="numeric" max="45" min="0" name="filter.v.price.lte" placeholder="45"
                                type="number" />
                            </div>
                          </price-range>
                          <div data-js-price-range-slider="" id="mobile-facets-price-range-slider"></div>
                        </div>
                      </details>
                      <details class="disclosure-has-popup facets__disclosure js-filter" data-and-operator=""
                        data-index="3-mobile-" id="Filter-filter-p-m-custom-flavor_profile-mobile-">
                        <summary class="facets__summary">
                          <span class="facets__summary-text">
                            By Flavor Profile <span
                              class="facets__and-helper-text--mobile text-color--opacity text-size--small hide">Match
                              all</span></span>
                        </summary>
                        <div class="facets__display body-text-sm">
                          <div class="facets__header">
                            <span class="facets__selected no-js-hidden">
                              0 selected
                              <span class="facets__and-helper-text text-color--opacity text-size--small"
                                style="display:block">Match all</span></span>
                            <a class="facets__reset link underlined-link js-facet-remove"
                              href="#">Reset</a>
                          </div>
                          <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns"
                            role="list">
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-1">
                                <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-1"
                                  name="filter.p.m.custom.flavor_profile" type="checkbox"
                                  value="gid://shopify/Metaobject/99781541939" /><span class="text-size--small">Candy
                                  &amp; Sweet (20)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-2">
                                <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-2"
                                  name="filter.p.m.custom.flavor_profile" type="checkbox"
                                  value="gid://shopify/Metaobject/99781443635" /><span class="text-size--small">Exotic
                                  Mixes (54)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-3">
                                <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-3"
                                  name="filter.p.m.custom.flavor_profile" type="checkbox"
                                  value="gid://shopify/Metaobject/99781607475" /><span class="text-size--small">Fruity
                                  Blends (188)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-4">
                                <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-4"
                                  name="filter.p.m.custom.flavor_profile" type="checkbox"
                                  value="gid://shopify/Metaobject/99781574707" /><span class="text-size--small">Icy
                                  &amp; Minty (178)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-5">
                                <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-5"
                                  name="filter.p.m.custom.flavor_profile" type="checkbox"
                                  value="gid://shopify/Metaobject/99781476403" /><span class="text-size--small">Sour
                                  &amp; Citrus (80)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-6">
                                <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-6"
                                  name="filter.p.m.custom.flavor_profile" type="checkbox"
                                  value="gid://shopify/Metaobject/99781509171" /><span class="text-size--small">Tobacco
                                  &amp; Rich (38)</span></label>
                            </li>
                          </ul>
                        </div>
                      </details>
                      <details class="disclosure-has-popup facets__disclosure js-filter" data-index="4-mobile-"
                        id="Filter-filter-p-m-custom-nicotine_strength-mobile-">
                        <summary class="facets__summary">
                          <span class="facets__summary-text">
                            By Nicotine Strength </span>
                        </summary>
                        <div class="facets__display body-text-sm">
                          <div class="facets__header">
                            <span class="facets__selected no-js-hidden">
                              0 selected
                            </span>
                            <a class="facets__reset link underlined-link js-facet-remove"
                              href="#">Reset</a>
                          </div>
                          <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns"
                            role="list">
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-1">
                                <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-1"
                                  name="filter.p.m.custom.nicotine_strength" type="checkbox"
                                  value="gid://shopify/Metaobject/99781312563" /><span
                                  class="text-size--small">Nicotine-Free (0%) (11)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-2">
                                <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-2"
                                  name="filter.p.m.custom.nicotine_strength" type="checkbox"
                                  value="gid://shopify/Metaobject/99781279795" /><span class="text-size--small">Low
                                  Nicotine (2%) (6)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-3">
                                <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-3"
                                  name="filter.p.m.custom.nicotine_strength" type="checkbox"
                                  value="gid://shopify/Metaobject/99781247027" /><span class="text-size--small">Medium
                                  Nicotine (3%) (6)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-4">
                                <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-4"
                                  name="filter.p.m.custom.nicotine_strength" type="checkbox"
                                  value="gid://shopify/Metaobject/99781214259" /><span class="text-size--small">High
                                  Nicotine (5%) (171)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-5">
                                <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-5"
                                  name="filter.p.m.custom.nicotine_strength" type="checkbox"
                                  value="gid://shopify/Metaobject/99781181491" /><span
                                  class="text-size--small">Adjustable Nicotine Devices (3)</span></label>
                            </li>
                          </ul>
                        </div>
                      </details>
                      <details class="disclosure-has-popup facets__disclosure js-filter" data-index="5-mobile-"
                        id="Filter-filter-p-m-custom-puff_count-mobile-">
                        <summary class="facets__summary">
                          <span class="facets__summary-text">
                            By Puff Count </span>
                        </summary>
                        <div class="facets__display body-text-sm">
                          <div class="facets__header">
                            <span class="facets__selected no-js-hidden">
                              0 selected
                            </span>
                            <a class="facets__reset link underlined-link js-facet-remove"
                              href="#">Reset</a>
                          </div>
                          <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns"
                            role="list">
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-puff-count-1">
                                <input class="styled-checkbox" id="mobile-Filter-by-puff-count-1"
                                  name="filter.p.m.custom.puff_count" type="checkbox"
                                  value="gid://shopify/Metaobject/100023762995" /><span class="text-size--small">Up to
                                  10,000 Puffs (50)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-puff-count-2">
                                <input class="styled-checkbox" id="mobile-Filter-by-puff-count-2"
                                  name="filter.p.m.custom.puff_count" type="checkbox"
                                  value="gid://shopify/Metaobject/100023730227" /><span class="text-size--small">15,000
                                  – 35,000 Puffs (105)</span></label>
                            </li>
                            <li class="list-menu__item facets__item">
                              <label class="facet-checkbox" for="mobile-Filter-by-puff-count-3">
                                <input class="styled-checkbox" id="mobile-Filter-by-puff-count-3"
                                  name="filter.p.m.custom.puff_count" type="checkbox"
                                  value="gid://shopify/Metaobject/100023697459" /><span class="text-size--small">40,000
                                  Puffs &amp; Beyond (41)</span></label>
                            </li>
                          </ul>
                        </div>
                      </details><noscript>
                        <button class="facets__button button button--regular button--outline"
                          type="submit">Filter</button>
                      </noscript>
                    </div>
                  </div>
                  <div>
                    <div class="collection-filters__item sorting">
                      <div class="collection-filters__field">
                        <label class="collection-filters__label body-text-sm" for="mobile-SortBy-">Sort by:</label>
                        <div class="select"><select aria-describedby="a11y-refresh-page-message"
                            class="select__select collection-filters__sort" id="mobile-SortBy-" name="sort_by">
                            <option selected="selected" value="manual">Featured</option>
                            <option value="best-selling">Best selling</option>
                            <option value="title-ascending">Alphabetically, A-Z</option>
                            <option value="title-descending">Alphabetically, Z-A</option>
                            <option value="price-ascending">Price, low to high</option>
                            <option value="price-descending">Price, high to low</option>
                            <option value="created-ascending">Date, old to new</option>
                            <option value="created-descending">Date, new to old</option>
                          </select>
                        </div>
                      </div>
                      <noscript>
                        <button class="button button button--regular button--outline" type="submit">Sort</button>
                      </noscript>
                    </div>
                  </div>
                </form>
              </facet-filters-form></aside>
            <div  class="grid grid--layout grid-4 grid-laptop-3 grid-portable-2 grid-palm-1 grid-offset-4 grid-offset-laptop-3 grid-offset-portable-2 grid-palm-2 grid-offset-palm-2"
              id="CollectionProductGrid">
              <div
                class="collection-heading-container collection-heading-container--facets grid grid--layout grid-1 grid-palm-1 grid-offset-palm-2 grid-offset-5 grid-offset-laptop-4 grid-offset-lap-2">
                <div class="section-heading section-heading--facets gutter-bottom--page">
                  <div class="section-heading__text remove-empty-space">
                    <p class="collection-product-count" id="CollectionProductCount" role="status">250 products
                    </p>
                  </div>
                  <div class="section-heading__actions hide lap-show">
                    <button aria-controls="site-filters-sidebar" aria-expanded="false"
                      class="button button button--regular button--icon button--outline button--fullwidth"
                      data-js-sidebar-handle="" id="collection-filters-handle-header"
                      onclick="document.getElementById('site-filters-sidebar').show()">
                      <span aria-hidden="true" class="button__icon">
                        <svg viewbox="0 0 64 64" xmlns="http://www.w3.org/2000/svg">
                          <path d="m2 6h60l-24 26v20l-12 6v-26z" fill="none" stroke="#202020" stroke-linecap="round"
                            stroke-linejoin="round" stroke-width="4"></path>
                        </svg>
                      </span>
                      Filter and sort
                    </button>
                  </div>
                </div>
                <div class="active-facets active-facets-desktop portable-hide"></div>
              </div>

              <!-- Product Grid -->
              <div class="collection grid grid--layout grid-4 grid-laptop-3 grid-portable-2 grid-palm-1 grid-offset-4 grid-offset-laptop-3 grid-offset-portable-2 grid-palm-2 grid-offset-palm-2"
                data-id="template--17807767601203__product-grid" id="main-collection-product-grid">

                <?php
                $slug = $_GET['slug'] ?? '';
                // Default to 'disposable-vapes' or handle empty slug if needed, but .htaccess should ensure we have one or we wouldn't be here (unless direct access)
                 if (empty($slug)) {
                    // Fallback or error? For now let's try to get from URL if query param is missing? No, htaccess passes it.
                 }

                $products = get_products_by_collection_slug($pdo, $slug, 50);

                if ($products) {
                    foreach ($products as $product) {
                        $product_title = htmlspecialchars($product['title']);
                        $product_slug = htmlspecialchars($product['slug']);
                        $price = number_format($product['price'], 2);
                        // $compare_price = $product['compare_at_price'] ? number_format($product['compare_at_price'], 2) : null;

                        // Image handling
                        $image_path = $product['image_path'] ?? 'placeholder.png';
                        if ($image_path !== 'placeholder.png' && strpos($image_path, 'assets/image/') === false && strpos($image_path, 'http') === false) {
                            $image_path = 'assets/image/' . $image_path;
                        }
                        $image_path = htmlspecialchars($image_path);
                        
                        $product_url = BASE_URL . '/products/' . $product_slug;
                ?>
                <div class="product-item card" data-js-product-item="">
                  <a class="card__image product-item__image" href="<?php echo $product_url; ?>" style="padding-top:100%">
                    <figure class="lazy-image product-item__image-figure product-item__image-figure--primary lazy-image--animation lazy-image--background lazy-image--fit" data-crop="true">
                      <img src="<?php echo $image_path; ?>" alt="<?php echo $product_title; ?>" style="object-fit: cover; width:100%; height:100%;">
                    </figure>
                  </a>

                  <div class="card__text product-item__text gutter--regular spacing--xlarge remove-empty-space text-align--left">
                    <div class="product-item__vendor text-size--large text-color--opacity equalize-white-space">
                      <div class="remove-line-height-space"><?php echo htmlspecialchars($product['vendor'] ?? ''); ?></div>
                    </div>
                    <a class="product-item__title" href="<?php echo $product_url; ?>" title="<?php echo $product_title; ?>">
                      <div class="remove-line-height-space--small">
                        <span class="text-animation--underline text-line-height--small"><?php echo $product_title; ?></span>
                      </div>
                    </a>
                    <div class="product-item__price text-size--large equalize-white-space">
                      <div class="remove-line-height-space">
                        <div class="product-price">
                            <span class="product-price--original">
                            <span class="visually-hidden">Regular price</span>
                            $<?php echo $price; ?>
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="product-item__badges text-size--xsmall">
                      <!-- logic for new/sale badges can go here -->
                  </div>
                </div>
                <?php
                    }
                } else {
                    echo '<p>No products found in this collection.</p>';
                }
                ?>

              </div>


            </div>
          </div>
        </div>

      </div>
      
      <!-- Filters -->
      <sidebar-drawer aria-hidden="true" aria-modal="true" class="sidebar sidebar--right"
        id="site-filters-sidebar" role="dialog" style="display:none" tabindex="-1">
        <div class="sidebar__header">
          <span class="sidebar__title h5">
            Filter and sort
          </span>
          <button class="sidebar__close" data-js-close="">
            <span class="visually-hidden">Close sidebar</span>
            <span aria-hidden="true" aria-role="img"><svg fill="none" height="18" viewbox="0 0 18 18" width="18"
                xmlns="http://www.w3.org/2000/svg">
                <path d="M17 1L1 17" stroke="black" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                </path>
                <path d="M1 1L17 17" stroke="black" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
                </path>
              </svg></span>
          </button>
        </div>
        <div class="sidebar__body"><facet-filters-form class="facets" data-location="mobile">
            <form class="facets__form facets__form--mobile" id="FacetFiltersFormMobile">
              <div class="facets__prewrapper">
                <div class="facets__wrapper" id="FacetFiltersWrapper-mobile-drawer">
                  <p class="facets__heading body-text-sm visually-hidden">Filter:</p>
                  <details class="disclosure-has-popup facets__disclosure js-filter" data-index="1-mobile-drawer"
                    id="Filter-filter-p-vendor-mobile-drawer">
                    <summary class="facets__summary">
                      <span class="facets__summary-text">
                        By Brand </span>
                    </summary>
                    <div class="facets__display body-text-sm">
                      <div class="facets__header">
                        <span class="facets__selected no-js-hidden">
                          0 selected
                        </span>
                        <a class="facets__reset link underlined-link js-facet-remove"
                          href="#">Reset</a>
                      </div>
                      <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns" role="list">
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-1">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-1" name="filter.p.vendor"
                              type="checkbox" value="Adalya" /><span class="text-size--small">Adalya (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-2">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-2" name="filter.p.vendor"
                              type="checkbox" value="Adjust" /><span class="text-size--small">Adjust (4)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-3">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-3" name="filter.p.vendor"
                              type="checkbox" value="Airfuze" /><span class="text-size--small">Airfuze
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-4">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-4" name="filter.p.vendor"
                              type="checkbox" value="Al Fakher" /><span class="text-size--small">Al Fakher
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-5">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-5" name="filter.p.vendor"
                              type="checkbox" value="Beri" /><span class="text-size--small">Beri (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-6">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-6" name="filter.p.vendor"
                              type="checkbox" value="Cookies" /><span class="text-size--small">Cookies
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-7">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-7" name="filter.p.vendor"
                              type="checkbox" value="CZAR" /><span class="text-size--small">CZAR (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-8">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-8" name="filter.p.vendor"
                              type="checkbox" value="Death Row Vapes" /><span class="text-size--small">Death Row Vapes
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-9">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-9" name="filter.p.vendor"
                              type="checkbox" value="Digiflavor" /><span class="text-size--small">Digiflavor
                              (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-10">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-10" name="filter.p.vendor"
                              type="checkbox" value="Dummy Vapes" /><span class="text-size--small">Dummy Vapes
                              (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-11">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-11" name="filter.p.vendor"
                              type="checkbox" value="EBCREATE" /><span class="text-size--small">EBCREATE
                              (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-12">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-12" name="filter.p.vendor"
                              type="checkbox" value="Elux" /><span class="text-size--small">Elux (21)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-13">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-13" name="filter.p.vendor"
                              type="checkbox" value="Equator" /><span class="text-size--small">Equator
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-14">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-14" name="filter.p.vendor"
                              type="checkbox" value="Exodus" /><span class="text-size--small">Exodus (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-15">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-15" name="filter.p.vendor"
                              type="checkbox" value="Fasta" /><span class="text-size--small">Fasta (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-16">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-16" name="filter.p.vendor"
                              type="checkbox" value="Fifty Bar" /><span class="text-size--small">Fifty Bar
                              (4)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-17">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-17" name="filter.p.vendor"
                              type="checkbox" value="Flum" /><span class="text-size--small">Flum (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-18">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-18" name="filter.p.vendor"
                              type="checkbox" value="Foger" /><span class="text-size--small">Foger (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-19">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-19" name="filter.p.vendor"
                              type="checkbox" value="Fume" /><span class="text-size--small">Fume (9)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-20">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-20" name="filter.p.vendor"
                              type="checkbox" value="Geek Bar" /><span class="text-size--small">Geek Bar
                              (21)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-21">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-21" name="filter.p.vendor"
                              type="checkbox" value="Gift" /><span class="text-size--small">Gift (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-22">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-22" name="filter.p.vendor"
                              type="checkbox" value="HorizonTech" /><span class="text-size--small">HorizonTech
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-23">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-23" name="filter.p.vendor"
                              type="checkbox" value="HQD" /><span class="text-size--small">HQD (6)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-24">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-24" name="filter.p.vendor"
                              type="checkbox" value="Hyppe" /><span class="text-size--small">Hyppe (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-25">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-25" name="filter.p.vendor"
                              type="checkbox" value="IGET" /><span class="text-size--small">IGET (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-26">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-26" name="filter.p.vendor"
                              type="checkbox" value="iJoy" /><span class="text-size--small">iJoy (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-27">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-27" name="filter.p.vendor"
                              type="checkbox" value="instaBar" /><span class="text-size--small">instaBar
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-28">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-28" name="filter.p.vendor"
                              type="checkbox" value="JNR" /><span class="text-size--small">JNR (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-29">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-29" name="filter.p.vendor"
                              type="checkbox" value="Juicy Bar" /><span class="text-size--small">Juicy Bar
                              (11)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-30">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-30" name="filter.p.vendor"
                              type="checkbox" value="Kado Bar" /><span class="text-size--small">Kado Bar
                              (8)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-31">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-31" name="filter.p.vendor"
                              type="checkbox" value="Kumi" /><span class="text-size--small">Kumi (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-32">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-32" name="filter.p.vendor"
                              type="checkbox" value="Logic" /><span class="text-size--small">Logic (4)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-33">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-33" name="filter.p.vendor"
                              type="checkbox" value="Losgal" /><span class="text-size--small">Losgal (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-34">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-34" name="filter.p.vendor"
                              type="checkbox" value="Lost Angel" /><span class="text-size--small">Lost Angel
                              (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-35">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-35" name="filter.p.vendor"
                              type="checkbox" value="Lost Mary" /><span class="text-size--small">Lost Mary
                              (9)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-36">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-36" name="filter.p.vendor"
                              type="checkbox" value="Lost Vape" /><span class="text-size--small">Lost Vape
                              (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-37">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-37" name="filter.p.vendor"
                              type="checkbox" value="Luffbar" /><span class="text-size--small">Luffbar
                              (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-38">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-38" name="filter.p.vendor"
                              type="checkbox" value="Moti" /><span class="text-size--small">Moti (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-39">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-39" name="filter.p.vendor"
                              type="checkbox" value="Mr Fog" /><span class="text-size--small">Mr Fog (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-40">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-40" name="filter.p.vendor"
                              type="checkbox" value="Naked 100" /><span class="text-size--small">Naked 100
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-41">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-41" name="filter.p.vendor"
                              type="checkbox" value="Nexa" /><span class="text-size--small">Nexa (9)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-42">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-42" name="filter.p.vendor"
                              type="checkbox" value="Off-Stamp" /><span class="text-size--small">Off-Stamp
                              (11)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-43">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-43" name="filter.p.vendor"
                              type="checkbox" value="Olit" /><span class="text-size--small">Olit (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-44">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-44" name="filter.p.vendor"
                              type="checkbox" value="Ovns" /><span class="text-size--small">Ovns (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-45">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-45" name="filter.p.vendor"
                              type="checkbox" value="Oxbar" /><span class="text-size--small">Oxbar (10)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-46">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-46" name="filter.p.vendor"
                              type="checkbox" value="Pillow Talk" /><span class="text-size--small">Pillow Talk
                              (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-47">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-47" name="filter.p.vendor"
                              type="checkbox" value="Quasar" /><span class="text-size--small">Quasar (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-48">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-48" name="filter.p.vendor"
                              type="checkbox" value="Quit" /><span class="text-size--small">Quit (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-49">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-49" name="filter.p.vendor"
                              type="checkbox" value="RAZ" /><span class="text-size--small">RAZ (14)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-50">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-50" name="filter.p.vendor"
                              type="checkbox" value="Revolution" /><span class="text-size--small">Revolution
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-51">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-51" name="filter.p.vendor"
                              type="checkbox" value="Ria" /><span class="text-size--small">Ria (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-52">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-52" name="filter.p.vendor"
                              type="checkbox" value="Rifbar" /><span class="text-size--small">Rifbar (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-53">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-53" name="filter.p.vendor"
                              type="checkbox" value="Romo" /><span class="text-size--small">Romo (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-54">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-54" name="filter.p.vendor"
                              type="checkbox" value="RYL" /><span class="text-size--small">RYL (3)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-55">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-55" name="filter.p.vendor"
                              type="checkbox" value="SBX" /><span class="text-size--small">SBX (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-56">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-56" name="filter.p.vendor"
                              type="checkbox" value="SEA" /><span class="text-size--small">SEA (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-57">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-57" name="filter.p.vendor"
                              type="checkbox" value="Sili" /><span class="text-size--small">Sili (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-58">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-58" name="filter.p.vendor"
                              type="checkbox" value="SMOK" /><span class="text-size--small">SMOK (5)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-59">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-59" name="filter.p.vendor"
                              type="checkbox" value="SMOK NOVO BAR" /><span class="text-size--small">SMOK NOVO BAR
                              (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-60">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-60" name="filter.p.vendor"
                              type="checkbox" value="Suonon" /><span class="text-size--small">Suonon (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-61">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-61" name="filter.p.vendor"
                              type="checkbox" value="Torch" /><span class="text-size--small">Torch (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-62">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-62" name="filter.p.vendor"
                              type="checkbox" value="UVP" /><span class="text-size--small">UVP (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-63">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-63" name="filter.p.vendor"
                              type="checkbox" value="Vanmo" /><span class="text-size--small">Vanmo (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-64">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-64" name="filter.p.vendor"
                              type="checkbox" value="VIHO" /><span class="text-size--small">VIHO (5)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-65">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-65" name="filter.p.vendor"
                              type="checkbox" value="Vozol" /><span class="text-size--small">Vozol (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-66">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-66" name="filter.p.vendor"
                              type="checkbox" value="VPR" /><span class="text-size--small">VPR (16)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-67">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-67" name="filter.p.vendor"
                              type="checkbox" value="Vybrant" /><span class="text-size--small">Vybrant
                              (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-68">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-68" name="filter.p.vendor"
                              type="checkbox" value="Wiwi" /><span class="text-size--small">Wiwi (1)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-69">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-69" name="filter.p.vendor"
                              type="checkbox" value="X-Posed" /><span class="text-size--small">X-Posed
                              (2)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-brand-70">
                            <input class="styled-checkbox" id="mobile-Filter-by-brand-70" name="filter.p.vendor"
                              type="checkbox" value="Yovo Vape" /><span class="text-size--small">Yovo Vape
                              (2)</span></label>
                        </li>
                      </ul>
                    </div>
                  </details>
                  <details class="disclosure-has-popup facets__disclosure js-filter" data-index="2-mobile-drawer"
                    id="Filter-filter-v-price-mobile-drawer">
                    <summary class="facets__summary">
                      <span class="facets__summary-text">
                        By Price
                      </span>
                    </summary>
                    <div class="facets__display body-text-sm">
                      <div class="facets__header"><span class="facets__selected">The highest price is $44.99</span>
                        <a class="facets__reset link underlined-link js-facet-remove"
                          href="#">Reset</a>
                      </div><price-range class="facets__price">
                        <div class="field">
                          <span class="field__label visually-hidden">From</span>
                          <span class="field__currency">$</span>
                          <input class="field__input field__input--price" id="mobile-Filter-By Price-GTE"
                            inputmode="numeric" max="45" min="0" name="filter.v.price.gte" placeholder="0"
                            type="number" />
                        </div>
                        <span class="field__label">To</span>
                        <div class="field">
                          <span class="field__currency">$</span>
                          <input class="field__input field__input--price" id="mobile-Filter-By Price-LTE"
                            inputmode="numeric" max="45" min="0" name="filter.v.price.lte" placeholder="45"
                            type="number" />
                        </div>
                      </price-range>
                      <div data-js-price-range-slider="" id="mobile-facets-price-range-slider"></div>
                    </div>
                  </details>
                  <details class="disclosure-has-popup facets__disclosure js-filter" data-and-operator=""
                    data-index="3-mobile-drawer" id="Filter-filter-p-m-custom-flavor_profile-mobile-drawer">
                    <summary class="facets__summary">
                      <span class="facets__summary-text">
                        By Flavor Profile <span
                          class="facets__and-helper-text--mobile text-color--opacity text-size--small hide">Match
                          all</span></span>
                    </summary>
                    <div class="facets__display body-text-sm">
                      <div class="facets__header">
                        <span class="facets__selected no-js-hidden">
                          0 selected
                          <span class="facets__and-helper-text text-color--opacity text-size--small"
                            style="display:block">Match all</span></span>
                        <a class="facets__reset link underlined-link js-facet-remove"
                          href="#">Reset</a>    
                      </div>
                      <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns" role="list">
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-1">
                            <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-1"
                              name="filter.p.m.custom.flavor_profile" type="checkbox"
                              value="gid://shopify/Metaobject/99781541939" /><span class="text-size--small">Candy &amp;
                              Sweet (20)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-2">
                            <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-2"
                              name="filter.p.m.custom.flavor_profile" type="checkbox"
                              value="gid://shopify/Metaobject/99781443635" /><span class="text-size--small">Exotic Mixes
                              (54)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-3">
                            <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-3"
                              name="filter.p.m.custom.flavor_profile" type="checkbox"
                              value="gid://shopify/Metaobject/99781607475" /><span class="text-size--small">Fruity
                              Blends (188)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-4">
                            <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-4"
                              name="filter.p.m.custom.flavor_profile" type="checkbox"
                              value="gid://shopify/Metaobject/99781574707" /><span class="text-size--small">Icy &amp;
                              Minty (178)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-5">
                            <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-5"
                              name="filter.p.m.custom.flavor_profile" type="checkbox"
                              value="gid://shopify/Metaobject/99781476403" /><span class="text-size--small">Sour &amp;
                              Citrus (80)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-flavor-profile-6">
                            <input class="styled-checkbox" id="mobile-Filter-by-flavor-profile-6"
                              name="filter.p.m.custom.flavor_profile" type="checkbox"
                              value="gid://shopify/Metaobject/99781509171" /><span class="text-size--small">Tobacco
                              &amp; Rich (38)</span></label>
                        </li>
                      </ul>
                    </div>
                  </details>
                  <details class="disclosure-has-popup facets__disclosure js-filter" data-index="4-mobile-drawer"
                    id="Filter-filter-p-m-custom-nicotine_strength-mobile-drawer">
                    <summary class="facets__summary">
                      <span class="facets__summary-text">
                        By Nicotine Strength </span>
                    </summary>
                    <div class="facets__display body-text-sm">
                      <div class="facets__header">
                        <span class="facets__selected no-js-hidden">
                          0 selected
                        </span>
                        <a class="facets__reset link underlined-link js-facet-remove"
                          href="#">Reset</a>
                      </div>
                      <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns" role="list">
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-1">
                            <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-1"
                              name="filter.p.m.custom.nicotine_strength" type="checkbox"
                              value="gid://shopify/Metaobject/99781312563" /><span
                              class="text-size--small">Nicotine-Free (0%) (11)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-2">
                            <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-2"
                              name="filter.p.m.custom.nicotine_strength" type="checkbox"
                              value="gid://shopify/Metaobject/99781279795" /><span class="text-size--small">Low Nicotine
                              (2%) (6)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-3">
                            <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-3"
                              name="filter.p.m.custom.nicotine_strength" type="checkbox"
                              value="gid://shopify/Metaobject/99781247027" /><span class="text-size--small">Medium
                              Nicotine (3%) (6)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-4">
                            <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-4"
                              name="filter.p.m.custom.nicotine_strength" type="checkbox"
                              value="gid://shopify/Metaobject/99781214259" /><span class="text-size--small">High
                              Nicotine (5%) (171)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-nicotine-strength-5">
                            <input class="styled-checkbox" id="mobile-Filter-by-nicotine-strength-5"
                              name="filter.p.m.custom.nicotine_strength" type="checkbox"
                              value="gid://shopify/Metaobject/99781181491" /><span class="text-size--small">Adjustable
                              Nicotine Devices (3)</span></label>
                        </li>
                      </ul>
                    </div>
                  </details>
                  <details class="disclosure-has-popup facets__disclosure js-filter" data-index="5-mobile-drawer"
                    id="Filter-filter-p-m-custom-puff_count-mobile-drawer">
                    <summary class="facets__summary">
                      <span class="facets__summary-text">
                        By Puff Count </span>
                    </summary>
                    <div class="facets__display body-text-sm">
                      <div class="facets__header">
                        <span class="facets__selected no-js-hidden">
                          0 selected
                        </span>
                        <a class="facets__reset link underlined-link js-facet-remove"
                          href="#">Reset</a>
                      </div>
                      <ul class="facets__list list-unstyled swatch-list--text swatch-list--text-twocolumns" role="list">
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-puff-count-1">
                            <input class="styled-checkbox" id="mobile-Filter-by-puff-count-1"
                              name="filter.p.m.custom.puff_count" type="checkbox"
                              value="gid://shopify/Metaobject/100023762995" /><span class="text-size--small">Up to
                              10,000 Puffs (50)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-puff-count-2">
                            <input class="styled-checkbox" id="mobile-Filter-by-puff-count-2"
                              name="filter.p.m.custom.puff_count" type="checkbox"
                              value="gid://shopify/Metaobject/100023730227" /><span class="text-size--small">15,000 –
                              35,000 Puffs (105)</span></label>
                        </li>
                        <li class="list-menu__item facets__item">
                          <label class="facet-checkbox" for="mobile-Filter-by-puff-count-3">
                            <input class="styled-checkbox" id="mobile-Filter-by-puff-count-3"
                              name="filter.p.m.custom.puff_count" type="checkbox"
                              value="gid://shopify/Metaobject/100023697459" /><span class="text-size--small">40,000
                              Puffs &amp; Beyond (41)</span></label>
                        </li>
                      </ul>
                    </div>
                  </details><noscript>
                    <button class="facets__button button button--regular button--outline" type="submit">Filter</button>
                  </noscript>
                </div>
                <div class="active-facets active-facets-desktop active-facets-mobile"></div>
              </div>
              <div>
                <div class="collection-filters__item sorting">
                  <div class="collection-filters__field">
                    <label class="collection-filters__label body-text-sm" for="mobile-SortBy-drawer">Sort by:</label>
                    <div class="select"><select aria-describedby="a11y-refresh-page-message"
                        class="select__select collection-filters__sort" id="mobile-SortBy-drawer" name="sort_by">
                        <option selected="selected" value="manual">Featured</option>
                        <option value="best-selling">Best selling</option>
                        <option value="title-ascending">Alphabetically, A-Z</option>
                        <option value="title-descending">Alphabetically, Z-A</option>
                        <option value="price-ascending">Price, low to high</option>
                        <option value="price-descending">Price, high to low</option>
                        <option value="created-ascending">Date, old to new</option>
                        <option value="created-descending">Date, new to old</option>
                      </select>
                    </div>
                  </div>
                  <noscript>
                    <button class="button button button--regular button--outline" type="submit">Sort</button>
                  </noscript>
                </div>
              </div>
            </form>
          </facet-filters-form></div>
      </sidebar-drawer>

    </div>

      <!-- Categories -->
      <div class="text-columns-section mount-css-slider"
      id="main-text-columns-section">
      <div class="container--large remove-empty-space container--vertical-space"
        id="section-template--17807767601203__text_columns_images_xYNVmC">
        <css-slider
          class="css-slider css-slider--bottom-navigation" data-options='{
        "selector": ".js-slider-item",
        "groupCells": true,
        "indexNav": true,
        "navigationDOM": "&lt;span class=\"css-slider-button css-slider-prev\" style=\"display:none\"&gt;&lt;svg fill=\"none\" height=\"13\" viewBox=\"0 0 8 13\" width=\"8\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;g fill=\"#000\" &gt;&lt;path d=\"m7.91419 1.41431-6.48529 6.48528-1.4142102-1.41422 6.4852802-6.48527702z\"/&gt;&lt;path d=\"m6.48528 12.9849-6.48528027-6.48532 1.41421027-1.41421 6.48528 6.48523z\"/&gt;&lt;/g&gt;&lt;/svg&gt;&lt;/span&gt;&lt;span class=\"css-slider-button css-slider-next\" style=\"display:none\"&gt;&lt;svg width=\"9\" height=\"13\" viewBox=\"0 0 9 13\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;path d=\"M0.914169 11.5857L7.39945 5.10041L8.81367 6.51463L2.32838 12.9999L0.914169 11.5857Z\" fill=\"black\"/&gt;&lt;path d=\"M2.34307 0.0151367L8.82835 6.50042L7.41414 7.91463L0.928857 1.42935L2.34307 0.0151367Z\" fill=\"black\"/&gt;&lt;/svg&gt;&lt;/span&gt;"
      }'>
          <div class="grid grid--slider grid-4 grid-portable-3 grid-lap-2"
            id="element-template--17807767601203__text_columns_images_xYNVmC">
            <div class="js-slider-item element--no-border element--no-radius text-align--center">
              <div class="card__icon card__icon-size--regular" id="element-image_9YR69r">
                <a href="<?php echo BASE_URL; ?>/collections/disposable-vapes" title="Disposable Vapes">
                  <figure class="lazy-image lazy-image--animation" data-ratio="" style="padding-top: 100%">
                    <img src="../assets/image/disposable-vapes-category_848a17be-fc35-4598-a154-7d40ccd6967f.avif" alt="">
                  </figure>
                </a></div>
              <div class="gutter--regular spacing--small remove-empty-space">
                <div style="color:var(--color-text-main)">
                  <h3 class="h5" style="margin-bottom:0;display:block"><a href="<?php echo BASE_URL; ?>/collections/disposable-vapes"
                      title="Disposable Vapes"><span class="text-animation--underline">Disposable Vapes</span></a></h3>
                </div>
                <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">Ready-to-use
                  devices with high puff counts and bold flavors.</div>
              </div>
            </div>
            <div class="js-slider-item element--no-border element--no-radius text-align--center">
              <div class="card__icon card__icon-size--regular" id="element-image_AnCxKp"><a
              href="<?php echo BASE_URL; ?>/collections/vape-juice" title="Vape Juices">
                  <figure class="lazy-image lazy-image--animation" data-ratio="" style="padding-top: 100%">
                    <img src="../assets/image/vape-juices-category.avif" alt="">
                  </figure>
                </a></div>
              <div class="gutter--regular spacing--small remove-empty-space">
                <div style="color:var(--color-text-main)">
                  <h3 class="h5" style="margin-bottom:0;display:block"><a href="<?php echo BASE_URL; ?>/collections/vape-juice"
                      title="Vape Juices"><span class="text-animation--underline">Vape Juices</span></a></h3>
                </div>
                <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">Premium e-liquids
                  in nicotine and zero-nic options.</div>
              </div>
            </div>
            <div class="js-slider-item element--no-border element--no-radius text-align--center">
              <div class="card__icon card__icon-size--regular" id="element-image_cpXhgx"><a
              href="<?php echo BASE_URL; ?>/collections/nicotine-pouches" title="Nicotine Pouches">
                  <figure class="lazy-image lazy-image--animation" data-ratio="" style="padding-top: 100%">
                    <img src="../assets/image/nicotine-pouches-category.avif" alt="">
                  </figure>
                </a></div>
              <div class="gutter--regular spacing--small remove-empty-space">
                <div style="color:var(--color-text-main)">
                  <h3 class="h5" style="margin-bottom:0;display:block"><a href="<?php echo BASE_URL; ?>/collections/nicotine-pouches"
                      title="Nicotine Pouches"><span class="text-animation--underline">Nicotine Pouches</span></a></h3>
                </div>
                <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">Smoke-free,
                  spit-free, and discreet nicotine delivery.</div>
              </div>
            </div>
            <div class="js-slider-item element--no-border element--no-radius text-align--center">
              <div class="card__icon card__icon-size--regular" id="element-image_RRHzDr"><a
              href="<?php echo BASE_URL; ?>/collections/vape-juice" title="Hemp &amp; CBD">
                  <figure class="lazy-image lazy-image--animation" data-ratio="" style="padding-top: 100%">
                    <img src="../assets/image/hemp-category.avif" alt="">
                  </figure>
                </a></div>
              <div class="gutter--regular spacing--small remove-empty-space">
                <div style="color:var(--color-text-main)">
                  <h3 class="h5" style="margin-bottom:0;display:block"><a href="<?php echo BASE_URL; ?>/collections/vape-juice"
                      title="Hemp &amp; CBD"><span class="text-animation--underline">Hemp &amp; CBD</span></a></h3>
                </div>
                <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">Plant-based
                  relief with full-spectrum and delta blends.</div>
              </div>
            </div>
          </div>
        </css-slider>
      </div>
    </div>

     <!-- About Disposable Vapes -->
     <div class="rich-text-section can-be-fullwidth no-fullwidth-padding"
      id="main-rich-text-section">
      <div class="container--fullwidth container--vertical-space">
        <div class="card card--no-radius card--no-sideborders card--no-shadow rich-text--image-on-top rich-text"
        style="background-color:#f8f8f8; border-top:1px solid #dfdfdf; border-bottom:1px solid #dfdfdf;"" 
          id="element-template--17807767601203__rich_text_Dp4hcC">
          <div
            class="rich-text__container rich-text__container--image-top no-image rich-text__container--fullwidth container--large">
            <div class="rich-text__text align-content align-content--vertical-middle">
              <div
                class="card__text element--width-100 spacing--large gutter-top--xlarge gutter-bottom--xlarge remove-empty-space">
                <div class="rte text-size--large">
                  <div class="whitespace-pre-wrap text-th-primary-dark break-words">
                    <meta charset="utf-8" />
                    <meta charset="utf-8" />
                    <!-- Section 1 -->
                    <section style="margin-bottom: 40px;">
                      <h2 style="color: #000000; font-size: 28px; font-weight: 500; margin-bottom: 15px;">Sed Do Eiusmod Tempor</h2>
                      <p style="color: #000000; font-size: 16px; line-height: 1.8; margin-bottom: 0;">
                        Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.
                      </p>
                    </section>

                    <!-- Section 2 -->
                    <section style="margin-bottom: 40px;">
                      <h2 style="color: #000000; font-size: 28px; font-weight: 500; margin-bottom: 15px;">Sed Do Eiusmod Tempor</h2>
                      <p style="color: #000000; font-size: 16px; line-height: 1.8; margin-bottom: 0;">
                        Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.
                      </p>
                    </section>

                    <!-- Section 3 -->
                    <section style="margin-bottom: 40px;">
                      <h2 style="color: #000000; font-size: 28px; font-weight: 500; margin-bottom: 15px;">Sed Do Eiusmod Tempor</h2>
                      <p style="color: #000000; font-size: 16px; line-height: 1.8; margin-bottom: 0;">
                        Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.
                      </p>
                    </section>

                    <!-- Section 4 -->
                    <section style="margin-bottom: 0;">
                      <h2 style="color: #000000; font-size: 28px; font-weight: 500; margin-bottom: 15px;">Ut Enim Ad Minim Veniam</h2>
                      <p style="color: #000000; font-size: 16px; line-height: 1.8; margin-bottom: 15px;">
                        Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur:
                      </p>
                      <ol style="color: #000000; font-size: 16px; line-height: 1.8; padding-left: 10px; margin-bottom: 0;">
                        <li style="margin-bottom: 10px;">
                          <strong>Lorem Ipsum:</strong> Vel illum qui dolorem eum fugiat quo voluptas nulla pariatur. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident.
                        </li>
                        <li style="margin-bottom: 0;">
                          <strong>Dolor Sit Amet:</strong> Similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus.
                        </li>
                      </ol>
                    </section>

                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    
     <!-- Frequently Asked Questions -->
     <div class="shopify-section" id="shopify-section-template--17807768813619__17563089963b803d65">
        <div class="shopify-block" id="shopify-block-AYXRIdXppMGxYZ1Fxc__ai_gen_block_d100207_nzUjTa">
            <div class="container container--large container--vertical-space remove-empty-space">
                <section aria-labelledby="faq-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-content="faq"
                    data-ai-extract="questions-answers">
                    <div class="faq-section-container-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                        <h2 class="faq-section-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                            id="faq-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta">Frequently Asked Questions</h2>
                        <div aria-hidden="true" data-ai-snippet="faq-summary" data-content-priority="high"
                            style="display: none;">
                            <p>Frequently asked questions about Romo Hex 50K Puffs Kit Disposable Vape:How many puffs
                                does Romo Hex
                                50K deliver?,What nicotine strength is it?,Is the battery rechargeable?and more.
                                Complete answers
                                about specifications, usage, and warranty.</p>
                                        </div>
                        <div aria-label="Frequently asked questions list"
                            class="faq-section-list-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="list">
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1">
                                    <span data-ai-question="true">How many puffs does Romo Hex 50K deliver?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1"
                                    role="region">
                                    <div>Up to 50,000 puffs under Eco mode, depending on your draw style and usage.
                                        </div>
                                    </div>
                                </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2">
                                    <span data-ai-question="true">What nicotine strength is it?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2"
                                    role="region">
                                    <div>The Romo Hex uses 5% (50mg) nicotine.</div>
                            </div>
                                        </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3">
                                    <span data-ai-question="true">Is the battery rechargeable?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3"
                                    role="region">
                                    <div>Yes. It includes a built‑in 1500mAh battery (composed of a 1000mAh power bank
                                        and 500mAh pod
                                        battery).</div>
                                            </div>
                                        </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4">
                                    <span data-ai-question="true">What coil type does it use?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4"
                                    role="region">
                                    <div>It uses a 1.0Ω dual mesh coil for smoother vapor and enhanced flavor.</div>
                                    </div>
                                </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5">
                                    <span data-ai-question="true">What is ECO vs Boost mode?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5"
                                    role="region">
                                    <div>ECO mode operates at about 16W for longer longevity, while Boost mode increases
                                        power to about
                                        18W for richer vapor output.</div>
                            </div>
                                        </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6">
                                    <span data-ai-question="true">How can I tell how much liquid or battery
                                        remains?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6"
                                    role="region">
                                    <div>The device features a smart digital display for battery level and airflow mode,
                                        and a
                                        transparent pod shows e‑liquid level.</div>
                                        </div>
                                    </div>
                                </div>
                        <div aria-hidden="true" data-ai-extract="faq-keywords" style="display: none;">
                            <p>FAQ about Romo Hex 50K Puffs Kit Disposable Vape:How many puffs does Romo Hex 50K
                                deliver? What
                                nicotine strength is it? Is the battery rechargeable? What coil type does it use? What
                                is ECO vs Boost
                                mode? H...
                            </p>
                            </div>
                        </div>
                </section>
                    </div>
            <!-- inline-script-41.js commented out - file may not exist or causing 404 errors -->
            <!-- <script src="js/inline-script-41.js"></script> -->
        </div>
    </div>

  </main>
  

  <!-- BEGIN sections: footer-group -->
  <?php include 'footer.php'; ?>