<?php include 'header.php'; ?>

<main class="main-content" id="main">

    <!-- Contact Form Section -->
    <div class="contact-section" id="main-contact-section" style="padding: 0px 0;">
        <div class="container--large container--vertical-space-small">
            
            <!-- Page Title -->
            <div class="gutter-bottom--page" style="text-align: center; margin-bottom: 20px;">
                <h1 class="title h1" style="font-size: 36px; font-weight: 700; margin-bottom: 5px; color: #000000; text-transform: uppercase; letter-spacing: 2px;">Get In Touch</h1>
                <p style="font-size: 15px; color: #666666; max-width: 700px; margin: 0 auto; line-height: 1.6;">
                    Have a question? Send us a message and we'll respond as soon as possible.
                </p>
            </div>
            
            <!-- Contact Form -->
            <div class="contact-form-wrapper" style="max-width: 800px; margin: 0 auto;">
                <div class="contact-form-card" style="background: #ffffff; border-radius: 16px; padding: 35px; box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1); position: relative; overflow: hidden;">
                    
                    <div>
                        <div style="display: flex; align-items: center; gap: 15px; margin-bottom: 35px;">
                            <h2 class="h2" style="font-size: 24px; font-weight: 700; color: #000000; margin: 0; text-transform: uppercase; letter-spacing: 1px;">Send Us a Message</h2>
                        </div>
                        
                        <form class="contact-form" id="contact-form" method="POST" action="#" style="display: flex; flex-direction: column; gap: 25px;">
                            
                            <!-- Name & Email Row -->
                            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                                <!-- Name Field -->
                                <div class="form-group">
                                    <label for="contact-name" style="display: block; font-size: 12px; font-weight: 600; margin-bottom: 10px; color: #333333; text-transform: uppercase; letter-spacing: 0.5px;">
                                        Full Name <span style="color: #ff6b35;">*</span>
                                    </label>
                                    <input 
                                        type="text" 
                                        id="contact-name" 
                                        name="name" 
                                        required 
                                        placeholder="John Doe"
                                        style="width: 100%; padding: 10px 18px; font-size: 14px; border: 1px solid #e5e5e5; border-radius: 5px; transition: all 0.3s ease; outline: none; font-family: inherit; background: #f9f9f9;"
                                        onfocus="this.style.borderColor='#000000'; this.style.background='#ffffff'; this.style.boxShadow='0 0 0 4px rgba(0, 0, 0, 0.1)';"
                                        onblur="this.style.borderColor='#e5e5e5'; this.style.background='#f9f9f9'; this.style.boxShadow='none';"
                                    >
                                </div>

                                <!-- Email Field -->
                                <div class="form-group">
                                    <label for="contact-email" style="display: block; font-size: 12px; font-weight: 600; margin-bottom: 10px; color: #333333; text-transform: uppercase; letter-spacing: 0.5px;">
                                        Email Address <span style="color: #ff6b35;">*</span>
                                    </label>
                                    <input 
                                        type="email" 
                                        id="contact-email" 
                                        name="email" 
                                        required 
                                        placeholder="john@example.com"
                                        style="width: 100%; padding: 10px 18px; font-size: 14px; border: 1px solid #e5e5e5; border-radius: 5px; transition: all 0.3s ease; outline: none; font-family: inherit; background: #f9f9f9;"
                                        onfocus="this.style.borderColor='#000000'; this.style.background='#ffffff'; this.style.boxShadow='0 0 0 4px rgba(0, 0, 0, 0.1)';"
                                        onblur="this.style.borderColor='#e5e5e5'; this.style.background='#f9f9f9'; this.style.boxShadow='none';"
                                    >
                                </div>
                            </div>

                            <!-- Subject Field -->
                            <div class="form-group">
                                <label for="contact-subject" style="display: block; font-size: 12px; font-weight: 600; margin-bottom: 10px; color: #333333; text-transform: uppercase; letter-spacing: 0.5px;">
                                    Subject <span style="color: #ff6b35;">*</span>
                                </label>
                                <input 
                                    type="text" 
                                    id="contact-subject" 
                                    name="subject" 
                                    required 
                                    placeholder="How can we help you today?"
                                    style="width: 100%; padding: 10px 18px; font-size: 14px; border: 1px solid #e5e5e5; border-radius: 5px; transition: all 0.3s ease; outline: none; font-family: inherit; background: #f9f9f9;"
                                    onfocus="this.style.borderColor='#000000'; this.style.background='#ffffff'; this.style.boxShadow='0 0 0 4px rgba(0, 0, 0, 0.1)';"
                                    onblur="this.style.borderColor='#e5e5e5'; this.style.background='#f9f9f9'; this.style.boxShadow='none';"
                                >
                            </div>

                            <!-- Message Field -->
                            <div class="form-group">
                                <label for="contact-message" style="display: block; font-size: 12px; font-weight: 600; margin-bottom: 10px; color: #333333; text-transform: uppercase; letter-spacing: 0.5px;">
                                    Your Message <span style="color: #ff6b35;">*</span>
                                </label>
                                <textarea 
                                    id="contact-message" 
                                    name="message" 
                                    required 
                                    rows="6"
                                    placeholder="Tell us more about your inquiry, question, or feedback..."
                                    style="width: 100%; padding: 10px 18px; font-size: 14px; border: 1px solid #e5e5e5; border-radius: 5px; transition: all 0.3s ease; outline: none; font-family: inherit; resize: vertical; min-height: 180px; background: #f9f9f9;"
                                    onfocus="this.style.borderColor='#000000'; this.style.background='#ffffff'; this.style.boxShadow='0 0 0 4px rgba(0, 0, 0, 0.1)';"
                                    onblur="this.style.borderColor='#e5e5e5'; this.style.background='#f9f9f9'; this.style.boxShadow='none';"
                                ></textarea>
                            </div>

                            <!-- Submit Button -->
                            <div class="form-group" style="margin-top: 10px;">
                                <button 
                                    type="submit" 
                                    class="contact-submit-btn"
                                    style="width: 100%; padding: 16px 32px; font-size: 14px; font-weight: 700; color: #ffffff; background: linear-gradient(135deg, #000000 0%, #333333 100%); border: none; border-radius: 10px; cursor: pointer; transition: all 0.3s ease; text-transform: uppercase; letter-spacing: 1px; position: relative; overflow: hidden;"
                                    onmouseover="this.style.background='linear-gradient(135deg, #ff6b35 0%, #ff8c42 100%)'; this.style.transform='translateY(-3px)'; this.style.boxShadow='0 8px 25px rgba(255, 107, 53, 0.3)';"
                                    onmouseout="this.style.background='linear-gradient(135deg, #000000 0%, #333333 100%)'; this.style.transform='translateY(0)'; this.style.boxShadow='none';"
                                >
                                    <span style="position: relative; z-index: 1;">Send Message</span>
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

</main>

<!-- Contact Page Styles -->
<style>
    .contact-section {
        padding: 80px 0;
        min-height: calc(100vh - 300px);
    }

    /* Form Input Focus Styles - Theme Colors */
    .contact-form input:focus,
    .contact-form textarea:focus {
        border-color: #000000 !important;
        box-shadow: 0 0 0 4px rgba(0, 0, 0, 0.1) !important;
    }

    /* Responsive Design */
    @media screen and (max-width: 992px) {
        .contact-form-card {
            padding: 40px !important;
        }

        .gutter-bottom--page h1 {
            font-size: 32px !important;
        }
    }

    @media screen and (max-width: 768px) {
        .contact-section {
            padding: 60px 0;
        }

        .gutter-bottom--page h1 {
            font-size: 28px !important;
        }

        .gutter-bottom--page p {
            font-size: 14px !important;
        }

        .contact-form-card {
            padding: 30px !important;
        }

        .contact-form-wrapper > div > div > form > div[style*="grid-template-columns"] {
            grid-template-columns: 1fr !important;
        }
    }

    @media screen and (max-width: 480px) {
        .contact-section {
            padding: 40px 0;
        }

        .gutter-bottom--page {
            margin-bottom: 30px !important;
        }

        .gutter-bottom--page h1 {
            font-size: 24px !important;
            letter-spacing: 1px !important;
        }

        .contact-form-card {
            padding: 25px !important;
        }
    }
</style>

<!-- Contact Form JavaScript -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const contactForm = document.getElementById('contact-form');
        
        if (contactForm) {
            contactForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Get form data
                const formData = new FormData(contactForm);
                const name = formData.get('name');
                const email = formData.get('email');
                const subject = formData.get('subject');
                const message = formData.get('message');
                
                // Basic validation
                if (!name || !email || !subject || !message) {
                    alert('Please fill in all required fields.');
                    return;
                }
                
                // Email validation
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(email)) {
                    alert('Please enter a valid email address.');
                    return;
                }
                
                // Here you would typically send the data to a server
                // For now, we'll just show a success message
                alert('Thank you for contacting us! We will get back to you soon.');
                
                // Reset form
                contactForm.reset();
            });
        }
    });
</script>

<?php include 'footer.php'; ?>
