<?php
// Base URL detect karo agar pehle se define nahi hai
if (!defined('BASE_URL')) {
  $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'];
  $script_name = $_SERVER['SCRIPT_NAME'];
  // Current file ka path detect karo
  $current_file = $_SERVER['PHP_SELF'];
  // Agar subdirectory mein hai (jaise collections/), to parent directory root hai
  if (strpos($current_file, '/collections/') !== false || strpos($current_file, '/pages/') !== false) {
    $base_path = dirname(dirname($script_name));
  } else {
    $base_path = dirname($script_name);
  }
  $BASE_URL = rtrim($protocol . '://' . $host . $base_path, '/');
  define('BASE_URL', $BASE_URL);
}
?>
<div class="footer-section footer-section-group main-footer"
    id="main-footer-section">

    <link href="<?php echo BASE_URL; ?>/css/section-footer.css" media="all" rel="stylesheet" type="text/css" />

    <div class="footer-top-modern" data-js-inert="">
      <div class="container--large" style="max-width: 1400px; margin: 0 auto; padding: 80px 20px;">
        
        <!-- Top Section: Brand & Newsletter -->
        <div class="footer-brand-section" style="display: grid; grid-template-columns: 1fr 1fr; gap: 60px; margin-bottom: 70px; padding-bottom: 60px; border-bottom: 1px solid rgba(255, 255, 255, 0.1);">
          
          <!-- Brand Info -->
          <div class="footer-brand-info">
            <div class="footer-logo-modern" style="margin-bottom: 25px;">
              <h2 style="color: #ffffff; font-size: 32px; font-weight: 800; letter-spacing: -0.5px; margin: 0; font-family: 'DM Sans', sans-serif;">
                The Perfect Vape
              </h2>
            </div>
            <p style="color: rgba(255, 255, 255, 0.8); font-size: 16px; line-height: 1.7; margin: 0 0 30px 0; max-width: 450px;">
              America's Best Vape Deals – Fast Shipping, Fresh Flavors, Always Stocked. Your trusted source for premium disposable vapes and e-liquids.
            </p>
            <div class="footer-social-modern" style="display: flex; gap: 15px; align-items: center;">
              <a href="mailto:support@theperfectvape.com" 
                 class="social-icon-modern" 
                 style="width: 42px; height: 42px; border-radius: 50%; background: rgba(255, 255, 255, 0.1); display: flex; align-items: center; justify-content: center; color: #ffffff; text-decoration: none; transition: all 0.3s ease; border: 1px solid rgba(255, 255, 255, 0.15);">
                <i class="fa-solid fa-envelope" style="font-size: 16px;"></i>
              </a>
              <a href="#" 
                 class="social-icon-modern" 
                 style="width: 42px; height: 42px; border-radius: 50%; background: rgba(255, 255, 255, 0.1); display: flex; align-items: center; justify-content: center; color: #ffffff; text-decoration: none; transition: all 0.3s ease; border: 1px solid rgba(255, 255, 255, 0.15);">
                <i class="fa-brands fa-facebook-f" style="font-size: 16px;"></i>
              </a>
              <a href="#" 
                 class="social-icon-modern" 
                 style="width: 42px; height: 42px; border-radius: 50%; background: rgba(255, 255, 255, 0.1); display: flex; align-items: center; justify-content: center; color: #ffffff; text-decoration: none; transition: all 0.3s ease; border: 1px solid rgba(255, 255, 255, 0.15);">
                <i class="fa-brands fa-instagram" style="font-size: 18px;"></i>
              </a>
              <a href="#" 
                 class="social-icon-modern" 
                 style="width: 42px; height: 42px; border-radius: 50%; background: rgba(255, 255, 255, 0.1); display: flex; align-items: center; justify-content: center; color: #ffffff; text-decoration: none; transition: all 0.3s ease; border: 1px solid rgba(255, 255, 255, 0.15);">
                <i class="fa-brands fa-pinterest" style="font-size: 16px;"></i>
              </a>
            </div>
          </div>

          <!-- Newsletter -->
          <div class="footer-newsletter-modern">
            <h3 style="color: #ffffff; font-size: 22px; font-weight: 700; margin: 0 0 15px 0; font-family: 'DM Sans', sans-serif;">
              Stay Updated
            </h3>
            <p style="color: rgba(255, 255, 255, 0.7); font-size: 14px; line-height: 1.6; margin: 0 0 25px 0;">
              Subscribe to get exclusive deals, new product launches, and vaping tips delivered to your inbox.
            </p>
            <form class="newsletter-form-modern" style="display: flex; gap: 10px; max-width: 400px;">
              <input type="email" 
                     placeholder="Enter your email" 
                     required
                     style="flex: 1; padding: 14px 18px; border-radius: 8px; border: 1px solid rgba(255, 255, 255, 0.2); background: rgba(255, 255, 255, 0.05); color: #ffffff; font-size: 14px; outline: none; transition: all 0.3s ease;">
              <button type="submit" 
                      style="padding: 14px 28px; border-radius: 8px; background: #ffffff; color: #000000; border: none; font-weight: 600; font-size: 14px; cursor: pointer; transition: all 0.3s ease; white-space: nowrap;">
                Subscribe
              </button>
            </form>
          </div>

        </div>

        <!-- Bottom Section: Links Grid -->
        <div class="footer-links-grid" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 50px;">
          
          <!-- Shop -->
          <div class="footer-column-modern">
            <h4 style="color: #ffffff; font-size: 16px; font-weight: 700; margin: 0 0 25px 0; text-transform: uppercase; letter-spacing: 0.5px; font-family: 'DM Sans', sans-serif;">
              Shop
            </h4>
            <nav style="display: flex; flex-direction: column; gap: 12px;">
              <a href="<?php echo BASE_URL; ?>/collections/disposable-vapes" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Disposable Vapes
              </a>
              <a href="<?php echo BASE_URL; ?>/collections/nicotine-pouches" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Nicotine Pouches
              </a>
              <a href="<?php echo BASE_URL; ?>/collections/vape-juice" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Vape Juices
              </a>
            </nav>
          </div>

          <!-- Support -->
          <div class="footer-column-modern">
            <h4 style="color: #ffffff; font-size: 16px; font-weight: 700; margin: 0 0 25px 0; text-transform: uppercase; letter-spacing: 0.5px; font-family: 'DM Sans', sans-serif;">
              Support
            </h4>
            <nav style="display: flex; flex-direction: column; gap: 12px;">
              <a href="<?php echo BASE_URL; ?>/pages/faqs.php" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                FAQs
              </a>
              <a href="<?php echo BASE_URL; ?>/pages/shipping-policy.php" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Shipping Policy
              </a>
              <a href="<?php echo BASE_URL; ?>/pages/return-policy.php" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Return Policy
              </a>
              <a href="" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Track Your Order
              </a>
            </nav>
          </div>

          <!-- Legal -->
          <div class="footer-column-modern">
            <h4 style="color: #ffffff; font-size: 16px; font-weight: 700; margin: 0 0 25px 0; text-transform: uppercase; letter-spacing: 0.5px; font-family: 'DM Sans', sans-serif;">
              Legal
            </h4>
            <nav style="display: flex; flex-direction: column; gap: 12px;">
              <a href="<?php echo BASE_URL; ?>/pages/privacy-policy.php" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Privacy Policy
              </a>
              <a href="<?php echo BASE_URL; ?>/pages/terms-and-conditions.php" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Terms & Conditions
              </a>
              <a href="<?php echo BASE_URL; ?>/pages/fda-disclaimer.php" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                FDA Disclaimer
              </a>
              <a href="<?php echo BASE_URL; ?>/blog.php" 
                 style="color: rgba(255, 255, 255, 0.75); text-decoration: none; font-size: 15px; transition: all 0.2s ease; display: inline-block; width: fit-content;">
                Blog
              </a>
            </nav>
          </div>

        </div>

      </div>
    </div>

    <div class="footer-bottom-modern" data-js-inert="" style="border-top: 1px solid rgba(255, 255, 255, 0.1);">
      <div class="container--large" style="max-width: 1400px; margin: 0 auto; padding: 30px 20px;">
        <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 30px;">
          
          <!-- Copyright -->
          <div style="flex: 1; min-width: 250px;">
            <p style="color: rgba(255, 255, 255, 0.6); font-size: 14px; margin: 0; line-height: 1.6;">
              Copyright © 2025 <a href="index.php" style="color: rgba(255, 255, 255, 0.9); text-decoration: none; font-weight: 600; transition: color 0.2s ease;">The Perfect Vape</a>. All rights reserved.
            </p>
          </div>

          <!-- Payment Methods -->
          <div class="payment-methods-modern" style="display: flex; align-items: center; gap: 15px; flex-wrap: wrap; justify-content: flex-end;">
            <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
              <img src="<?php echo BASE_URL; ?>/assets/image/visa.png" alt="Visa" style="height: 20px; object-fit: contain; opacity: 0.9; transition: opacity 0.2s ease;">
              <img src="<?php echo BASE_URL; ?>/assets/image/mastercard.png" alt="Mastercard" style="height: 24px; object-fit: contain; opacity: 0.9; transition: opacity 0.2s ease;">
              <img src="<?php echo BASE_URL; ?>/assets/image/amex.png" alt="American Express" style="height: 24px; object-fit: contain; opacity: 0.9; transition: opacity 0.2s ease;">
              <img src="<?php echo BASE_URL; ?>/assets/image/discover.png" alt="Discover" style="height: 24px; object-fit: contain; opacity: 0.9; transition: opacity 0.2s ease;">
              <img src="<?php echo BASE_URL; ?>/assets/image/jcb.png" alt="JCB" style="height: 24px; object-fit: contain; opacity: 0.9; transition: opacity 0.2s ease;">
              <img src="<?php echo BASE_URL; ?>/assets/image/gpay.png" alt="Google Pay" style="height: 24px; object-fit: contain; opacity: 0.9; transition: opacity 0.2s ease;">
              <img src="<?php echo BASE_URL; ?>/assets/image/shop.png" alt="Shop Pay" style="height: 24px; object-fit: contain; opacity: 0.9; transition: opacity 0.2s ease;">
            </div>
          </div>

        </div>
      </div>
    </div>

  </div>

  <div class="popups-section" id="main-popups-section">
    <div class="stacked-popups stacked-popups--position-right"><modal-box
        class="popup popup-block popup--cookies popup-size--small" data-modal-box="" data-options='
              {
                
                "show":  1 ,
                "enabled": true,
                
                "frequency": "month",
                 "type": "cookies", 
                "closeByKey": false,
                "disableScroll": false
              }
            ' id="modal-popups-0" style="display:none;">
        <div class="popup-text gutter--regular spacing--large remove-empty-space">
          <div>
            <span class="h4 popup-title">Cookies</span>
          </div>
          <div>
            <span class="text-size--small">This website uses cookies to ensure you get the best experience on your
              device.</span>
          </div>
          <div class="increased-spacing cta-stacked">
            <button class="button button--solid button--regular button--fullwidth" data-js-close=""
              data-js-cookies-accept="">
              Accept all cookies
            </button>
            <button class="button button--outline button--regular button--fullwidth" data-js-close=""
              data-js-cookies-decline="">
              Decline all cookies
            </button>
          </div>
        </div>
        <div aria-hidden="true" data-content="" style="display:none">cookies-popups-0</div>
        <link href="<?php echo BASE_URL; ?>/css/inline-style-54.css" rel="stylesheet" />
      </modal-box></div>
    <link href="<?php echo BASE_URL; ?>/css/inline-style-55.css" rel="stylesheet" />
    <link href="<?php echo BASE_URL; ?>/css/inline-style-56.css" rel="stylesheet" />
  </div>

  <div class="age-verification-section mount-popup" id="main-age-verification-section"><modal-box
      class="popup-age-verification" data-options='
      {
        "show":  0 ,
        "frequency": "day",
        "enabled": true,
        "closeByKey": false,
        "disableScroll": true,
        "showOnce": false
      }
    ' id="modal-popup-age-verification" style="display:none;">
      <div class="popup-age-verification__content">
        <div class="popup-text gutter--regular spacing--large remove-empty-space">
          <div>
            <span class="h4 popup-title">Age verification</span>
          </div>
          <div class="rte">
            <p>By clicking enter, I certify that I am over the age of 21</p>
          </div>
          <div class="increased-spacing">
            <button class="button button--outline button--regular button--fullwidth" data-js-close="">
              Enter
            </button>
          </div>
        </div>
      </div>
      <div aria-hidden="true" data-content="" style="display:none">age-verification</div>
    </modal-box>
    <link href="<?php echo BASE_URL; ?>/css/inline-style-57.css" rel="stylesheet" />
  </div>

  <div class="exit-intent-section element--has-section-borders mount-exit-intent-popup"
    id="main-exit-intent-section">
  </div>

  <div class="store-selector-section mount-popup mount-store-selector mount-map" id="main-store-selector-section">
  </div>
  <script defer="" src="<?php echo BASE_URL; ?>/js/component-modal.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/component-modal.css" media="print" onload="this.media='all'" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/css/component-popup.css" media="print" onload="this.media='all'" rel="stylesheet" />

  <script>
    // Force show age verification modal for testing
    document.addEventListener('DOMContentLoaded', function() {
      setTimeout(function() {
        const ageModal = document.getElementById('modal-popup-age-verification');
        if (ageModal) {
          // Clear localStorage for this modal
          const modalKey = 'modal-' + document.location.hostname + '-modal-popup-age-verification';
          localStorage.removeItem(modalKey);
          // Force show modal
          if (ageModal.show) {
            ageModal.show();
          } else {
            ageModal.style.display = '';
            ageModal.classList.add('active');
          }
        }
      }, 1000);
    });
  </script>

  <script defer="" src="<?php echo BASE_URL; ?>/js/component-slider.js"></script><sidebar-drawer aria-hidden="true" aria-modal="true"
    class="sidebar sidebar--right" data-cart-items="5" data-js-site-cart-sidebar="" id="site-cart-sidebar"
    role="dialog" style="display:none" tabindex="-1">
    
    <div class="sidebar__header">
      <span class="sidebar__title h5">

        Shopping Cart

        (<span data-header-cart-count="">5</span>)

      </span>
      <button class="sidebar__close" data-js-close="">
        <span class="visually-hidden">Close sidebar</span>
        <span aria-hidden="true" aria-role="img"><svg fill="none" height="18" viewbox="0 0 18 18" width="18"
            xmlns="http://www.w3.org/2000/svg">
            <path d="M17 1L1 17" stroke="black" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
            <path d="M1 1L17 17" stroke="black" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
          </svg></span>
      </button>
    </div>

    <div class="sidebar__body sidebar__body--flex">
      <div class="sidebar__body-top">
        <div class="cart-form"><cart-form id="AjaxCartForm">
            <form action="/cart" class="cart__form" id="cart" method="post" novalidate="">
              <div class="cart-holder" data-items="5">
                <div class="cart__items">

                  <!-- Static Cart Item -->
                  <div class="cart-item">
                    <a href="<?php echo BASE_URL; ?>/products/off-stamp-xcube-crystal-35k" class="cart-item__thumbnail" style="display: block; width: 6.25rem; height: 6.25rem; flex-shrink: 0; overflow: hidden; align-self: flex-start; background: #f5f5f5; border-radius: 4px;">
                      <img src="<?php echo BASE_URL; ?>/assets/image/ryl-classic-35k.webp" alt="Off-Stamp X-Cube Crystal 35k" loading="lazy" style="width: 100%; height: 100%; object-fit: cover; display: block;">
                    </a>
                    <div class="cart-item__content">
                      <div>
                        <div class="cart-item__price">$94.75</div>
                        <a href="<?php echo BASE_URL; ?>/products/off-stamp-xcube-crystal-35k" class="cart-item__title" style="text-decoration: none; color: inherit; display: block;">Off-Stamp X-Cube Crystal 35k (Pod)</a>
                        <div class="cart-item__variant">Flavor: Black Mint</div>
                        <div class="cart-item__actions" style="display: flex !important; align-items: center; gap: 15px; margin-top: 0.5rem;">
                          <div class="quantity-selector-holder" style="display: flex; align-items: center; gap: 8px;">
                            <button type="button" class="qty-button" aria-label="Decrease quantity" style="width: 1.875rem; height: 1.875rem; border-radius: 100%; border: 1px solid #ddd; background: #fff; display: flex; align-items: center; justify-content: center; cursor: pointer; padding: 0; line-height: 1; transition: all 0.1s linear;">
                              <svg fill="none" height="11" viewbox="0 0 12 12" width="12" xmlns="http://www.w3.org/2000/svg" style="height: 0.6875rem;">
                                <path d="M2 6h8" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"></path>
                              </svg>
                            </button>
                            <span class="qty-selector" style="height: 1.875rem; min-width: 1.875rem; display: flex; align-items: center; justify-content: center; font-size: 14px; font-weight: 500; color: #000;">5</span>
                            <button type="button" class="qty-button" aria-label="Increase quantity" style="width: 1.875rem; height: 1.875rem; border-radius: 100%; border: 1px solid #ddd; background: #fff; display: flex; align-items: center; justify-content: center; cursor: pointer; padding: 0; line-height: 1; transition: all 0.1s linear;">
                              <svg fill="none" height="11" viewbox="0 0 12 12" width="12" xmlns="http://www.w3.org/2000/svg" style="height: 0.6875rem;">
                                <path d="M6 2v8M2 6h8" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"></path>
                              </svg>
                            </button>
                          </div>
                          <a href="#" class="remove" style="text-decoration: underline; font-size: 12px; color: #666;">Remove</a>
                        </div>
                      </div>
                    </div>
                  </div>
                  
                  <!-- Often bought together section -->
                  <div class="cart-recommendations" style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #eee;">
                    <h4 style="font-size: 16px; font-weight: bold; margin-bottom: 20px; color: #000;">Often bought together</h4>
                    <div class="recommendations-slider" style="display: flex; gap: 15px; overflow-x: auto; padding-bottom: 10px; scrollbar-width: thin;">
                      <!-- Product 1 -->
                      <a href="<?php echo BASE_URL; ?>/products/off-stamp-classic-cube-pod-25k" class="recommendation-item" style="min-width: 150px; max-width: 150px; text-decoration: none; color: inherit; display: block; flex-shrink: 0;">
                        <div class="recommendation-item__image" style="margin-bottom: 10px; border-radius: 8px; overflow: hidden; background: #f5f5f5; aspect-ratio: 1;">
                          <img src="<?php echo BASE_URL; ?>/assets/image/geek-bar-pulse-15k-thermal-edition.webp" alt="Off-Stamp Classic Cube Pod 25K" style="width: 100%; height: 100%; object-fit: cover; display: block;">
                        </div>
                        <div class="recommendation-item__price" style="font-weight: bold; font-size: 14px; margin-bottom: 5px; color: #000;">$18.50</div>
                        <div class="recommendation-item__title" style="font-size: 12px; color: #666; line-height: 1.4;">Off-Stamp Classic Cube Pod 25K Disposable</div>
                      </a>
                      <!-- Product 2 -->
                      <a href="<?php echo BASE_URL; ?>/products/off-stamp-sw16000-pod" class="recommendation-item" style="min-width: 150px; max-width: 150px; text-decoration: none; color: inherit; display: block; flex-shrink: 0;">
                        <div class="recommendation-item__image" style="margin-bottom: 10px; border-radius: 8px; overflow: hidden; background: #f5f5f5; aspect-ratio: 1;">
                          <img src="<?php echo BASE_URL; ?>/assets/image/lost-mary-nera-fullview.webp" alt="Off-Stamp SW16000 POD" style="width: 100%; height: 100%; object-fit: cover; display: block;">
                        </div>
                        <div class="recommendation-item__price" style="font-weight: bold; font-size: 14px; margin-bottom: 5px; color: #000;">$13.75</div>
                        <div class="recommendation-item__title" style="font-size: 12px; color: #666; line-height: 1.4;">Off-Stamp SW16000 POD Disposable</div>
                      </a>
                    </div>
                    <!-- Pagination dots -->
                    <div class="recommendations-pagination" style="display: flex; justify-content: center; align-items: center; gap: 10px; margin-top: 15px;">
                      <span style="width: 8px; height: 8px; border-radius: 50%; background: #000; display: inline-block;"></span>
                      <span style="width: 8px; height: 8px; border-radius: 50%; background: #ddd; display: inline-block;"></span>
                      <span style="width: 8px; height: 8px; border-radius: 50%; background: #ddd; display: inline-block;"></span>
                      <button type="button" style="margin-left: 15px; background: none; border: none; cursor: pointer; font-size: 18px; color: #000; padding: 0 5px;">&lt;</button>
                      <button type="button" style="background: none; border: none; cursor: pointer; font-size: 18px; color: #000; padding: 0 5px;">&gt;</button>
                    </div>
                  </div>

                </div>
              </div>
            </form>
            <span aria-hidden="true" class="cart__count hidden" data-cart-count="">5</span>
            <span aria-hidden="true" class="cart__total hidden" data-cart-total="">$94.75</span>
          </cart-form>
        </div>
      </div>
    </div>

    <div class="sidebar__footer" style="position: sticky;">
      <div id="AjaxCartSubtotal">
        <div class="cart__details">
          <div class="cart__total">
            <span>Total</span>
            <strong class="text-size--heading">$94.75</strong>
          </div>
          <div class="cart__shipping text-color--opacity text-size--small">Taxes and <a
              href="#">shipping</a> calculated at checkout</div>
          <div class="flex-buttons"><a class="button button--regular button--outline" href="<?php echo BASE_URL; ?>/cart.php" id="ViewCart">View
              Cart</a><a class="button button--regular button--solid" href="<?php echo BASE_URL; ?>/checkout.php" id="CheckOut">
              Checkout
            </a></div>
        </div>
      </div>
    </div>

  </sidebar-drawer>
<script src="<?php echo BASE_URL; ?>/js/cart.js"></script>
<script src="<?php echo BASE_URL; ?>/js/checkout.js"></script>
<script src="<?php echo BASE_URL; ?>/js/login.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/inline-script-41.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/component-cart.css" media="print" onload="this.media='all'" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/css/component-sidebar.css" media="print" onload="this.media='all';" rel="stylesheet" />
  <script defer="" src="<?php echo BASE_URL; ?>/js/section-header.js"></script>
  <div class="site-overlay" style="display:none"></div>
  <link href="<?php echo BASE_URL; ?>/css/section-main-product.css" media="print" onload="this.media='all';" rel="stylesheet" />
  <script src="<?php echo BASE_URL; ?>/js/inline-script-42.js"></script>
  <link href="<?php echo BASE_URL; ?>/css/inline-style-58.css" rel="stylesheet" />
  <div class="chat-widget-block app-block" id="gorgias-chat-widget-block">
  </div>
</body>

</html>