<?php
include 'includes/db_connection.php';
include 'includes/functions.php';
include 'header.php';
?>

<style>
    html {
        scroll-behavior: smooth;
    }

    /* Tab Image Styles */
    .tab-btn {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 10px;
    }

    .tab-image-wrapper {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        overflow: hidden;
        border: 3px solid rgb(126, 126, 126);
        transition: all 0.3s ease;
        position: relative;
    }

    .tab-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        transition: transform 0.3s ease;
    }

    .tab-title {
        font-size: 12px;
        font-weight: 600;
        color:rgb(88, 88, 88);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: color 0.3s ease;
        margin-top: 5px;
    }

    .tab-btn:hover .tab-image-wrapper {
        border-color: rgba(255, 255, 255, 0.6);
        transform: scale(1.05);
    }

    .tab-btn:hover .tab-image {
        transform: scale(1.1);
    }

    .tab-btn:hover .tab-title {
        color: #333333;
    }

    .tab-btn.active .tab-image-wrapper {
        border-color: black;
        border-width: 3px;
        box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.2), 0 0 20px rgba(0, 0, 0, 0.3);
        transform: scale(1.1);
    }

    .tab-btn.active .tab-image {
        transform: scale(1);
    }

    .tab-btn.active .tab-title {
        color: #000000;
        font-weight: 600;
    }

    .customize-btn:hover {
        background-color: var(--color-accent-footer, #ffffff);
        color: var(--color-background-footer, #000000);
    }

    .tabs-nav {
        display: flex !important;
        flex-direction: row !important;
    }

    /* Image Side Styles */
    .image-side {
        width: 100%;
        height: 100%;
        min-height: 500px;
        position: relative;
        overflow: hidden;
    }

    .image-side figure {
        width: 100%;
        height: 100%;
        margin: 0;
        padding: 0;
        position: relative;
    }

    .image-side img {
        width: 100% !important;
        height: 100% !important;
        object-fit: cover !important;
        object-position: center !important;
        display: block;
        position: absolute;
        top: 0;
        left: 0;
    }

    @media screen and (max-width: 768px) {
        .custom-tabs-section {
            grid-template-columns: 1fr !important;
        }

        .tabs-content-side {
            padding: 20px 10px !important;
            min-height: 400px;
        }

        .image-side {
            min-height: 400px;
            height: 100%;
        }

        .image-side figure {
            height: 100%;
        }

        .image-side img {
            width: 100% !important;
            height: 100% !important;
            object-fit: cover !important;
            object-position: center !important;
        }

        .tabs-nav {
            flex-direction: row !important;
            gap: 15px !important;
            flex-wrap: wrap;
            justify-content: center;
        }

        .tab-image-wrapper {
            width: 60px;
            height: 60px;
        }

        .tab-title {
            font-size: 12px;
        }

        .tab-btn.active .tab-image-wrapper {
            transform: scale(1.05);
        }
    }

    @media screen and (max-width: 768px) {

        .choosing-vapes-section .col-md-4,
        .choosing-vapes-section .col-md-8 {
            flex: 0 0 100% !important;
            max-width: 100% !important;
            margin-bottom: 30px;
        }

        .vapes-display-side {
            min-height: 400px !important;
            padding: 0 !important;
        }

        .vapes-display-side img {
            min-height: 400px !important;
        }

        .vapes-content-side {
            padding: 20px 0px !important;
            min-height: auto !important;
        }
    }

    .vapes-display-side {
        overflow: hidden !important;
    }

    .vapes-display-side img {
        transition: transform 0.5s ease, opacity 0.5s ease;
        transform: scale(1);
    }

    .vapes-display-side:hover img {
        transform: scale(1.1);
    }

    @media screen and (max-width: 767px) {
        #main-cards-section .grid[style*="grid-template-columns: repeat(5"] {
            grid-template-columns: repeat(2, 1fr) !important;
        }

        #main-cards-section .grid--layout-flex {
            grid-template-columns: 1fr !important;
            gap: 15px !important;
        }

        #main-cards-section .grid--layout-flex .block-flex-item {
            grid-column: span 1 !important;
            width: 100% !important;
            display: block !important;
            visibility: visible !important;
        }

        #main-cards-section .grid--layout-flex .block-flex-item .card__image {
            min-height: 250px !important;
            height: 250px !important;
            display: block !important;
        }

        #main-cards-section .grid--layout-flex .block-flex-item .card__image figure {
            height: 100% !important;
            display: block !important;
        }

        #main-cards-section .grid--layout-flex .block-flex-item .card__image img {
            width: 100% !important;
            height: 100% !important;
            object-fit: cover !important;
            display: block !important;
        }
    }

    @media screen and (min-width: 768px) and (max-width: 1024px) {
        #main-cards-section .grid[style*="grid-template-columns: repeat(5"] {
            grid-template-columns: repeat(3, 1fr) !important;
        }
    }

    .read-more-button:hover {
        background-color: #ffffff !important;
        color: #000000 !important;
    }

    @media screen and (max-width: 768px) {
        .about-vapes-section {
            background-attachment: scroll !important;
            min-height: 500px;
        }

        #main-about-vapes-section>div {
            padding: 60px 20px !important;
        }
    }

    /* CTA Button Hover Effect */
    .cta-shop-button:hover {
        background-color: var(--color-background-footer, #000000) !important;
        color: var(--color-accent-footer, #ffffff) !important;
        border: 1px solid var(--color-accent-footer, #ffffff);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(255, 255, 255, 0.2);
    }

    @media screen and (max-width: 768px) {
        .cta-section {
            padding: 60px 0 !important;
        }

        .cta-section>.container--large>div {
            flex-direction: column !important;
            gap: 0 !important;
            justify-content: center !important;
            align-items: center !important;
        }

        .cta-section .cta-content-side {
            flex: 0 0 100% !important;
            min-width: 100% !important;
            text-align: center !important;
            padding: 0 !important;
        }

        .cta-section .cta-content-side h2 {
            text-align: center !important;
            font-size: 32px !important;
        }

        .cta-section .cta-content-side p {
            text-align: center !important;
        }
    }

    .testimonials-slider::-webkit-scrollbar {
        display: none;
    }

    .testimonial-nav-btn:hover {
        background-color: #000 !important;
        transform: scale(1.1);
    }

    .testimonial-nav-btn:active {
        transform: scale(0.95);
    }

    .testimonial-nav-btn:disabled {
        opacity: 0.5 !important;
        cursor: not-allowed !important;
    }

    @media screen and (max-width: 1024px) {
        .testimonial-card {
            flex: 0 0 calc(33.333% - 14px) !important;
            min-width: 260px !important;
        }
    }

    @media screen and (max-width: 768px) {
        .testimonial-card {
            flex: 0 0 calc(50% - 10px) !important;
            min-width: 240px !important;
        }

        .testimonials-section-custom {
            padding: 60px 0 !important;
        }

        .testimonials-section-custom h2 {
            font-size: 28px !important;
        }
    }

    @media screen and (max-width: 480px) {
        .testimonial-card {
            flex: 0 0 100% !important;
            min-width: 100% !important;
        }
    }

    :root {
        --accent: #ff6b35;
        --closed: 5rem;
        --open: 60rem;
        --gap: 1.5rem;
        --speed: 0.4s;
    }

    section {
        /* background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%); */
        padding: 40px 0 0px;
        margin-top: 50px;
    }

    .head {
        visibility: hidden;
        position: absolute;
        opacity: 0;
        pointer-events: none;
        height: 0;
        padding: 0;
        margin: 0;
    }

    .head h2 {
        font: 400 1.5rem/1.2 Inter, sans-serif;
        color: #fff;
    }

    @media (min-width: 1024px) {
        .head h2 {
            font-size: 2.25rem;
        }
    }

    .nav-btn {
        width: 2.5rem;
        height: 2.5rem;
        border: none;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.12);
        color: #fff;
        font-size: 1.5rem;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: 0.3s;
    }

    .nav-btn:hover {
        background: var(--accent);
    }

    .nav-btn:disabled {
        opacity: 0.3;
        cursor: default;
    }

    .slider {
        max-width: 1400px;
        margin: auto;
        overflow: hidden;
    }

    .controls {
        display: flex;
        flex-direction: row;
        gap: 0.5rem;
    }

    .track {
        display: flex;
        gap: var(--gap);
        align-items: flex-start;
        justify-content: center;
        scroll-behavior: smooth;
        scroll-snap-type: x mandatory;
        /* padding-bottom: 40px; */
    }

    .track::-webkit-scrollbar {
        display: none;
    }

    .project-card {
        position: relative;
        flex: 0 0 var(--closed);
        height: 25rem;
        border-radius: 1rem;
        overflow: hidden;
        cursor: pointer;
        transition: flex-basis var(--speed), transform var(--speed);
    }

    .project-card[active] {
        flex-basis: var(--open);
        box-shadow: -1px 8px 20px rgba(0, 0, 0, 0.45);
    }

    .project-card__bg {
        position: absolute;
        inset: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
        filter: brightness(0.75) saturate(75%);
        transition: filter 0.3s, transform var(--speed);
    }

    .project-card[active] .project-card__bg {
        filter: brightness(1) saturate(100%);
        z-index: 1;
    }

    .project-card:hover .project-card__bg {
        filter: brightness(0.9) saturate(100%);
        transform: scale(1.06);
    }

    .project-card[active]:hover .project-card__bg {
        transform: none;
    }

    .project-card__content {
        position: absolute;
        inset: 0;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        gap: 0.7rem;
        padding: 0;
        background: linear-gradient(transparent 40%, rgba(0, 0, 0, 0.85) 100%);
        z-index: 2;
    }

    .project-card__title {
        color: #fff;
        font-weight: 700;
        font-size: 1.35rem;
        writing-mode: vertical-rl;
        transform: rotate(180deg);
    }

    .project-card__thumb,
    .project-card__desc,
    .project-card__btn {
        display: none;
    }

    .project-card[active] .project-card__content {
        flex-direction: column;
        /* align-items: flex-start;
        justify-content: flex-end; */
        padding: 2rem;
        gap: 1rem;
        background: #0009;
    }

    .project-card[active] .project-card__title {
        writing-mode: horizontal-tb;
        transform: none;
        font-size: 2.4rem;
        width: 100%;
    }

    .project-card[active] .project-card__thumb {
        display: none;
    }

    .project-card[active] .project-card__desc,
    .project-card[active] .project-card__btn {
        display: block;
    }

    .project-card__thumb {
        width: 133px;
        height: 269px;
        border-radius: 0.45rem;
        object-fit: cover;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.4);
    }

    .project-card__desc {
        color: #ddd;
        font-size: 1rem;
        line-height: 1.4;
        max-width: 100%;
        width: 100%;
    }

    .project-card__btn {
        display: none;
    }

    .project-card__btn:hover {
        background: rgba(0, 0, 0, 0.85);
        opacity: 0.95;
    }

    .dots {
        display: flex;
        gap: 0.5rem;
        justify-content: center;
        padding: 20px 0;
    }

    .dot {
        width: 13px;
        height: 13px;
        border-radius: 50%;
        background: rgba(82, 82, 82, 0.73);
        cursor: pointer;
        transition: 0.3s;
    }

    .dot.active {
        background: black;
        transform: scale(1.2);
    }

    @media (max-width: 1023px) {
        :root {
            --closed: 4rem;
            --open: 22rem;
        }

        .head {
            padding: 50px 20px 30px;
        }

        .track {
            flex-direction: column;
            scroll-snap-type: y mandatory;
            align-items: center;
            justify-content: flex-start;
            padding-bottom: 0;
        }

        .project-card {
            height: 20rem;
        }

        .project-card__title {
            font-size: 1.1rem;
            writing-mode: horizontal-tb;
            transform: none;
            text-align: center;
            padding-inline: 0.3rem;
        }

        .nav-btn {
            width: 2rem;
            height: 2rem;
            font-size: 1.2rem;
        }
    }

    @media (min-width: 1024px) and (max-width: 1280px) {
        :root {
            --open: 45rem;
            --closed: 4.5rem;
        }

        .slider {
            max-width: 100%;
            padding: 0 20px;
        }

        .project-card[active] .project-card__title {
            font-size: 2rem;
        }

        .project-card[active] .project-card__content {
            padding: 1.5rem;
        }
    }

    @media (max-width: 1023px) {
        :root {
            --closed: 100%;
            --open: 100%;
            --gap: 0.8rem;
        }

        .head {
            padding: 30px 15px 20px;
            flex-direction: column;
            align-items: flex-start;
            gap: 1rem;
        }

        .slider {
            padding: 0 15px;
        }

        .track {
            flex-direction: column;
            scroll-snap-type: y mandatory;
            gap: 0.8rem;
            padding-bottom: 20px;
        }

        .project-card {
            height: auto;
            min-height: 80px;
            flex: 0 0 auto;
            width: 100%;
            scroll-snap-align: start;
        }

        .project-card[active] {
            min-height: 300px;
            transform: none;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        }

        .project-card__content {
            flex-direction: row;
            justify-content: flex-start;
            padding: 1rem;
            align-items: center;
            gap: 1rem;
        }

        .project-card__title {
            writing-mode: horizontal-tb;
            transform: none;
            font-size: 1.2rem;
            margin-right: auto;
        }

        .project-card__thumb,
        .project-card__desc,
        .project-card__btn {
            display: none;
        }

        .project-card[active] .project-card__content {
            align-items: flex-start;
            justify-content: flex-end;
            padding: 1.5rem;
            flex-direction: column;
        }

        .project-card[active] .project-card__title {
            font-size: 1.8rem;
            margin-bottom: 1rem;
            margin-top: 0;
            width: 100%;
        }

        .project-card[active] .project-card__thumb {
            display: none;
        }

        .project-card[active] .project-card__desc {
            font-size: 0.95rem;
            max-width: 100%;
            width: 100%;
            margin-bottom: 1rem;
        }

        .project-card[active] .project-card__btn {
            align-self: center;
            width: 100%;
            text-align: center;
            padding: 0.7rem;
        }

        .dots {
            display: none;
        }

        .controls {
            width: 100%;
            justify-content: space-between;
            padding: 0 15px 20px;
        }

        .nav-btn {
            position: static;
            transform: none;
        }
    }

    /* Fade Up Animation Styles */
    .fade-up-element {
        opacity: 0;
        transform: translateY(50px);
        transition: opacity 0.8s ease-out, transform 0.8s ease-out;
    }

    .fade-up-element.fade-up-visible {
        opacity: 1;
        transform: translateY(0);
    }

    /* Staggered animation delay for multiple elements */
    .fade-up-element.fade-up-delay-1 {
        transition-delay: 0.1s;
    }

    .fade-up-element.fade-up-delay-2 {
        transition-delay: 0.2s;
    }

    .fade-up-element.fade-up-delay-3 {
        transition-delay: 0.3s;
    }

    .fade-up-element.fade-up-delay-4 {
        transition-delay: 0.4s;
    }

    .fade-up-element.fade-up-delay-5 {
        transition-delay: 0.5s;
    }

    /* Disable animation on mobile for better performance (optional) */
    @media (max-width: 768px) {
        .fade-up-element {
            transition-duration: 0.6s;
        }
    }

    /* Reduce motion for users who prefer it */
    @media (prefers-reduced-motion: reduce) {
        .fade-up-element {
            opacity: 1;
            transform: none;
            transition: none;
        }
    }

    /* Cards Section Hover Zoom Effect */
    #main-cards-section .card {
        overflow: hidden;
        transition: transform 0.3s ease;
    }

    #main-cards-section .card:hover {
        transform: translateY(-5px);
    }

    #main-cards-section .card__image {
        overflow: hidden;
    }

    #main-cards-section .card__image img,
    #main-cards-section .card__image figure img {
        transition: transform 0.5s ease;
        transform: scale(1);
        will-change: transform;
    }

    #main-cards-section .card:hover .card__image img,
    #main-cards-section .card:hover .card__image figure img {
        transform: scale(1.1);
    }

    /* For cards with lazy-image background */
    #main-cards-section .card:hover .lazy-image--background img {
        transform: scale(1.1);
    }

    /* For nested images in figure */
    #main-cards-section .card:hover figure img {
        transform: scale(1.1);
    }

    /* Blog Items Section Hover Zoom Effect */
    #main-testimonials-section .blog-item {
        overflow: hidden;
        transition: transform 0.3s ease;
    }

    #main-testimonials-section .blog-item:hover {
        transform: translateY(-5px);
    }

    #main-testimonials-section .blog-item__image {
        overflow: hidden;
    }

    #main-testimonials-section .blog-item__image figure,
    #main-testimonials-section .blog-item__image .lazy-image {
        overflow: hidden;
    }

    #main-testimonials-section .blog-item__image img,
    #main-testimonials-section .blog-item__image figure img,
    #main-testimonials-section .blog-item__image .lazy-image img {
        transition: transform 0.5s ease;
        transform: scale(1);
        will-change: transform;
    }

    #main-testimonials-section .blog-item:hover .blog-item__image img,
    #main-testimonials-section .blog-item:hover .blog-item__image figure img,
    #main-testimonials-section .blog-item:hover .blog-item__image .lazy-image img {
        transform: scale(1.1);
    }

    /* Product Items - Hover Image Zoom Effect */
    .product-item.card .card__image {
        overflow: hidden;
        position: relative;
    }

    .product-item.card .card__image figure,
    .product-item.card .card__image .lazy-image {
        overflow: hidden;
        width: 100%;
        height: 100%;
    }

    .product-item.card .card__image img,
    .product-item.card .card__image figure img,
    .product-item.card .card__image .lazy-image img {
        transition: transform 0.5s ease;
        transform: scale(1);
        will-change: transform;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .product-item.card:hover .card__image img,
    .product-item.card:hover .card__image figure img,
    .product-item.card:hover .card__image .lazy-image img {
        transform: scale(1.1);
    }

    /* Bottom Row Cards - Hover Black Overlay (Only for bottom row, not top row) */
    /* Exclude top row cards with block-flex-item class */
    #main-cards-section .grid.grid--layout:not(:has(.block-flex-item)) .card,
    #main-cards-section .grid.grid--layout .card:not(.block-flex-item) {
        position: relative;
    }

    #main-cards-section .grid.grid--layout:not(:has(.block-flex-item)) .card::after,
    #main-cards-section .grid.grid--layout .card:not(.block-flex-item)::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 0;
        background: linear-gradient(to top, rgba(0, 0, 0, 0.95), rgba(0, 0, 0, 0.7), transparent);
        transition: height 0.3s ease;
        z-index: 5;
        pointer-events: none;
    }

    #main-cards-section .grid.grid--layout:not(:has(.block-flex-item)) .card:hover::after,
    #main-cards-section .grid.grid--layout .card:not(.block-flex-item):hover::after {
        height: 50%;
    }

    /* Enhance existing bottom overlay on hover (only bottom row) */
    #main-cards-section .grid.grid--layout:not(:has(.block-flex-item)) .card:hover .card__image>div,
    #main-cards-section .grid.grid--layout .card:not(.block-flex-item):hover .card__image>div {
        background: linear-gradient(to top, rgba(0, 0, 0, 0.95), rgba(0, 0, 0, 0.7), transparent) !important;
        transition: background 0.3s ease;
    }

    /* Ensure top row cards don't have overlay */
    #main-cards-section .block-flex-item.card::after {
        display: none !important;
    }

    #main-cards-section .block-flex-item.card:hover .card__image>div {
        background: inherit !important;
    }

    /* Professional Carousel Styles */
    .hero-carousel-section {
        position: relative;
        width: 100%;
        overflow: hidden;
        height: 85vh;
        margin-bottom: 0;
    }

    .hero-carousel-container {
        width: 100%;
        height: 100%;
        position: relative;
    }

    .hero-carousel-wrapper {
        position: relative;
        width: 100%;
        height: 100%;
        overflow: hidden;
    }

    .hero-carousel-track {
        display: flex;
        height: 100%;
        transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
        will-change: transform;
        width: 100%;
    }

    .hero-carousel-slide {
        min-width: 100%;
        width: 100%;
        height: 100%;
        position: relative;
        flex-shrink: 0;
        opacity: 0;
        transition: opacity 0.6s ease;
    }

    .hero-carousel-slide.active {
        opacity: 1;
    }

    .hero-carousel-image {
        position: relative;
        width: 100%;
        height: 100%;
        overflow: hidden;
    }

    .hero-carousel-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        object-position: center;
        transition: transform 0.8s ease;
    }

    .hero-carousel-slide.active .hero-carousel-image img {
        transform: scale(1.05);
    }

    .hero-carousel-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(to bottom,
                rgba(0, 0, 0, 0.3) 0%,
                rgba(0, 0, 0, 0.5) 100%);
        z-index: 1;
    }

    .hero-carousel-content {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: flex-start;
        z-index: 2;
        padding: 40px 20px;
    }

    .hero-carousel-text {
        max-width: 600px;
        color: #ffffff;
        animation: fadeInUp 0.8s ease 0.3s both;
    }

    .hero-carousel-caption {
        display: block;
        font-size: 18px;
        font-weight: 500;
        margin-bottom: 15px;
        opacity: 0.9;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .hero-carousel-title {
        font-size: 48px;
        font-weight: 700;
        line-height: 1.2;
        margin-bottom: 30px;
        text-transform: uppercase;
        letter-spacing: 2px;
    }

    .hero-carousel-buttons {
        display: flex;
        gap: 20px;
        flex-wrap: wrap;
        align-items: center;
        justify-content: flex-start;
    }

    /* Navigation Buttons */
    .hero-carousel-nav {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: rgba(255, 255, 255, 0.2);
        border: 2px solid rgba(255, 255, 255, 0.3);
        color: #ffffff;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        z-index: 3;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
    }

    .hero-carousel-nav:hover {
        background: rgba(255, 255, 255, 0.3);
        border-color: rgba(255, 255, 255, 0.5);
        transform: translateY(-50%) scale(1.1);
    }

    .hero-carousel-nav:active {
        transform: translateY(-50%) scale(0.95);
    }

    .hero-carousel-prev {
        left: 20px;
    }

    .hero-carousel-next {
        right: 20px;
    }

    .hero-carousel-nav svg {
        width: 20px;
        height: 20px;
    }

    /* Dots Indicator */
    .hero-carousel-dots {
        position: absolute;
        bottom: 30px;
        left: 50%;
        transform: translateX(-50%);
        display: flex;
        gap: 12px;
        z-index: 3;
    }

    .hero-carousel-dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.4);
        border: 2px solid rgba(255, 255, 255, 0.6);
        cursor: pointer;
        transition: all 0.3s ease;
        padding: 0;
    }

    .hero-carousel-dot:hover {
        background: rgba(255, 255, 255, 0.6);
        transform: scale(1.2);
    }

    .hero-carousel-dot.active {
        background: #ffffff;
        border-color: #ffffff;
        width: 32px;
        border-radius: 6px;
    }

    /* Animations */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .hero-carousel-section {
            height: 450px;
        }

        .hero-carousel-title {
            font-size: 32px;
        }

        .hero-carousel-caption {
            font-size: 14px;
        }

        .hero-carousel-nav {
            width: 30px;
            height: 30px;
        }

        .hero-carousel-prev {
            left: 10px;
        }

        .hero-carousel-next {
            right: 10px;
        }

        .hero-carousel-dots {
            bottom: 20px;
        }

        .hero-carousel-buttons {
            display: flex;
            flex-direction: row;
            gap: 15px;
            width: 100%;
            align-items: center;
            justify-content: flex-start;
            flex-wrap: wrap;
        }

        .hero-carousel-buttons .button {
            flex: 1 1 auto;
            min-width: 140px;
            text-align: center;
        }
    }

    @media (max-width: 480px) {
        .hero-carousel-section {
            height: 350px;
        }

        .hero-carousel-title {
            font-size: 24px;
        }

        .hero-carousel-text {
            max-width: 100%;
        }

        .hero-carousel-content {
            padding: 20px 15px;
        }

        .hero-carousel-buttons {
            display: flex;
            flex-direction: row;
            gap: 10px;
            width: 100%;
            align-items: center;
            justify-content: flex-start;
            flex-wrap: wrap;
        }

        .hero-carousel-buttons .button {
            flex: 1 1 auto;
            min-width: 120px;
            text-align: center;
            font-size: 14px;
            padding: 12px 20px;
        }
    }

    /* Reduced Motion */
    @media (prefers-reduced-motion: reduce) {

        .hero-carousel-track,
        .hero-carousel-slide,
        .hero-carousel-image img,
        .hero-carousel-text {
            transition: none;
            animation: none;
        }
    }

    /* Professional Button Animations */
    .button {
        position: relative;
        overflow: hidden;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        transform: translateY(0);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        border: none;
        z-index: 1;
        will-change: transform, box-shadow;
    }

    /* Subtle Shine Effect */
    .button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg,
                transparent,
                rgba(255, 255, 255, 0.2),
                transparent);
        transition: left 0.5s ease;
        z-index: 1;
    }

    /* Professional Hover State */
    .button:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
    }

    .button:hover::before {
        left: 100%;
    }

    .button:active {
        transform: translateY(0);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.1s ease, box-shadow 0.1s ease;
    }

    /* Solid Button - Professional Black & White */
    .button--solid {
        background: #000000;
        color: #ffffff;
        transition: background-color 0.3s cubic-bezier(0.4, 0, 0.2, 1),
            color 0.3s cubic-bezier(0.4, 0, 0.2, 1),
            transform 0.3s cubic-bezier(0.4, 0, 0.2, 1),
            box-shadow 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        border: 2px solid #000000;
    }

    .button--solid:hover {
        background: #ffffff;
        color: #000000;
        border-color: #ffffff;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
    }

    /* Outline Button - Professional Style */
    .button--outline {
        border: 2px solid #ffffff;
        background: transparent;
        color: #ffffff;
        transition: background-color 0.3s cubic-bezier(0.4, 0, 0.2, 1),
            border-color 0.3s cubic-bezier(0.4, 0, 0.2, 1),
            transform 0.3s cubic-bezier(0.4, 0, 0.2, 1),
            box-shadow 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
    }

    .button--outline::before {
        background: rgba(255, 255, 255, 0.1);
    }

    .button--outline:hover {
        background: #000000;
        color: #ffffff;
        border-color: #000000;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
    }

    /* Button Text - Smooth Transition */
    .button span,
    .button {
        position: relative;
        z-index: 2;
        transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        display: inline-block;
    }

    .button:hover span {
        transform: translateX(2px);
    }

    /* Focus State for Accessibility */
    .button:focus {
        outline: 2px solid rgba(255, 255, 255, 0.5);
        outline-offset: 2px;
    }

    .button:focus:not(:focus-visible) {
        outline: none;
    }

    /* Smooth Loading State */
    .button.loading {
        pointer-events: none;
        opacity: 0.7;
    }

    .button.loading::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 16px;
        height: 16px;
        margin: -8px 0 0 -8px;
        border: 2px solid currentColor;
        border-top-color: transparent;
        border-radius: 50%;
        animation: buttonSpin 0.6s linear infinite;
        z-index: 3;
    }

    @keyframes buttonSpin {
        to {
            transform: rotate(360deg);
        }
    }

    /* Disabled State */
    .button:disabled,
    .button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
        pointer-events: none;
    }

    /* Mobile Optimization */
    @media (max-width: 768px) {
        .button:hover {
            transform: translateY(-1px);
        }

        .button:active {
            transform: translateY(0);
        }
    }

    /* Reduced Motion Support */
    @media (prefers-reduced-motion: reduce) {

        .button,
        .button::before,
        .button span {
            transition: none;
            animation: none;
        }

        .button:hover {
            transform: none;
        }
    }
</style>

<main class="main-content main-content--align-product-items" id="main">

    <!-- Professional Carousel Section -->
    <div class="hero-carousel-section fade-up-element" id="main-hero-carousel">
        <div class="hero-carousel-container">
            <div class="hero-carousel-wrapper">
                <div class="hero-carousel-track" id="heroCarouselTrack">
                    <!-- Slide 1 -->
                    <div class="hero-carousel-slide active" data-slide="0">
                        <div class="hero-carousel-image">
                            <img src="assets\image\lost-mary-nera-fullview.webp" alt="Lost Mary Nera Fullview 70K">
                            <div class="hero-carousel-overlay"></div>
                        </div>
                        <div class="hero-carousel-content">
                            <div class="container--large">
                                <div class="hero-carousel-text">
                                    <span class="hero-carousel-caption">Double the Puffs, Keep it Fresh!</span>
                                    <h1 class="hero-carousel-title">LOST MARY NERA FULLVIEW 70K</h1>
                                    <div class="hero-carousel-buttons">
                                        <a href="#" class="button button--regular button--solid">BUY THE KIT</a>
                                        <a href="#" class="button button--regular button--outline">POD REFILLS</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Slide 2 -->
                    <div class="hero-carousel-slide" data-slide="1">
                        <div class="hero-carousel-image">
                            <img src="assets\image\luffbar-doris-30k-banner.webp" alt="Luffbar Doris 30K">
                            <div class="hero-carousel-overlay"></div>
                        </div>
                        <div class="hero-carousel-content">
                            <div class="container--large">
                                <div class="hero-carousel-text">
                                    <span class="hero-carousel-caption">30K Puffs of Pure Satisfaction</span>
                                    <h1 class="hero-carousel-title">LUFFBAR DORIS 30K</h1>
                                    <div class="hero-carousel-buttons">
                                        <a href="#" class="button button--regular button--solid">SHOP NOW</a>
                                        <a href="#" class="button button--regular button--outline">VIEW DETAILS</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Slide 3 -->
                    <div class="hero-carousel-slide" data-slide="2">
                        <div class="hero-carousel-image">
                            <img src="assets\image\cookies-30k-nic-disposable-vapes.webp"
                                alt="Cookies 30K Disposable Vapes">
                            <div class="hero-carousel-overlay"></div>
                        </div>
                        <div class="hero-carousel-content">
                            <div class="container--large">
                                <div class="hero-carousel-text">
                                    <span class="hero-carousel-caption">Rich Flavors, Long-Lasting Puffs</span>
                                    <h1 class="hero-carousel-title">COOKIES 30K DISPOSABLE VAPES</h1>
                                    <div class="hero-carousel-buttons">
                                        <a href="#" class="button button--regular button--solid">EXPLORE</a>
                                        <a href="#" class="button button--regular button--outline">LEARN MORE</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Navigation Buttons -->
                <button class="hero-carousel-nav hero-carousel-prev" id="heroCarouselPrev" aria-label="Previous slide">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </button>
                <button class="hero-carousel-nav hero-carousel-next" id="heroCarouselNext" aria-label="Next slide">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </button>

                <!-- Dots Indicator -->
                <div class="hero-carousel-dots" id="heroCarouselDots">
                    <button class="hero-carousel-dot active" data-slide="0" aria-label="Go to slide 1"></button>
                    <button class="hero-carousel-dot" data-slide="1" aria-label="Go to slide 2"></button>
                    <button class="hero-carousel-dot" data-slide="2" aria-label="Go to slide 3"></button>
                </div>
            </div>
        </div>
    </div>

    <!-- Cards Section -->
    <div class="cards-section fade-up-element" id="main-cards-section" style="padding: 40px 0;">
        <div class="container--large remove-empty-space container--vertical-space"
            id="section-template--17807768223795__flex_cards_KPAqTd">
            <!-- Top Row: 2 Large Cards -->
            <div class="grid grid--layout grid--layout-flex mobile-autoheight" style="margin-bottom: 20px; gap: 20px;">

                <div class="block-flex-item card"  id="element-AK2FHZWZLK2FmYUpWc__card_XLmdtJ" style="
                    --column-desktop: 6;
                    --image-height-desktop: 400px;
                    --image-height-mobile: 250px;
  ">
                    <div class="card__image border-radius-top" style="position: relative; overflow: hidden; border-radius: 8px;">
                        <figure class="lazy-image lazy-image--background" data-crop="true" data-ratio="1.5"
                            style="padding-top: 66.66666666666667%">
                            <img src="assets\image\clearance-sale-banner.webp" alt=""
                                style="object-fit: cover; width: 100%; height: 100%;">
                        </figure>
                    </div>
                </div>

                <div class="block-flex-item card" id="element-AQkJjdUJzYm1kUVZJb__card_q84wa7" style="
                    --column-desktop: 6;
                    --image-height-desktop: 400px;
                    --image-height-mobile: 250px;
  ">
                    <div class="card__image border-radius-top" style="position: relative; overflow: hidden; border-radius: 8px;">
                        <figure class="lazy-image lazy-image--background" data-crop="true" data-ratio="1.5"
                            style="padding-top: 66.66666666666667%">
                            <img src="assets\image\luffbar-doris-30k-banner.webp" alt=""
                                style="object-fit: cover; width: 100%; height: 100%;">
                        </figure>
                    </div>
                </div>
            </div>

            <!-- Bottom Row: 5 Smaller Cards -->
            <div class="grid grid--layout"
                style="display: grid; grid-template-columns: repeat(5, 1fr); gap: 15px; grid-auto-rows: 1fr;">
                <?php
                $collections = get_collections($pdo, 5);
                if ($collections) {
                    foreach ($collections as $collection) {
                        $collection_name = htmlspecialchars($collection['name']);
                        $collection_image = !empty($collection['image']) ? 'assets/image/' . htmlspecialchars($collection['image']) : 'assets/image/placeholder.png';
                        // Check if image path already contains assets/image
                        if (strpos($collection['image'], 'assets/image/') === 0) {
                             $collection_image = htmlspecialchars($collection['image']);
                        }
                        $collection_url = BASE_URL . '/collection-detail.php?slug=' . htmlspecialchars($collection['slug']);
                ?>
                <div class="card" style="position: relative; overflow: hidden; border-radius: 8px; aspect-ratio: 1;">
                    <a href="<?php echo $collection_url; ?>" style="display: block; width: 100%; height: 100%; position: relative;">
                        <div class="card__image" style="width: 100%; height: 100%; position: relative;">
                            <figure class="lazy-image"
                                style="width: 100%; height: 100%; margin: 0; position: relative;">
                                <img src="<?php echo $collection_image; ?>"
                                    alt="<?php echo $collection_name; ?>" style="width: 100%; height: 100%; object-fit: cover; display: block;">
                            </figure>
                            <div
                                style="position: absolute; bottom: 0; left: 0; right: 0; background: linear-gradient(to top, rgba(0,0,0,0.8), rgba(0,0,0,0.4), transparent); padding: 20px; color: white; z-index: 10; pointer-events: none;">
                                <span
                                    style="font-size: 18px; font-weight: 700; display: block; text-shadow: 1px 1px 2px rgba(0,0,0,0.5);">
                                    <?php echo $collection_name; ?>
                                </span>
                            </div>
                        </div>
                    </a>
                </div>
                <?php
                    }
                } else {
                    // Fallback or Empty State if no collections found
                     echo '<p style="grid-column: 1 / -1; text-align: center;">No collections found.</p>';
                }
                ?>
            </div>
        </div>
    </div>

    <!-- Reviews & Rating Section -->
    <div class="reviews-rating-section fade-up-element fade-up-delay-1"
        style="padding: 20px 20px; margin: 20px 0px -40px; background-color: #ffffff; text-align: center;">
        <div class="container--large" style="max-width: 800px; margin: 0 auto;">
            <!-- Star Rating -->
            <div>
                <div style="display: inline-flex; gap: 4px;">
                    <span style="color: #FFD700; font-size: 32px;">★</span>
                    <span style="color: #FFD700; font-size: 32px;">★</span>
                    <span style="color: #FFD700; font-size: 32px;">★</span>
                    <span style="color: #FFD700; font-size: 32px;">★</span>
                    <span style="color: #FFD700; font-size: 32px;">★</span>
                </div>
            </div>

            <!-- Reviews Count & Rating -->
            <div style="margin-bottom: 15px;">
                <p style="font-size: 18px; font-weight: 600; color: #333333; margin: 0; line-height: 1.5;">
                    3450+ REVIEWS & 4.9 RATING
                </p>
            </div>

            <!-- Description -->
            <div style="margin-bottom: 15px;">
                <p
                    style="font-size: 16px; color: #666666; margin: 0; line-height: 1.6; max-width: 600px; margin-left: auto; margin-right: auto;">
                    Highest-quality leather outerwear and goods, crafted from the best-in-class raw materials, without
                    excessive mark-ups.
                </p>
            </div>

            <!-- Button -->
            <div style="text-align: center;">
                <a class="button button--regular button--solid" href="#main-reviews-app-section"
                    style="display: inline-block; text-decoration: none;">
                    Why & How We Did It?
                </a>
            </div>
        </div>
    </div>

    <!-- Just Dropped – New Arrivals -->
    <div class="featured-collection-section mount-css-slider mount-collection-tabs fade-up-element fade-up-delay-2"
        id="main-featured-collection">
        <link href="#" media="all" rel="stylesheet" type="text/css" />
        <div class="container--large remove-empty-space container--vertical-space"
            id="section-template--17807768223795__featured-collection">
            <collection-tabs>
                <div class="section-heading section-heading--center gutter-bottom--page" style="text-align: center;">
                    <div class="section-heading__text remove-empty-space">
                        <h2 class="section-heading__title h4">Just Dropped – New Arrivals</h2>
                    </div>
                </div>
                <div id="product-grid-template--17807768223795__featured-collection">
                    <div class="collection-tabs_panel active active"
                        id="collection-template--17807768223795__featured-collection-0">
                        <div
                            class="grid grid--layout grid-5 grid-laptop-4 grid-portable-3 grid-lap-2 grid-tiny-1 grid-palm-2">
                            <?php
                            $new_arrivals = get_products_by_collection_slug($pdo, 'new-arrivals', 10);
                            if ($new_arrivals) {
                                foreach ($new_arrivals as $product) {
                                    // Use 'title' correctly as per database schema
                                    $product_name = htmlspecialchars($product['title']);
                                    
                                    // Handle image path - check if it already has assets/image prefix or is a URL
                                    $image_path = $product['image'] ?? 'placeholder.png'; // Fallback if no image found
                                    
                                    if ($image_path !== 'placeholder.png' && strpos($image_path, 'assets/image/') === false && strpos($image_path, 'http') === false) {
                                        $image_path = 'assets/image/' . $image_path;
                                    }
                                    $image_path = htmlspecialchars($image_path);
                                    
                                    $product_url = BASE_URL . '/products/' . htmlspecialchars($product['slug']);
                                    $price = number_format($product['price'], 2);
                            ?>
                            <div class="product-item card" data-js-product-item="" id="product-item-<?php echo $product['id']; ?>">
                                <a class="card__image product-item__image" href="<?php echo $product_url; ?>" style="padding-top:100%">
                                    <figure class="lazy-image product-item__image-figure product-item__image-figure--primary lazy-image--animation lazy-image--background lazy-image--fit" data-crop="true">
                                        <img src="<?php echo $image_path; ?>" alt="<?php echo $product_name; ?>" style="object-fit: cover; width: 100%; height: 100%;">
                                    </figure>
                                </a>
                                <div class="card__text product-item__text gutter--regular spacing--xlarge remove-empty-space text-align--left">
                                    <a class="product-item__title" href="<?php echo $product_url; ?>" title="<?php echo $product_name; ?>">
                                        <div class="remove-line-height-space--small">
                                            <span class="text-animation--underline text-line-height--small"><?php echo $product_name; ?></span>
                                        </div>
                                    </a>
                                    <div class="product-item__price text-size--large equalize-white-space">
                                        <div class="remove-line-height-space">
                                            <div class="product-price">
                                                <span class="product-price--original">
                                                    <span class="visually-hidden">Regular price</span>
                                                    $<?php echo $price; ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="product-item__badges text-size--xsmall">
                                    <span class="product-item__badge product-item__badge--new" style="background-color: #3C863B; color: #ffffff">New</span>
                                </div>
                            </div>
                            <?php
                                }
                            } else {
                                echo '<p style="grid-column: 1 / -1; text-align: center;">No new arrivals found.</p>';
                            }
                            ?>
                        </div>
                        <div style="text-align: center; margin-top: 40px; padding-top: 30px;">
                            <a class="button button--regular button--solid"
                                href="<?php echo BASE_URL; ?>/collections/new-arrivals"
                                style="display: inline-block; text-decoration: none;">
                                View All Products
                            </a>
                        </div>
                    </div>
                </div>
            </collection-tabs>
        </div>
        <link href="css/inline-style-24.css" rel="stylesheet" />
    </div>

    <section class="fade-up-element fade-up-delay-3">
        <div class="head">
            <div class="controls">
                <button id="prev" class="nav-btn" aria-label="Prev">‹</button>
                <button id="next" class="nav-btn" aria-label="Next">›</button>
            </div>
        </div>

        <div class="slider">
            <div class="track" id="track">
                <?php
                $featured_collections = get_featured_collections($pdo, 10);
                if ($featured_collections) {
                    $first = true;
                    foreach ($featured_collections as $collection) {
                        $collection_name = htmlspecialchars($collection['name']);
                        $collection_desc = htmlspecialchars($collection['description'] ?? '');
                        
                        // Handle image
                        $image_path = $collection['image'] ?? 'placeholder_collection.png';
                        if ($image_path !== 'placeholder_collection.png' && strpos($image_path, 'assets/image/') === false && strpos($image_path, 'http') === false) {
                             $image_path = 'assets/image/' . $image_path;
                        }
                        $image_path = htmlspecialchars($image_path);
                        
                        $active_class = $first ? 'active' : '';
                        $first = false;
                ?>
                <article class="project-card" <?php echo $active_class; ?>>
                    <img class="project-card__bg" src="<?php echo $image_path; ?>" alt="<?php echo $collection_name; ?>">
                    <div class="project-card__content">
                        <div>
                            <h3 class="project-card__title"><?php echo $collection_name; ?></h3>
                            <p class="project-card__desc"><?php echo $collection_desc; ?></p>
                        </div>
                    </div>
                </article>
                <?php
                    }
                } else {
                    // Fallback or empty state if needed
                }
                ?>
            </div>
        </div>

        <div class="dots" id="dots"></div>
    </section>

    <!-- Custom Tabs & Content Section -->
    <div class="custom-tabs-section fade-up-element fade-up-delay-4"
        style="background-color: #f8f8f8; padding: 20px 20px; margin-top: 70px; display: grid; grid-template-columns: 1fr 1fr; min-height: 500px;">
        <div class="tabs-content-side"
            style=" padding: 60px 50px; display: flex; flex-direction: column; justify-content: center;">
            <div class="tabs-nav"
                style="display: flex; gap: 20px; margin-bottom: 30px; align-items: flex-start; flex-wrap: wrap;">
                <button class="tab-btn active" data-tab="tab1" data-image="assets/image/ryl-classic-35k.webp"
                    style="background: none; border: none; cursor: pointer; padding: 0; position: relative; outline: none; display: flex; flex-direction: column; align-items: center; gap: 10px;">
                    <div class="tab-image-wrapper">
                        <img src="assets/image/ryl-classic-35k.webp" alt="Tab 1" class="tab-image">
                    </div>
                    <span class="tab-title">Tab 1</span>
                </button>
                <button class="tab-btn" data-tab="tab2" data-image="assets/image/lost-mary-nera-fullview.webp"
                    style="background: none; border: none; cursor: pointer; padding: 0; position: relative; outline: none; display: flex; flex-direction: column; align-items: center; gap: 10px;">
                    <div class="tab-image-wrapper">
                        <img src="assets/image/lost-mary-nera-fullview.webp" alt="Tab 2" class="tab-image">
                    </div>
                    <span class="tab-title">Tab 2</span>
                </button>
                <button class="tab-btn" data-tab="tab3" data-image="assets/image/luffbar-doris-30k-banner.webp"
                    style="background: none; border: none; cursor: pointer; padding: 0; position: relative; outline: none; display: flex; flex-direction: column; align-items: center; gap: 10px;">
                    <div class="tab-image-wrapper">
                        <img src="assets/image/luffbar-doris-30k-banner.webp" alt="Tab 3" class="tab-image">
                    </div>
                    <span class="tab-title">Tab 3</span>
                </button>
            </div>

            <div class="tab-content-wrapper" style="flex: 1;">
                <div class="tab-content active" id="tab1-content" style="display: block; opacity: 1;">
                    <p
                        style="color: black; font-size: 16px; line-height: 1.8; margin-bottom: 35px; font-family: inherit;">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut
                        labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco
                        laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in
                        voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat
                        non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
                    </p>
                </div>

                <div class="tab-content" id="tab2-content" style="display: none; opacity: 0;">
                    <p
                        style="color: black; font-size: 16px; line-height: 1.8; margin-bottom: 35px; font-family: inherit;">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut
                        labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco
                        laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in
                        voluptate velit esse cillum dolore eu fugiat nulla pariatur.
                    </p>
                </div>

                <div class="tab-content" id="tab3-content" style="display: none; opacity: 0;">
                    <p
                        style="color: black; font-size: 16px; line-height: 1.8; margin-bottom: 35px; font-family: inherit;">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut
                        labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco
                        laboris nisi ut aliquip ex ea commodo consequat. Excepteur sint occaecat cupidatat non proident,
                        sunt in culpa qui officia deserunt mollit anim id est laborum.
                    </p>
                </div>
            </div>
        </div>


        <!-- Right Side: Image -->
        <div class="image-side"
            style="background-color: var(--color-background-main, #ffffff); position: relative; overflow: hidden; width: 100%; height: 100%; min-height: 500px;">
            <figure style="width: 100%; height: 100%; margin: 0; padding: 0; position: relative;">
                <img id="main-tab-image" src="assets/image/ryl-classic-35k.webp" alt="Custom Design Process"
                    style="width: 100%; height: 100%; object-fit: cover; object-position: center; display: block; transition: opacity 0.4s ease; position: absolute; top: 0; left: 0;">
            </figure>
        </div>
    </div>

    <!-- Top Picks – Best Sellers -->
    <div class="featured-collection-section mount-css-slider mount-collection-tabs fade-up-element fade-up-delay-1"
        id="main-featured-collection-2">
        <!-- component-product-item.css already loaded above, duplicate removed -->
        <div class="container--large remove-empty-space container--vertical-space"
            id="section-template--17807768223795__featured_collection_X3jgLR">
            <collection-tabs>
                <div class="section-heading section-heading--center gutter-bottom--page" style="text-align: center;">
                    <div class="section-heading__text remove-empty-space">
                        <h2 class="section-heading__title h4">Top Picks – Best Sellers</h2>
                    </div>
                </div>
                <div id="product-grid-template--17807768223795__featured_collection_X3jgLR">
                    <div class="collection-tabs_panel active active"
                        id="collection-template--17807768223795__featured_collection_X3jgLR-0">
                        <css-slider class="css-slider css-slider--bottom-navigation" data-options='{
        "selector": ".product-item",
        "indexNav": true,
        "groupCells": true,
        "navigationDOM": "&lt;span class=\"css-slider-button css-slider-prev\" style=\"display:none\"&gt;&lt;svg fill=\"none\" height=\"13\" viewBox=\"0 0 8 13\" width=\"8\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;g fill=\"#000\" &gt;&lt;path d=\"m7.91419 1.41431-6.48529 6.48528-1.4142102-1.41422 6.4852802-6.48527702z\"/&gt;&lt;path d=\"m6.48528 12.9849-6.48528027-6.48532 1.41421027-1.41421 6.48528 6.48523z\"/&gt;&lt;/g&gt;&lt;/svg&gt;&lt;/span&gt;&lt;span class=\"css-slider-button css-slider-next\" style=\"display:none\"&gt;&lt;svg width=\"9\" height=\"13\" viewBox=\"0 0 9 13\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;path d=\"M0.914169 11.5857L7.39945 5.10041L8.81367 6.51463L2.32838 12.9999L0.914169 11.5857Z\" fill=\"black\"/&gt;&lt;path d=\"M2.34307 0.0151367L8.82835 6.50042L7.41414 7.91463L0.928857 1.42935L2.34307 0.0151367Z\" fill=\"black\"/&gt;&lt;/svg&gt;&lt;/span&gt;"
      }' id="css-slider-template--17807768223795__featured_collection_X3jgLR-0">
                            <div
                                class="grid grid--slider grid-5 grid-laptop-4 grid-portable-3 grid-lap-2 grid-tiny-1 grid-palm-2">
                                <?php
                                $best_sellers = get_products_by_collection_slug($pdo, 'best-sellers', 10);
                                if ($best_sellers) {
                                    foreach ($best_sellers as $product) {
                                        $product_title = htmlspecialchars($product['title']);
                                        $product_slug = htmlspecialchars($product['slug']);
                                        $price = number_format($product['price'], 2);
                                        $compare_price = $product['compare_at_price'] ? number_format($product['compare_at_price'], 2) : null;
                                        
                                        // Image handling
                                        $image_path = $product['image_path'] ?? 'placeholder.png'; // Fallback
                                        if ($image_path !== 'placeholder.png' && strpos($image_path, 'assets/image/') === false && strpos($image_path, 'http') === false) {
                                            $image_path = 'assets/image/' . $image_path;
                                        }
                                        $image_path = htmlspecialchars($image_path);
                                        
                                        $product_url = BASE_URL . '/products/' . $product_slug;
                                        
                                        // Calculate badge (logic can be improved)
                                        $badge_html = '';
                                        if ($compare_price && $product['price'] < $product['compare_at_price']) {
                                             $badge_html = '<span class="product-item__badge product-item__badge--hot" style="background-color: #D14545; color: #ffffff">SALE</span>';
                                        }
                                ?>
                                <div class="product-item card" data-js-product-item="">
                                    <a class="card__image product-item__image" href="<?php echo $product_url; ?>" style="padding-top:100%">
                                        <figure
                                            class="lazy-image product-item__image-figure product-item__image-figure--primary lazy-image--animation lazy-image--background lazy-image--fit"
                                            data-crop="true">
                                            <img src="<?php echo $image_path; ?>" alt="<?php echo $product_title; ?>">
                                        </figure>
                                    </a>
                                    <div
                                        class="card__text product-item__text gutter--regular spacing--xlarge remove-empty-space text-align--left">
                                        <a class="product-item__title" href="<?php echo $product_url; ?>"
                                            title="<?php echo $product_title; ?>">
                                            <div class="remove-line-height-space--small">
                                                <span class="text-animation--underline text-line-height--small"><?php echo $product_title; ?></span>
                                            </div>
                                        </a>
                                        <div class="product-item__price text-size--large equalize-white-space">
                                            <div class="remove-line-height-space">
                                                <div class="product-price">
                                                    <span class="product-price--original">
                                                        <span class="visually-hidden">Regular price</span>
                                                        $<?php echo $price; ?>
                                                    </span>
                                                    <?php if ($compare_price): ?>
                                                    <span class="product-price--compare">
                                                        <span class="visually-hidden">Original price</span>
                                                        <del>$<?php echo $compare_price; ?></del>
                                                    </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="product-item__badges text-size--xsmall"><?php echo $badge_html; ?></div>
                                </div>
                                <?php
                                    }
                                } else {
                                    echo '<div class="alert alert-info">No best sellers found.</div>';
                                }
                                ?>
                            </div>
                        </css-slider>
                    </div>
                </div>
            </collection-tabs>
        </div>
        <link href="css/inline-style-27.css" rel="stylesheet" />
    </div>

    <!-- image & content -->
    <div class="grid-section fade-up-element fade-up-delay-2" id="main-grid-section-2">
        <div class="container--vertical-space" id="section-template--17807768223795__flex_grid_gYPxfg">
            <div class="container--large"></div>
            <div class="grid grid--layout grid--layout-items container--large" style="--grid-aspect: 1.0;
      --grid-aspect-mobile: 1.0;">
                <div class="block-grid-item card" id="element-AWVlmSUhhN09rYkJ0c__grid_text_k3WXkg" style="
    --column-desktop: 6;
    --column-mobile: 2;
    --row-mobile: 1;
    --row-desktop: 2;
    --card-text-width: 90%;
  ">
                    <div class="align-content align-content--horizontal-left align-content--vertical-middle">
                        <div class="card__text gutter--regular spacing--custom-small remove-empty-space"
                            style="--horizontal-alignment:left;">
                            <div class="content-block" id="star-rating-block">
                                <div class="star-rating star-rating--block"
                                    id="star-rating-AVFJIUXJPeHNhb3ltY__star_rating_VbBaik">
                                    <span class="visually-hidden">

                                        5 out of 5 stars
                                    </span><span aria-hidden="true" class="star-rating__stars" style="width:100px">
                                        <span class="star-rating__stars-active" style="width:100px"></span>
                                    </span>
                                </div>
                                <link href="css/inline-style-28.css" rel="stylesheet" />
                            </div>
                            <div class="content-block remove-empty-space" id="grid-heading-block-1">
                                <span class="h2 text-line-height--small">
                                    <strong>EBCREATE BC PRO</strong><br /> 40000 PUFFS
                                </span>
                            </div>
                            <div class="content-block" id="grid-caption-block-1">
                                <span class="text-size--regular" style="">
                                    The most powerful BC Series yet — BC PRO ushers a new era of autofill technology.
                                </span>
                            </div>
                            <div aria-hidden="true" class="empty-space" style="height:0;">

                            </div>
                            <div class="content-block" id="grid-button-block-1">
                                <a class="button button--regular button--solid"
                                    href="/products/ebcreate-bc-pro-40k-disposable-vape"
                                    id="button-AKzRXN1Zzd0VZdjRvW__button_FeYBLE">
                                    SHOP NOW
                                </a>
                            </div>
                        </div>
                        <div class="card__image card__image--background card__image--with-overlay"></div>
                        <link href="css/inline-style-29.css" rel="stylesheet" />
                    </div>
                </div>
                <div class="block-grid-item card element--hide-on-small"
                    id="element-AOS9wcVJmSnNQeW0wM__grid_media_64Trqd" style="
    --column-desktop: 6;
    --column-mobile: 1;
    --row-mobile: 2;
    --row-desktop: 2;
  ">
                    <div class="block-grid-item__container"><a aria-hidden="true"
                            class="card__whole-link card__whole-link--alternate" href="#"></a>
                        <div class="card__image card__image--background">
                            <!-- Avada Order Limit settings disabled - contains invalid template syntax for static site -->
                            <!-- <script src="js/inline-script-39.js"></script> -->
                            <video-component class="video-component video-component--background element--border-radius"
                                data-autoplay="true" data-media-type="video" data-video=""
                                id="video-AOS9wcVJmSnNQeW0wM__grid_media_64Trqd"
                                style="--aspect-ratio-padding: 56.33802816901409%">
                                <template>
                                    <video autoplay="" loop="" muted="" playsinline="">
                                    </video><a href="assets/image/videoframe_1933.png"></a></template>
                                <div class="video-component__container" data-js-video-component-container="">
                                    <a class="video-component__link"
                                        href="assets/image/6ad9e5fcd4e84adbb52040e94e93cc59.HD-1080p-7.2Mbps-56309218.mp4"
                                        data-js-video-component-link="" tabindex="-1">
                                        <span class="video-component__autoplay-poster lazy-image"></span></a>
                                    <video autoplay="" muted="" loop="" playsinline="" preload="auto"
                                        style="width: 100%; height: 100%; object-fit: cover; position: absolute; top: 0; left: 0; z-index: 99;">
                                        <source
                                            src="assets/image/6ad9e5fcd4e84adbb52040e94e93cc59.HD-1080p-7.2Mbps-56309218.mp4"
                                            type="video/mp4">
                                    </video>
                                </div>
                            </video-component>
                            <script src="js/component-video-init.js"></script>
                        </div>
                        <link href="css/inline-style-30.css" rel="stylesheet" />
                        <link href="css/inline-style-31.css" rel="stylesheet" />
                    </div>
                </div>
                <div class="block-grid-item card" id="element-AYjFxWE1YeU05TTFmK__grid_text_fLctEE" style="
    --column-desktop: 3;
    --column-mobile: 1;
    --row-mobile: 1;
    --row-desktop: 1;
    --card-text-width: 90%;
  ">
                    <div class="align-content align-content--horizontal-left align-content--vertical-bottom">
                        <div class="card__text gutter--regular spacing--custom-small remove-empty-space"
                            style="--horizontal-alignment:left;">
                            <div class="content-block" id="grid-image-block-2">
                                <div class="block-image" style="--image-height: 40px;">
                                    <figure class="block-image__figure lazyloaded">
                                        <img src="assets/image/nicotine.png" alt="" loading="eager">
                                    </figure>
                                </div>
                            </div>
                            <div aria-hidden="true" class="empty-space" style="height:0;">

                            </div>
                            <div class="content-block remove-empty-space" id="grid-heading-block-2">
                                <span class="h5 text-line-height--default">
                                    <strong>Nicotine Strength</strong>
                                </span>
                            </div>
                            <div class="content-block" id="grid-caption-block-2">
                                <span class="text-size--large" style="">
                                    <strong>50 mg/mL</strong>
                                </span>
                            </div>
                        </div>
                        <div class="card__image card__image--background card__image--with-overlay"></div>
                        <link href="css/inline-style-32.css" rel="stylesheet" />
                    </div>
                </div>
                <div class="block-grid-item card" id="element-AZUZTQ0tncThITkdtT__grid_text_Gk8HJd" style="
    --column-desktop: 3;
    --column-mobile: 1;
    --row-mobile: 1;
    --row-desktop: 1;
    --card-text-width: 90%;
  ">
                    <div class="align-content align-content--horizontal-left align-content--vertical-bottom">
                        <div class="card__text gutter--regular spacing--custom-small remove-empty-space"
                            style="--horizontal-alignment:left;">
                            <div class="content-block" id="grid-image-block-3">
                                <div class="block-image" style="--image-height: 40px;">
                                    <figure class="block-image__figure lazyloaded">
                                        <img src="assets/image/battery.png" alt="" loading="eager">
                                    </figure>
                                </div>
                            </div>
                            <div aria-hidden="true" class="empty-space" style="height:0;">

                            </div>
                            <div class="content-block remove-empty-space" id="grid-heading-block-3">
                                <span class="h5 text-line-height--default">
                                    <strong>Battery Capacity</strong>
                                </span>
                            </div>
                            <div class="content-block" id="grid-caption-block-3">
                                <span class="text-size--large" style="">
                                    <strong>1000 mAh</strong>
                                </span>
                            </div>
                        </div>
                        <div class="card__image card__image--background card__image--with-overlay"></div>
                        <link href="css/inline-style-33.css" rel="stylesheet" />
                    </div>
                </div>
                <div class="block-grid-item card" id="element-AaVVKLzYycy9QVWkwY__grid_text_TG7pPB" style="
    --column-desktop: 3;
    --column-mobile: 1;
    --row-mobile: 1;
    --row-desktop: 1;
    --card-text-width: 90%;
  ">
                    <div class="align-content align-content--horizontal-left align-content--vertical-bottom">
                        <div class="card__text gutter--regular spacing--custom-small remove-empty-space"
                            style="--horizontal-alignment:left;">
                            <div class="content-block" id="grid-image-block-4">
                                <div class="block-image" style="--image-height: 40px;">
                                    <figure class="block-image__figure lazyloaded">
                                        <img src="assets/image/puffs.png" alt="" loading="eager">
                                    </figure>
                                </div>
                            </div>
                            <div aria-hidden="true" class="empty-space" style="height:0;">

                            </div>
                            <div class="content-block remove-empty-space" id="grid-heading-block-4">
                                <span class="h5 text-line-height--default">
                                    <strong>Puffs Count</strong>
                                </span>
                            </div>
                            <div class="content-block" id="grid-caption-block-4">
                                <span class="text-size--large" style="">
                                    <strong>Up to 40000</strong>
                                </span>
                            </div>
                        </div>
                        <div class="card__image card__image--background card__image--with-overlay"></div>
                        <link href="css/inline-style-34.css" rel="stylesheet" />
                    </div>
                </div>
                <div class="block-grid-item card" id="element-ASzRzUXdhTjJyemlCc__grid_text_8FMBfY" style="
    --column-desktop: 3;
    --column-mobile: 1;
    --row-mobile: 1;
    --row-desktop: 1;
    --card-text-width: 90%;
  ">
                    <div class="align-content align-content--horizontal-left align-content--vertical-bottom">
                        <div class="card__text gutter--regular spacing--custom-small remove-empty-space"
                            style="--horizontal-alignment:left;">
                            <div class="content-block" id="grid-image-block-5">
                                <div class="block-image" style="--image-height: 40px;">
                                    <figure class="block-image__figure lazyloaded">
                                        <img src="assets/image/charging_port.png" alt="" loading="eager">
                                    </figure>
                                </div>
                            </div>
                            <div aria-hidden="true" class="empty-space" style="height:0;">

                            </div>
                            <div class="content-block remove-empty-space" id="grid-heading-block-5">
                                <span class="h5 text-line-height--default">
                                    <strong>Charging Port</strong>
                                </span>
                            </div>
                            <div class="content-block" id="grid-caption-block-5">
                                <span class="text-size--large" style="">
                                    <strong>Type-C</strong>
                                </span>
                            </div>
                        </div>
                        <div class="card__image card__image--background card__image--with-overlay"></div>
                        <link href="css/inline-style-35.css" rel="stylesheet" />
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- About Disposable Vapes -->
    <div class="about-vapes-section fade-up-element fade-up-delay-3" id="main-about-vapes-section"
        style="position: relative; display: flex; justify-content: center; align-items: center; margin-top: 90px; min-height: 500px; background-attachment: fixed; background-position: center; background-repeat: no-repeat; background-size: cover; background-image: url('assets/image/ryl-classic-35k.webp');">
        <!-- Overlay -->
        <div
            style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1;">
        </div>

        <!-- Content Container -->
        <div style="position: relative; z-index: 2; padding: 80px 20px; max-width: 1200px; margin: 0 auto;">
            <div style="text-align: center; color: #ffffff;">
                <!-- Heading -->
                <h2 class="h3" style="color: #ffffff; margin-bottom: 30px; font-size: 32px; font-weight: 600;">About
                    Disposable Vapes</h2>

                <!-- Visible Content (Always Shown) -->
                <div class="vapes-content-visible" style="margin-bottom: 25px;">
                    <p style="font-size: 18px; line-height: 1.8; max-width: 900px; margin: 0 auto; color: #ffffff;">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut
                        labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco
                        laboris.
                    </p>
                </div>

                <!-- Hidden Content (Shown on Read More) -->
                <div class="vapes-content-hidden" id="vapes-hidden-content" style="display: none; margin-bottom: 25px;">
                    <p
                        style="font-size: 18px; line-height: 1.8; max-width: 900px; margin: 0 auto 20px; color: #ffffff;">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut
                        labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco
                        laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in
                        voluptate velit esse cillum dolore eu fugiat nulla pariatur.
                    </p>
                    <p style="font-size: 18px; line-height: 1.8; max-width: 900px; margin: 0 auto; color: #ffffff;">
                        Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim
                        id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium
                        doloremque laudantium, totam rem aperiam.
                    </p>
                </div>

                <!-- Read More Button -->
                <div style="margin-top: 30px;">
                    <button id="read-more-btn" class="read-more-button"
                        style="background-color: rgba(255, 255, 255, 0.2); border: 2px solid #ffffff; color: #ffffff; padding: 10px 30px; border-radius: 30px; font-size: 14px; font-weight: 600; cursor: pointer; text-transform: uppercase; letter-spacing: 1px; transition: all 0.3s ease; backdrop-filter: blur(10px);">
                        Read More
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Best Disposable Vapes – Flavors, Puff Counts, & Deals -->
    <div class="featured-collection-section mount-css-slider mount-collection-tabs fade-up-element fade-up-delay-4"
        id="main-featured-collection-3" style="background-color:#f8f8f8;">
        <!-- component-product-item.css already loaded above, duplicate removed -->
        <div class="container--large remove-empty-space container--has-background"
            id="section-template--17807768223795__featured_collection_QwdTVt">
            <collection-tabs>
                <div class="section-heading section-heading--center gutter-bottom--page" style="text-align: center;">
                    <div class="section-heading__text remove-empty-space">
                        <h2 class="section-heading__title h4">Best Disposable Vapes – Flavors, Puff Counts, &amp; Deals
                        </h2>
                    </div>
                </div>
                <div id="product-grid-template--17807768223795__featured_collection_QwdTVt">
                    <div class="collection-tabs_panel active active"
                        id="collection-template--17807768223795__featured_collection_QwdTVt-0">
                        <div
                            class="grid grid--layout grid-5 grid-laptop-4 grid-portable-3 grid-lap-2 grid-tiny-1 grid-palm-2">
                            <?php
                            $disposable_vapes = get_products_by_collection_slug($pdo, 'disposable-vapes', 5);
                            if ($disposable_vapes) {
                                foreach ($disposable_vapes as $product) {
                                    $product_title = htmlspecialchars($product['title']);
                                    $product_slug = htmlspecialchars($product['slug']);
                                    $price = number_format($product['price'], 2);
                                    $compare_price = $product['compare_at_price'] ? number_format($product['compare_at_price'], 2) : null;
                                    
                                    // Image handling
                                    $image_path = $product['image_path'] ?? 'placeholder.png'; // Fallback
                                    if ($image_path !== 'placeholder.png' && strpos($image_path, 'assets/image/') === false && strpos($image_path, 'http') === false) {
                                        $image_path = 'assets/image/' . $image_path;
                                    }
                                    $image_path = htmlspecialchars($image_path);
                                    
                                    $product_url = BASE_URL . '/products/' . $product_slug;
                                    
                                    // Calculate badge
                                    $badge_html = '';
                                    if ($compare_price && $product['price'] < $product['compare_at_price']) {
                                         $badge_html = '<span class="product-item__badge product-item__badge--hot" style="background-color: #D14545; color: #ffffff">SALE</span>';
                                    }
                            ?>
                            <div class="product-item card" data-js-product-item="">
                                <a class="card__image product-item__image" href="<?php echo $product_url; ?>" style="padding-top:100%">
                                    <figure
                                        class="lazy-image product-item__image-figure product-item__image-figure--primary lazy-image--animation lazy-image--background lazy-image--fit"
                                        data-crop="true">
                                        <img src="<?php echo $image_path; ?>" alt="<?php echo $product_title; ?>">
                                    </figure>
                                </a>
                                <div
                                    class="card__text product-item__text gutter--regular spacing--xlarge remove-empty-space text-align--left">
                                    <a class="product-item__title" href="<?php echo $product_url; ?>"
                                        title="<?php echo $product_title; ?>">
                                        <div class="remove-line-height-space--small">
                                            <span class="text-animation--underline text-line-height--small"><?php echo $product_title; ?></span>
                                        </div>
                                    </a>
                                    <div class="product-item__price text-size--large equalize-white-space">
                                        <div class="remove-line-height-space">
                                            <div class="product-price">
                                                <span class="product-price--original">
                                                    <span class="visually-hidden">Regular price</span>
                                                    $<?php echo $price; ?>
                                                </span>
                                                <?php if ($compare_price): ?>
                                                <span class="product-price--compare">
                                                    <span class="visually-hidden">Original price</span>
                                                    <del>$<?php echo $compare_price; ?></del>
                                                </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="product-item__badges text-size--xsmall"><?php echo $badge_html; ?></div>
                            </div>
                            <?php
                                }
                            } else {
                                echo '<div class="alert alert-info">No products found in Disposable Vapes.</div>';
                            }
                            ?>
                        </div>
                        <div style="text-align: center; margin-top: 40px; padding-top: 30px;">
                            <a class="button button--regular button--solid" href="<?php echo BASE_URL; ?>/collections/disposable-vapes"
                                style="display: inline-block; text-decoration: none;">
                                View All Products
                            </a>
                        </div>
                    </div>
                </div>
            </collection-tabs>
        </div>
        <link href="css/inline-style-36.css" rel="stylesheet" />
        <link href="css/inline-style-37.css" rel="stylesheet" />
    </div>

    <!-- Choosing The Right Vape Products -->
    <div class="choosing-vapes-section fade-up-element fade-up-delay-1"
        style="background-color: var(--color-background-main, #ffffff);">
        <div class="container--large" style="max-width: 1200px; margin: 0 auto; padding: 0 20px;">
            <div style="display: flex; flex-wrap: wrap; margin: 0 -15px; align-items: stretch;">
                <!-- Left Side: Image (col-4 - Smaller) -->
                <div class="col-md-4"
                    style="flex: 0 0 33.333333%; max-width: 33.333333%; padding: 0; box-sizing: border-box; display: flex; align-items: stretch;">
                    <div class="vapes-display-side"
                        style="position: relative; overflow: hidden; display: flex; align-items: center; justify-content: center; padding: 0; margin: 0; width: 100%; height: 100%;">
                        <!-- Full Width Image -->
                        <img src="assets/image/vape.png" alt="Vape Product"
                            style="width: 100%; height: 80%; object-fit: contain; border-radius:3px; display: block; margin: 0; padding: 0;">
                    </div>
                </div>

                <!-- Right Side: Content (col-8 - Larger) -->
                <div class="col-md-8"
                    style="flex: 0 0 66.666667%; max-width: 66.666667%; padding: 0 25px; box-sizing: border-box; display: flex; align-items: stretch;">
                    <div class="vapes-content-side"
                        style="padding: 0px 20px; display: flex; flex-direction: column; justify-content: center; background-color: var(--color-background-main, #ffffff); min-height: 500px; width: 100%;">
                        <!-- Heading -->
                        <h2 class="h3"
                            style="color: var(--color-text-main, #1d1d1d); margin-bottom: 20px; font-size: 32px; font-weight: 700; font-family: var(--font-stack-headings, 'DM Sans', sans-serif);">
                            Lorem ipsum dolor sit amet
                        </h2>

                        <!-- Numbered List -->
                        <ul style="list-style: none; padding: 0; margin: 0;">
                            <li style="margin-bottom: 20px; padding-left: 40px; position: relative;">
                                <div
                                    style="position: absolute; left: 0; top: 0; color: var(--color-accent-main, #000000); font-size: 18px; font-weight: 700; font-family: var(--font-stack-headings, 'DM Sans', sans-serif);">
                                    01.
                                </div>
                                <div>
                                    <strong
                                        style="color: var(--color-text-main, #1d1d1d); font-size: 18px; font-weight: 600; display: block; font-family: inherit;">Lorem
                                        ipsum dolor</strong>
                                    <p
                                        style="color: var(--color-secondary-text-main, rgba(29, 29, 29, 0.62)); font-size: 16px; line-height: 1.6; margin: 0; font-family: inherit;">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor
                                        incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis
                                        nostrud exercitation ullamco laboris.
                                    </p>
                                </div>
                            </li>

                            <li style="margin-bottom: 20px; padding-left: 40px; position: relative;">
                                <div
                                    style="position: absolute; left: 0; top: 0; color: var(--color-accent-main, #000000); font-size: 18px; font-weight: 700; font-family: var(--font-stack-headings, 'DM Sans', sans-serif);">
                                    02.
                                </div>
                                <div>
                                    <strong
                                        style="color: var(--color-text-main, #1d1d1d); font-size: 18px; font-weight: 600; display: block; font-family: inherit;">Lorem
                                        ipsum dolor</strong>
                                    <p
                                        style="color: var(--color-secondary-text-main, rgba(29, 29, 29, 0.62)); font-size: 16px; line-height: 1.6; margin: 0; font-family: inherit;">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor
                                        incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis
                                        nostrud exercitation ullamco laboris nisi ut aliquip.
                                    </p>
                                </div>
                            </li>

                            <li style="margin-bottom: 20px; padding-left: 40px; position: relative;">
                                <div
                                    style="position: absolute; left: 0; top: 0; color: var(--color-accent-main, #000000); font-size: 18px; font-weight: 700; font-family: var(--font-stack-headings, 'DM Sans', sans-serif);">
                                    03.
                                </div>
                                <div>
                                    <strong
                                        style="color: var(--color-text-main, #1d1d1d); font-size: 18px; font-weight: 600; display: block; font-family: inherit;">Lorem
                                        ipsum dolor</strong>
                                    <p
                                        style="color: var(--color-secondary-text-main, rgba(29, 29, 29, 0.62)); font-size: 16px; line-height: 1.6; margin: 0; font-family: inherit;">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor
                                        incididunt ut labore et dolore magna aliqua. Duis aute irure dolor in
                                        reprehenderit in voluptate velit esse.
                                    </p>
                                </div>
                            </li>

                            <li style="margin-bottom: 0; padding-left: 40px; position: relative;">
                                <div
                                    style="position: absolute; left: 0; top: 0; color: var(--color-accent-main, #000000); font-size: 18px; font-weight: 700; font-family: var(--font-stack-headings, 'DM Sans', sans-serif);">
                                    04.
                                </div>
                                <div>
                                    <strong
                                        style="color: var(--color-text-main, #1d1d1d); font-size: 18px; font-weight: 600; display: block; font-family: inherit;">Lorem
                                        ipsum dolor</strong>
                                    <p
                                        style="color: var(--color-secondary-text-main, rgba(29, 29, 29, 0.62)); font-size: 16px; line-height: 1.6; margin: 0; font-family: inherit;">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor
                                        incididunt ut labore et dolore magna aliqua. Excepteur sint occaecat cupidatat
                                        non proident, sunt in culpa qui officia.
                                    </p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Call To Action Section -->
    <div class="cta-section fade-up-element fade-up-delay-2"
        style="background-color: var(--color-background-footer, #000000); background-image: url('assets/image/sea-xs-15000.webp'); background-size: cover; background-position: center; background-repeat: no-repeat; padding: 80px 0; position: relative; min-height: 400px;">
        <!-- Overlay for better text readability -->
        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-color:#0000008f; z-index: 1;">
        </div>

        <div class="container--large"
            style="max-width: 1200px; margin: 0 auto; padding: 0 20px; position: relative; z-index: 2;">
            <div style="display: flex; align-items: center; gap: 60px; flex-wrap: wrap;">
                <!-- Left Side: Logo -->
                <div class="cta-logo-side" style="flex: 0 0 auto; min-width: 200px;">
                    <img src="assets/image/cta.png" alt="Logo"
                        style="max-width: 200px; height: auto; display: block; filter: brightness(0) invert(1);">
                </div>

                <!-- Right Side: Content -->
                <div class="cta-content-side" style="flex: 1; min-width: 300px;">
                    <!-- Heading -->
                    <h2 class="h2"
                        style="color: var(--color-accent-footer, #ffffff); margin-bottom: 20px; font-size: 42px; font-weight: 700; font-family: var(--font-stack-headings, 'DM Sans', sans-serif);">
                        Ready to Find Your Perfect Vape?
                    </h2>

                    <!-- Description -->
                    <p
                        style="color: var(--color-text-footer,rgb(238, 238, 238)); font-size: 18px; line-height: 1.6; margin-bottom: 40px; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">
                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut
                        labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.
                    </p>

                    <!-- CTA Button -->
                    <div style="margin-top: 20px;">
                        <a class="button button--regular button--solid cta-shop-button"
                            href="<?php echo BASE_URL; ?>/collections/all.php"
                            style="display: inline-block; text-decoration: none; background-color: var(--color-accent-footer, #ffffff); color: var(--color-background-footer, #000000); padding: 10px 30px; font-size: 15px; font-weight: 600; border-radius: 30px; transition: all 0.3s ease;">
                            Shop Now
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Let Customers Speak For Us -->
    <div class="testimonials-section-custom fade-up-element fade-up-delay-3" id="main-reviews-app-section"
        style="background-color: #f5f5f5; background-image: radial-gradient(circle, #e0e0e0 1px, transparent 1px); background-size: 20px 20px; padding: 80px 0;">
        <div class="container--large" style="max-width: 1250px; margin: 0 auto; padding: 0 20px;">

            <div class="section-heading section-heading--center gutter-bottom--page" style="text-align: center; ">
                <div class="section-heading__text remove-empty-space">
                    <h2 class="section-heading__title h4">Let Customers Speak For Us</h2>
                </div>
            </div>

            <!-- Reviews Carousel -->
            <div class="testimonials-carousel-wrapper" style="position: relative;">
                <div class="testimonials-slider"
                    style="display: flex; gap: 20px; overflow-x: auto; overflow-y: hidden; scroll-behavior: smooth; padding-bottom: 20px; scrollbar-width: none; -ms-overflow-style: none; position: relative; -webkit-overflow-scrolling: touch;">

                    <!-- Review Card 1 - Google -->
                    <div class="testimonial-card fade-up-element fade-up-delay-1"
                        style="flex: 0 0 calc(25% - 15px); min-width: 280px; background: #ffffff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                        <!-- Google Logo -->
                        <div style="margin-bottom: 15px;">
                            <img src="assets/image/google.png" alt="Google"
                                style="height: 30px; object-fit: contain; display: block;">
                        </div>

                        <!-- Review Text -->
                        <div style="margin-bottom: 15px; min-height: 60px;">
                            <p
                                style="color: #000; font-size: 14px; line-height: 1.5; margin: 0; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">
                                Sleek design, perfect balance of aloe and grape, overall a satisfying vape.
                            </p>
                        </div>

                        <!-- Reviewer Name -->
                        <div style="margin-bottom: 10px;">
                            <span
                                style="color: #000; font-size: 14px; font-weight: 600; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">ElodieS.</span>
                        </div>

                        <!-- Star Rating and Verified Badge -->
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <span style="color: #FFD700; font-size: 18px; letter-spacing: 2px;">★★★★★</span>
                            </div>
                            <div>
                                <span
                                    style="display: inline-flex; align-items: center; gap: 5px; color: #000; font-size: 12px; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">
                                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="7" cy="7" r="7" fill="#34A853" />
                                        <path d="M4 7L6 9L10 5" stroke="white" stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                    Verified
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Review Card 2 - Google -->
                    <div class="testimonial-card fade-up-element fade-up-delay-2"
                        style="flex: 0 0 calc(25% - 15px); min-width: 280px; background: #ffffff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                        <!-- Google Logo -->
                        <div style="margin-bottom: 15px;">
                            <img src="assets/image/google.png" alt="Google"
                                style="height: 30px; object-fit: contain; display: block;">
                        </div>

                        <!-- Review Text -->
                        <div style="margin-bottom: 15px; min-height: 60px;">
                            <p
                                style="color: #000; font-size: 14px; line-height: 1.5; margin: 0; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">
                                Portable, long-lasting battery, smooth vape, perfect for daily use.
                            </p>
                        </div>

                        <!-- Reviewer Name -->
                        <div style="margin-bottom: 10px;">
                            <span
                                style="color: #000; font-size: 14px; font-weight: 600; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">GretaM.</span>
                        </div>

                        <!-- Star Rating and Verified Badge -->
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <span style="color: #FFD700; font-size: 18px; letter-spacing: 2px;">★★★★★</span>
                            </div>
                            <div>
                                <span
                                    style="display: inline-flex; align-items: center; gap: 5px; color: #000; font-size: 12px; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">
                                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="7" cy="7" r="7" fill="#34A853" />
                                        <path d="M4 7L6 9L10 5" stroke="white" stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                    Verified
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Review Card 3 - Trustpilot -->
                    <div class="testimonial-card fade-up-element fade-up-delay-3"
                        style="flex: 0 0 calc(25% - 15px); min-width: 280px; background: #ffffff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                        <!-- Google Logo -->
                        <div style="margin-bottom: 15px;">
                            <img src="assets/image/trustpilot.png" alt="Google"
                                style="height: 30px; object-fit: contain; display: block;">
                        </div>

                        <!-- Review Text -->
                        <div style="margin-bottom: 15px; min-height: 60px;">
                            <p
                                style="color: #000; font-size: 14px; line-height: 1.5; margin: 0; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">
                                Flavor lasts till the last puff, thick vapor, and device looks high-end.
                            </p>
                        </div>

                        <!-- Reviewer Name -->
                        <div style="margin-bottom: 10px;">
                            <span
                                style="color: #000; font-size: 14px; font-weight: 600; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">MasonT.</span>
                        </div>

                        <!-- Star Rating and Verified Badge -->
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <span style="color: #FFD700; font-size: 18px; letter-spacing: 2px;">★★★★</span><span
                                    style="color: #ddd; font-size: 18px; letter-spacing: 2px;">☆</span>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>

                    <!-- Review Card 4 - Trustpilot -->
                    <div class="testimonial-card fade-up-element fade-up-delay-4"
                        style="flex: 0 0 calc(25% - 15px); min-width: 280px; background: #ffffff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                        <!-- Google Logo -->
                        <div style="margin-bottom: 15px;">
                            <img src="assets/image/trustpilot.png" alt="Google"
                                style="height: 30px; object-fit: contain; display: block;">
                        </div>

                        <!-- Review Text -->
                        <div style="margin-bottom: 15px; min-height: 60px;">
                            <p
                                style="color: #000; font-size: 14px; line-height: 1.5; margin: 0; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">
                                Spearmint flavor is so refreshing, smooth hits, and lasts all 15k puffs.
                            </p>
                        </div>

                        <!-- Reviewer Name -->
                        <div style="margin-bottom: 10px;">
                            <span
                                style="color: #000; font-size: 14px; font-weight: 600; font-family: var(--font-stack-body, 'DM Sans', sans-serif);">VivianR.</span>
                        </div>

                        <!-- Star Rating and Verified Badge -->
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <span style="color: #FFD700; font-size: 18px; letter-spacing: 2px;">★★★★</span><span
                                    style="color: #ddd; font-size: 18px; letter-spacing: 2px;">☆</span>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>

                </div>

                <!-- Navigation Arrows -->
                <div style="display: flex; justify-content: center; gap: 10px; margin-top: 30px;">
                    <button class="testimonial-nav-btn testimonial-prev"
                        style="width: 40px; height: 40px; border-radius: 50%; background-color: #333; border: none; cursor: pointer; display: flex; align-items: center; justify-content: center; color: white; transition: all 0.3s ease;">
                        <svg width="12" height="12" viewBox="0 0 8 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M7.91419 1.41431L1.4289 7.89959L0.0146893 6.48538L6.49998 0.0000896454L7.91419 1.41431Z"
                                fill="white" />
                            <path
                                d="M6.48528 12.9849L-2.98023e-08 6.49961L1.41421 5.0854L7.8995 11.5707L6.48528 12.9849Z"
                                fill="white" />
                        </svg>
                    </button>
                    <button class="testimonial-nav-btn testimonial-next"
                        style="width: 40px; height: 40px; border-radius: 50%; background-color: #333; border: none; cursor: pointer; display: flex; align-items: center; justify-content: center; color: white; transition: all 0.3s ease;">
                        <svg width="12" height="12" viewBox="0 0 9 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M0.914169 11.5857L7.39945 5.10041L8.81367 6.51463L2.32838 12.9999L0.914169 11.5857Z"
                                fill="white" />
                            <path
                                d="M2.34307 0.0151367L8.82835 6.50042L7.41414 7.91463L0.928857 1.42935L2.34307 0.0151367Z"
                                fill="white" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Frequently Asked Questions -->
    <div class="shopify-section fade-up-element fade-up-delay-4"
        id="shopify-section-template--17807768813619__17563089963b803d65">
        <div class="shopify-block" id="shopify-block-AYXRIdXppMGxYZ1Fxc__ai_gen_block_d100207_nzUjTa">
            <div class="container container--large remove-empty-space">
                <section aria-labelledby="faq-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-content="faq"
                    data-ai-extract="questions-answers">
                    <div class="faq-section-container-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                        <div class="section-heading section-heading--center gutter-bottom--page" style="text-align: center;">
                            <div class="section-heading__text remove-empty-space">
                                <h2 class="section-heading__title h4" id="faq-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    Frequently Asked Questions</h2>
                            </div>
                        </div>
                        <div aria-label="Frequently asked questions list"
                            class="faq-section-list-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="list">
                            <div class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="listitem">
                                <div class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <i class="bi bi-square faq-question-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"></i>
                                    <span class="faq-question-text-ayxridxppmgxyz1fxcaigenblockd100207nzujta">How many puffs does Romo Hex 50K deliver?</span>
                                </div>
                                <div class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <div>Up to 50,000 puffs under Eco mode, depending on your draw style and usage.</div>
                                </div>
                            </div>
                            <div class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="listitem">
                                <div class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <i
                                        class="bi bi-mortarboard faq-question-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"></i>
                                    <span class="faq-question-text-ayxridxppmgxyz1fxcaigenblockd100207nzujta">What
                                        nicotine strength is it?</span>
                                </div>
                                <div class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <div>The Romo Hex uses 5% (50mg) nicotine.</div>
                                </div>
                            </div>
                            <div class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="listitem">
                                <div class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <i
                                        class="bi bi-flag faq-question-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"></i>
                                    <span class="faq-question-text-ayxridxppmgxyz1fxcaigenblockd100207nzujta">Is the
                                        battery rechargeable?</span>
                                </div>
                                <div class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <div>Yes. It includes a built‑in 1500mAh battery (composed of a 1000mAh power bank
                                        and 500mAh pod battery).</div>
                                </div>
                            </div>
                            <div class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="listitem">
                                <div class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <i
                                        class="bi bi-currency-dollar faq-question-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"></i>
                                    <span class="faq-question-text-ayxridxppmgxyz1fxcaigenblockd100207nzujta">What coil
                                        type does it use?</span>
                                </div>
                                <div class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <div>It uses a 1.0Ω dual mesh coil for smoother vapor and enhanced flavor.</div>
                                </div>
                            </div>
                            <div class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="listitem">
                                <div class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <i
                                        class="bi bi-shield-check faq-question-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"></i>
                                    <span class="faq-question-text-ayxridxppmgxyz1fxcaigenblockd100207nzujta">What is
                                        ECO vs Boost mode?</span>
                                </div>
                                <div class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <div>ECO mode operates at about 16W for longer longevity, while Boost mode increases
                                        power to about 18W for richer vapor output.</div>
                                </div>
                            </div>
                            <div class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="listitem">
                                <div class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <i
                                        class="bi bi-shield-check faq-question-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"></i>
                                    <span class="faq-question-text-ayxridxppmgxyz1fxcaigenblockd100207nzujta">How can I
                                        tell how much liquid or battery remains?</span>
                                </div>
                                <div class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                                    <div>The device features a smart digital display for battery level and airflow mode,
                                        and a transparent pod shows e‑liquid level.</div>
                                </div>
                            </div>
                        </div>
                        <div aria-hidden="true" data-ai-extract="faq-keywords" style="display: none;">
                            <p>FAQ about Romo Hex 50K Puffs Kit Disposable Vape:How many puffs does Romo Hex 50K
                                deliver? What
                                nicotine strength is it? Is the battery rechargeable? What coil type does it use? What
                                is ECO vs Boost
                                mode? H...
                            </p>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <!-- Vape Smarter with Our Guides -->
    <div class="testimonials-section fade-up-element fade-up-delay-5" id="main-testimonials-section">
        <link href="css\component-blog-item.css" media="all" rel="stylesheet" type="text/css" />
        <div class="container--large remove-empty-space container--vertical-space"
            id="section-template--17807768223795__16551127939786a43a">
            <div class="section-heading section-heading--center gutter-bottom--page" style="text-align: center;">
                <div class="section-heading__text remove-empty-space">
                    <h2 class="section-heading__title h4">Latest News</h2>
                </div>
            </div>
            <div class="grid grid--layout grid-3 grid-lap-1">
                <?php
                $latest_blogs = get_latest_blogs($pdo, 3);
                if ($latest_blogs) {
                    foreach ($latest_blogs as $blog) {
                        $blog_title = htmlspecialchars($blog['title']);
                        $blog_slug = htmlspecialchars($blog['slug']);
                        $blog_date = date('F j, Y', strtotime($blog['published_at']));
                        
                        // Image handling
                        $image_path = $blog['featured_image'] ?? 'placeholder.png'; // Fallback
                        // Assuming blog images might be stored differently, but following product pattern or absolute paths if applicable.
                        // Based on SQL dump, featured_image column exists.
                         if ($image_path !== 'placeholder.png' && strpos($image_path, 'assets/image/') === false && strpos($image_path, 'http') === false) {
                             $image_path = 'assets/image/' . $image_path; // Adjust if blog images have a specific folder
                        }
                        $image_path = htmlspecialchars($image_path);
                        $blog_url = BASE_URL . '/blog-detail.php?slug=' . $blog_slug; // Assuming you have a blog detail page or similar
                ?>
                <div class="blog-item spacing--small remove-empty-space fade-up-element fade-up-delay-1">
                    <a class="blog-item__image element--has-border element--border-radius increased-spacing" href="<?php echo $blog_url; ?>"
                        title="<?php echo $blog_title; ?>">
                        <figure class="lazy-image lazy-image--animation element--border-radius" data-crop="false"
                            data-ratio="1.33333" style="padding-top: 75.00018750046875%">
                            <img src="<?php echo $image_path; ?>" alt="<?php echo $blog_title; ?>">
                        </figure>
                    </a>
                    <div class="blog-item__meta text-color--opacity">
                        <span class="blog-item__date text-size--small"><?php echo $blog_date; ?></span>
                    </div>
                    <div class="blog-item__title-holder">
                        <a href="<?php echo $blog_url; ?>" title="<?php echo $blog_title; ?>">
                            <span class="text-size--large text-weight--bold text-animation--underline"><?php echo $blog_title; ?></span>
                        </a>
                    </div>
                </div>
                <?php
                    }
                } else {
                    echo '<div class="alert alert-info">No latest news found.</div>';
                }
                ?>
            </div>
            <div style="text-align: center; margin-top: 40px; padding-top: 30px;">
                <a class="button button--regular button--solid" href="#"
                    style="display: inline-block; text-decoration: none;">
                    Visit the Blog
                </a>
            </div>
        </div>
    </div>

    <!-- Why Shop at Our Store? -->
    <div class="text-columns-icons-section mount-css-slider fade-up-element fade-up-delay-1"
        style="background-color:#f8f8f8; margin-top: 90px;" id="main-text-columns-icons-section">
        <div class="container--large remove-empty-space container--vertical-space container--has-background "
            style="padding-top: 60px !important; padding-bottom: 60px !important; margin-top: 30px !important;">
            <div class="section-heading section-heading--center gutter-bottom--page">
                <div class="section-heading__text remove-empty-space">
                    <h2 class="section-heading__title h4">Why Shop at Our Store?</h2><span
                        class="section-heading__subheading text-size--large">Your one-stop vape shop with top value and
                        speed.</span>
                </div>
            </div>
            <link href="css/inline-style-41.css" rel="stylesheet" />
            <css-slider class="css-slider css-slider--bottom-navigation" data-options='{
        "selector": ".js-slider-item",
        "groupCells": true,
        "indexNav": true,
        "navigationDOM": "&lt;span class=\"css-slider-button css-slider-prev\" style=\"display:none\"&gt;&lt;svg fill=\"none\" height=\"13\" viewBox=\"0 0 8 13\" width=\"8\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;g fill=\"#000\" &gt;&lt;path d=\"m7.91419 1.41431-6.48529 6.48528-1.4142102-1.41422 6.4852802-6.48527702z\"/&gt;&lt;path d=\"m6.48528 12.9849-6.48528027-6.48532 1.41421027-1.41421 6.48528 6.48523z\"/&gt;&lt;/g&gt;&lt;/svg&gt;&lt;/span&gt;&lt;span class=\"css-slider-button css-slider-next\" style=\"display:none\"&gt;&lt;svg width=\"9\" height=\"13\" viewBox=\"0 0 9 13\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;path d=\"M0.914169 11.5857L7.39945 5.10041L8.81367 6.51463L2.32838 12.9999L0.914169 11.5857Z\" fill=\"black\"/&gt;&lt;path d=\"M2.34307 0.0151367L8.82835 6.50042L7.41414 7.91463L0.928857 1.42935L2.34307 0.0151367Z\" fill=\"black\"/&gt;&lt;/svg&gt;&lt;/span&gt;"
      }'>
                <div class="grid grid--slider grid-4 grid-portable-3 grid-lap-2">
                    <div
                        class="element--no-border text-align--center element--no-radius js-slider-item fade-up-element fade-up-delay-1">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_Bx4hXf"
                            style="margin-bottom: 10px !important;">
                            <img src="assets\image\delivery-time-2-256.png" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space"
                            style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">Lightning-Fast Shipping</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">
                                Reliable
                                delivery, always fast and nationwide.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-42.css" rel="stylesheet" />
                    <link href="css/inline-style-43.css" rel="stylesheet" />
                    <div
                        class="element--no-border text-align--center element--no-radius js-slider-item fade-up-element fade-up-delay-2">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_ae3Rnb"
                            style="margin-bottom: 10px !important;">
                            <img src="assets\image\pay-by-card-256.png" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space"
                            style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">100%
                                        Secure Checkout</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">
                                Encrypted
                                payments with full buyer protection.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-44.css" rel="stylesheet" />
                    <link href="css/inline-style-45.css" rel="stylesheet" />
                    <div
                        class="element--no-border text-align--center element--no-radius js-slider-item fade-up-element fade-up-delay-3">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_FBF9AH"
                            style="margin-bottom: 10px !important;">
                            <img src="assets\image\sms-message-256_1.webp" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space"
                            style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">Trusted
                                        Support Team</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">Real
                                help, fast
                                replies, no bots involved.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-46.css" rel="stylesheet" />
                    <link href="css/inline-style-47.css" rel="stylesheet" />
                    <div
                        class="element--no-border text-align--center element--no-radius js-slider-item fade-up-element fade-up-delay-4">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_phWeRX"
                            style="margin-bottom: 10px !important;">
                            <img src="assets\image\label-256.webp" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space"
                            style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">Lowest
                                        Prices Guaranteed</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">
                                Unbeatable deals
                                on top brands and new releases.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-48.css" rel="stylesheet" />
                    <link href="css/inline-style-49.css" rel="stylesheet" />
                </div>
            </css-slider>
        </div>
        <link href="css/inline-style-50.css" rel="stylesheet" />
    </div>

</main>
<!-- BEGIN sections: footer-group -->



<?php include 'footer.php'; ?>

<!-- Professional Carousel JavaScript -->
<script>
    // Professional Hero Carousel Functionality
    (function () {
        const carouselTrack = document.getElementById('heroCarouselTrack');
        const slides = document.querySelectorAll('.hero-carousel-slide');
        const prevBtn = document.getElementById('heroCarouselPrev');
        const nextBtn = document.getElementById('heroCarouselNext');
        const dots = document.querySelectorAll('.hero-carousel-dot');

        if (!carouselTrack || slides.length === 0) return;

        let currentSlide = 0;
        let autoPlayInterval = null;
        const autoPlayDelay = 5000; // 5 seconds

        // Initialize carousel
        function initCarousel() {
            showSlide(0);
            startAutoPlay();
        }

        // Show specific slide
        function showSlide(index) {
            // Remove active class from all slides and dots
            slides.forEach((slide, i) => {
                slide.classList.remove('active');
                if (i === index) {
                    setTimeout(() => {
                        slide.classList.add('active');
                    }, 50);
                }
            });

            dots.forEach((dot, i) => {
                dot.classList.toggle('active', i === index);
            });

            // Update track position
            carouselTrack.style.transform = `translateX(-${index * 100}%)`;
            currentSlide = index;
        }

        // Go to next slide
        function nextSlide() {
            const next = (currentSlide + 1) % slides.length;
            showSlide(next);
            resetAutoPlay();
        }

        // Go to previous slide
        function prevSlide() {
            const prev = (currentSlide - 1 + slides.length) % slides.length;
            showSlide(prev);
            resetAutoPlay();
        }

        // Go to specific slide
        function goToSlide(index) {
            if (index >= 0 && index < slides.length) {
                showSlide(index);
                resetAutoPlay();
            }
        }

        // Auto-play functionality
        function startAutoPlay() {
            autoPlayInterval = setInterval(nextSlide, autoPlayDelay);
        }

        function stopAutoPlay() {
            if (autoPlayInterval) {
                clearInterval(autoPlayInterval);
                autoPlayInterval = null;
            }
        }

        function resetAutoPlay() {
            stopAutoPlay();
            startAutoPlay();
        }

        // Event listeners
        if (nextBtn) {
            nextBtn.addEventListener('click', function (e) {
                e.preventDefault();
                nextSlide();
            });
        }

        if (prevBtn) {
            prevBtn.addEventListener('click', function (e) {
                e.preventDefault();
                prevSlide();
            });
        }

        // Dot navigation
        dots.forEach((dot, index) => {
            dot.addEventListener('click', function (e) {
                e.preventDefault();
                goToSlide(index);
            });
        });

        // Pause on hover
        const carouselWrapper = document.querySelector('.hero-carousel-wrapper');
        if (carouselWrapper) {
            carouselWrapper.addEventListener('mouseenter', stopAutoPlay);
            carouselWrapper.addEventListener('mouseleave', startAutoPlay);
        }

        // Touch/swipe support for mobile
        let touchStartX = 0;
        let touchEndX = 0;

        if (carouselWrapper) {
            carouselWrapper.addEventListener('touchstart', function (e) {
                touchStartX = e.changedTouches[0].screenX;
            }, { passive: true });

            carouselWrapper.addEventListener('touchend', function (e) {
                touchEndX = e.changedTouches[0].screenX;
                handleSwipe();
            }, { passive: true });
        }

        function handleSwipe() {
            const swipeThreshold = 50;
            const diff = touchStartX - touchEndX;

            if (Math.abs(diff) > swipeThreshold) {
                if (diff > 0) {
                    // Swipe left - next slide
                    nextSlide();
                } else {
                    // Swipe right - previous slide
                    prevSlide();
                }
            }
        }

        // Keyboard navigation
        document.addEventListener('keydown', function (e) {
            if (carouselWrapper && document.contains(carouselWrapper)) {
                if (e.key === 'ArrowLeft') {
                    prevSlide();
                } else if (e.key === 'ArrowRight') {
                    nextSlide();
                }
            }
        });

        // Initialize when DOM is ready
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initCarousel);
        } else {
            initCarousel();
        }

        // Pause when page is hidden (tab switch)
        document.addEventListener('visibilitychange', function () {
            if (document.hidden) {
                stopAutoPlay();
            } else {
                startAutoPlay();
            }
        });
    })();
</script>

<!-- Fade Up Animation JavaScript -->
<script>
    (function () {
        'use strict';

        // Fade Up Animation using Intersection Observer
        function initFadeUpAnimation() {
            // Check if Intersection Observer is supported
            if (!('IntersectionObserver' in window)) {
                // Fallback: Show all elements immediately
                document.querySelectorAll('.fade-up-element').forEach(function (el) {
                    el.classList.add('fade-up-visible');
                });
                return;
            }

            // Create Intersection Observer
            const observerOptions = {
                root: null, // Use viewport as root
                rootMargin: '0px 0px -50px 0px', // Trigger when element is 50px from bottom of viewport
                threshold: 0.1 // Trigger when 10% of element is visible
            };

            const observer = new IntersectionObserver(function (entries) {
                entries.forEach(function (entry) {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('fade-up-visible');
                        // Unobserve after animation to improve performance
                        observer.unobserve(entry.target);
                    }
                });
            }, observerOptions);

            // Observe all fade-up elements
            document.querySelectorAll('.fade-up-element').forEach(function (element) {
                observer.observe(element);
            });
        }

        // Auto-add fade-up animation to product items
        function addFadeUpToProductItems() {
            const productItems = document.querySelectorAll('.product-item.card');
            productItems.forEach(function (item, index) {
                // Add fade-up class with staggered delay
                item.classList.add('fade-up-element');
                const delayIndex = (index % 5) + 1; // Cycle through delays 1-5
                item.classList.add('fade-up-delay-' + delayIndex);
            });
        }

        // Initialize when DOM is ready
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', function () {
                initFadeUpAnimation();
                addFadeUpToProductItems();
                // Re-initialize observer after adding classes to product items
                setTimeout(initFadeUpAnimation, 100);
            });
        } else {
            addFadeUpToProductItems();
            initFadeUpAnimation();
            // Re-initialize observer after adding classes to product items
            setTimeout(initFadeUpAnimation, 100);
        }
    })();
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const tabButtons = document.querySelectorAll('.tab-btn');
        const tabContents = document.querySelectorAll('.tab-content');
        const mainTabImage = document.getElementById('main-tab-image');

        tabButtons.forEach(button => {
            button.addEventListener('click', function () {
                const targetTab = this.getAttribute('data-tab');
                const targetImage = this.getAttribute('data-image');

                // Remove active class from all buttons
                tabButtons.forEach(btn => {
                    btn.classList.remove('active');
                });

                // Hide all tab contents
                tabContents.forEach(content => {
                    content.style.display = 'none';
                });

                // Add active class to clicked button
                this.classList.add('active');

                // Show corresponding content with fade effect
                const targetContent = document.getElementById(targetTab + '-content');
                if (targetContent) {
                    targetContent.style.opacity = '0';
                    targetContent.style.display = 'block';
                    setTimeout(() => {
                        targetContent.style.transition = 'opacity 0.4s ease';
                        targetContent.style.opacity = '1';
                    }, 10);
                }

                // Change main image with fade effect
                if (mainTabImage && targetImage) {
                    mainTabImage.style.opacity = '0';
                    setTimeout(() => {
                        mainTabImage.src = targetImage;
                        mainTabImage.style.opacity = '1';
                    }, 200);
                }
            });
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const readMoreBtn = document.getElementById('read-more-btn');
        const hiddenContent = document.getElementById('vapes-hidden-content');
        let isExpanded = false;

        if (readMoreBtn && hiddenContent) {
            readMoreBtn.addEventListener('click', function () {
                if (isExpanded) {
                    // Collapse
                    hiddenContent.style.display = 'none';
                    readMoreBtn.textContent = 'Read More';
                    isExpanded = false;
                } else {
                    // Expand
                    hiddenContent.style.display = 'block';
                    readMoreBtn.textContent = 'Read Less';
                    isExpanded = true;
                }
            });
        }
    });
</script>

<script>
    // Testimonials Carousel Navigation
    (function () {
        function initTestimonialSlider() {
            const slider = document.querySelector('.testimonials-slider');
            const prevBtn = document.querySelector('.testimonial-prev');
            const nextBtn = document.querySelector('.testimonial-next');

            if (!slider || !prevBtn || !nextBtn) {
                return;
            }

            const cards = slider.querySelectorAll('.testimonial-card');
            if (cards.length === 0) {
                return;
            }

            // Calculate scroll amount based on card width + gap
            function getScrollAmount() {
                const firstCard = cards[0];
                const cardWidth = firstCard.offsetWidth;
                const gap = 20; // gap between cards
                return cardWidth + gap;
            }

            // Update button visibility based on scroll position
            function updateButtons() {
                const isAtStart = slider.scrollLeft <= 0;
                const isAtEnd = slider.scrollLeft >= slider.scrollWidth - slider.clientWidth - 10;

                prevBtn.style.opacity = isAtStart ? '0.5' : '1';
                prevBtn.style.pointerEvents = isAtStart ? 'none' : 'auto';

                nextBtn.style.opacity = isAtEnd ? '0.5' : '1';
                nextBtn.style.pointerEvents = isAtEnd ? 'none' : 'auto';
            }

            // Scroll functions
            prevBtn.addEventListener('click', function (e) {
                e.preventDefault();
                const scrollAmount = getScrollAmount();
                slider.scrollBy({
                    left: -scrollAmount,
                    behavior: 'smooth'
                });
            });

            nextBtn.addEventListener('click', function (e) {
                e.preventDefault();
                const scrollAmount = getScrollAmount();
                slider.scrollBy({
                    left: scrollAmount,
                    behavior: 'smooth'
                });
            });

            // Update buttons on scroll
            slider.addEventListener('scroll', updateButtons);

            // Initial button state
            updateButtons();

            // Update on resize
            let resizeTimer;
            window.addEventListener('resize', function () {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(updateButtons, 250);
            });
        }

        // Initialize when DOM is ready
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initTestimonialSlider);
        } else {
            initTestimonialSlider();
        }
    })();

    (() => {
        const track = document.getElementById("track");
        const wrap = track.parentElement;
        const cards = Array.from(track.children);
        const prev = document.getElementById("prev");
        const next = document.getElementById("next");
        const dotsBox = document.getElementById("dots");

        const isMobile = () => matchMedia("(max-width:767px)").matches;

        cards.forEach((_, i) => {
            const dot = document.createElement("span");
            dot.className = "dot";
            dot.onclick = () => activate(i, true);
            dotsBox.appendChild(dot);
        });
        const dots = Array.from(dotsBox.children);

        let current = 0;

        function center(i) {
            const card = cards[i];
            const axis = isMobile() ? "top" : "left";
            const size = isMobile() ? "clientHeight" : "clientWidth";
            const start = isMobile() ? card.offsetTop : card.offsetLeft;
            wrap.scrollTo({
                [axis]: start - (wrap[size] / 2 - card[size] / 2),
                behavior: "smooth"
            });
        }

        function toggleUI(i) {
            cards.forEach((c, k) => c.toggleAttribute("active", k === i));
            dots.forEach((d, k) => d.classList.toggle("active", k === i));
            prev.disabled = i === 0;
            next.disabled = i === cards.length - 1;
        }

        function activate(i, scroll) {
            if (i === current) return;
            current = i;
            toggleUI(i);
            if (scroll) center(i);
        }

        function go(step) {
            activate(Math.min(Math.max(current + step, 0), cards.length - 1), true);
        }

        prev.onclick = () => go(-1);
        next.onclick = () => go(1);

        addEventListener(
            "keydown",
            (e) => {
                if (["ArrowRight", "ArrowDown"].includes(e.key)) go(1);
                if (["ArrowLeft", "ArrowUp"].includes(e.key)) go(-1);
            },
            { passive: true }
        );

        cards.forEach((card, i) => {
            card.addEventListener(
                "mouseenter",
                () => matchMedia("(hover:hover)").matches && activate(i, true)
            );
            card.addEventListener("click", () => activate(i, true));
        });

        let sx = 0,
            sy = 0;
        track.addEventListener(
            "touchstart",
            (e) => {
                sx = e.touches[0].clientX;
                sy = e.touches[0].clientY;
            },
            { passive: true }
        );

        track.addEventListener(
            "touchend",
            (e) => {
                const dx = e.changedTouches[0].clientX - sx;
                const dy = e.changedTouches[0].clientY - sy;
                if (isMobile() ? Math.abs(dy) > 60 : Math.abs(dx) > 60)
                    go((isMobile() ? dy : dx) > 0 ? -1 : 1);
            },
            { passive: true }
        );
        if (window.matchMedia("(max-width:767px)").matches) dotsBox.hidden = true;

        addEventListener("resize", () => center(current));

        toggleUI(0);
        center(0);
    })();

</script>