(function() {
  // Quantity update functionality
  const qtyButtons = document.querySelectorAll('.qty-button');
  const cartTotalElement = document.querySelector('.cart-total-amount');
  
  qtyButtons.forEach(button => {
    button.addEventListener('click', function() {
      const isIncrease = this.classList.contains('qty-increase');
      const isDecrease = this.classList.contains('qty-decrease');
      const quantityElement = this.parentElement.querySelector('.qty-selector');
      const itemTotalElement = this.closest('.cart-item').querySelector('.cart-item__total');
      const itemPrice = parseFloat(this.getAttribute('data-item-price'));
      
      let currentQty = parseInt(quantityElement.getAttribute('data-quantity')) || parseInt(quantityElement.textContent);
      
      if (isIncrease) {
        currentQty++;
      } else if (isDecrease && currentQty > 1) {
        currentQty--;
      }
      
      // Update quantity
      quantityElement.setAttribute('data-quantity', currentQty);
      quantityElement.textContent = currentQty;
      
      // Calculate item total
      const itemTotal = (itemPrice * currentQty).toFixed(2);
      itemTotalElement.setAttribute('data-item-total', itemTotal);
      itemTotalElement.textContent = '$' + itemTotal;
      
      // Update cart total
      updateCartTotal();
    });
  });
  
  function updateCartTotal() {
    const itemTotals = document.querySelectorAll('.cart-item__total[data-item-total]');
    let total = 0;
    
    itemTotals.forEach(item => {
      total += parseFloat(item.getAttribute('data-item-total'));
    });
    
    const totalFormatted = total.toFixed(2);
    cartTotalElement.setAttribute('data-total', totalFormatted);
    cartTotalElement.textContent = '$' + totalFormatted;
  }
  
  // Remove button functionality
  const removeButtons = document.querySelectorAll('.remove');
  removeButtons.forEach(button => {
    button.addEventListener('click', function(e) {
      e.preventDefault();
      if (confirm('Are you sure you want to remove this item from your cart?')) {
        const cartItem = this.closest('.cart-item');
        cartItem.style.transition = 'opacity 0.3s';
        cartItem.style.opacity = '0';
        setTimeout(() => {
          cartItem.remove();
          updateCartTotal();
          
          // Check if cart is empty
          const remainingItems = document.querySelectorAll('.cart-item');
          if (remainingItems.length === 0) {
            const cartItemsSection = document.querySelector('.cart-items');
            cartItemsSection.innerHTML = '<div style="text-align: center; padding: 40px; color: #666;">Your cart is empty.</div>';
            cartTotalElement.textContent = '$0.00';
          }
        }, 300);
      }
    });
  });
})();





