// Video Component Initialization Script
// This script handles autoplay and visibility for video components

(function() {
    function initVideoComponent(videoComponentId) {
        const videoComponent = document.getElementById(videoComponentId);
        if (!videoComponent) {
            return;
        }

        const video = videoComponent.querySelector('video');
        if (!video) {
            return;
        }

        // Video ko play karne ke liye
        video.addEventListener('loadeddata', function() {
            video.play().catch(function(error) {
                console.log('Video autoplay failed:', error);
            });
            videoComponent.classList.add('video-playing');
        });
        
        // Agar video already loaded hai
        if (video.readyState >= 2) {
            video.play().catch(function(error) {
                console.log('Video autoplay failed:', error);
            });
            videoComponent.classList.add('video-playing');
        }
        
        // Video ko manually play karne ke liye
        video.play().then(function() {
            videoComponent.classList.add('video-playing');
        }).catch(function(error) {
            console.log('Video autoplay failed, will try on user interaction:', error);
            // User interaction ke baad play karega
            document.addEventListener('click', function playVideoOnce() {
                video.play().then(function() {
                    videoComponent.classList.add('video-playing');
                });
                document.removeEventListener('click', playVideoOnce);
            }, { once: true });
        });
    }

    // DOM ready hone ke baad initialize karega
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            initVideoComponent('video-AOS9wcVJmSnNQeW0wM__grid_media_64Trqd');
        });
    } else {
        // Agar DOM already ready hai
        initVideoComponent('video-AOS9wcVJmSnNQeW0wM__grid_media_64Trqd');
    }
})();



