// Simple FAQ accordion for static site
(function() {
  document.addEventListener('DOMContentLoaded', function() {
    const faqItems = document.querySelectorAll('[data-faq-item]');
    
    faqItems.forEach((item) => {
      const button = item.querySelector('[data-faq-button]');
      if (!button) return;
      
      button.addEventListener('click', function() {
        const isExpanded = item.getAttribute('aria-expanded') === 'true';
        const newState = !isExpanded;
        const answerId = button.getAttribute('aria-controls');
        const answerElement = document.getElementById(answerId);
        
        // Toggle state
        item.setAttribute('aria-expanded', newState);
        button.setAttribute('aria-expanded', newState);
        
        if (answerElement) {
          answerElement.setAttribute('aria-expanded', newState);
          // Toggle visibility
          if (newState) {
            answerElement.style.display = 'block';
          } else {
            answerElement.style.display = 'none';
          }
        }
      });
    });
  });
})();

