(function() {
  // Tab switching functionality
  const tabs = document.querySelectorAll('.account-tab');
  const loginForm = document.getElementById('login-form');
  const signupForm = document.getElementById('signup-form');
  
  tabs.forEach(tab => {
    tab.addEventListener('click', function() {
      const tabType = this.getAttribute('data-tab');
      
      // Update tab styles
      tabs.forEach(t => {
        t.classList.remove('active');
        t.style.color = '#666';
        t.style.borderBottom = 'none';
      });
      
      this.classList.add('active');
      this.style.color = '#000';
      this.style.borderBottom = '2px solid #000';
      this.style.marginBottom = '-2px';
      
      // Show/hide forms
      if (tabType === 'login') {
        loginForm.style.display = 'block';
        signupForm.style.display = 'none';
      } else {
        loginForm.style.display = 'none';
        signupForm.style.display = 'block';
      }
    });
  });
  
  // Password confirmation validation
  const signupPassword = document.getElementById('signup-password');
  const signupConfirmPassword = document.getElementById('signup-confirm-password');
  
  if (signupConfirmPassword) {
    signupConfirmPassword.addEventListener('input', function() {
      if (this.value !== signupPassword.value) {
        this.setCustomValidity('Passwords do not match');
      } else {
        this.setCustomValidity('');
      }
    });
  }
  
  // Form submissions
  const loginFormElement = document.getElementById('login-form-element');
  const signupFormElement = document.getElementById('signup-form-element');
  
  if (loginFormElement) {
    loginFormElement.addEventListener('submit', function(e) {
      e.preventDefault();
      alert('Login successful! (This is a demo login page)');
      // In real implementation, you would submit the form data to your server
    });
  }
  
  if (signupFormElement) {
    signupFormElement.addEventListener('submit', function(e) {
      e.preventDefault();
      
      // Validate password match
      if (signupPassword.value !== signupConfirmPassword.value) {
        alert('Passwords do not match!');
        return;
      }
      
      alert('Account created successfully! (This is a demo signup page)');
      // In real implementation, you would submit the form data to your server
    });
  }
})();





