<?php
// Base URL define karo - automatically detect karta hai
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$script_name = $_SERVER['SCRIPT_NAME'];
$base_path = dirname($script_name);
$base_url = $protocol . '://' . $host . $base_path;
// Root directory ke liye base URL
$root_base_url = $protocol . '://' . $host . dirname($script_name);
$BASE_URL = rtrim($root_base_url, '/');
define('BASE_URL', $BASE_URL);
include 'header.php';
?>

<main class="main-content" id="main">
  <!-- Breadcrumb -->
  <div class="breadcrumb-main">
    <div class="breadcrumb-container">
      <nav aria-label="breadcrumbs" class="breadcrumb" id="product-breadcrumb" role="navigation">
        <span class="breadcrumb__link"><a href="<?php echo BASE_URL; ?>/">Home</a></span><span class="breadcrumb__separator">/</span><span class="breadcrumb__current">Account</span>
      </nav>
    </div>
  </div>

  <!-- Login/Signup Section -->
  <div class="account-section container--large container--vertical-space" id="main-account-section">
    <div class="account-container" style="max-width: 500px; margin: 0 auto;">
      
      <!-- Tabs -->
      <div class="account-tabs" style="display: flex; border-bottom: 2px solid #eee; margin-bottom: 30px;">
        <button class="account-tab active" data-tab="login" style="flex: 1; padding: 15px; background: none; border: none; font-size: 18px; font-weight: 600; color: #000; cursor: pointer; border-bottom: 2px solid #000; margin-bottom: -2px;">
          Login
        </button>
        <button class="account-tab" data-tab="signup" style="flex: 1; padding: 15px; background: none; border: none; font-size: 18px; font-weight: 600; color: #666; cursor: pointer;">
          Sign Up
        </button>
      </div>

      <!-- Login Form -->
      <div class="account-form-container" id="login-form" style="display: block;">
        <div class="card" style="background: #f9f9f9; border-radius: 8px; padding: 40px;">
          <h2 class="form-title" style="font-size: 24px; font-weight: 600; margin-bottom: 25px; color: #000; text-align: center;">Welcome Back</h2>
          
          <form class="account-form" id="login-form-element" method="post" action="#">
            <div class="form-field" style="margin-bottom: 20px;">
              <label for="login-email" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Email Address *</label>
              <input type="email" id="login-email" name="email" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; box-sizing: border-box;">
            </div>
            
            <div class="form-field" style="margin-bottom: 20px;">
              <label for="login-password" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Password *</label>
              <input type="password" id="login-password" name="password" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; box-sizing: border-box;">
            </div>
            
            <div class="form-options" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px;">
              <label class="remember-me" style="display: flex; align-items: center; gap: 8px; cursor: pointer; font-size: 14px;">
                <input type="checkbox" name="remember" style="width: 16px; height: 16px; cursor: pointer;">
                <span>Remember me</span>
              </label>
              <a href="#" class="forgot-password" style="font-size: 14px; color: #666; text-decoration: underline;">Forgot Password?</a>
            </div>
            
            <button type="submit" class="button button--regular button--solid" style="width: 100%; background: #000; color: #fff; border: none; padding: 15px; border-radius: 4px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.2s;">
              Login
            </button>
          </form>
        </div>
      </div>

      <!-- Signup Form -->
      <div class="account-form-container" id="signup-form" style="display: none;">
        <div class="card" style="background: #f9f9f9; border-radius: 8px; padding: 40px;">
          <h2 class="form-title" style="font-size: 24px; font-weight: 600; margin-bottom: 25px; color: #000; text-align: center;">Create Account</h2>
          
          <form class="account-form" id="signup-form-element" method="post" action="#">
            <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
              <div class="form-field">
                <label for="signup-firstname" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">First Name *</label>
                <input type="text" id="signup-firstname" name="first_name" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; box-sizing: border-box;">
              </div>
              <div class="form-field">
                <label for="signup-lastname" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Last Name *</label>
                <input type="text" id="signup-lastname" name="last_name" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; box-sizing: border-box;">
              </div>
            </div>
            
            <div class="form-field" style="margin-bottom: 20px;">
              <label for="signup-email" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Email Address *</label>
              <input type="email" id="signup-email" name="email" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; box-sizing: border-box;">
            </div>
            
            <div class="form-field" style="margin-bottom: 20px;">
              <label for="signup-password" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Password *</label>
              <input type="password" id="signup-password" name="password" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; box-sizing: border-box;">
              <small style="display: block; margin-top: 5px; font-size: 12px; color: #666;">Must be at least 8 characters</small>
            </div>
            
            <div class="form-field" style="margin-bottom: 20px;">
              <label for="signup-confirm-password" style="display: block; margin-bottom: 8px; font-weight: 500; color: #000;">Confirm Password *</label>
              <input type="password" id="signup-confirm-password" name="confirm_password" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; box-sizing: border-box;">
            </div>
            
            <div class="form-field" style="margin-bottom: 25px;">
              <label class="terms-checkbox" style="display: flex; align-items: flex-start; gap: 8px; cursor: pointer; font-size: 14px; line-height: 1.5;">
                <input type="checkbox" name="terms" required style="width: 16px; height: 16px; cursor: pointer; margin-top: 2px; flex-shrink: 0;">
                <span>I agree to the <a href="#" style="color: #666; text-decoration: underline;">Terms of Service</a> and <a href="#" style="color: #666; text-decoration: underline;">Privacy Policy</a> *</span>
              </label>
            </div>
            
            <button type="submit" class="button button--regular button--solid" style="width: 100%; background: #000; color: #fff; border: none; padding: 15px; border-radius: 4px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.2s;">
              Create Account
            </button>
          </form>
        </div>
      </div>
    </div>
  </div>
  
</main>

<style>
  @media screen and (max-width: 768px) {
    .account-container {
      padding: 0 15px;
    }
    
    .card {
      padding: 30px 20px !important;
    }
    
    .form-row {
      grid-template-columns: 1fr !important;
    }
  }
  
  .account-tab:hover {
    color: #000 !important;
  }
  
  .button--solid:hover {
    background: #333 !important;
  }
  
  input:focus {
    outline: none;
    border-color: #000 !important;
  }
</style>


<?php include 'footer.php'; ?>

