<?php 
include 'includes/db_connection.php';
include 'includes/functions.php';
include 'header.php'; 

$slug = $_GET['slug'] ?? '';
$product = get_product_by_slug($pdo, $slug);

if (!$product) {
    echo "<div class='container' style='padding:50px;text-align:center;'><h2>Product not found</h2><p>The product you are looking for does not exist.</p><a href='" . BASE_URL . "' class='button button--solid'>Return Home</a></div>";
    include 'footer.php';
    exit;
}

// Fetch Images
$stmt_img = $pdo->prepare("SELECT * FROM product_images WHERE product_id = ? ORDER BY is_featured DESC, sort_order ASC");
$stmt_img->execute([$product['id']]);
$images = $stmt_img->fetchAll(PDO::FETCH_ASSOC);

if (empty($images)) {
    // Fallback if no images found
    $images[] = ['image_path' => 'placeholder.png', 'alt_text' => $product['title']];
}

// Fetch Variants
$stmt_var = $pdo->prepare("SELECT * FROM product_variants WHERE product_id = ? ORDER BY price ASC"); 
$stmt_var->execute([$product['id']]);
$variants = $stmt_var->fetchAll(PDO::FETCH_ASSOC);

$default_variant = $variants[0] ?? null;
// Use variant price if available, else product price (assuming product table has base price as fallback)
$price = $default_variant ? $default_variant['price'] : ($product['price'] ?? 0);
$compare_at_price = $default_variant ? ($default_variant['compare_at_price'] ?? null) : ($product['compare_at_price'] ?? null);
$sku = $default_variant ? ($default_variant['sku'] ?? '') : ($product['sku'] ?? '');
$variant_id = $default_variant ? $default_variant['id'] : $product['id']; // Fallback
?>


<main class="main-content main-content--align-product-items" id="main">
    
    <div class="breadcrumb-main">
        <div class="breadcrumb-container">
            <nav aria-label="breadcrumbs" class="breadcrumb" id="product-breadcrumb" role="navigation">
                <span class="breadcrumb__link"><a href="<?php echo BASE_URL; ?>">Home</a></span><span class="breadcrumb__separator">/</span>
                <!-- Optional: specific collection link if we had it, for now just Products or skip -->
                 <span class="breadcrumb__link"><a href="#">Products</a></span><span class="breadcrumb__separator">/</span>
                <span class="breadcrumb__current"><?php echo htmlspecialchars($product['title']); ?></span>
            </nav>
        </div>
    </div>

    <div class="shopify-section mount-css-slider mount-toggles mount-product-page"
        id="shopify-section-template--17807768813619__main">
        <product-page
            class="container container--large container--vertical-space-small grid grid--layout grid--gap-xlarge grid-2 grid-lap-1 grid--no-stretch main-product product-component--default-to-first-variant-true"
            data-availability="true" data-collection="" data-id="7670625763379" data-js-product-component=""
            id="product-template--17807768813619__main">

            <!-- product gallery -->
            <div class="product-gallery product-gallery--slider" data-js-disable-parallax="false"
                data-js-product-gallery="">
                <css-slider class="css-slider--bottom-navigation element--border-radius" data-options='{
        "selector": ".product-gallery-item",
        "autoHeight": true,"thumbnails": false, 
          "navigation": false,"listenScroll": true
      }' id="css-slider-template--17807768813619__main">
                    <div class="grid grid--slider grid-1 grid--gap-small">
                        <!-- featured image -->
                         <?php foreach ($images as $index => $img): 
                            $img_src = (strpos($img['image_path'], 'http') === 0 || strpos($img['image_path'], 'assets/') === 0) ? $img['image_path'] : 'assets/image/' . $img['image_path'];
                         ?>
                        <div class="product-gallery-item element--border-radius element--border-radius"
                            data-image-zoomdata-ratio="1.33333" data-index="<?php echo $index; ?>" data-media-id="<?php echo $product['id'] . '-' . $index; ?>"
                            data-product-media-type="image" data-product-single-media-wrapper="" data-video=""
                            id="FeaturedMedia-<?php echo $product['id'] . '-' . $index; ?>"
                            style="padding-top: 75.00018750046875%" tabindex="0">
                            <figure class="lazy-image apply-gallery-animation lazy-image--background lazy-image--fit"
                                data-crop="true">
                                <img src="<?php echo htmlspecialchars($img_src); ?>" alt="<?php echo htmlspecialchars($img['alt_text'] ?? $product['title']); ?>" loading="lazy" style="width: 100%; height: 100%; object-fit: cover;">
                            </figure>
                            <product-image-zoom aria-hidden="true" class="product-gallery-item__zoom" tabindex="-1"><svg
                                    fill="none" height="21" viewbox="0 0 21 21" width="21"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <circle cx="9.08008" cy="9" r="8" stroke="var(--main-text)" stroke-width="2"
                                        style="fill:none!important"></circle>
                                    <rect fill="#111111" height="6.65426" transform="rotate(-45 14.2988 15.9062)"
                                        width="1.98612" x="14.2988" y="15.9062"></rect>
                                    <path d="M8.08008 5H10.0801V13H8.08008V5Z" fill="#111111"></path>
                                    <path d="M13.0801 8V10L5.08008 10L5.08008 8L13.0801 8Z" fill="#111111"></path>
                                </svg></product-image-zoom>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </css-slider>

                <!-- product images -->
                <div class="product-gallery__thumbnails">
                    <div class="product-gallery__thumbnails-holder">
                        <?php foreach ($images as $index => $img): 
                             $img_src = (strpos($img['image_path'], 'http') === 0 || strpos($img['image_path'], 'assets/') === 0) ? $img['image_path'] : 'assets/image/' . $img['image_path'];
                        ?>
                        <button class="thumbnail element--border-radius"
                            data-index="<?php echo $index; ?>" tabindex="0">
                            <span class="visually-hidden">Show slide <?php echo $index + 1; ?></span>
                            <span aria-hidden="true" style="display:block">
                                <figure class="lazy-image lazy-image--small lazy-image--fit thumbnail__image"
                                    data-ratio="" style="padding-top: 100%">
                                    <img src="<?php echo htmlspecialchars($img_src); ?>" alt="<?php echo htmlspecialchars($img['alt_text'] ?? 'Thumbnail'); ?>" loading="lazy" style="width: 100%; height: 100%; object-fit: cover;">
                                </figure>
                            </span>
                        </button>
                        <?php endforeach; ?>
                </div>
            </div>
            
            </div>
            
            <div class="product-text remove-empty-space">
                <h1 class="product__title h4"><?php echo htmlspecialchars($product['title']); ?></h1>
                
                <!-- Ratings and Stock Section -->
                <div style="display: flex; align-items: center; gap: 15px; margin-bottom: 15px; flex-wrap: wrap;">
                    <div style="display: flex; align-items: center; gap: 8px;">
                        <div style="display: flex; gap: 2px;">
                            <span style="color: #f59e00; font-size: 18px;">★★★★☆</span>
                        </div>
                        <span style="color: #333; font-size: 14px;">(66 Ratings)</span>
                    </div>
                    <div style="display: flex; align-items: center; gap: 6px; color: #34A853;">
                    <i class="fa-solid fa-check"></i>
                        <span style="color: #155c2c; font-size: 14px; font-weight: 500;">In Stock</span>
                </div>
                </div>

                <!-- Pricing Section -->
                <div style="margin-bottom: 15px;">
                    <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                         <?php if ($compare_at_price && $compare_at_price > $price): ?>
                            <span style="text-decoration: line-through; color: #999; font-size: 18px;">$<?php echo number_format($compare_at_price, 2); ?></span>
                        <?php endif; ?>
                        <span style="color: #000; font-size: 28px; font-weight: 700;">$<?php echo number_format($price, 2); ?></span>
                        <!-- Custom financing text or logo can remain static or be dynamic if needed -->
                    </div>
                </div>

                <!-- Shipping and Delivery Section -->
                <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 15px; padding: 15px 0; border-top: 1px solid #f5f5f5; border-bottom: 1px solid #f5f5f5; flex-wrap: wrap; gap: 15px;">
                    <span style="color: #155c2c; font-size: 14px; font-weight: 500;">Free Shipping & Free Returns Until Jan 31st, 2026</span>
                    <span style="background: #000; color: #fff; padding: 8px 10px; border-radius: 30px; font-size: 13px; font-weight: 500; display: inline-block;">Get it in 2-4 Days</span>
                            </div>

                <!-- Shipping Timeline -->
                <div style="margin-bottom: 20px; padding: 15px; background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%); border-radius: 10px; border: 1px solid #e9ecef;">
                    <div style="position: relative; display: flex; align-items: flex-start; justify-content: space-between; max-width: 550px; margin: 0 auto;">
                        <!-- Timeline Line with Gradient -->
                        <div style="position: absolute; top: 20px; left: 26px; right: 26px; height: 2px; background: linear-gradient(90deg, #22c55e 0%, #22c55e 50%, #d1d5db 50%, #d1d5db 100%); border-radius: 2px; z-index: 0; box-shadow: 0 1px 2px rgba(0,0,0,0.05);"></div>
                        
                        <!-- Stage 1: Ordered (Completed) -->
                        <div style="position: relative; z-index: 1; flex: 1; display: flex; flex-direction: column; align-items: center;">
                            <div style="width: 42px; height: 42px; border-radius: 50%; background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%); display: flex; align-items: center; justify-content: center; margin-bottom: 8px; box-shadow: 0 3px 10px rgba(34, 197, 94, 0.4); position: relative;">
                                <div style="position: absolute; inset: -2px; border-radius: 50%; background: linear-gradient(135deg, #22c55e, #16a34a); opacity: 0.2; animation: pulse 2s infinite;"></div>
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="position: relative; z-index: 1;">
                                    <path d="M5 3L3 7V19C3 19.5304 3.21071 20.0391 3.58579 20.4142C3.96086 20.7893 4.46957 21 5 21H19C19.5304 21 20.0391 20.7893 20.4142 20.4142C20.7893 20.0391 21 19.5304 21 19V7L19 3H5Z" stroke="white" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M3 7H21" stroke="white" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M9 12V15M15 12V15" stroke="white" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                        </div>
                            <div style="text-align: center; padding: 5px 10px; background: white; border-radius: 6px; border: 1px solid #d1d5db; min-width: 80px; box-shadow: 0 1px 3px rgba(0,0,0,0.08);">
                                <div style="font-weight: 700; font-size: 10px; color: #16a34a; margin-bottom: 2px; letter-spacing: 0.2px;">Wed, Dec 3</div>
                                <div style="font-size: 9px; color: #16a34a; font-weight: 600; text-transform: uppercase; letter-spacing: 0.4px;">Ordered</div>
                    </div>
                </div>

                        <!-- Stage 2: Order Ready (Completed) -->
                        <div style="position: relative; z-index: 1; flex: 1; display: flex; flex-direction: column; align-items: center;">
                            <div style="width: 42px; height: 42px; border-radius: 50%; background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%); display: flex; align-items: center; justify-content: center; margin-bottom: 8px; box-shadow: 0 3px 10px rgba(34, 197, 94, 0.4); position: relative;">
                                <div style="position: absolute; inset: -2px; border-radius: 50%; background: linear-gradient(135deg, #22c55e, #16a34a); opacity: 0.2; animation: pulse 2s infinite;"></div>
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="position: relative; z-index: 1;">
                                    <path d="M1 13H23M1 13L3 9H21L23 13M1 13V19C1 19.5304 1.21071 20.0391 1.58579 20.4142C1.96086 20.7893 2.46957 21 3 21H21C21.5304 21 22.0391 20.7893 22.4142 20.4142C22.7893 20.0391 23 19.5304 23 19V13M7 13V15M17 13V15" stroke="white" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M3 9L1 5H23L21 9" stroke="white" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                                    <circle cx="6" cy="15" r="0.8" fill="white"/>
                                    <circle cx="18" cy="15" r="0.8" fill="white"/>
                                </svg>
                            </div>
                            <div style="text-align: center; padding: 5px 10px; background: white; border-radius: 6px; border: 1px solid #d1d5db; min-width: 80px; box-shadow: 0 1px 3px rgba(0,0,0,0.08);">
                                <div style="font-weight: 700; font-size: 10px; color: #16a34a; margin-bottom: 2px; letter-spacing: 0.2px;">Wed, Dec 3</div>
                                <div style="font-size: 9px; color: #16a34a; font-weight: 600; text-transform: uppercase; letter-spacing: 0.4px;">Order Ready</div>
                            </div>
                        </div>

                        <!-- Stage 3: Delivered (Current/Active) -->
                        <div style="position: relative; z-index: 1; flex: 1; display: flex; flex-direction: column; align-items: center;">
                            <div style="width: 42px; height: 42px; border-radius: 50%; background:#ffd700; display: flex; align-items: center; justify-content: center; margin-bottom: 8px; box-shadow: 0 3px 12px rgba(251, 191, 36, 0.5); position: relative; border: 2px solid white;">
                                <div style="position: absolute; inset: -3px; border-radius: 50%; background: #ffd700; opacity: 0.3; animation: pulse 2s infinite;"></div>
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="position: relative; z-index: 1;">
                                    <path d="M12 2L4 8V18C4 18.5304 4.21071 19.0391 4.58579 19.4142C4.96086 19.7893 5.46957 20 6 20H18C18.5304 20 19.0391 19.7893 19.4142 19.4142C19.7893 19.0391 20 18.5304 20 18V8L12 2Z" stroke="#000" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12 8L9 11L12 14L15 11L12 8Z" fill="#000"/>
                                    <path d="M12 8V4M12 4L18 9H15M12 4L6 9H9" stroke="#000" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                            <div style="text-align: center; padding: 5px 10px; background: linear-gradient(135deg, #fef3c7 0%, #fef9e7 100%); border-radius: 6px; border: 1px solid #ffd700; min-width: 80px; box-shadow: 0 2px 6px rgba(251, 191, 36, 0.25);">
                                <div style="font-weight: 700; font-size: 10px; color: #000; margin-bottom: 2px; letter-spacing: 0.2px;">Thu, Dec 4</div>
                                <div style="font-size: 9px; color: #000; font-weight: 700; text-transform: uppercase; letter-spacing: 0.4px;">Delivered</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Flavour Selection -->
                <div style="margin-bottom: 25px;">
                    <div style="display: flex; align-items: center; gap: 10px; flex-wrap: nowrap;">
                        <label style="color: #333; font-size: 14px; font-weight: 500; white-space: nowrap;">Flavour:</label>
                        <select style="padding: 10px 35px 10px 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; min-width: 180px; background: #fff; cursor: pointer; appearance: none; background-image: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M2 4L6 8L10 4\" stroke=\"%23333\" stroke-width=\"1.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/></svg>'); background-repeat: no-repeat; background-position: right 10px center;">
                            <option>Choose a Flavour</option>
                            <option>Banana Ice</option>
                            <option>Blue Pink Lemonade</option>
                            <option>Blue Razz Ice</option>
                            <option>Miami Mint</option>
                            <option>Sour Apple Ice</option>
                            <option>Strawberry Ice</option>
                            <option>Triple Berry</option>
                            <option>Tropical Wave</option>
                            <option>Watermelon Ice</option>
                            <option>White Yummy</option>
                        </select>
                    </div>
                </div>

                <!-- add to cart Actions -->
                <div class="product-actions">
                    <product-form class="product-form" data-ajax-cart="" data-js-product-form=""
                        data-product-url="<?php echo BASE_URL . '/products/' . $product['slug']; ?>"
                        id="add-to-cart-template--17807768813619__main">
                        <form accept-charset="UTF-8" action="/cart/add" class="form" data-type="add-to-cart-form"
                            enctype="multipart/form-data" id="product-form-template--17807768813619__main" method="post"
                            novalidate="novalidate"><input name="form_type" type="hidden" value="product" /><input
                                name="utf8" type="hidden" value="✓" /><input name="id" type="hidden"
                                value="<?php echo $variant_id; ?>" />
                            <div class="product__cart-functions">
                                <div class="flex-buttons shopify-buttons--not-solid" style="display: flex; align-items: center; gap: 15px; flex-wrap: wrap;">

                                    <!-- Quantity Selector -->
                                    <div style="display: flex; align-items: center; gap: 10px;">
                                        <label style="color: #333; font-size: 14px; font-weight: 500;">Quantity:</label>
                                        <div style="display: flex; align-items: center; border: 1px solid #ddd; border-radius: 4px; overflow: hidden; background: #fff;">
                                            <button type="button" id="qty-decrease" style="background: #f5f5f5; border: none; padding: 10px 16px; cursor: pointer; font-size: 18px; font-weight: 500; color: #333; border-right: 1px solid #ddd; transition: background 0.2s;" onmouseover="this.style.background='#e8e8e8'" onmouseout="this.style.background='#f5f5f5'">-</button>
                                            <input type="number" id="qty-input" value="1" min="1" style="width: 50px; text-align: center; border: none; padding: 10px 5px; font-size: 14px; font-weight: 500; outline: none; background: #fff;">
                                            <button type="button" id="qty-increase" style="background: #f5f5f5; border: none; padding: 10px 16px; cursor: pointer; font-size: 18px; font-weight: 500; color: #333; border-left: 1px solid #ddd; transition: background 0.2s;" onmouseover="this.style.background='#e8e8e8'" onmouseout="this.style.background='#f5f5f5'">+</button>
                                        </div>
                                    </div>

                                    <!-- Add to Cart Button -->
                                    <button class="add-to-cart button button--solid button--product button--loader"
                                        data-js-product-add-to-cart="" name="add" type="submit" style="background: #FFD700; color: #000; font-weight: 700; font-size: 14px; text-transform: uppercase; letter-spacing: 0.5px; display: flex; align-items: center; justify-content: center; gap: 8px; padding: 14px 30px; border: none; cursor: pointer; flex: 1; min-width: 220px; transition: all 0.3s ease;" onmouseover="this.style.background='#FFC700'; this.style.transform='translateY(-1px)'" onmouseout="this.style.background='#FFD700'; this.style.transform='translateY(0)'">
                                        <span class="button__text" data-js-product-add-to-cart-text="">ADD TO CART</span>
                                        <span class="button__preloader">
                                            <svg class="button__preloader-element" viewbox="25 25 50 50">
                                                <circle cx="50" cy="50" fill="none" r="20" stroke-width="4"></circle>
                                            </svg>
                                        </span>
                                    </button>
                                    
                                            </div>
                                    </div>
                        </form>
                    </product-form>
                </div>

                <div class="card-widget card-widget--is-collapsible card-widget--layout-boxed card-widget--is-accordion-item"
                    style="--widget-borders-color: rgba(29, 29, 29, 0.15);
                       --color-borders-main: rgba(29, 29, 29, 0.15);--color-background-widget-header: rgba(29, 29, 29, 0.05);">
                    <toggle-tab class="toggle opened">
                        <div aria-controls="toggle-collapsible_tab_4V4Yfe" aria-expanded="true" class="toggle__title"
                            data-js-title="" role="button" tabindex="0">
                            <div class="card-widget__header card-widget__header--title-only"><span
                                    class="card-widget__header-text"><span class="card-widget__header-text__title">
                                        <span>Description</span></span></span>
                            </div>
                        </div>
                        <div class="toggle__content remove-empty-space" data-js-content=""
                            id="toggle--collapsible_tab_4V4Yfe" role="region">
                            <div class="card-widget__content rte remove-empty-space">
                                <div class="metafield-rich_text_field">
                                    <?php echo $product['description']; ?>
                                </div>
                            </div>
                        </div>
                    </toggle-tab>
                </div>

                <div class="card-widget card-widget--is-collapsible card-widget--layout-boxed card-widget--is-accordion-item"
                    style="--widget-borders-color: rgba(29, 29, 29, 0.15);
  --color-borders-main: rgba(29, 29, 29, 0.15);--color-background-widget-header: rgba(29, 29, 29, 0.05);">
                    <toggle-tab class="toggle">
                        <div aria-controls="toggle-collapsible_tab_7LgcrM" aria-expanded="false" class="toggle__title"
                            data-js-title="" role="button" tabindex="0">
                            <div class="card-widget__header card-widget__header--title-only"><span
                                    class="card-widget__header-text"><span class="card-widget__header-text__title">
                                        <span>Key Features</span></span></span>
                            </div>
                        </div>
                        <div class="toggle__content remove-empty-space" data-js-content=""
                            id="toggle--collapsible_tab_7LgcrM" role="region">
                            <div class="card-widget__content rte remove-empty-space">
                                <div class="metafield-rich_text_field">
                                    <ul>
                                        <li>Delivers up to 50,000 puffs per full charge and e‑liquid capacity</li>
                                        <li>Includes 12mL of pre‑filled 5% (50mg) nicotine strength e‑liquid</li>
                                        <li>Features 1500mAh battery (1000mAh power bank + 500mAh pod battery)</li>
                                        <li>Offers two power modes: ECO (16W) and Boost (18W)</li>
                                        <li>Equipped with 1.0Ω dual mesh coil for smooth, flavorful vapor</li>
                                        <li>Displays battery level and airflow mode via smart digital screen</li>
                                        <li>Adjusts airflow with 2‑level airflow control for custom draws</li>
                                        <li>Transparent and visible e‑juice pod for easy monitoring</li>
                                        <li>Mouthpiece shaped for comfort during long sessions<br />
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </toggle-tab>
                </div>

                <div class="card-widget card-widget--is-collapsible card-widget--layout-boxed card-widget--is-accordion-item"
                    style="--widget-borders-color: rgba(29, 29, 29, 0.15);
  --color-borders-main: rgba(29, 29, 29, 0.15);--color-background-widget-header: rgba(29, 29, 29, 0.05);">
                    <toggle-tab class="toggle">
                        <div aria-controls="toggle-collapsible_tab_mWLrE6" aria-expanded="false" class="toggle__title"
                            data-js-title="" role="button" tabindex="0">
                            <div class="card-widget__header card-widget__header--title-only"><span
                                    class="card-widget__header-text"><span class="card-widget__header-text__title">
                                        <span>Available Flavors</span></span></span>
                            </div>
                        </div>
                        <div class="toggle__content remove-empty-space" data-js-content=""
                            id="toggle--collapsible_tab_mWLrE6" role="region">
                            <div class="card-widget__content rte remove-empty-space">
                                <div class="metafield-rich_text_field">
                                    <ul>
                                        <li>Banana Ice</li>
                                        <li>Blue Pink Lemonade</li>
                                        <li>Blue Razz Ice</li>
                                        <li>Miami Mint</li>
                                        <li>Sour Apple Ice</li>
                                        <li>Strawberry Ice</li>
                                        <li>Triple Berry</li>
                                        <li>Tropical Wave</li>
                                        <li>Watermelon Ice</li>
                                        <li>White Yummy</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </toggle-tab>
                </div>
                
            </div>
        </product-page>
    </div>

     <!-- Why Shop at Our Store? -->
     <div class="text-columns-icons-section mount-css-slider" style="background-color:#f8f8f8; margin-top: 90px;"
        id="main-text-columns-icons-section">
        <div class="container--large remove-empty-space container--vertical-space container--has-background "
            style="padding-top: 60px !important; padding-bottom: 60px !important; margin-top: 30px !important;">
            <div class="section-heading section-heading--center gutter-bottom--page">
                <div class="section-heading__text remove-empty-space">
                    <h2 class="section-heading__title h4">Why Shop at Our Store?</h2><span
                        class="section-heading__subheading text-size--large">Your one-stop vape shop with top value and
                        speed.</span>
                </div>
            </div>
            <link href="css/inline-style-41.css" rel="stylesheet" />
            <css-slider class="css-slider css-slider--bottom-navigation" data-options='{
        "selector": ".js-slider-item",
        "groupCells": true,
        "indexNav": true,
        "navigationDOM": "&lt;span class=\"css-slider-button css-slider-prev\" style=\"display:none\"&gt;&lt;svg fill=\"none\" height=\"13\" viewBox=\"0 0 8 13\" width=\"8\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;g fill=\"#000\" &gt;&lt;path d=\"m7.91419 1.41431-6.48529 6.48528-1.4142102-1.41422 6.4852802-6.48527702z\"/&gt;&lt;path d=\"m6.48528 12.9849-6.48528027-6.48532 1.41421027-1.41421 6.48528 6.48523z\"/&gt;&lt;/g&gt;&lt;/svg&gt;&lt;/span&gt;&lt;span class=\"css-slider-button css-slider-next\" style=\"display:none\"&gt;&lt;svg width=\"9\" height=\"13\" viewBox=\"0 0 9 13\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"&gt;&lt;path d=\"M0.914169 11.5857L7.39945 5.10041L8.81367 6.51463L2.32838 12.9999L0.914169 11.5857Z\" fill=\"black\"/&gt;&lt;path d=\"M2.34307 0.0151367L8.82835 6.50042L7.41414 7.91463L0.928857 1.42935L2.34307 0.0151367Z\" fill=\"black\"/&gt;&lt;/svg&gt;&lt;/span&gt;"
      }'>
                <div class="grid grid--slider grid-4 grid-portable-3 grid-lap-2">
                    <div class="element--no-border text-align--center element--no-radius js-slider-item">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_Bx4hXf" style="margin-bottom: 10px !important;">
                            <img src="assets\image\delivery-time-2-256.png" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space" style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">Lightning-Fast Shipping</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">
                                Reliable
                                delivery, always fast and nationwide.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-42.css" rel="stylesheet" />
                    <link href="css/inline-style-43.css" rel="stylesheet" />
                    <div class="element--no-border text-align--center element--no-radius js-slider-item">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_ae3Rnb" style="margin-bottom: 10px !important;">
                            <img src="assets\image\pay-by-card-256.png" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space" style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">100%
                                        Secure Checkout</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">
                                Encrypted
                                payments with full buyer protection.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-44.css" rel="stylesheet" />
                    <link href="css/inline-style-45.css" rel="stylesheet" />
                    <div class="element--no-border text-align--center element--no-radius js-slider-item">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_FBF9AH" style="margin-bottom: 10px !important;">
                            <img src="assets\image\sms-message-256_1.webp" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space" style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">Trusted
                                        Support Team</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">Real
                                help, fast
                                replies, no bots involved.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-46.css" rel="stylesheet" />
                    <link href="css/inline-style-47.css" rel="stylesheet" />
                    <div class="element--no-border text-align--center element--no-radius js-slider-item">
                        <div class="card__icon card__icon--is-img card__icon-size--regular" id="element-image_phWeRX" style="margin-bottom: 10px !important;">
                            <img src="assets\image\label-256.webp" alt="">
                        </div>
                        <div class="gutter--regular spacing--small remove-empty-space" style="margin: 0 !important; padding: 0 10px !important;">
                            <div style="color:var(--color-text-main)">
                                <h3 class="h5" style="margin-bottom:0;display:block"><span
                                        class="text-animation--underline">Lowest
                                        Prices Guaranteed</span></h3>
                            </div>
                            <div class="text-size--small text-color--opacity" style="color:var(--color-text-main)">
                                Unbeatable deals
                                on top brands and new releases.</div>
                        </div>
                    </div>
                    <link href="css/inline-style-48.css" rel="stylesheet" />
                    <link href="css/inline-style-49.css" rel="stylesheet" />
                </div>
            </css-slider>
        </div>
        <link href="css/inline-style-50.css" rel="stylesheet" />
    </div>

    <div class="shopify-section" id="shopify-section-template--17807768813619__17563089963b803d65">
        <div class="shopify-block" id="shopify-block-AYXRIdXppMGxYZ1Fxc__ai_gen_block_d100207_nzUjTa">
            <div class="container container--large container--vertical-space remove-empty-space">
                <section aria-labelledby="faq-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-content="faq"
                    data-ai-extract="questions-answers">
                    <div class="faq-section-container-ayxridxppmgxyz1fxcaigenblockd100207nzujta">
                        <h2 class="faq-section-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                            id="faq-heading-ayxridxppmgxyz1fxcaigenblockd100207nzujta">Frequently Asked Questions</h2>
                        <div aria-hidden="true" data-ai-snippet="faq-summary" data-content-priority="high"
                            style="display: none;">
                            <p>Frequently asked questions about Romo Hex 50K Puffs Kit Disposable Vape:How many puffs
                                does Romo Hex
                                50K deliver?,What nicotine strength is it?,Is the battery rechargeable?and more.
                                Complete answers
                                about specifications, usage, and warranty.</p>
                        </div>
                        <div aria-label="Frequently asked questions list"
                            class="faq-section-list-ayxridxppmgxyz1fxcaigenblockd100207nzujta" role="list">
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1">
                                    <span data-ai-question="true">How many puffs does Romo Hex 50K deliver?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-1"
                                    role="region">
                                    <div>Up to 50,000 puffs under Eco mode, depending on your draw style and usage.
                                    </div>
                                </div>
                            </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2">
                                    <span data-ai-question="true">What nicotine strength is it?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-2"
                                    role="region">
                                    <div>The Romo Hex uses 5% (50mg) nicotine.</div>
                                </div>
                            </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3">
                                    <span data-ai-question="true">Is the battery rechargeable?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-3"
                                    role="region">
                                    <div>Yes. It includes a built‑in 1500mAh battery (composed of a 1000mAh power bank
                                        and 500mAh pod
                                        battery).</div>
                                </div>
                            </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4">
                                    <span data-ai-question="true">What coil type does it use?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-4"
                                    role="region">
                                    <div>It uses a 1.0Ω dual mesh coil for smoother vapor and enhanced flavor.</div>
                                </div>
                            </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5">
                                    <span data-ai-question="true">What is ECO vs Boost mode?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-5"
                                    role="region">
                                    <div>ECO mode operates at about 16W for longer longevity, while Boost mode increases
                                        power to about
                                        18W for richer vapor output.</div>
                                </div>
                            </div>
                            <div aria-expanded="false" class="faq-item-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                data-ai-qa-pair="true" data-faq-item="" role="listitem">
                                <button aria-controls="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6"
                                    aria-expanded="false" class="faq-question-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                    data-faq-button="" id="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6">
                                    <span data-ai-question="true">How can I tell how much liquid or battery
                                        remains?</span>
                                    <svg aria-hidden="true" class="faq-icon-ayxridxppmgxyz1fxcaigenblockd100207nzujta"
                                        fill="currentColor" viewbox="0 0 13 8" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.414.086 7.9 6.57 6.485 7.985 0 1.5 1.414.086Z"></path>
                                        <path d="M12.985 1.515 6.5 8 5.085 6.586 11.571.101l1.414 1.414Z"></path>
                                    </svg>
                                </button>
                                <div aria-labelledby="question-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6"
                                    class="faq-answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta" data-ai-answer="true"
                                    data-faq-answer="" id="answer-ayxridxppmgxyz1fxcaigenblockd100207nzujta-6"
                                    role="region">
                                    <div>The device features a smart digital display for battery level and airflow mode,
                                        and a
                                        transparent pod shows e‑liquid level.</div>
                                </div>
                            </div>
                        </div>
                        <div aria-hidden="true" data-ai-extract="faq-keywords" style="display: none;">
                            <p>FAQ about Romo Hex 50K Puffs Kit Disposable Vape:How many puffs does Romo Hex 50K
                                deliver? What
                                nicotine strength is it? Is the battery rechargeable? What coil type does it use? What
                                is ECO vs Boost
                                mode? H...
                            </p>
                        </div>
                    </div>
                </section>
            </div>
            <!-- inline-script-41.js commented out - file may not exist or causing 404 errors -->
            <!-- <script src="js/inline-script-41.js"></script> -->
        </div>
    </div>

</main>
<!-- BEGIN sections: footer-group -->

<script>
// Quantity Selector Functionality
document.addEventListener('DOMContentLoaded', function() {
    const qtyInput = document.getElementById('qty-input');
    const qtyIncrease = document.getElementById('qty-increase');
    const qtyDecrease = document.getElementById('qty-decrease');
    
    if (qtyIncrease && qtyDecrease && qtyInput) {
        qtyIncrease.addEventListener('click', function() {
            let currentValue = parseInt(qtyInput.value) || 1;
            qtyInput.value = currentValue + 1;
        });
        
        qtyDecrease.addEventListener('click', function() {
            let currentValue = parseInt(qtyInput.value) || 1;
            if (currentValue > 1) {
                qtyInput.value = currentValue - 1;
            }
        });
        
        qtyInput.addEventListener('change', function() {
            let value = parseInt(this.value) || 1;
            if (value < 1) {
                this.value = 1;
            }
        });
    }

    // Toggle Accordion Functionality - Ek open ho to dusra close (Smooth Animation)
    const toggleTabs = document.querySelectorAll('toggle-tab.toggle');
    
    // Smooth animation ke liye CSS add karo
    const style = document.createElement('style');
    style.textContent = `
        .toggle__content {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-in-out, padding 0.4s ease-in-out;
            padding-top: 0;
            padding-bottom: 0;
        }
        toggle-tab.opened .toggle__content {
            max-height: 5000px;
            padding-top: 1.1875rem;
            padding-bottom: 1.1875rem;
        }
    `;
    document.head.appendChild(style);
    
    toggleTabs.forEach(function(toggleTab) {
        const toggleTitle = toggleTab.querySelector('.toggle__title');
        const toggleContent = toggleTab.querySelector('.toggle__content');
        
        if (toggleTitle && toggleContent) {
            // Initial state set karo
            if (toggleTab.classList.contains('opened')) {
                toggleContent.style.maxHeight = toggleContent.scrollHeight + 'px';
            } else {
                toggleContent.style.maxHeight = '0';
                toggleContent.style.display = 'block'; // display block rakho animation ke liye
            }
            
            toggleTitle.addEventListener('click', function() {
                const isOpened = toggleTab.classList.contains('opened');
                
                if (isOpened) {
                    // Close with animation
                    toggleTab.classList.remove('opened');
                    toggleTitle.setAttribute('aria-expanded', 'false');
                    toggleContent.style.maxHeight = '0';
                    toggleContent.style.paddingTop = '0';
                    toggleContent.style.paddingBottom = '0';
                } else {
                    // Pehle sab sections close karo (smooth)
                    toggleTabs.forEach(function(tab) {
                        if (tab.classList.contains('opened')) {
                            const title = tab.querySelector('.toggle__title');
                            const content = tab.querySelector('.toggle__content');
                            tab.classList.remove('opened');
                            if (title) title.setAttribute('aria-expanded', 'false');
                            if (content) {
                                content.style.maxHeight = '0';
                                content.style.paddingTop = '0';
                                content.style.paddingBottom = '0';
                            }
                        }
                    });
                    
                    // Small delay for smooth transition
                    setTimeout(function() {
                        // Ab clicked wala section open karo (smooth)
                        toggleTab.classList.add('opened');
                        toggleTitle.setAttribute('aria-expanded', 'true');
                        toggleContent.style.display = 'block';
                        const contentHeight = toggleContent.scrollHeight;
                        toggleContent.style.maxHeight = contentHeight + 'px';
                        toggleContent.style.paddingTop = '1.1875rem';
                        toggleContent.style.paddingBottom = '1.1875rem';
                    }, 50);
                }
            });
        }
    });
});
</script>

<?php include 'footer.php'; ?>